export namespace base {
    export { pay };
    export { getPaymentStatus };
    export namespace constants {
        export { CHAIN_IDS };
        export { TOKENS };
    }
    export let types: {};
}
export function createBaseAccountSDK(params: any): {
    getProvider: () => any;
    subAccount: {
        create(accountParam: any): Promise<any>;
        get(): Promise<any>;
        addOwner: ({ address, publicKey, chainId }: {
            address: any;
            publicKey: any;
            chainId: any;
        }) => Promise<any>;
        setToOwnerAccount(toSubAccountOwner: any): void;
    };
};
export function getCryptoKeyAccount(): Promise<{
    account: {
        id: string;
        publicKey: string;
        sign({ hash }: {
            hash: any;
        }): Promise<{
            signature: string;
            raw: {};
            webauthn: {
                authenticatorData: string;
                clientDataJSON: string;
                challengeIndex: number;
                typeIndex: number;
                userVerificationRequired: boolean;
            };
        }>;
        signMessage({ message }: {
            message: any;
        }): Promise<{
            signature: string;
            raw: {};
            webauthn: {
                authenticatorData: string;
                clientDataJSON: string;
                challengeIndex: number;
                typeIndex: number;
                userVerificationRequired: boolean;
            };
        }>;
        signTypedData(parameters: any): Promise<{
            signature: string;
            raw: {};
            webauthn: {
                authenticatorData: string;
                clientDataJSON: string;
                challengeIndex: number;
                typeIndex: number;
                userVerificationRequired: boolean;
            };
        }>;
        type: string;
    };
}>;
export function getPaymentStatus(options: any): Promise<{
    status: string;
    id: any;
    message: string;
}>;
export function pay(options: any): Promise<{
    success: boolean;
    id: any;
    amount: any;
    to: any;
    payerInfoResponses: any;
    error?: undefined;
} | {
    success: boolean;
    error: string;
    amount: any;
    to: any;
    id?: undefined;
    payerInfoResponses?: undefined;
}>;
export function removeCryptoKey(): Promise<void>;
declare namespace CHAIN_IDS {
    let base: number;
    let baseSepolia: number;
}
declare namespace TOKENS {
    namespace USDC {
        let decimals: number;
        namespace addresses {
            let base_1: string;
            export { base_1 as base };
            let baseSepolia_1: string;
            export { baseSepolia_1 as baseSepolia };
        }
    }
}
export {};
