import { A as AbiEncodingLengthMismatchError, c as concatHex, i as isAddress, I as InvalidAddressError, p as pad$1, s as stringToHex, b as boolToHex, a as integerRegex, n as numberToHex, d as bytesRegex, B as BytesSizeMismatchError, e as arrayRegex, U as UnsupportedPackedAbiType, L as LruMap, f as encodeAbiParameters, h as hexToBytes, g as secp256k1, j as clsx, E as EventEmitter, k as concat$1, l as size$2, m as hashTypedData, o as keccak256, q as getAction, r as getCode, t as readContract, u as parseAbi, v as BaseError$1, w as prettyPrint, x as formatGwei, y as decodeErrorResult, C as ContractFunctionZeroDataError, z as ContractFunctionRevertedError, D as ContractFunctionExecutionError, F as hexToBigInt, G as AccountNotFoundError, H as encodeFunctionData, J as estimateFeesPerGas, K as prepareAuthorization, M as parseAccount, N as getChainId, O as serializeStateOverride, P as formatLog, Q as formatTransactionReceipt, R as stringify$1, S as observe, T as poll, V as createClient, W as createPublicClient, X as http, Y as isHex, Z as sha256$1, _ as createCurve, $ as Field, a0 as sha256$2, a1 as sha384, a2 as sha512, a3 as hashMessage, a4 as slice$2, a5 as toHex$2, a6 as waitForCallsStatus, a7 as stringToBytes, a8 as trim, a9 as decodeFunctionData, aa as hexToString, ab as decodeAbiParameters, ac as erc20Abi, ad as hexToNumber, ae as isAddressEqual, af as decodeEventLog, ag as formatUnits, ah as parseUnits } from "./popup.html-Dy5lSDZO.js";
import "./storage-B2ZD4aVa.js";
function encodePacked(types2, values) {
  if (types2.length !== values.length)
    throw new AbiEncodingLengthMismatchError({
      expectedLength: types2.length,
      givenLength: values.length
    });
  const data = [];
  for (let i2 = 0; i2 < types2.length; i2++) {
    const type = types2[i2];
    const value = values[i2];
    data.push(encode(type, value));
  }
  return concatHex(data);
}
function encode(type, value, isArray = false) {
  if (type === "address") {
    const address = value;
    if (!isAddress(address))
      throw new InvalidAddressError({ address });
    return pad$1(address.toLowerCase(), {
      size: isArray ? 32 : null
    });
  }
  if (type === "string")
    return stringToHex(value);
  if (type === "bytes")
    return value;
  if (type === "bool")
    return pad$1(boolToHex(value), { size: isArray ? 32 : 1 });
  const intMatch = type.match(integerRegex);
  if (intMatch) {
    const [_type, baseType, bits = "256"] = intMatch;
    const size2 = Number.parseInt(bits, 10) / 8;
    return numberToHex(value, {
      size: isArray ? 32 : size2,
      signed: baseType === "int"
    });
  }
  const bytesMatch = type.match(bytesRegex);
  if (bytesMatch) {
    const [_type, size2] = bytesMatch;
    if (Number.parseInt(size2, 10) !== (value.length - 2) / 2)
      throw new BytesSizeMismatchError({
        expectedSize: Number.parseInt(size2, 10),
        givenSize: (value.length - 2) / 2
      });
    return pad$1(value, { dir: "right", size: isArray ? 32 : null });
  }
  const arrayMatch = type.match(arrayRegex);
  if (arrayMatch && Array.isArray(value)) {
    const [_type, childType] = arrayMatch;
    const data = [];
    for (let i2 = 0; i2 < value.length; i2++) {
      data.push(encode(childType, value[i2], true));
    }
    if (data.length === 0)
      return "0x";
    return concatHex(data);
  }
  throw new UnsupportedPackedAbiType(type);
}
function defineChain(chain) {
  const chainInstance = {
    formatters: void 0,
    fees: void 0,
    serializers: void 0,
    ...chain
  };
  function extend(base2) {
    return (fnOrExtended) => {
      const properties = typeof fnOrExtended === "function" ? fnOrExtended(base2) : fnOrExtended;
      const combined = { ...base2, ...properties };
      return Object.assign(combined, { extend: extend(combined) });
    };
  }
  return Object.assign(chainInstance, {
    extend: extend(chainInstance)
  });
}
function createNonceManager(parameters) {
  const { source } = parameters;
  const deltaMap = /* @__PURE__ */ new Map();
  const nonceMap = new LruMap(8192);
  const promiseMap = /* @__PURE__ */ new Map();
  const getKey = ({ address, chainId }) => `${address}.${chainId}`;
  return {
    async consume({ address, chainId, client }) {
      const key = getKey({ address, chainId });
      const promise = this.get({ address, chainId, client });
      this.increment({ address, chainId });
      const nonce = await promise;
      await source.set({ address, chainId }, nonce);
      nonceMap.set(key, nonce);
      return nonce;
    },
    async increment({ address, chainId }) {
      const key = getKey({ address, chainId });
      const delta = deltaMap.get(key) ?? 0;
      deltaMap.set(key, delta + 1);
    },
    async get({ address, chainId, client }) {
      const key = getKey({ address, chainId });
      let promise = promiseMap.get(key);
      if (!promise) {
        promise = (async () => {
          try {
            const nonce = await source.get({ address, chainId, client });
            const previousNonce = nonceMap.get(key) ?? 0;
            if (previousNonce > 0 && nonce <= previousNonce)
              return previousNonce + 1;
            nonceMap.delete(key);
            return nonce;
          } finally {
            this.reset({ address, chainId });
          }
        })();
        promiseMap.set(key, promise);
      }
      const delta = deltaMap.get(key) ?? 0;
      return delta + await promise;
    },
    reset({ address, chainId }) {
      const key = getKey({ address, chainId });
      deltaMap.delete(key);
      promiseMap.delete(key);
    }
  };
}
const erc6492MagicBytes = "0x6492649264926492649264926492649264926492649264926492649264926492";
function serializeErc6492Signature(parameters) {
  const { address, data, signature, to = "hex" } = parameters;
  const signature_ = concatHex([
    encodeAbiParameters([{ type: "address" }, { type: "bytes" }, { type: "bytes" }], [address, data, signature]),
    erc6492MagicBytes
  ]);
  if (to === "hex")
    return signature_;
  return hexToBytes(signature_);
}
function parseSignature(signatureHex) {
  const { r: r2, s: s2 } = secp256k1.Signature.fromCompact(signatureHex.slice(2, 130));
  const yParityOrV = Number(`0x${signatureHex.slice(130)}`);
  const [v2, yParity] = (() => {
    if (yParityOrV === 0 || yParityOrV === 1)
      return [void 0, yParityOrV];
    if (yParityOrV === 27)
      return [BigInt(yParityOrV), 0];
    if (yParityOrV === 28)
      return [BigInt(yParityOrV), 1];
    throw new Error("Invalid yParityOrV value");
  })();
  if (typeof v2 !== "undefined")
    return {
      r: numberToHex(r2, { size: 32 }),
      s: numberToHex(s2, { size: 32 }),
      v: v2,
      yParity
    };
  return {
    r: numberToHex(r2, { size: 32 }),
    s: numberToHex(s2, { size: 32 }),
    yParity
  };
}
const name = "@base-org/account";
const version$1 = "1.1.1";
const pkg = {
  name,
  version: version$1
};
const CB_KEYS_URL = "https://keys.coinbase.com/connect";
const CB_WALLET_RPC_URL = "https://rpc.wallet.coinbase.com";
const PACKAGE_NAME = pkg.name;
const PACKAGE_VERSION = pkg.version;
function createJSONStorage(getStorage, options) {
  let storage2;
  try {
    storage2 = getStorage();
  } catch (e2) {
    return;
  }
  const persistStorage = {
    getItem: (name2) => {
      var _a;
      const parse = (str2) => {
        if (str2 === null) {
          return null;
        }
        return JSON.parse(str2, void 0);
      };
      const str = (_a = storage2.getItem(name2)) != null ? _a : null;
      if (str instanceof Promise) {
        return str.then(parse);
      }
      return parse(str);
    },
    setItem: (name2, newValue) => storage2.setItem(
      name2,
      JSON.stringify(newValue, void 0)
    ),
    removeItem: (name2) => storage2.removeItem(name2)
  };
  return persistStorage;
}
const toThenable = (fn) => (input) => {
  try {
    const result = fn(input);
    if (result instanceof Promise) {
      return result;
    }
    return {
      then(onFulfilled) {
        return toThenable(onFulfilled)(result);
      },
      catch(_onRejected) {
        return this;
      }
    };
  } catch (e2) {
    return {
      then(_onFulfilled) {
        return this;
      },
      catch(onRejected) {
        return toThenable(onRejected)(e2);
      }
    };
  }
};
const persistImpl = (config2, baseOptions) => (set2, get2, api) => {
  let options = {
    storage: createJSONStorage(() => localStorage),
    partialize: (state) => state,
    version: 0,
    merge: (persistedState, currentState) => ({
      ...currentState,
      ...persistedState
    }),
    ...baseOptions
  };
  let hasHydrated = false;
  const hydrationListeners = /* @__PURE__ */ new Set();
  const finishHydrationListeners = /* @__PURE__ */ new Set();
  let storage2 = options.storage;
  if (!storage2) {
    return config2(
      (...args) => {
        console.warn(
          `[zustand persist middleware] Unable to update item '${options.name}', the given storage is currently unavailable.`
        );
        set2(...args);
      },
      get2,
      api
    );
  }
  const setItem = () => {
    const state = options.partialize({ ...get2() });
    return storage2.setItem(options.name, {
      state,
      version: options.version
    });
  };
  const savedSetState = api.setState;
  api.setState = (state, replace) => {
    savedSetState(state, replace);
    void setItem();
  };
  const configResult = config2(
    (...args) => {
      set2(...args);
      void setItem();
    },
    get2,
    api
  );
  api.getInitialState = () => configResult;
  let stateFromStorage;
  const hydrate = () => {
    var _a, _b;
    if (!storage2) return;
    hasHydrated = false;
    hydrationListeners.forEach((cb) => {
      var _a2;
      return cb((_a2 = get2()) != null ? _a2 : configResult);
    });
    const postRehydrationCallback = ((_b = options.onRehydrateStorage) == null ? void 0 : _b.call(options, (_a = get2()) != null ? _a : configResult)) || void 0;
    return toThenable(storage2.getItem.bind(storage2))(options.name).then((deserializedStorageValue) => {
      if (deserializedStorageValue) {
        if (typeof deserializedStorageValue.version === "number" && deserializedStorageValue.version !== options.version) {
          if (options.migrate) {
            const migration = options.migrate(
              deserializedStorageValue.state,
              deserializedStorageValue.version
            );
            if (migration instanceof Promise) {
              return migration.then((result) => [true, result]);
            }
            return [true, migration];
          }
          console.error(
            `State loaded from storage couldn't be migrated since no migrate function was provided`
          );
        } else {
          return [false, deserializedStorageValue.state];
        }
      }
      return [false, void 0];
    }).then((migrationResult) => {
      var _a2;
      const [migrated, migratedState] = migrationResult;
      stateFromStorage = options.merge(
        migratedState,
        (_a2 = get2()) != null ? _a2 : configResult
      );
      set2(stateFromStorage, true);
      if (migrated) {
        return setItem();
      }
    }).then(() => {
      postRehydrationCallback == null ? void 0 : postRehydrationCallback(stateFromStorage, void 0);
      stateFromStorage = get2();
      hasHydrated = true;
      finishHydrationListeners.forEach((cb) => cb(stateFromStorage));
    }).catch((e2) => {
      postRehydrationCallback == null ? void 0 : postRehydrationCallback(void 0, e2);
    });
  };
  api.persist = {
    setOptions: (newOptions) => {
      options = {
        ...options,
        ...newOptions
      };
      if (newOptions.storage) {
        storage2 = newOptions.storage;
      }
    },
    clearStorage: () => {
      storage2 == null ? void 0 : storage2.removeItem(options.name);
    },
    getOptions: () => options,
    rehydrate: () => hydrate(),
    hasHydrated: () => hasHydrated,
    onHydrate: (cb) => {
      hydrationListeners.add(cb);
      return () => {
        hydrationListeners.delete(cb);
      };
    },
    onFinishHydration: (cb) => {
      finishHydrationListeners.add(cb);
      return () => {
        finishHydrationListeners.delete(cb);
      };
    }
  };
  if (!options.skipHydration) {
    hydrate();
  }
  return stateFromStorage || configResult;
};
const persist = persistImpl;
const createStoreImpl = (createState) => {
  let state;
  const listeners = /* @__PURE__ */ new Set();
  const setState = (partial, replace) => {
    const nextState = typeof partial === "function" ? partial(state) : partial;
    if (!Object.is(nextState, state)) {
      const previousState = state;
      state = (replace != null ? replace : typeof nextState !== "object" || nextState === null) ? nextState : Object.assign({}, state, nextState);
      listeners.forEach((listener) => listener(state, previousState));
    }
  };
  const getState = () => state;
  const getInitialState = () => initialState;
  const subscribe = (listener) => {
    listeners.add(listener);
    return () => listeners.delete(listener);
  };
  const api = { setState, getState, getInitialState, subscribe };
  const initialState = state = createState(setState, getState, api);
  return api;
};
const createStore$1 = (createState) => createState ? createStoreImpl(createState) : createStoreImpl;
const createChainSlice = () => {
  return {
    chains: []
  };
};
const createKeysSlice = () => {
  return {
    keys: {}
  };
};
const createAccountSlice = () => {
  return {
    account: {}
  };
};
const createSubAccountSlice = () => {
  return {
    subAccount: void 0
  };
};
const createSubAccountConfigSlice = () => {
  return {
    subAccountConfig: {}
  };
};
const createSpendPermissionsSlice = () => {
  return {
    spendPermissions: []
  };
};
const createConfigSlice = () => {
  return {
    config: {
      version: PACKAGE_VERSION
    }
  };
};
const sdkstore = createStore$1(persist((...args) => Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, createChainSlice(...args)), createKeysSlice(...args)), createAccountSlice(...args)), createSubAccountSlice(...args)), createSpendPermissionsSlice(...args)), createConfigSlice(...args)), createSubAccountConfigSlice(...args)), {
  name: "base-acc-sdk.store",
  storage: createJSONStorage(() => localStorage),
  partialize: (state) => {
    return {
      chains: state.chains,
      keys: state.keys,
      account: state.account,
      subAccount: state.subAccount,
      spendPermissions: state.spendPermissions,
      config: state.config
    };
  }
}));
const subAccountsConfig = {
  get: () => sdkstore.getState().subAccountConfig,
  set: (subAccountConfig) => {
    sdkstore.setState((state) => ({
      subAccountConfig: Object.assign(Object.assign({}, state.subAccountConfig), subAccountConfig)
    }));
  },
  clear: () => {
    sdkstore.setState({
      subAccountConfig: {}
    });
  }
};
const subAccounts = {
  get: () => sdkstore.getState().subAccount,
  set: (subAccount) => {
    sdkstore.setState((state) => ({
      subAccount: state.subAccount ? Object.assign(Object.assign({}, state.subAccount), subAccount) : Object.assign({ address: subAccount.address }, subAccount)
    }));
  },
  clear: () => {
    sdkstore.setState({
      subAccount: void 0
    });
  }
};
const spendPermissions = {
  get: () => sdkstore.getState().spendPermissions,
  set: (spendPermissions2) => {
    sdkstore.setState({ spendPermissions: spendPermissions2 });
  },
  clear: () => {
    sdkstore.setState({
      spendPermissions: []
    });
  }
};
const account = {
  get: () => sdkstore.getState().account,
  set: (account2) => {
    sdkstore.setState((state) => ({
      account: Object.assign(Object.assign({}, state.account), account2)
    }));
  },
  clear: () => {
    sdkstore.setState({
      account: {}
    });
  }
};
const chains = {
  get: () => sdkstore.getState().chains,
  set: (chains2) => {
    sdkstore.setState({ chains: chains2 });
  },
  clear: () => {
    sdkstore.setState({
      chains: []
    });
  }
};
const keys = {
  get: (key) => sdkstore.getState().keys[key],
  set: (key, value) => {
    sdkstore.setState((state) => ({ keys: Object.assign(Object.assign({}, state.keys), { [key]: value }) }));
  },
  clear: () => {
    sdkstore.setState({
      keys: {}
    });
  }
};
const config = {
  get: () => sdkstore.getState().config,
  set: (config2) => {
    sdkstore.setState((state) => ({ config: Object.assign(Object.assign({}, state.config), config2) }));
  }
};
const actions = {
  subAccounts,
  subAccountsConfig,
  spendPermissions,
  account,
  chains,
  keys,
  config
};
const store = Object.assign(Object.assign({}, sdkstore), actions);
const TELEMETRY_SCRIPT_CONTENT = `!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.ClientAnalytics=t():e.ClientAnalytics=t()}(this,(function(){return(()=>{var e={792:e=>{var t={utf8:{stringToBytes:function(e){return t.bin.stringToBytes(unescape(encodeURIComponent(e)))},bytesToString:function(e){return decodeURIComponent(escape(t.bin.bytesToString(e)))}},bin:{stringToBytes:function(e){for(var t=[],n=0;n<e.length;n++)t.push(255&e.charCodeAt(n));return t},bytesToString:function(e){for(var t=[],n=0;n<e.length;n++)t.push(String.fromCharCode(e[n]));return t.join("")}}};e.exports=t},562:e=>{var t,n;t="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",n={rotl:function(e,t){return e<<t|e>>>32-t},rotr:function(e,t){return e<<32-t|e>>>t},endian:function(e){if(e.constructor==Number)return 16711935&n.rotl(e,8)|4278255360&n.rotl(e,24);for(var t=0;t<e.length;t++)e[t]=n.endian(e[t]);return e},randomBytes:function(e){for(var t=[];e>0;e--)t.push(Math.floor(256*Math.random()));return t},bytesToWords:function(e){for(var t=[],n=0,r=0;n<e.length;n++,r+=8)t[r>>>5]|=e[n]<<24-r%32;return t},wordsToBytes:function(e){for(var t=[],n=0;n<32*e.length;n+=8)t.push(e[n>>>5]>>>24-n%32&255);return t},bytesToHex:function(e){for(var t=[],n=0;n<e.length;n++)t.push((e[n]>>>4).toString(16)),t.push((15&e[n]).toString(16));return t.join("")},hexToBytes:function(e){for(var t=[],n=0;n<e.length;n+=2)t.push(parseInt(e.substr(n,2),16));return t},bytesToBase64:function(e){for(var n=[],r=0;r<e.length;r+=3)for(var i=e[r]<<16|e[r+1]<<8|e[r+2],a=0;a<4;a++)8*r+6*a<=8*e.length?n.push(t.charAt(i>>>6*(3-a)&63)):n.push("=");return n.join("")},base64ToBytes:function(e){e=e.replace(/[^A-Z0-9+\\/]/gi,"");for(var n=[],r=0,i=0;r<e.length;i=++r%4)0!=i&&n.push((t.indexOf(e.charAt(r-1))&Math.pow(2,-2*i+8)-1)<<2*i|t.indexOf(e.charAt(r))>>>6-2*i);return n}},e.exports=n},335:e=>{function t(e){return!!e.constructor&&"function"==typeof e.constructor.isBuffer&&e.constructor.isBuffer(e)}e.exports=function(e){return null!=e&&(t(e)||function(e){return"function"==typeof e.readFloatLE&&"function"==typeof e.slice&&t(e.slice(0,0))}(e)||!!e._isBuffer)}},762:(e,t,n)=>{var r,i,a,o,s;r=n(562),i=n(792).utf8,a=n(335),o=n(792).bin,(s=function(e,t){e.constructor==String?e=t&&"binary"===t.encoding?o.stringToBytes(e):i.stringToBytes(e):a(e)?e=Array.prototype.slice.call(e,0):Array.isArray(e)||e.constructor===Uint8Array||(e=e.toString());for(var n=r.bytesToWords(e),c=8*e.length,u=1732584193,l=-271733879,d=-1732584194,p=271733878,m=0;m<n.length;m++)n[m]=16711935&(n[m]<<8|n[m]>>>24)|4278255360&(n[m]<<24|n[m]>>>8);n[c>>>5]|=128<<c%32,n[14+(c+64>>>9<<4)]=c;var f=s._ff,v=s._gg,g=s._hh,b=s._ii;for(m=0;m<n.length;m+=16){var h=u,w=l,y=d,T=p;u=f(u,l,d,p,n[m+0],7,-680876936),p=f(p,u,l,d,n[m+1],12,-389564586),d=f(d,p,u,l,n[m+2],17,606105819),l=f(l,d,p,u,n[m+3],22,-1044525330),u=f(u,l,d,p,n[m+4],7,-176418897),p=f(p,u,l,d,n[m+5],12,1200080426),d=f(d,p,u,l,n[m+6],17,-1473231341),l=f(l,d,p,u,n[m+7],22,-45705983),u=f(u,l,d,p,n[m+8],7,1770035416),p=f(p,u,l,d,n[m+9],12,-1958414417),d=f(d,p,u,l,n[m+10],17,-42063),l=f(l,d,p,u,n[m+11],22,-1990404162),u=f(u,l,d,p,n[m+12],7,1804603682),p=f(p,u,l,d,n[m+13],12,-40341101),d=f(d,p,u,l,n[m+14],17,-1502002290),u=v(u,l=f(l,d,p,u,n[m+15],22,1236535329),d,p,n[m+1],5,-165796510),p=v(p,u,l,d,n[m+6],9,-1069501632),d=v(d,p,u,l,n[m+11],14,643717713),l=v(l,d,p,u,n[m+0],20,-373897302),u=v(u,l,d,p,n[m+5],5,-701558691),p=v(p,u,l,d,n[m+10],9,38016083),d=v(d,p,u,l,n[m+15],14,-660478335),l=v(l,d,p,u,n[m+4],20,-405537848),u=v(u,l,d,p,n[m+9],5,568446438),p=v(p,u,l,d,n[m+14],9,-1019803690),d=v(d,p,u,l,n[m+3],14,-187363961),l=v(l,d,p,u,n[m+8],20,1163531501),u=v(u,l,d,p,n[m+13],5,-1444681467),p=v(p,u,l,d,n[m+2],9,-51403784),d=v(d,p,u,l,n[m+7],14,1735328473),u=g(u,l=v(l,d,p,u,n[m+12],20,-1926607734),d,p,n[m+5],4,-378558),p=g(p,u,l,d,n[m+8],11,-2022574463),d=g(d,p,u,l,n[m+11],16,1839030562),l=g(l,d,p,u,n[m+14],23,-35309556),u=g(u,l,d,p,n[m+1],4,-1530992060),p=g(p,u,l,d,n[m+4],11,1272893353),d=g(d,p,u,l,n[m+7],16,-155497632),l=g(l,d,p,u,n[m+10],23,-1094730640),u=g(u,l,d,p,n[m+13],4,681279174),p=g(p,u,l,d,n[m+0],11,-358537222),d=g(d,p,u,l,n[m+3],16,-722521979),l=g(l,d,p,u,n[m+6],23,76029189),u=g(u,l,d,p,n[m+9],4,-640364487),p=g(p,u,l,d,n[m+12],11,-421815835),d=g(d,p,u,l,n[m+15],16,530742520),u=b(u,l=g(l,d,p,u,n[m+2],23,-995338651),d,p,n[m+0],6,-198630844),p=b(p,u,l,d,n[m+7],10,1126891415),d=b(d,p,u,l,n[m+14],15,-1416354905),l=b(l,d,p,u,n[m+5],21,-57434055),u=b(u,l,d,p,n[m+12],6,1700485571),p=b(p,u,l,d,n[m+3],10,-1894986606),d=b(d,p,u,l,n[m+10],15,-1051523),l=b(l,d,p,u,n[m+1],21,-2054922799),u=b(u,l,d,p,n[m+8],6,1873313359),p=b(p,u,l,d,n[m+15],10,-30611744),d=b(d,p,u,l,n[m+6],15,-1560198380),l=b(l,d,p,u,n[m+13],21,1309151649),u=b(u,l,d,p,n[m+4],6,-145523070),p=b(p,u,l,d,n[m+11],10,-1120210379),d=b(d,p,u,l,n[m+2],15,718787259),l=b(l,d,p,u,n[m+9],21,-343485551),u=u+h>>>0,l=l+w>>>0,d=d+y>>>0,p=p+T>>>0}return r.endian([u,l,d,p])})._ff=function(e,t,n,r,i,a,o){var s=e+(t&n|~t&r)+(i>>>0)+o;return(s<<a|s>>>32-a)+t},s._gg=function(e,t,n,r,i,a,o){var s=e+(t&r|n&~r)+(i>>>0)+o;return(s<<a|s>>>32-a)+t},s._hh=function(e,t,n,r,i,a,o){var s=e+(t^n^r)+(i>>>0)+o;return(s<<a|s>>>32-a)+t},s._ii=function(e,t,n,r,i,a,o){var s=e+(n^(t|~r))+(i>>>0)+o;return(s<<a|s>>>32-a)+t},s._blocksize=16,s._digestsize=16,e.exports=function(e,t){if(null==e)throw new Error("Illegal argument "+e);var n=r.wordsToBytes(s(e,t));return t&&t.asBytes?n:t&&t.asString?o.bytesToString(n):r.bytesToHex(n)}},2:(e,t,n)=>{"use strict";n.r(t),n.d(t,{Perfume:()=>ze,incrementUjNavigation:()=>Le,markStep:()=>Re,markStepOnce:()=>qe});var r,i,a={isResourceTiming:!1,isElementTiming:!1,maxTime:3e4,reportOptions:{},enableNavigationTracking:!0},o=window,s=o.console,c=o.navigator,u=o.performance,l=function(){return c.deviceMemory},d=function(){return c.hardwareConcurrency},p="mark.",m=function(){return u&&!!u.getEntriesByType&&!!u.now&&!!u.mark},f="4g",v=!1,g={},b={value:0},h={value:{beacon:0,css:0,fetch:0,img:0,other:0,script:0,total:0,xmlhttprequest:0}},w={value:0},y={value:0},T={},k={isHidden:!1,didChange:!1},_=function(){k.isHidden=!1,document.hidden&&(k.isHidden=document.hidden,k.didChange=!0)},S=function(e,t){try{var n=new PerformanceObserver((function(e){t(e.getEntries())}));return n.observe({type:e,buffered:!0}),n}catch(e){s.warn("Perfume.js:",e)}return null},E=function(){return!!(d()&&d()<=4)||!!(l()&&l()<=4)},x=function(e,t){switch(e){case"slow-2g":case"2g":case"3g":return!0;default:return E()||t}},O=function(e){return parseFloat(e.toFixed(4))},j=function(e){return"number"!=typeof e?null:O(e/Math.pow(1024,2))},N=function(e,t,n,r,i){var s,u=function(){a.analyticsTracker&&(k.isHidden&&!["CLS","INP"].includes(e)||a.analyticsTracker({attribution:r,metricName:e,data:t,navigatorInformation:c?{deviceMemory:l()||0,hardwareConcurrency:d()||0,serviceWorkerStatus:"serviceWorker"in c?c.serviceWorker.controller?"controlled":"supported":"unsupported",isLowEndDevice:E(),isLowEndExperience:x(f,v)}:{},rating:n,navigationType:i}))};["CLS","INP"].includes(e)?u():(s=u,"requestIdleCallback"in o?o.requestIdleCallback(s,{timeout:3e3}):s())},I=function(e){e.forEach((function(e){if(!("self"!==e.name||e.startTime<b.value)){var t=e.duration-50;t>0&&(w.value+=t,y.value+=t)}}))};!function(e){e.instant="instant",e.quick="quick",e.moderate="moderate",e.slow="slow",e.unavoidable="unavoidable"}(r||(r={}));var P,M,B,C,D,A=((i={})[r.instant]={vitalsThresholds:[100,200],maxOutlierThreshold:1e4},i[r.quick]={vitalsThresholds:[200,500],maxOutlierThreshold:1e4},i[r.moderate]={vitalsThresholds:[500,1e3],maxOutlierThreshold:1e4},i[r.slow]={vitalsThresholds:[1e3,2e3],maxOutlierThreshold:1e4},i[r.unavoidable]={vitalsThresholds:[2e3,5e3],maxOutlierThreshold:2e4},i),L={RT:[100,200],TBT:[200,600],NTBT:[200,600]},U=function(e,t){return L[e]?t<=L[e][0]?"good":t<=L[e][1]?"needsImprovement":"poor":null},R=function(e,t,n){Object.keys(t).forEach((function(e){"number"==typeof t[e]&&(t[e]=O(t[e]))})),N(e,t,null,n||{})},q=function(e){var t=e.attribution,n=e.name,r=e.rating,i=e.value,o=e.navigationType;"FCP"===n&&(b.value=i),["FCP","LCP"].includes(n)&&!T[0]&&(T[0]=S("longtask",I)),"FID"===n&&setTimeout((function(){k.didChange||(q({attribution:t,name:"TBT",rating:U("TBT",w.value),value:w.value,navigationType:o}),R("dataConsumption",h.value))}),1e4);var s=O(i);s<=a.maxTime&&s>=0&&N(n,s,r,t,o)},F=function(){return window.performance&&performance.getEntriesByType&&performance.getEntriesByType("navigation")[0]},z=function(e){if("loading"===document.readyState)return"loading";var t=F();if(t){if(e<t.domInteractive)return"loading";if(0===t.domContentLoadedEventStart||e<t.domContentLoadedEventStart)return"dom-interactive";if(0===t.domComplete||e<t.domComplete)return"dom-content-loaded"}return"complete"},K=function(e){var t=e.nodeName;return 1===e.nodeType?t.toLowerCase():t.toUpperCase().replace(/^#/,"")},$=function(e,t){var n="";try{for(;e&&9!==e.nodeType;){var r=e,i=r.id?"#"+r.id:K(r)+(r.className&&r.className.length?"."+r.className.replace(/\\s+/g,"."):"");if(n.length+i.length>(t||100)-1)return n||i;if(n=n?i+">"+n:i,r.id)break;e=r.parentNode}}catch(e){}return n},Q=-1,W=function(){return Q},H=function(e){addEventListener("pageshow",(function(t){t.persisted&&(Q=t.timeStamp,e(t))}),!0)},V=function(){var e=F();return e&&e.activationStart||0},J=function(e,t){var n=F(),r="navigate";return W()>=0?r="back-forward-cache":n&&(r=document.prerendering||V()>0?"prerender":document.wasDiscarded?"restore":n.type.replace(/_/g,"-")),{name:e,value:void 0===t?-1:t,rating:"good",delta:0,entries:[],id:"v3-".concat(Date.now(),"-").concat(Math.floor(8999999999999*Math.random())+1e12),navigationType:r}},X=function(e,t,n){try{if(PerformanceObserver.supportedEntryTypes.includes(e)){var r=new PerformanceObserver((function(e){Promise.resolve().then((function(){t(e.getEntries())}))}));return r.observe(Object.assign({type:e,buffered:!0},n||{})),r}}catch(e){}},G=function(e,t){var n=function n(r){"pagehide"!==r.type&&"hidden"!==document.visibilityState||(e(r),t&&(removeEventListener("visibilitychange",n,!0),removeEventListener("pagehide",n,!0)))};addEventListener("visibilitychange",n,!0),addEventListener("pagehide",n,!0)},Z=function(e,t,n,r){var i,a;return function(o){t.value>=0&&(o||r)&&((a=t.value-(i||0))||void 0===i)&&(i=t.value,t.delta=a,t.rating=function(e,t){return e>t[1]?"poor":e>t[0]?"needs-improvement":"good"}(t.value,n),e(t))}},Y=function(e){requestAnimationFrame((function(){return requestAnimationFrame((function(){return e()}))}))},ee=function(e){document.prerendering?addEventListener("prerenderingchange",(function(){return e()}),!0):e()},te=-1,ne=function(){return"hidden"!==document.visibilityState||document.prerendering?1/0:0},re=function(e){"hidden"===document.visibilityState&&te>-1&&(te="visibilitychange"===e.type?e.timeStamp:0,ae())},ie=function(){addEventListener("visibilitychange",re,!0),addEventListener("prerenderingchange",re,!0)},ae=function(){removeEventListener("visibilitychange",re,!0),removeEventListener("prerenderingchange",re,!0)},oe=function(){return te<0&&(te=ne(),ie(),H((function(){setTimeout((function(){te=ne(),ie()}),0)}))),{get firstHiddenTime(){return te}}},se=function(e,t){t=t||{},ee((function(){var n,r=[1800,3e3],i=oe(),a=J("FCP"),o=X("paint",(function(e){e.forEach((function(e){"first-contentful-paint"===e.name&&(o.disconnect(),e.startTime<i.firstHiddenTime&&(a.value=Math.max(e.startTime-V(),0),a.entries.push(e),n(!0)))}))}));o&&(n=Z(e,a,r,t.reportAllChanges),H((function(i){a=J("FCP"),n=Z(e,a,r,t.reportAllChanges),Y((function(){a.value=performance.now()-i.timeStamp,n(!0)}))})))}))},ce={passive:!0,capture:!0},ue=new Date,le=function(e,t){P||(P=t,M=e,B=new Date,me(removeEventListener),de())},de=function(){if(M>=0&&M<B-ue){var e={entryType:"first-input",name:P.type,target:P.target,cancelable:P.cancelable,startTime:P.timeStamp,processingStart:P.timeStamp+M};C.forEach((function(t){t(e)})),C=[]}},pe=function(e){if(e.cancelable){var t=(e.timeStamp>1e12?new Date:performance.now())-e.timeStamp;"pointerdown"==e.type?function(e,t){var n=function(){le(e,t),i()},r=function(){i()},i=function(){removeEventListener("pointerup",n,ce),removeEventListener("pointercancel",r,ce)};addEventListener("pointerup",n,ce),addEventListener("pointercancel",r,ce)}(t,e):le(t,e)}},me=function(e){["mousedown","keydown","touchstart","pointerdown"].forEach((function(t){return e(t,pe,ce)}))},fe=0,ve=1/0,ge=0,be=function(e){e.forEach((function(e){e.interactionId&&(ve=Math.min(ve,e.interactionId),ge=Math.max(ge,e.interactionId),fe=ge?(ge-ve)/7+1:0)}))},he=function(){return D?fe:performance.interactionCount||0},we=0,ye=function(){return he()-we},Te=[],ke={},_e=function(e){var t=Te[Te.length-1],n=ke[e.interactionId];if(n||Te.length<10||e.duration>t.latency){if(n)n.entries.push(e),n.latency=Math.max(n.latency,e.duration);else{var r={id:e.interactionId,latency:e.duration,entries:[e]};ke[r.id]=r,Te.push(r)}Te.sort((function(e,t){return t.latency-e.latency})),Te.splice(10).forEach((function(e){delete ke[e.id]}))}},Se={},Ee=function e(t){document.prerendering?ee((function(){return e(t)})):"complete"!==document.readyState?addEventListener("load",(function(){return e(t)}),!0):setTimeout(t,0)},xe=function(e,t){t=t||{};var n=[800,1800],r=J("TTFB"),i=Z(e,r,n,t.reportAllChanges);Ee((function(){var a=F();if(a){var o=a.responseStart;if(o<=0||o>performance.now())return;r.value=Math.max(o-V(),0),r.entries=[a],i(!0),H((function(){r=J("TTFB",0),(i=Z(e,r,n,t.reportAllChanges))(!0)}))}}))},Oe=function(e){e.forEach((function(e){e.identifier&&q({attribution:{identifier:e.identifier},name:"ET",rating:null,value:e.startTime})}))},je=function(e){e.forEach((function(e){if(a.isResourceTiming&&R("resourceTiming",e),e.decodedBodySize&&e.initiatorType){var t=e.decodedBodySize/1e3;h.value[e.initiatorType]+=t,h.value.total+=t}}))},Ne=function(){!function(e,t){xe((function(e){!function(e){if(e.entries.length){var t=e.entries[0],n=t.activationStart||0,r=Math.max(t.domainLookupStart-n,0),i=Math.max(t.connectStart-n,0),a=Math.max(t.requestStart-n,0);e.attribution={waitingTime:r,dnsTime:i-r,connectionTime:a-i,requestTime:e.value-a,navigationEntry:t}}else e.attribution={waitingTime:0,dnsTime:0,connectionTime:0,requestTime:0}}(e),function(e){e.value>0&&q(e)}(e)}),t)}(0,a.reportOptions.ttfb),function(e,t){!function(e,t){t=t||{},ee((function(){var e,n=[.1,.25],r=J("CLS"),i=-1,a=0,o=[],s=function(e){i>-1&&function(e){!function(e){if(e.entries.length){var t=e.entries.reduce((function(e,t){return e&&e.value>t.value?e:t}));if(t&&t.sources&&t.sources.length){var n=(r=t.sources).find((function(e){return e.node&&1===e.node.nodeType}))||r[0];if(n)return void(e.attribution={largestShiftTarget:$(n.node),largestShiftTime:t.startTime,largestShiftValue:t.value,largestShiftSource:n,largestShiftEntry:t,loadState:z(t.startTime)})}}var r;e.attribution={}}(e),function(e){q(e)}(e)}(e)},c=function(t){t.forEach((function(t){if(!t.hadRecentInput){var n=o[0],i=o[o.length-1];a&&t.startTime-i.startTime<1e3&&t.startTime-n.startTime<5e3?(a+=t.value,o.push(t)):(a=t.value,o=[t]),a>r.value&&(r.value=a,r.entries=o,e())}}))},u=X("layout-shift",c);u&&(e=Z(s,r,n,t.reportAllChanges),se((function(t){i=t.value,r.value<0&&(r.value=0,e())})),G((function(){c(u.takeRecords()),e(!0)})),H((function(){a=0,i=-1,r=J("CLS",0),e=Z(s,r,n,t.reportAllChanges),Y((function(){return e()}))})))}))}(0,t)}(0,a.reportOptions.cls),function(e,t){se((function(e){!function(e){if(e.entries.length){var t=F(),n=e.entries[e.entries.length-1];if(t){var r=t.activationStart||0,i=Math.max(0,t.responseStart-r);return void(e.attribution={timeToFirstByte:i,firstByteToFCP:e.value-i,loadState:z(e.entries[0].startTime),navigationEntry:t,fcpEntry:n})}}e.attribution={timeToFirstByte:0,firstByteToFCP:e.value,loadState:z(W())}}(e),function(e){q(e)}(e)}),t)}(0,a.reportOptions.fcp),function(e,t){!function(e,t){t=t||{},ee((function(){var n,r=[100,300],i=oe(),a=J("FID"),o=function(e){e.startTime<i.firstHiddenTime&&(a.value=e.processingStart-e.startTime,a.entries.push(e),n(!0))},s=function(e){e.forEach(o)},c=X("first-input",s);n=Z(e,a,r,t.reportAllChanges),c&&G((function(){s(c.takeRecords()),c.disconnect()}),!0),c&&H((function(){var i;a=J("FID"),n=Z(e,a,r,t.reportAllChanges),C=[],M=-1,P=null,me(addEventListener),i=o,C.push(i),de()}))}))}((function(e){!function(e){var t=e.entries[0];e.attribution={eventTarget:$(t.target),eventType:t.name,eventTime:t.startTime,eventEntry:t,loadState:z(t.startTime)}}(e),function(e){q(e)}(e)}),t)}(0,a.reportOptions.fid),function(e,t){!function(e,t){t=t||{},ee((function(){var n,r=[2500,4e3],i=oe(),a=J("LCP"),o=function(e){var t=e[e.length-1];if(t){var r=Math.max(t.startTime-V(),0);r<i.firstHiddenTime&&(a.value=r,a.entries=[t],n())}},s=X("largest-contentful-paint",o);if(s){n=Z(e,a,r,t.reportAllChanges);var c=function(){Se[a.id]||(o(s.takeRecords()),s.disconnect(),Se[a.id]=!0,n(!0))};["keydown","click"].forEach((function(e){addEventListener(e,c,{once:!0,capture:!0})})),G(c,!0),H((function(i){a=J("LCP"),n=Z(e,a,r,t.reportAllChanges),Y((function(){a.value=performance.now()-i.timeStamp,Se[a.id]=!0,n(!0)}))}))}}))}((function(e){!function(e){if(e.entries.length){var t=F();if(t){var n=t.activationStart||0,r=e.entries[e.entries.length-1],i=r.url&&performance.getEntriesByType("resource").filter((function(e){return e.name===r.url}))[0],a=Math.max(0,t.responseStart-n),o=Math.max(a,i?(i.requestStart||i.startTime)-n:0),s=Math.max(o,i?i.responseEnd-n:0),c=Math.max(s,r?r.startTime-n:0),u={element:$(r.element),timeToFirstByte:a,resourceLoadDelay:o-a,resourceLoadTime:s-o,elementRenderDelay:c-s,navigationEntry:t,lcpEntry:r};return r.url&&(u.url=r.url),i&&(u.lcpResourceEntry=i),void(e.attribution=u)}}e.attribution={timeToFirstByte:0,resourceLoadDelay:0,resourceLoadTime:0,elementRenderDelay:e.value}}(e),function(e){q(e)}(e)}),t)}(0,a.reportOptions.lcp),function(e,t){!function(e,t){t=t||{},ee((function(){var n=[200,500];"interactionCount"in performance||D||(D=X("event",be,{type:"event",buffered:!0,durationThreshold:0}));var r,i=J("INP"),a=function(e){e.forEach((function(e){e.interactionId&&_e(e),"first-input"===e.entryType&&!Te.some((function(t){return t.entries.some((function(t){return e.duration===t.duration&&e.startTime===t.startTime}))}))&&_e(e)}));var t,n=(t=Math.min(Te.length-1,Math.floor(ye()/50)),Te[t]);n&&n.latency!==i.value&&(i.value=n.latency,i.entries=n.entries,r())},o=X("event",a,{durationThreshold:t.durationThreshold||40});r=Z(e,i,n,t.reportAllChanges),o&&(o.observe({type:"first-input",buffered:!0}),G((function(){a(o.takeRecords()),i.value<0&&ye()>0&&(i.value=0,i.entries=[]),r(!0)})),H((function(){Te=[],we=he(),i=J("INP"),r=Z(e,i,n,t.reportAllChanges)})))}))}((function(t){!function(e){if(e.entries.length){var t=e.entries.sort((function(e,t){return t.duration-e.duration||t.processingEnd-t.processingStart-(e.processingEnd-e.processingStart)}))[0];e.attribution={eventTarget:$(t.target),eventType:t.name,eventTime:t.startTime,eventEntry:t,loadState:z(t.startTime)}}else e.attribution={}}(t),e(t)}),t)}((function(e){return q(e)}),a.reportOptions.inp),a.isResourceTiming&&S("resource",je),a.isElementTiming&&S("element",Oe)},Ie=function(e){var t="usageDetails"in e?e.usageDetails:{};R("storageEstimate",{quota:j(e.quota),usage:j(e.usage),caches:j(t.caches),indexedDB:j(t.indexedDB),serviceWorker:j(t.serviceWorkerRegistrations)})},Pe={finalMarkToStepsMap:{},startMarkToStepsMap:{},active:{},navigationSteps:{}},Me=function(e){delete Pe.active[e]},Be=function(){return Pe.navigationSteps},Ce=function(e){var t;return null!==(t=Be()[e])&&void 0!==t?t:{}},De=function(e,t,n){var r="step."+e,i=u.getEntriesByName(p+t).length>0;if(u.getEntriesByName(p+n).length>0&&a.steps){var o=A[a.steps[e].threshold],s=o.maxOutlierThreshold,c=o.vitalsThresholds;if(i){var l=u.measure(r,p+t,p+n),d=l.duration;if(d<=s){var m=function(e,t){return e<=t[0]?"good":e<=t[1]?"needsImprovement":"poor"}(d,c);d>=0&&(N("userJourneyStep",d,m,{stepName:e},void 0),u.measure("step.".concat(e,"_vitals_").concat(m),{start:l.startTime+l.duration,end:l.startTime+l.duration,detail:{type:"stepVital",duration:d}}))}}}},Ae=function(){var e=Be(),t=Pe.startMarkToStepsMap,n=Object.keys(e).length;if(0===n)return{};var r={},i=n-1,a=Ce(i);if(Object.keys(a).forEach((function(e){var n,i=null!==(n=t[e])&&void 0!==n?n:[];Object.keys(i).forEach((function(e){r[e]=!0}))})),n>1){var o=Ce(i-1);Object.keys(o).forEach((function(e){var n,i=null!==(n=t[e])&&void 0!==n?n:[];Object.keys(i).forEach((function(e){r[e]=!0}))}))}return r},Le=function(){var e,t=Object.keys(Pe.navigationSteps).length;Pe.navigationSteps[t]={};var n=Ae();null===(e=a.onMarkStep)||void 0===e||e.call(a,"",Object.keys(n))},Ue=function(e){var t,n,r,i,o,s,c;if(Pe.finalMarkToStepsMap[e]){!function(e){var t=Pe.navigationSteps,n=Pe.finalMarkToStepsMap,r=Object.keys(t).length;if(0!==r){var i=r-1,a=Ce(i);if(a&&n[e]){var o=n[e];o&&Object.keys(o).forEach((function(e){if(a[e]){var n=Ce(i)||{};n[e]=!1,t[i]=n}if(r>1){var o=i-1,s=Ce(o);s[e]&&(s[e]=!1,t[o]=s)}}))}}}(e);var u=Pe.finalMarkToStepsMap[e];Object.keys(u).forEach((function(t){var n=u[t];n.forEach(Me),Promise.all(n.map((function(n){return function(e,t,n,r){return new(n||(n=Promise))((function(e,t){function i(e){try{o(r.next(e))}catch(e){t(e)}}function a(e){try{o(r.throw(e))}catch(e){t(e)}}function o(t){var r;t.done?e(t.value):(r=t.value,r instanceof n?r:new n((function(e){e(r)}))).then(i,a)}o((r=r.apply(undefined,[])).next())}))}(0,0,void 0,(function(){return function(e,t){var n,r,i,a,o={label:0,sent:function(){if(1&i[0])throw i[1];return i[1]},trys:[],ops:[]};return a={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function s(a){return function(s){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;o;)try{if(n=1,r&&(i=2&a[0]?r.return:a[0]?r.throw||((i=r.return)&&i.call(r),0):r.next)&&!(i=i.call(r,a[1])).done)return i;switch(r=0,i&&(a=[2&a[0],i.value]),a[0]){case 0:case 1:i=a;break;case 4:return o.label++,{value:a[1],done:!1};case 5:o.label++,r=a[1],a=[0];continue;case 7:a=o.ops.pop(),o.trys.pop();continue;default:if(!((i=(i=o.trys).length>0&&i[i.length-1])||6!==a[0]&&2!==a[0])){o=0;continue}if(3===a[0]&&(!i||a[1]>i[0]&&a[1]<i[3])){o.label=a[1];break}if(6===a[0]&&o.label<i[1]){o.label=i[1],i=a;break}if(i&&o.label<i[2]){o.label=i[2],o.ops.push(a);break}i[2]&&o.ops.pop(),o.trys.pop();continue}a=t.call(e,o)}catch(e){a=[6,e],r=0}finally{n=i=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,s])}}}(this,(function(r){switch(r.label){case 0:return[4,De(n,t,e)];case 1:return r.sent(),[2]}}))}))}))).catch((function(){}))}))}else r=e,i=Pe.navigationSteps,o=Object.keys(i).length,(c=Ce(s=(o>0?o:1)-1)||[])[r]=!0,i[s]=c,function(e){var t,n=null!==(t=Pe.startMarkToStepsMap[e])&&void 0!==t?t:[];Object.keys(n).forEach((function(e){Pe.active[e]||(Pe.active[e]=!0)}))}(e);if(a.enableNavigationTracking){var l=Ae();null===(t=a.onMarkStep)||void 0===t||t.call(a,e,Object.keys(l))}else null===(n=a.onMarkStep)||void 0===n||n.call(a,e,Object.keys(Pe.active))},Re=function(e){u.mark(p+e),Ue(e)},qe=function(e){0===u.getEntriesByName(p+e).length&&(u.mark(p+e),Ue(e))},Fe=0,ze=function(){function e(e){if(void 0===e&&(e={}),this.v="9.0.0-rc.3",a.analyticsTracker=e.analyticsTracker,a.isResourceTiming=!!e.resourceTiming,a.isElementTiming=!!e.elementTiming,a.maxTime=e.maxMeasureTime||a.maxTime,a.reportOptions=e.reportOptions||a.reportOptions,a.steps=e.steps,a.onMarkStep=e.onMarkStep,a.enableNavigationTracking=e.enableNavigationTracking,m()){"PerformanceObserver"in o&&Ne(),void 0!==document.hidden&&document.addEventListener("visibilitychange",_);var t=function(){if(!m())return{};var e=u.getEntriesByType("navigation")[0];if(!e)return{};var t=e.responseStart,n=e.responseEnd;return{fetchTime:n-e.fetchStart,workerTime:e.workerStart>0?n-e.workerStart:0,totalTime:n-e.requestStart,downloadTime:n-t,timeToFirstByte:t-e.requestStart,headerSize:e.transferSize-e.encodedBodySize||0,dnsLookupTime:e.domainLookupEnd-e.domainLookupStart,redirectTime:e.redirectEnd-e.redirectStart}}();R("navigationTiming",t),t.redirectTime&&q({attribution:{},name:"RT",rating:U("RT",t.redirectTime),value:t.redirectTime}),R("networkInformation",function(){if("connection"in c){var e=c.connection;return"object"!=typeof e?{}:(f=e.effectiveType,v=!!e.saveData,{downlink:e.downlink,effectiveType:e.effectiveType,rtt:e.rtt,saveData:!!e.saveData})}return{}}()),c&&c.storage&&"function"==typeof c.storage.estimate&&c.storage.estimate().then(Ie),a.steps&&a.steps&&(Pe.startMarkToStepsMap={},Pe.finalMarkToStepsMap={},Pe.active={},Pe.navigationSteps={},Object.entries(a.steps).forEach((function(e){var t,n,r=e[0],i=e[1].marks,a=i[0],o=i[1],s=null!==(n=Pe.startMarkToStepsMap[a])&&void 0!==n?n:{};if(s[r]=!0,Pe.startMarkToStepsMap[a]=s,Pe.finalMarkToStepsMap[o]){var c=Pe.finalMarkToStepsMap[o][a]||[];c.push(r),Pe.finalMarkToStepsMap[o][a]=c}else Pe.finalMarkToStepsMap[o]=((t={})[a]=[r],t)})))}}return e.prototype.start=function(e){m()&&!g[e]&&(g[e]=!0,u.mark("mark_".concat(e,"_start")))},e.prototype.end=function(e,t,n){if(void 0===t&&(t={}),void 0===n&&(n=!0),m()&&g[e]){u.mark("mark_".concat(e,"_end")),delete g[e];var r=function(e){u.measure(e,"mark_".concat(e,"_start"),"mark_".concat(e,"_end"));var t=u.getEntriesByName(e).pop();return t&&"measure"===t.entryType?t.duration:-1}(e);n&&R(e,O(r),t)}},e.prototype.endPaint=function(e,t){var n=this;setTimeout((function(){n.end(e,t)}))},e.prototype.clear=function(e){delete g[e],u.clearMarks&&(u.clearMarks("mark_".concat(e,"_start")),u.clearMarks("mark_".concat(e,"_end")))},e.prototype.markNTBT=function(){var e=this;this.start("ntbt"),y.value=0,clearTimeout(Fe),Fe=setTimeout((function(){e.end("ntbt",{},!1),q({attribution:{},name:"NTBT",rating:U("NTBT",y.value),value:y.value}),y.value=0}),2e3)},e}()},426:(e,t)=>{"use strict";Symbol.for("react.element"),Symbol.for("react.portal"),Symbol.for("react.fragment"),Symbol.for("react.strict_mode"),Symbol.for("react.profiler"),Symbol.for("react.provider"),Symbol.for("react.context"),Symbol.for("react.forward_ref"),Symbol.for("react.suspense"),Symbol.for("react.memo"),Symbol.for("react.lazy"),Symbol.iterator;var n={isMounted:function(){return!1},enqueueForceUpdate:function(){},enqueueReplaceState:function(){},enqueueSetState:function(){}},r=Object.assign,i={};function a(e,t,r){this.props=e,this.context=t,this.refs=i,this.updater=r||n}function o(){}function s(e,t,r){this.props=e,this.context=t,this.refs=i,this.updater=r||n}a.prototype.isReactComponent={},a.prototype.setState=function(e,t){if("object"!=typeof e&&"function"!=typeof e&&null!=e)throw Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");this.updater.enqueueSetState(this,e,t,"setState")},a.prototype.forceUpdate=function(e){this.updater.enqueueForceUpdate(this,e,"forceUpdate")},o.prototype=a.prototype;var c=s.prototype=new o;c.constructor=s,r(c,a.prototype),c.isPureReactComponent=!0;Array.isArray,Object.prototype.hasOwnProperty;var u={current:null};t.useCallback=function(e,t){return u.current.useCallback(e,t)},t.useEffect=function(e,t){return u.current.useEffect(e,t)},t.useRef=function(e){return u.current.useRef(e)}},784:(e,t,n)=>{"use strict";e.exports=n(426)},353:function(e,t,n){var r;!function(i,a){"use strict";var o="function",s="undefined",c="object",u="string",l="major",d="model",p="name",m="type",f="vendor",v="version",g="architecture",b="console",h="mobile",w="tablet",y="smarttv",T="wearable",k="embedded",_="Amazon",S="Apple",E="ASUS",x="BlackBerry",O="Browser",j="Chrome",N="Firefox",I="Google",P="Huawei",M="LG",B="Microsoft",C="Motorola",D="Opera",A="Samsung",L="Sharp",U="Sony",R="Xiaomi",q="Zebra",F="Facebook",z="Chromium OS",K="Mac OS",$=function(e){for(var t={},n=0;n<e.length;n++)t[e[n].toUpperCase()]=e[n];return t},Q=function(e,t){return typeof e===u&&-1!==W(t).indexOf(W(e))},W=function(e){return e.toLowerCase()},H=function(e,t){if(typeof e===u)return e=e.replace(/^\\s\\s*/,""),typeof t===s?e:e.substring(0,350)},V=function(e,t){for(var n,r,i,s,u,l,d=0;d<t.length&&!u;){var p=t[d],m=t[d+1];for(n=r=0;n<p.length&&!u&&p[n];)if(u=p[n++].exec(e))for(i=0;i<m.length;i++)l=u[++r],typeof(s=m[i])===c&&s.length>0?2===s.length?typeof s[1]==o?this[s[0]]=s[1].call(this,l):this[s[0]]=s[1]:3===s.length?typeof s[1]!==o||s[1].exec&&s[1].test?this[s[0]]=l?l.replace(s[1],s[2]):a:this[s[0]]=l?s[1].call(this,l,s[2]):a:4===s.length&&(this[s[0]]=l?s[3].call(this,l.replace(s[1],s[2])):a):this[s]=l||a;d+=2}},J=function(e,t){for(var n in t)if(typeof t[n]===c&&t[n].length>0){for(var r=0;r<t[n].length;r++)if(Q(t[n][r],e))return"?"===n?a:n}else if(Q(t[n],e))return"?"===n?a:n;return e},X={ME:"4.90","NT 3.11":"NT3.51","NT 4.0":"NT4.0",2e3:"NT 5.0",XP:["NT 5.1","NT 5.2"],Vista:"NT 6.0",7:"NT 6.1",8:"NT 6.2",8.1:"NT 6.3",10:["NT 6.4","NT 10.0"],RT:"ARM"},G={browser:[[/\\b(?:crmo|crios)\\/([\\w\\.]+)/i],[v,[p,"Chrome"]],[/edg(?:e|ios|a)?\\/([\\w\\.]+)/i],[v,[p,"Edge"]],[/(opera mini)\\/([-\\w\\.]+)/i,/(opera [mobiletab]{3,6})\\b.+version\\/([-\\w\\.]+)/i,/(opera)(?:.+version\\/|[\\/ ]+)([\\w\\.]+)/i],[p,v],[/opios[\\/ ]+([\\w\\.]+)/i],[v,[p,D+" Mini"]],[/\\bopr\\/([\\w\\.]+)/i],[v,[p,D]],[/(kindle)\\/([\\w\\.]+)/i,/(lunascape|maxthon|netfront|jasmine|blazer)[\\/ ]?([\\w\\.]*)/i,/(avant |iemobile|slim)(?:browser)?[\\/ ]?([\\w\\.]*)/i,/(ba?idubrowser)[\\/ ]?([\\w\\.]+)/i,/(?:ms|\\()(ie) ([\\w\\.]+)/i,/(flock|rockmelt|midori|epiphany|silk|skyfire|bolt|iron|vivaldi|iridium|phantomjs|bowser|quark|qupzilla|falkon|rekonq|puffin|brave|whale(?!.+naver)|qqbrowserlite|qq|duckduckgo)\\/([-\\w\\.]+)/i,/(heytap|ovi)browser\\/([\\d\\.]+)/i,/(weibo)__([\\d\\.]+)/i],[p,v],[/(?:\\buc? ?browser|(?:juc.+)ucweb)[\\/ ]?([\\w\\.]+)/i],[v,[p,"UC"+O]],[/microm.+\\bqbcore\\/([\\w\\.]+)/i,/\\bqbcore\\/([\\w\\.]+).+microm/i],[v,[p,"WeChat(Win) Desktop"]],[/micromessenger\\/([\\w\\.]+)/i],[v,[p,"WeChat"]],[/konqueror\\/([\\w\\.]+)/i],[v,[p,"Konqueror"]],[/trident.+rv[: ]([\\w\\.]{1,9})\\b.+like gecko/i],[v,[p,"IE"]],[/ya(?:search)?browser\\/([\\w\\.]+)/i],[v,[p,"Yandex"]],[/(avast|avg)\\/([\\w\\.]+)/i],[[p,/(.+)/,"$1 Secure "+O],v],[/\\bfocus\\/([\\w\\.]+)/i],[v,[p,N+" Focus"]],[/\\bopt\\/([\\w\\.]+)/i],[v,[p,D+" Touch"]],[/coc_coc\\w+\\/([\\w\\.]+)/i],[v,[p,"Coc Coc"]],[/dolfin\\/([\\w\\.]+)/i],[v,[p,"Dolphin"]],[/coast\\/([\\w\\.]+)/i],[v,[p,D+" Coast"]],[/miuibrowser\\/([\\w\\.]+)/i],[v,[p,"MIUI "+O]],[/fxios\\/([-\\w\\.]+)/i],[v,[p,N]],[/\\bqihu|(qi?ho?o?|360)browser/i],[[p,"360 "+O]],[/(oculus|samsung|sailfish|huawei)browser\\/([\\w\\.]+)/i],[[p,/(.+)/,"$1 "+O],v],[/(comodo_dragon)\\/([\\w\\.]+)/i],[[p,/_/g," "],v],[/(electron)\\/([\\w\\.]+) safari/i,/(tesla)(?: qtcarbrowser|\\/(20\\d\\d\\.[-\\w\\.]+))/i,/m?(qqbrowser|baiduboxapp|2345Explorer)[\\/ ]?([\\w\\.]+)/i],[p,v],[/(metasr)[\\/ ]?([\\w\\.]+)/i,/(lbbrowser)/i,/\\[(linkedin)app\\]/i],[p],[/((?:fban\\/fbios|fb_iab\\/fb4a)(?!.+fbav)|;fbav\\/([\\w\\.]+);)/i],[[p,F],v],[/(kakao(?:talk|story))[\\/ ]([\\w\\.]+)/i,/(naver)\\(.*?(\\d+\\.[\\w\\.]+).*\\)/i,/safari (line)\\/([\\w\\.]+)/i,/\\b(line)\\/([\\w\\.]+)\\/iab/i,/(chromium|instagram)[\\/ ]([-\\w\\.]+)/i],[p,v],[/\\bgsa\\/([\\w\\.]+) .*safari\\//i],[v,[p,"GSA"]],[/musical_ly(?:.+app_?version\\/|_)([\\w\\.]+)/i],[v,[p,"TikTok"]],[/headlesschrome(?:\\/([\\w\\.]+)| )/i],[v,[p,j+" Headless"]],[/ wv\\).+(chrome)\\/([\\w\\.]+)/i],[[p,j+" WebView"],v],[/droid.+ version\\/([\\w\\.]+)\\b.+(?:mobile safari|safari)/i],[v,[p,"Android "+O]],[/(chrome|omniweb|arora|[tizenoka]{5} ?browser)\\/v?([\\w\\.]+)/i],[p,v],[/version\\/([\\w\\.\\,]+) .*mobile\\/\\w+ (safari)/i],[v,[p,"Mobile Safari"]],[/version\\/([\\w(\\.|\\,)]+) .*(mobile ?safari|safari)/i],[v,p],[/webkit.+?(mobile ?safari|safari)(\\/[\\w\\.]+)/i],[p,[v,J,{"1.0":"/8",1.2:"/1",1.3:"/3","2.0":"/412","2.0.2":"/416","2.0.3":"/417","2.0.4":"/419","?":"/"}]],[/(webkit|khtml)\\/([\\w\\.]+)/i],[p,v],[/(navigator|netscape\\d?)\\/([-\\w\\.]+)/i],[[p,"Netscape"],v],[/mobile vr; rv:([\\w\\.]+)\\).+firefox/i],[v,[p,N+" Reality"]],[/ekiohf.+(flow)\\/([\\w\\.]+)/i,/(swiftfox)/i,/(icedragon|iceweasel|camino|chimera|fennec|maemo browser|minimo|conkeror|klar)[\\/ ]?([\\w\\.\\+]+)/i,/(seamonkey|k-meleon|icecat|iceape|firebird|phoenix|palemoon|basilisk|waterfox)\\/([-\\w\\.]+)$/i,/(firefox)\\/([\\w\\.]+)/i,/(mozilla)\\/([\\w\\.]+) .+rv\\:.+gecko\\/\\d+/i,/(polaris|lynx|dillo|icab|doris|amaya|w3m|netsurf|sleipnir|obigo|mosaic|(?:go|ice|up)[\\. ]?browser)[-\\/ ]?v?([\\w\\.]+)/i,/(links) \\(([\\w\\.]+)/i,/panasonic;(viera)/i],[p,v],[/(cobalt)\\/([\\w\\.]+)/i],[p,[v,/master.|lts./,""]]],cpu:[[/(?:(amd|x(?:(?:86|64)[-_])?|wow|win)64)[;\\)]/i],[[g,"amd64"]],[/(ia32(?=;))/i],[[g,W]],[/((?:i[346]|x)86)[;\\)]/i],[[g,"ia32"]],[/\\b(aarch64|arm(v?8e?l?|_?64))\\b/i],[[g,"arm64"]],[/\\b(arm(?:v[67])?ht?n?[fl]p?)\\b/i],[[g,"armhf"]],[/windows (ce|mobile); ppc;/i],[[g,"arm"]],[/((?:ppc|powerpc)(?:64)?)(?: mac|;|\\))/i],[[g,/ower/,"",W]],[/(sun4\\w)[;\\)]/i],[[g,"sparc"]],[/((?:avr32|ia64(?=;))|68k(?=\\))|\\barm(?=v(?:[1-7]|[5-7]1)l?|;|eabi)|(?=atmel )avr|(?:irix|mips|sparc)(?:64)?\\b|pa-risc)/i],[[g,W]]],device:[[/\\b(sch-i[89]0\\d|shw-m380s|sm-[ptx]\\w{2,4}|gt-[pn]\\d{2,4}|sgh-t8[56]9|nexus 10)/i],[d,[f,A],[m,w]],[/\\b((?:s[cgp]h|gt|sm)-\\w+|sc[g-]?[\\d]+a?|galaxy nexus)/i,/samsung[- ]([-\\w]+)/i,/sec-(sgh\\w+)/i],[d,[f,A],[m,h]],[/(?:\\/|\\()(ip(?:hone|od)[\\w, ]*)(?:\\/|;)/i],[d,[f,S],[m,h]],[/\\((ipad);[-\\w\\),; ]+apple/i,/applecoremedia\\/[\\w\\.]+ \\((ipad)/i,/\\b(ipad)\\d\\d?,\\d\\d?[;\\]].+ios/i],[d,[f,S],[m,w]],[/(macintosh);/i],[d,[f,S]],[/\\b(sh-?[altvz]?\\d\\d[a-ekm]?)/i],[d,[f,L],[m,h]],[/\\b((?:ag[rs][23]?|bah2?|sht?|btv)-a?[lw]\\d{2})\\b(?!.+d\\/s)/i],[d,[f,P],[m,w]],[/(?:huawei|honor)([-\\w ]+)[;\\)]/i,/\\b(nexus 6p|\\w{2,4}e?-[atu]?[ln][\\dx][012359c][adn]?)\\b(?!.+d\\/s)/i],[d,[f,P],[m,h]],[/\\b(poco[\\w ]+)(?: bui|\\))/i,/\\b; (\\w+) build\\/hm\\1/i,/\\b(hm[-_ ]?note?[_ ]?(?:\\d\\w)?) bui/i,/\\b(redmi[\\-_ ]?(?:note|k)?[\\w_ ]+)(?: bui|\\))/i,/\\b(mi[-_ ]?(?:a\\d|one|one[_ ]plus|note lte|max|cc)?[_ ]?(?:\\d?\\w?)[_ ]?(?:plus|se|lite)?)(?: bui|\\))/i],[[d,/_/g," "],[f,R],[m,h]],[/\\b(mi[-_ ]?(?:pad)(?:[\\w_ ]+))(?: bui|\\))/i],[[d,/_/g," "],[f,R],[m,w]],[/; (\\w+) bui.+ oppo/i,/\\b(cph[12]\\d{3}|p(?:af|c[al]|d\\w|e[ar])[mt]\\d0|x9007|a101op)\\b/i],[d,[f,"OPPO"],[m,h]],[/vivo (\\w+)(?: bui|\\))/i,/\\b(v[12]\\d{3}\\w?[at])(?: bui|;)/i],[d,[f,"Vivo"],[m,h]],[/\\b(rmx[12]\\d{3})(?: bui|;|\\))/i],[d,[f,"Realme"],[m,h]],[/\\b(milestone|droid(?:[2-4x]| (?:bionic|x2|pro|razr))?:?( 4g)?)\\b[\\w ]+build\\//i,/\\bmot(?:orola)?[- ](\\w*)/i,/((?:moto[\\w\\(\\) ]+|xt\\d{3,4}|nexus 6)(?= bui|\\)))/i],[d,[f,C],[m,h]],[/\\b(mz60\\d|xoom[2 ]{0,2}) build\\//i],[d,[f,C],[m,w]],[/((?=lg)?[vl]k\\-?\\d{3}) bui| 3\\.[-\\w; ]{10}lg?-([06cv9]{3,4})/i],[d,[f,M],[m,w]],[/(lm(?:-?f100[nv]?|-[\\w\\.]+)(?= bui|\\))|nexus [45])/i,/\\blg[-e;\\/ ]+((?!browser|netcast|android tv)\\w+)/i,/\\blg-?([\\d\\w]+) bui/i],[d,[f,M],[m,h]],[/(ideatab[-\\w ]+)/i,/lenovo ?(s[56]000[-\\w]+|tab(?:[\\w ]+)|yt[-\\d\\w]{6}|tb[-\\d\\w]{6})/i],[d,[f,"Lenovo"],[m,w]],[/(?:maemo|nokia).*(n900|lumia \\d+)/i,/nokia[-_ ]?([-\\w\\.]*)/i],[[d,/_/g," "],[f,"Nokia"],[m,h]],[/(pixel c)\\b/i],[d,[f,I],[m,w]],[/droid.+; (pixel[\\daxl ]{0,6})(?: bui|\\))/i],[d,[f,I],[m,h]],[/droid.+ (a?\\d[0-2]{2}so|[c-g]\\d{4}|so[-gl]\\w+|xq-a\\w[4-7][12])(?= bui|\\).+chrome\\/(?![1-6]{0,1}\\d\\.))/i],[d,[f,U],[m,h]],[/sony tablet [ps]/i,/\\b(?:sony)?sgp\\w+(?: bui|\\))/i],[[d,"Xperia Tablet"],[f,U],[m,w]],[/ (kb2005|in20[12]5|be20[12][59])\\b/i,/(?:one)?(?:plus)? (a\\d0\\d\\d)(?: b|\\))/i],[d,[f,"OnePlus"],[m,h]],[/(alexa)webm/i,/(kf[a-z]{2}wi|aeo[c-r]{2})( bui|\\))/i,/(kf[a-z]+)( bui|\\)).+silk\\//i],[d,[f,_],[m,w]],[/((?:sd|kf)[0349hijorstuw]+)( bui|\\)).+silk\\//i],[[d,/(.+)/g,"Fire Phone $1"],[f,_],[m,h]],[/(playbook);[-\\w\\),; ]+(rim)/i],[d,f,[m,w]],[/\\b((?:bb[a-f]|st[hv])100-\\d)/i,/\\(bb10; (\\w+)/i],[d,[f,x],[m,h]],[/(?:\\b|asus_)(transfo[prime ]{4,10} \\w+|eeepc|slider \\w+|nexus 7|padfone|p00[cj])/i],[d,[f,E],[m,w]],[/ (z[bes]6[027][012][km][ls]|zenfone \\d\\w?)\\b/i],[d,[f,E],[m,h]],[/(nexus 9)/i],[d,[f,"HTC"],[m,w]],[/(htc)[-;_ ]{1,2}([\\w ]+(?=\\)| bui)|\\w+)/i,/(zte)[- ]([\\w ]+?)(?: bui|\\/|\\))/i,/(alcatel|geeksphone|nexian|panasonic(?!(?:;|\\.))|sony(?!-bra))[-_ ]?([-\\w]*)/i],[f,[d,/_/g," "],[m,h]],[/droid.+; ([ab][1-7]-?[0178a]\\d\\d?)/i],[d,[f,"Acer"],[m,w]],[/droid.+; (m[1-5] note) bui/i,/\\bmz-([-\\w]{2,})/i],[d,[f,"Meizu"],[m,h]],[/(blackberry|benq|palm(?=\\-)|sonyericsson|acer|asus|dell|meizu|motorola|polytron)[-_ ]?([-\\w]*)/i,/(hp) ([\\w ]+\\w)/i,/(asus)-?(\\w+)/i,/(microsoft); (lumia[\\w ]+)/i,/(lenovo)[-_ ]?([-\\w]+)/i,/(jolla)/i,/(oppo) ?([\\w ]+) bui/i],[f,d,[m,h]],[/(kobo)\\s(ereader|touch)/i,/(archos) (gamepad2?)/i,/(hp).+(touchpad(?!.+tablet)|tablet)/i,/(kindle)\\/([\\w\\.]+)/i,/(nook)[\\w ]+build\\/(\\w+)/i,/(dell) (strea[kpr\\d ]*[\\dko])/i,/(le[- ]+pan)[- ]+(\\w{1,9}) bui/i,/(trinity)[- ]*(t\\d{3}) bui/i,/(gigaset)[- ]+(q\\w{1,9}) bui/i,/(vodafone) ([\\w ]+)(?:\\)| bui)/i],[f,d,[m,w]],[/(surface duo)/i],[d,[f,B],[m,w]],[/droid [\\d\\.]+; (fp\\du?)(?: b|\\))/i],[d,[f,"Fairphone"],[m,h]],[/(u304aa)/i],[d,[f,"AT&T"],[m,h]],[/\\bsie-(\\w*)/i],[d,[f,"Siemens"],[m,h]],[/\\b(rct\\w+) b/i],[d,[f,"RCA"],[m,w]],[/\\b(venue[\\d ]{2,7}) b/i],[d,[f,"Dell"],[m,w]],[/\\b(q(?:mv|ta)\\w+) b/i],[d,[f,"Verizon"],[m,w]],[/\\b(?:barnes[& ]+noble |bn[rt])([\\w\\+ ]*) b/i],[d,[f,"Barnes & Noble"],[m,w]],[/\\b(tm\\d{3}\\w+) b/i],[d,[f,"NuVision"],[m,w]],[/\\b(k88) b/i],[d,[f,"ZTE"],[m,w]],[/\\b(nx\\d{3}j) b/i],[d,[f,"ZTE"],[m,h]],[/\\b(gen\\d{3}) b.+49h/i],[d,[f,"Swiss"],[m,h]],[/\\b(zur\\d{3}) b/i],[d,[f,"Swiss"],[m,w]],[/\\b((zeki)?tb.*\\b) b/i],[d,[f,"Zeki"],[m,w]],[/\\b([yr]\\d{2}) b/i,/\\b(dragon[- ]+touch |dt)(\\w{5}) b/i],[[f,"Dragon Touch"],d,[m,w]],[/\\b(ns-?\\w{0,9}) b/i],[d,[f,"Insignia"],[m,w]],[/\\b((nxa|next)-?\\w{0,9}) b/i],[d,[f,"NextBook"],[m,w]],[/\\b(xtreme\\_)?(v(1[045]|2[015]|[3469]0|7[05])) b/i],[[f,"Voice"],d,[m,h]],[/\\b(lvtel\\-)?(v1[12]) b/i],[[f,"LvTel"],d,[m,h]],[/\\b(ph-1) /i],[d,[f,"Essential"],[m,h]],[/\\b(v(100md|700na|7011|917g).*\\b) b/i],[d,[f,"Envizen"],[m,w]],[/\\b(trio[-\\w\\. ]+) b/i],[d,[f,"MachSpeed"],[m,w]],[/\\btu_(1491) b/i],[d,[f,"Rotor"],[m,w]],[/(shield[\\w ]+) b/i],[d,[f,"Nvidia"],[m,w]],[/(sprint) (\\w+)/i],[f,d,[m,h]],[/(kin\\.[onetw]{3})/i],[[d,/\\./g," "],[f,B],[m,h]],[/droid.+; (cc6666?|et5[16]|mc[239][23]x?|vc8[03]x?)\\)/i],[d,[f,q],[m,w]],[/droid.+; (ec30|ps20|tc[2-8]\\d[kx])\\)/i],[d,[f,q],[m,h]],[/smart-tv.+(samsung)/i],[f,[m,y]],[/hbbtv.+maple;(\\d+)/i],[[d,/^/,"SmartTV"],[f,A],[m,y]],[/(nux; netcast.+smarttv|lg (netcast\\.tv-201\\d|android tv))/i],[[f,M],[m,y]],[/(apple) ?tv/i],[f,[d,S+" TV"],[m,y]],[/crkey/i],[[d,j+"cast"],[f,I],[m,y]],[/droid.+aft(\\w)( bui|\\))/i],[d,[f,_],[m,y]],[/\\(dtv[\\);].+(aquos)/i,/(aquos-tv[\\w ]+)\\)/i],[d,[f,L],[m,y]],[/(bravia[\\w ]+)( bui|\\))/i],[d,[f,U],[m,y]],[/(mitv-\\w{5}) bui/i],[d,[f,R],[m,y]],[/Hbbtv.*(technisat) (.*);/i],[f,d,[m,y]],[/\\b(roku)[\\dx]*[\\)\\/]((?:dvp-)?[\\d\\.]*)/i,/hbbtv\\/\\d+\\.\\d+\\.\\d+ +\\([\\w\\+ ]*; *([\\w\\d][^;]*);([^;]*)/i],[[f,H],[d,H],[m,y]],[/\\b(android tv|smart[- ]?tv|opera tv|tv; rv:)\\b/i],[[m,y]],[/(ouya)/i,/(nintendo) ([wids3utch]+)/i],[f,d,[m,b]],[/droid.+; (shield) bui/i],[d,[f,"Nvidia"],[m,b]],[/(playstation [345portablevi]+)/i],[d,[f,U],[m,b]],[/\\b(xbox(?: one)?(?!; xbox))[\\); ]/i],[d,[f,B],[m,b]],[/((pebble))app/i],[f,d,[m,T]],[/(watch)(?: ?os[,\\/]|\\d,\\d\\/)[\\d\\.]+/i],[d,[f,S],[m,T]],[/droid.+; (glass) \\d/i],[d,[f,I],[m,T]],[/droid.+; (wt63?0{2,3})\\)/i],[d,[f,q],[m,T]],[/(quest( 2| pro)?)/i],[d,[f,F],[m,T]],[/(tesla)(?: qtcarbrowser|\\/[-\\w\\.]+)/i],[f,[m,k]],[/(aeobc)\\b/i],[d,[f,_],[m,k]],[/droid .+?; ([^;]+?)(?: bui|\\) applew).+? mobile safari/i],[d,[m,h]],[/droid .+?; ([^;]+?)(?: bui|\\) applew).+?(?! mobile) safari/i],[d,[m,w]],[/\\b((tablet|tab)[;\\/]|focus\\/\\d(?!.+mobile))/i],[[m,w]],[/(phone|mobile(?:[;\\/]| [ \\w\\/\\.]*safari)|pda(?=.+windows ce))/i],[[m,h]],[/(android[-\\w\\. ]{0,9});.+buil/i],[d,[f,"Generic"]]],engine:[[/windows.+ edge\\/([\\w\\.]+)/i],[v,[p,"EdgeHTML"]],[/webkit\\/537\\.36.+chrome\\/(?!27)([\\w\\.]+)/i],[v,[p,"Blink"]],[/(presto)\\/([\\w\\.]+)/i,/(webkit|trident|netfront|netsurf|amaya|lynx|w3m|goanna)\\/([\\w\\.]+)/i,/ekioh(flow)\\/([\\w\\.]+)/i,/(khtml|tasman|links)[\\/ ]\\(?([\\w\\.]+)/i,/(icab)[\\/ ]([23]\\.[\\d\\.]+)/i,/\\b(libweb)/i],[p,v],[/rv\\:([\\w\\.]{1,9})\\b.+(gecko)/i],[v,p]],os:[[/microsoft (windows) (vista|xp)/i],[p,v],[/(windows) nt 6\\.2; (arm)/i,/(windows (?:phone(?: os)?|mobile))[\\/ ]?([\\d\\.\\w ]*)/i,/(windows)[\\/ ]?([ntce\\d\\. ]+\\w)(?!.+xbox)/i],[p,[v,J,X]],[/(win(?=3|9|n)|win 9x )([nt\\d\\.]+)/i],[[p,"Windows"],[v,J,X]],[/ip[honead]{2,4}\\b(?:.*os ([\\w]+) like mac|; opera)/i,/ios;fbsv\\/([\\d\\.]+)/i,/cfnetwork\\/.+darwin/i],[[v,/_/g,"."],[p,"iOS"]],[/(mac os x) ?([\\w\\. ]*)/i,/(macintosh|mac_powerpc\\b)(?!.+haiku)/i],[[p,K],[v,/_/g,"."]],[/droid ([\\w\\.]+)\\b.+(android[- ]x86|harmonyos)/i],[v,p],[/(android|webos|qnx|bada|rim tablet os|maemo|meego|sailfish)[-\\/ ]?([\\w\\.]*)/i,/(blackberry)\\w*\\/([\\w\\.]*)/i,/(tizen|kaios)[\\/ ]([\\w\\.]+)/i,/\\((series40);/i],[p,v],[/\\(bb(10);/i],[v,[p,x]],[/(?:symbian ?os|symbos|s60(?=;)|series60)[-\\/ ]?([\\w\\.]*)/i],[v,[p,"Symbian"]],[/mozilla\\/[\\d\\.]+ \\((?:mobile|tablet|tv|mobile; [\\w ]+); rv:.+ gecko\\/([\\w\\.]+)/i],[v,[p,N+" OS"]],[/web0s;.+rt(tv)/i,/\\b(?:hp)?wos(?:browser)?\\/([\\w\\.]+)/i],[v,[p,"webOS"]],[/watch(?: ?os[,\\/]|\\d,\\d\\/)([\\d\\.]+)/i],[v,[p,"watchOS"]],[/crkey\\/([\\d\\.]+)/i],[v,[p,j+"cast"]],[/(cros) [\\w]+(?:\\)| ([\\w\\.]+)\\b)/i],[[p,z],v],[/panasonic;(viera)/i,/(netrange)mmh/i,/(nettv)\\/(\\d+\\.[\\w\\.]+)/i,/(nintendo|playstation) ([wids345portablevuch]+)/i,/(xbox); +xbox ([^\\);]+)/i,/\\b(joli|palm)\\b ?(?:os)?\\/?([\\w\\.]*)/i,/(mint)[\\/\\(\\) ]?(\\w*)/i,/(mageia|vectorlinux)[; ]/i,/([kxln]?ubuntu|debian|suse|opensuse|gentoo|arch(?= linux)|slackware|fedora|mandriva|centos|pclinuxos|red ?hat|zenwalk|linpus|raspbian|plan 9|minix|risc os|contiki|deepin|manjaro|elementary os|sabayon|linspire)(?: gnu\\/linux)?(?: enterprise)?(?:[- ]linux)?(?:-gnu)?[-\\/ ]?(?!chrom|package)([-\\w\\.]*)/i,/(hurd|linux) ?([\\w\\.]*)/i,/(gnu) ?([\\w\\.]*)/i,/\\b([-frentopcghs]{0,5}bsd|dragonfly)[\\/ ]?(?!amd|[ix346]{1,2}86)([\\w\\.]*)/i,/(haiku) (\\w+)/i],[p,v],[/(sunos) ?([\\w\\.\\d]*)/i],[[p,"Solaris"],v],[/((?:open)?solaris)[-\\/ ]?([\\w\\.]*)/i,/(aix) ((\\d)(?=\\.|\\)| )[\\w\\.])*/i,/\\b(beos|os\\/2|amigaos|morphos|openvms|fuchsia|hp-ux|serenityos)/i,/(unix) ?([\\w\\.]*)/i],[p,v]]},Z=function(e,t){if(typeof e===c&&(t=e,e=a),!(this instanceof Z))return new Z(e,t).getResult();var n=typeof i!==s&&i.navigator?i.navigator:a,r=e||(n&&n.userAgent?n.userAgent:""),b=n&&n.userAgentData?n.userAgentData:a,y=t?function(e,t){var n={};for(var r in e)t[r]&&t[r].length%2==0?n[r]=t[r].concat(e[r]):n[r]=e[r];return n}(G,t):G,T=n&&n.userAgent==r;return this.getBrowser=function(){var e,t={};return t[p]=a,t[v]=a,V.call(t,r,y.browser),t[l]=typeof(e=t[v])===u?e.replace(/[^\\d\\.]/g,"").split(".")[0]:a,T&&n&&n.brave&&typeof n.brave.isBrave==o&&(t[p]="Brave"),t},this.getCPU=function(){var e={};return e[g]=a,V.call(e,r,y.cpu),e},this.getDevice=function(){var e={};return e[f]=a,e[d]=a,e[m]=a,V.call(e,r,y.device),T&&!e[m]&&b&&b.mobile&&(e[m]=h),T&&"Macintosh"==e[d]&&n&&typeof n.standalone!==s&&n.maxTouchPoints&&n.maxTouchPoints>2&&(e[d]="iPad",e[m]=w),e},this.getEngine=function(){var e={};return e[p]=a,e[v]=a,V.call(e,r,y.engine),e},this.getOS=function(){var e={};return e[p]=a,e[v]=a,V.call(e,r,y.os),T&&!e[p]&&b&&"Unknown"!=b.platform&&(e[p]=b.platform.replace(/chrome os/i,z).replace(/macos/i,K)),e},this.getResult=function(){return{ua:this.getUA(),browser:this.getBrowser(),engine:this.getEngine(),os:this.getOS(),device:this.getDevice(),cpu:this.getCPU()}},this.getUA=function(){return r},this.setUA=function(e){return r=typeof e===u&&e.length>350?H(e,350):e,this},this.setUA(r),this};Z.VERSION="1.0.35",Z.BROWSER=$([p,v,l]),Z.CPU=$([g]),Z.DEVICE=$([d,f,m,b,h,y,w,T,k]),Z.ENGINE=Z.OS=$([p,v]),typeof t!==s?(e.exports&&(t=e.exports=Z),t.UAParser=Z):n.amdO?(r=function(){return Z}.call(t,n,t,e))===a||(e.exports=r):typeof i!==s&&(i.UAParser=Z);var Y=typeof i!==s&&(i.jQuery||i.Zepto);if(Y&&!Y.ua){var ee=new Z;Y.ua=ee.getResult(),Y.ua.get=function(){return ee.getUA()},Y.ua.set=function(e){ee.setUA(e);var t=ee.getResult();for(var n in t)Y.ua[n]=t[n]}}}("object"==typeof window?window:this)}},t={};function n(r){var i=t[r];if(void 0!==i)return i.exports;var a=t[r]={exports:{}};return e[r].call(a.exports,a,a.exports,n),a.exports}n.amdO={},n.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return n.d(t,{a:t}),t},n.d=(e,t)=>{for(var r in t)n.o(t,r)&&!n.o(e,r)&&Object.defineProperty(e,r,{enumerable:!0,get:t[r]})},n.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),n.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var r={};return(()=>{"use strict";n.r(r),n.d(r,{ActionType:()=>f,AmplitudePlatformName:()=>g,AnalyticsEventImportance:()=>l,AnalyticsQueries:()=>e,AuthStatus:()=>b,ComponentType:()=>m,IThresholdTier:()=>Jt,MetricType:()=>d,PlatformName:()=>v,SessionActions:()=>h,SessionAutomatedEvents:()=>w,SessionRank:()=>y,SubjectType:()=>p,UserTypeCommerce:()=>c,UserTypeInsto:()=>i,UserTypeRetail:()=>t,UserTypeRetailBusinessBanking:()=>s,UserTypeRetailEmployeeInternal:()=>a,UserTypeRetailEmployeePersonal:()=>o,UserTypeWallet:()=>u,automatedEvents:()=>xn,automatedMappingConfig:()=>In,clearMarkEntry:()=>Vn,clearPerformanceMarkEntries:()=>Xn,config:()=>A,createEventConfig:()=>On,createNewSpan:()=>Ln,createNewTrace:()=>Un,device:()=>W,endPerfMark:()=>Jn,exposeExperiment:()=>wn,flushQueue:()=>or,generateUUID:()=>V,getAnalyticsHeaders:()=>sr,getReferrerData:()=>le,getTracingHeaders:()=>An,getTracingId:()=>Dn,getUrlHostname:()=>pe,getUrlParams:()=>me,getUrlPathname:()=>fe,getUserContext:()=>ar,identify:()=>Tn,identifyFlow:()=>xe,identity:()=>H,identityFlow:()=>Se,incrementUjNavigation:()=>an,init:()=>yn,initNextJsTrackPageview:()=>_n,initTrackPageview:()=>kn,isEventKeyFormatValid:()=>we,isSessionEnded:()=>pt,location:()=>re,logEvent:()=>$t,logMetric:()=>Ht,logPageView:()=>on,logTrace:()=>Rn,markNTBT:()=>tn,markStep:()=>nn,markStepOnce:()=>rn,onVisibilityChange:()=>ln,optIn:()=>En,optOut:()=>Sn,perfMark:()=>Wn,persistentData:()=>oe,postMessage:()=>K,recordSessionDuration:()=>pn,removeFromIdentifyFlow:()=>Ee,savePersistentData:()=>st,sendScheduledEvents:()=>Bt,setBreadcrumbs:()=>ie,setConfig:()=>U,setLocation:()=>ae,setPagePath:()=>ve,setPageview:()=>Kt,setPersistentData:()=>se,setSessionStart:()=>dt,setTime:()=>Ue,startPerfMark:()=>Hn,timeStone:()=>Le,useEventLogger:()=>Yn,useLogEventOnMount:()=>tr,usePerformanceMarks:()=>rr});let e=function(e){return e.fbclid="fbclid",e.gclid="gclid",e.msclkid="msclkid",e.ptclid="ptclid",e.ttclid="ttclid",e.utm_source="utm_source",e.utm_medium="utm_medium",e.utm_campaign="utm_campaign",e.utm_term="utm_term",e.utm_content="utm_content",e}({});const t=0,i=1,a=2,o=3,s=4,c=5,u=6;let l=function(e){return e.low="low",e.high="high",e}({}),d=function(e){return e.count="count",e.rate="rate",e.gauge="gauge",e.distribution="distribution",e.histogram="histogram",e}({}),p=function(e){return e.commerce_merchant="commerce_merchant",e.device="device",e.edp_fingerprint_id="edp_fingerprint_id",e.nft_user="nft_user",e.user="user",e.wallet_user="wallet_user",e.uuid="user_uuid",e}({}),m=function(e){return e.unknown="unknown",e.banner="banner",e.button="button",e.card="card",e.chart="chart",e.content_script="content_script",e.dropdown="dropdown",e.link="link",e.page="page",e.modal="modal",e.table="table",e.search_bar="search_bar",e.service_worker="service_worker",e.text="text",e.text_input="text_input",e.tray="tray",e.checkbox="checkbox",e.icon="icon",e}({}),f=function(e){return e.unknown="unknown",e.blur="blur",e.click="click",e.change="change",e.dismiss="dismiss",e.focus="focus",e.hover="hover",e.select="select",e.measurement="measurement",e.move="move",e.process="process",e.render="render",e.scroll="scroll",e.view="view",e.search="search",e.keyPress="keyPress",e}({}),v=function(e){return e.unknown="unknown",e.web="web",e.android="android",e.ios="ios",e.mobile_web="mobile_web",e.tablet_web="tablet_web",e.server="server",e.windows="windows",e.macos="macos",e.extension="extension",e}({}),g=function(e){return e.web="Web",e.ios="iOS",e.android="Android",e}({}),b=function(e){return e[e.notLoggedIn=0]="notLoggedIn",e[e.loggedIn=1]="loggedIn",e}({}),h=function(e){return e.ac="ac",e.af="af",e.ah="ah",e.al="al",e.am="am",e.ar="ar",e.as="as",e}({}),w=function(e){return e.pv="pv",e}({}),y=function(e){return e.xs="xs",e.s="s",e.m="m",e.l="l",e.xl="xl",e.xxl="xxl",e}({});const T="https://analytics-service-dev.cbhq.net",k=3e5,_=5e3,S="analytics-db",E="experiment-exposure-db",x="Analytics SDK:",O=Object.values(e),j="pageview",N="session_duration",I={navigationTiming:{eventName:"perf_navigation_timing"},redirectTime:{eventName:"perf_redirect_time"},RT:{eventName:"perf_redirect_time"},TTFB:{eventName:"perf_time_to_first_byte"},networkInformation:{eventName:"perf_network_information"},storageEstimate:{eventName:"perf_storage_estimate"},FCP:{eventName:"perf_first_contentful_paint"},FID:{eventName:"perf_first_input_delay"},LCP:{eventName:"perf_largest_contentful_paint"},CLS:{eventName:"perf_cumulative_layout_shift"},TBT:{eventName:"perf_total_blocking_time"},NTBT:{eventName:"perf_navigation_total_blocking_time"},INP:{eventName:"perf_interact_to_next_paint"},ET:{eventName:"perf_element_timing"},userJourneyStep:{eventName:"perf_user_journey_step"}},P="1",M="web";function B(){return B=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},B.apply(this,arguments)}const C=/^(https?:\\/\\/)/;function D(e){return{eventsEndpoint:e+"/amp",metricsEndPoint:e+"/metrics",exposureEndpoint:e+"/track-exposures",tracesEndpoint:e+"/traces"}}const A=B({authCookie:"logged_in",amplitudeApiKey:"",batchEventsPeriod:_,batchEventsThreshold:30,batchMetricsPeriod:_,batchMetricsThreshold:30,batchTracesPeriod:_,batchTracesThreshold:30,headers:{},interactionManager:null,isAlwaysAuthed:!1,isProd:!1,isInternalApplication:!1,onError:(e,t)=>{console.error(x,e,t)},platform:v.unknown,projectName:"",ricTimeoutScheduleEvent:1e3,ricTimeoutSetDevice:500,showDebugLogging:!1,trackUserId:!1,version:null,apiEndpoint:T},D(T),{steps:{}}),L=[].reduce(((e,t)=>n=>e(t(n))),(e=>{if(!e.isProd)return e.isInternalApplication?(e.apiEndpoint="https://analytics-service-internal-dev.cbhq.net",B({},e,D(e.apiEndpoint))):e;const t=(e=>e.apiEndpoint?C.test(e.apiEndpoint)?e.apiEndpoint:\`https://\${e.apiEndpoint}\`:e.isInternalApplication?"https://analytics-service-internal.cbhq.net":"https://as.coinbase.com")(e);return B({},e,{apiEndpoint:t},D(t))})),U=e=>{const{batchEventsThreshold:t,batchMetricsThreshold:n,batchTracesThreshold:r}=e,i=[t,n,r];for(const e of i)if((e||0)>30){console.warn("You are setting the threshhold for the batch limit to be greater than 30. This may cause request overload.");break}Object.assign(A,L(e))},R=[v.web,v.mobile_web,v.tablet_web];function q(){return"android"===A.platform}function F(){return"ios"===A.platform}function z(){return R.includes(A.platform)}function K(e){if(z()&&navigator&&"serviceWorker"in navigator&&navigator.serviceWorker.controller)try{navigator.serviceWorker.controller.postMessage(e)}catch(e){e instanceof Error&&A.onError(e)}}var $=n(353),Q=n.n($);const W={amplitudeOSName:null,amplitudeOSVersion:null,amplitudeDeviceModel:null,amplitudePlatform:null,browserName:null,browserMajor:null,osName:null,userAgent:null,width:null,height:null},H={countryCode:null,deviceId:null,device_os:null,isOptOut:!1,languageCode:null,locale:null,jwt:null,session_lcc_id:null,userAgent:null,userId:null},V=e=>e?(e^16*Math.random()>>e/4).toString(16):"10000000-1000-4000-8000-100000000000".replace(/[018]/g,V),J=()=>A.isAlwaysAuthed||!!H.userId,X=()=>{const e={};return H.countryCode&&(e.country_code=H.countryCode),e},G=()=>{const{platform:e}=A;if(e===v.web)switch(!0){case window.matchMedia("(max-width: 560px)").matches:return v.mobile_web;case window.matchMedia("(max-width: 1024px, min-width: 561px)").matches:return v.tablet_web}return e},Z=()=>{var e,t,n,r,i;z()?("requestIdleCallback"in window?window.requestIdleCallback(ne,{timeout:A.ricTimeoutSetDevice}):ne(),W.amplitudePlatform=g.web,W.userAgent=(null==(e=window)||null==(e=e.navigator)?void 0:e.userAgent)||null,ee({height:null!=(t=null==(n=window)?void 0:n.innerHeight)?t:null,width:null!=(r=null==(i=window)?void 0:i.innerWidth)?r:null})):F()?(W.amplitudePlatform=g.ios,W.userAgent=H.userAgent,W.userAgent&&ne()):q()&&(W.userAgent=H.userAgent,W.amplitudePlatform=g.android,W.userAgent&&ne())},Y=e=>{Object.assign(H,e),z()&&K({identity:{isAuthed:!!H.userId,locale:H.locale||null}})},ee=e=>{W.height=e.height,W.width=e.width},te=()=>{U({platform:G()}),z()&&K({config:{platform:A.platform}})},ne=()=>{var e;performance.mark&&performance.mark("ua_parser_start");const t=new(Q())(null!=(e=W.userAgent)?e:"").getResult();W.browserName=t.browser.name||null,W.browserMajor=t.browser.major||null,W.osName=t.os.name||null,W.amplitudeOSName=W.browserName,W.amplitudeOSVersion=W.browserMajor,W.amplitudeDeviceModel=W.osName,K({device:{browserName:W.browserName,osName:W.osName}}),performance.mark&&(performance.mark("ua_parser_end"),performance.measure("ua_parser","ua_parser_start","ua_parser_end"))},re={breadcrumbs:[],initialUAAData:{},pageKey:"",pageKeyRegex:{},pagePath:"",prevPageKey:"",prevPagePath:""};function ie(e){Object.assign(re,{breadcrumbs:e})}function ae(e){Object.assign(re,e)}const oe={eventId:0,sequenceNumber:0,sessionId:0,lastEventTime:0,sessionStart:0,sessionUUID:null,userId:null,ac:0,af:0,ah:0,al:0,am:0,ar:0,as:0,pv:0};function se(e){Object.assign(oe,e)}function ce(){var e,t;return null!=(e=null==(t=document)?void 0:t.referrer)?e:""}function ue(){return ue=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},ue.apply(this,arguments)}const le=()=>{const e=ce();if(!e)return{};const t=new URL(e);return t.hostname===pe()?{}:{referrer:e,referring_domain:t.hostname}},de=()=>{const e=new URLSearchParams(me()),t={};return O.forEach((n=>{e.has(n)&&(t[n]=(e.get(n)||"").toLowerCase())})),t},pe=()=>{var e;return(null==(e=window)||null==(e=e.location)?void 0:e.hostname)||""},me=()=>{var e;return(null==(e=window)||null==(e=e.location)?void 0:e.search)||""},fe=()=>{var e;return(null==(e=window)||null==(e=e.location)?void 0:e.pathname)||""},ve=()=>{const e=A.overrideWindowLocation?re.pagePath:fe()+me();e&&e!==re.pagePath&&(e!==re.pagePath&&ge(),re.pagePath=e,re.pageKeyRegex&&Object.keys(re.pageKeyRegex).some((e=>{if(re.pageKeyRegex[e].test(re.pagePath))return re.pageKey=e,!0})))},ge=()=>{if(z()){const e=ce();if(!re.prevPagePath&&e){const t=new URL(e);if(t.hostname===pe())return void(re.prevPagePath=t.pathname)}}re.prevPagePath=re.pagePath,re.prevPageKey=re.pageKey},be=e=>{z()&&Object.assign(e,z()?(Object.keys(re.initialUAAData).length>0||(new URLSearchParams(me()),re.initialUAAData=ue({},(()=>{const e={};return O.forEach((t=>{oe[t]&&(e[t]=oe[t])})),e})(),de(),le())),re.initialUAAData):re.initialUAAData)},he=/^[a-zd]+(_[a-zd]+)*$/;function we(e){return he.test(e)}function ye(){return ye=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},ye.apply(this,arguments)}const Te=["action","component_type","component_name","context","logging_id"],ke=["num_non_hardware_accounts","ujs"],_e="ujs_",Se={};function Ee(e){e.forEach((e=>{ke.includes(e)&&delete Se[e]}))}function xe(e){var t;const n=Object.entries(e).reduce(((e,t)=>{const[n,r]=t;return!Te.includes(n)&&ke.includes(n)?we(n)?ye({},e,{[n]:r}):(A.onError(new Error("IdentityFlow property names must have snake case format"),{[n]:r}),e):e}),{});null!=(t=n.ujs)&&t.length&&(n.ujs=n.ujs.map((e=>\`\${_e}\${e}\`))),Object.assign(Se,n)}function Oe(){return A.platform!==v.unknown||(A.onError(new Error("SDK platform not initialized")),!1)}const je={eventsQueue:[],eventsScheduled:!1,metricsQueue:[],metricsScheduled:!1,tracesQueue:[],tracesScheduled:!1};function Ne(e){Object.assign(je,e)}const Ie={ac:0,af:0,ah:0,al:0,am:0,ar:0,as:0,pv:0,sqs:0},Pe={ac:20,af:5,ah:1,al:1,am:0,ar:10,as:20},Me={pv:25},Be={xs:0,s:1,m:1,l:2,xl:2,xxl:2},Ce=e=>e<15?y.xs:e<60?y.s:e<240?y.m:e<960?y.l:e<3840?y.xl:y.xxl,De=e=>{Object.assign(Ie,e)};function Ae(){return(new Date).getTime()}const Le={timeStart:Ae(),timeOnPagePath:0,timeOnPageKey:0,prevTimeOnPagePath:0,prevTimeOnPageKey:0,sessionDuration:0,sessionEnd:0,sessionStart:0,prevSessionDuration:0};function Ue(e){Object.assign(Le,e)}const Re=(e,t)=>t.some((t=>e instanceof t));let qe,Fe;const ze=new WeakMap,Ke=new WeakMap,$e=new WeakMap,Qe=new WeakMap,We=new WeakMap;let He={get(e,t,n){if(e instanceof IDBTransaction){if("done"===t)return Ke.get(e);if("objectStoreNames"===t)return e.objectStoreNames||$e.get(e);if("store"===t)return n.objectStoreNames[1]?void 0:n.objectStore(n.objectStoreNames[0])}return Je(e[t])},set:(e,t,n)=>(e[t]=n,!0),has:(e,t)=>e instanceof IDBTransaction&&("done"===t||"store"===t)||t in e};function Ve(e){return"function"==typeof e?(t=e)!==IDBDatabase.prototype.transaction||"objectStoreNames"in IDBTransaction.prototype?(Fe||(Fe=[IDBCursor.prototype.advance,IDBCursor.prototype.continue,IDBCursor.prototype.continuePrimaryKey])).includes(t)?function(...e){return t.apply(Xe(this),e),Je(ze.get(this))}:function(...e){return Je(t.apply(Xe(this),e))}:function(e,...n){const r=t.call(Xe(this),e,...n);return $e.set(r,e.sort?e.sort():[e]),Je(r)}:(e instanceof IDBTransaction&&function(e){if(Ke.has(e))return;const t=new Promise(((t,n)=>{const r=()=>{e.removeEventListener("complete",i),e.removeEventListener("error",a),e.removeEventListener("abort",a)},i=()=>{t(),r()},a=()=>{n(e.error||new DOMException("AbortError","AbortError")),r()};e.addEventListener("complete",i),e.addEventListener("error",a),e.addEventListener("abort",a)}));Ke.set(e,t)}(e),Re(e,qe||(qe=[IDBDatabase,IDBObjectStore,IDBIndex,IDBCursor,IDBTransaction]))?new Proxy(e,He):e);var t}function Je(e){if(e instanceof IDBRequest)return function(e){const t=new Promise(((t,n)=>{const r=()=>{e.removeEventListener("success",i),e.removeEventListener("error",a)},i=()=>{t(Je(e.result)),r()},a=()=>{n(e.error),r()};e.addEventListener("success",i),e.addEventListener("error",a)}));return t.then((t=>{t instanceof IDBCursor&&ze.set(t,e)})).catch((()=>{})),We.set(t,e),t}(e);if(Qe.has(e))return Qe.get(e);const t=Ve(e);return t!==e&&(Qe.set(e,t),We.set(t,e)),t}const Xe=e=>We.get(e),Ge=["get","getKey","getAll","getAllKeys","count"],Ze=["put","add","delete","clear"],Ye=new Map;function et(e,t){if(!(e instanceof IDBDatabase)||t in e||"string"!=typeof t)return;if(Ye.get(t))return Ye.get(t);const n=t.replace(/FromIndex$/,""),r=t!==n,i=Ze.includes(n);if(!(n in(r?IDBIndex:IDBObjectStore).prototype)||!i&&!Ge.includes(n))return;const a=async function(e,...t){const a=this.transaction(e,i?"readwrite":"readonly");let o=a.store;return r&&(o=o.index(t.shift())),(await Promise.all([o[n](...t),i&&a.done]))[0]};return Ye.set(t,a),a}var tt;tt=He,He={...tt,get:(e,t,n)=>et(e,t)||tt.get(e,t,n),has:(e,t)=>!!et(e,t)||tt.has(e,t)};const nt={isReady:!1,idbKeyval:null};function rt(e){Object.assign(nt,e)}const it={},at=async e=>{if(!nt.idbKeyval)return Promise.resolve(null);try{return await nt.idbKeyval.get(e)}catch(e){return A.onError(new Error("IndexedDB:Get:InternalError")),Promise.resolve(null)}},ot=async(e,t)=>{if(nt.idbKeyval)try{await nt.idbKeyval.set(e,t)}catch(e){A.onError(new Error("IndexedDB:Set:InternalError"))}},st=()=>{"server"!==A.platform&&(se({sessionStart:Le.sessionStart,ac:Ie.ac,af:Ie.af,ah:Ie.ah,al:Ie.al,am:Ie.am,ar:Ie.ar,as:Ie.as,pv:Ie.pv}),H.userId&&se({userId:H.userId}),ot(S,oe))},ct="rgb(5,177,105)",ut=e=>{const{metricName:t,data:n}=e,r=e.importance||l.low;if(!A.showDebugLogging||!console)return;const i=\`%c \${x}\`,a=\`color:\${ct};font-size:11px;\`,o=\`Importance: \${r}\`;console.group(i,a,t,o),n.forEach((e=>{e.event_type?console.log(e.event_type,e):console.log(e)})),console.groupEnd()},lt=e=>{const{metricName:t,data:n}=e,r=e.importance||l.low;if(!A.showDebugLogging||!console)return;const i=\`color:\${ct};font-size:11px;\`,a=\`%c \${x}\`,o=\`Importance: \${r}\`;console.log(a,i,t,n,o)},dt=()=>{const e=Ae();oe.sessionId&&oe.lastEventTime&&oe.sessionUUID&&!pt(e)||(oe.sessionId=e,oe.sessionUUID=V(),Ue({sessionStart:e}),lt({metricName:"Started new session:",data:{persistentData:oe,timeStone:Le}})),oe.lastEventTime=e},pt=e=>e-oe.lastEventTime>18e5;function mt(){return mt=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},mt.apply(this,arguments)}const ft=e=>{var t;(e=>{switch(e.action){case f.click:Ie.ac+=1;break;case f.focus:Ie.af+=1;break;case f.hover:Ie.ah+=1;break;case f.move:Ie.am+=1;break;case f.scroll:Ie.al+=1;break;case f.search:Ie.ar+=1;break;case f.select:Ie.as+=1}})(t=e),t.event_type!==j?t.event_type===N&&((e=>{if(!e.session_rank)return;const t=e.session_rank;Object.values(h).forEach((e=>{Ie.sqs+=Ie[e]*Pe[e]})),Object.values(w).forEach((e=>{Ie.sqs+=Ie[e]*Me[e]})),Ie.sqs*=Be[t]})(t),Object.assign(t,Ie),De({ac:0,af:0,ah:0,al:0,am:0,ar:0,as:0,pv:0,sqs:0})):Ie.pv+=1;const n=e.event_type;delete e.event_type;const r=e.deviceId?e.deviceId:null,i=e.timestamp;return delete e.timestamp,se({eventId:oe.eventId+1}),se({sequenceNumber:oe.sequenceNumber+1}),dt(),st(),{device_id:H.deviceId||r||null,user_id:H.userId,timestamp:i,event_id:oe.eventId,session_id:oe.sessionId||-1,event_type:n,version_name:A.version||null,platform:W.amplitudePlatform,os_name:W.amplitudeOSName,os_version:W.amplitudeOSVersion,device_model:W.amplitudeDeviceModel,language:H.languageCode,event_properties:mt({},e,{session_uuid:oe.sessionUUID,height:W.height,width:W.width}),user_properties:X(),uuid:V(),library:{name:"@cbhq/client-analytics",version:"10.6.0"},sequence_number:oe.sequenceNumber,user_agent:W.userAgent||H.userAgent}},vt=e=>e.map((e=>ft(e)));function gt(){return gt=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},gt.apply(this,arguments)}const bt=e=>e.map((e=>(e=>{const t=e.tags||{},n=gt({authed:J()?"true":"false",platform:A.platform},t,{project_name:A.projectName,version_name:A.version||null});return{metric_name:e.metricName,page_path:e.pagePath||null,value:e.value,tags:n,type:e.metricType}})(e))),ht=e=>0!==je.metricsQueue.length&&(je.metricsQueue.length>=A.batchMetricsThreshold||(je.metricsScheduled||(je.metricsScheduled=!0,setTimeout((()=>{je.metricsScheduled=!1,e(bt(je.metricsQueue)),je.metricsQueue=[]}),A.batchMetricsPeriod)),!1)),wt=e=>0!==je.tracesQueue.length&&(je.tracesQueue.length>=A.batchTracesThreshold||(je.tracesScheduled||(je.tracesScheduled=!0,setTimeout((()=>{je.tracesScheduled=!1,e(je.tracesQueue),je.tracesQueue=[]}),A.batchTracesPeriod)),!1)),yt=e=>{var t;z()&&null!=(t=window)&&t.requestIdleCallback?window.requestIdleCallback(e,{timeout:A.ricTimeoutScheduleEvent}):(q()||F())&&A.interactionManager?A.interactionManager.runAfterInteractions(e):e()};function Tt(){return Tt=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},Tt.apply(this,arguments)}const kt="application/x-www-form-urlencoded; charset=UTF-8",_t=e=>{const{data:t,importance:n,isJSON:r,onError:i,url:a}=e,o=r?"application/json":kt,s=n||l.low,c=r?JSON.stringify(t):new URLSearchParams(t).toString();function u(){const e=new XMLHttpRequest;e.open("POST",a,!0),Object.keys(A.headers||{}).forEach((t=>{e.setRequestHeader(t,A.headers[t])})),e.setRequestHeader("Content-Type",kt),H.jwt&&e.setRequestHeader("authorization",\`Bearer \${H.jwt}\`),e.send(c)}if(!z()||r||!("sendBeacon"in navigator)||s!==l.low||A.headers&&0!==Object.keys(A.headers).length)if(z()&&!r)u();else{const e=Tt({},A.headers,{"Content-Type":o});H.jwt&&(e.Authorization=\`Bearer \${H.jwt}\`),fetch(a,{method:"POST",mode:"no-cors",headers:e,body:c}).catch((e=>{i(e,{context:"AnalyticsSDKApiError"})}))}else{const e=new Blob([c],{type:kt});try{navigator.sendBeacon.bind(navigator)(a,e)||u()}catch(e){console.error(e),u()}}};var St=n(762),Et=n.n(St);const xt=(e,t,n)=>{const r=e||"";return Et()("2"+r+t+n)};function Ot(){return Ot=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},Ot.apply(this,arguments)}class jt extends Error{constructor(e){super(e),this.name="CircularJsonReference",this.message=e,"function"==typeof Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=new Error(e).stack}}class Nt extends jt{constructor(...e){super(...e),this.name="DomReferenceInAnalyticsEvent"}}function It(){return It=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},It.apply(this,arguments)}const Pt=(e,t=l.low)=>{var n;e&&je.eventsQueue.push(e),nt.isReady&&(!A.trackUserId||H.userId?(t===l.high||(n=Mt,0!==je.eventsQueue.length&&(je.eventsQueue.length>=A.batchEventsThreshold||(je.eventsScheduled||(je.eventsScheduled=!0,setTimeout((()=>{je.eventsScheduled=!1,n(vt(je.eventsQueue)),je.eventsQueue=[]}),A.batchEventsPeriod)),0))))&&Bt():je.eventsQueue.length>10&&(A.trackUserId=!1,A.onError(new Error("userId not set in Logged-in"))))},Mt=(e,t=l.low)=>{if(H.isOptOut||0===e.length)return;let n;try{n=JSON.stringify(e)}catch(t){const r=e.map((e=>e.event_type)).join(", "),[i,a]=(e=>{try{const n=[];for(const r of e){const e=Ot({},r);r.event_properties&&(e.event_properties=Ot({},e.event_properties,{currentTarget:null,target:null,relatedTarget:null,_dispatchInstances:null,_targetInst:null,view:(t=r.event_properties.view,["string","number","boolean"].includes(typeof t)?r.event_properties.view:null)})),n.push(e)}return[!0,JSON.stringify(n)]}catch(e){return[!1,""]}var t})(e);if(!i)return void A.onError(new jt(t instanceof Error?t.message:"unknown"),{listEventType:r});n=a,A.onError(new Nt("Found DOM element reference"),{listEventType:r,stringifiedEventData:n})}const r=Ae().toString(),i=It({},{e:n,v:"2",upload_time:r},{client:A.amplitudeApiKey,checksum:xt(A.amplitudeApiKey,n,r)});_t({url:A.eventsEndpoint,data:i,importance:t,onError:A.onError}),ut({metricName:"Batch Events",data:e,importance:t})},Bt=()=>{Mt(vt(je.eventsQueue)),Ne({eventsQueue:[]})};function Ct(){return Ct=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},Ct.apply(this,arguments)}const Dt=Object.values(f),At=Object.values(m),Lt=e=>Dt.includes(e)?e:f.unknown,Ut=e=>At.includes(e)?e:m.unknown,Rt=(e,t,n)=>{const r={auth:J()?b.loggedIn:b.notLoggedIn,action:Lt(e),component_type:Ut(t),logging_id:n,platform:A.platform,project_name:A.projectName};return"number"==typeof H.userTypeEnum&&(r.user_type_enum=H.userTypeEnum),r},qt=e=>{const t=Ae();if(!e)return A.onError(new Error("missing logData")),Ct({},Rt(f.unknown,m.unknown),{locale:H.locale,session_lcc_id:H.session_lcc_id,timestamp:t,time_start:Le.timeStart});const n=Ct({},e,Rt(e.action,e.componentType,e.loggingId),{locale:H.locale,session_lcc_id:H.session_lcc_id,timestamp:t,time_start:Le.timeStart});return delete n.componentType,delete n.loggingId,n},Ft={blacklistRegex:[],isEnabled:!1};function zt(){return{page_key:re.pageKey,page_path:re.pagePath,prev_page_key:re.prevPageKey,prev_page_path:re.prevPagePath}}function Kt(e){Object.assign(Ft,e)}function $t(e,t,n=l.low){if(H.isOptOut)return;if(!Oe())return;const r=qt(t);!function(e){Ft.isEnabled&&(ve(),Object.assign(e,zt()))}(r),be(r),function(e){Object.keys(Se).length>0&&Object.assign(e,Se)}(r),r.has_double_fired=!1,r.event_type=e,n===l.high?Pt(r,n):yt((()=>{Pt(r)}))}function Qt(e,t=!1){t?_t({url:A.metricsEndPoint,data:{metrics:e},isJSON:!0,onError:A.onError}):yt((()=>{_t({url:A.metricsEndPoint,data:{metrics:e},isJSON:!0,onError:A.onError})})),ut({metricName:"Batch Metrics",data:e})}function Wt(){return Wt=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},Wt.apply(this,arguments)}function Ht(e){if(!Oe())return;v.server!==A.platform&&!e.pagePath&&re.pagePath&&(e.pagePath=re.pagePath);const t=Object.keys(Se).length?Wt({},e.tags,Se):e.tags;t&&Object.assign(e,{tags:t}),je.metricsQueue.push(e),ht(Qt)&&(Qt(bt(je.metricsQueue)),je.metricsQueue=[])}function Vt(){return Vt=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},Vt.apply(this,arguments)}let Jt=function(e){return e.instant="instant",e.quick="quick",e.moderate="moderate",e.slow="slow",e.unavoidable="unavoidable",e}({});function Xt(e){return e.toLowerCase()}let Gt={};const Zt=(e,t)=>{null!=A&&A.onMarkStep&&A.onMarkStep(e,t),xe({ujs:t})};let Yt;const en={Perfume:()=>{},markStep:e=>{},markStepOnce:e=>{},incrementUjNavigation:()=>{}},tn=()=>{z()&&Yt&&Yt.markNTBT&&Yt.markNTBT()},nn=e=>{z()&&Yt&&en.markStep&&en.markStep(e)},rn=e=>{z()&&Yt&&en.markStepOnce&&en.markStepOnce(e)},an=()=>{z()&&Yt&&en.incrementUjNavigation&&en.incrementUjNavigation()};function on(e={callMarkNTBT:!0}){"unknown"!==A.platform&&(Ft.blacklistRegex.some((e=>e.test(fe())))||($t(j,{action:f.render,componentType:m.page}),e.callMarkNTBT&&tn()))}let sn=!1,cn=!1;const un=e=>{sn=!e.persisted},ln=(e,t="hidden",n=!1)=>{cn||(addEventListener("pagehide",un),addEventListener("beforeunload",(()=>{})),cn=!0),addEventListener("visibilitychange",(({timeStamp:n})=>{document.visibilityState===t&&e({timeStamp:n,isUnloading:sn})}),{capture:!0,once:n})},dn=36e3;function pn(){const e=pt(Ae());if(e&&(O.forEach((e=>{oe[e]&&delete oe[e]})),st()),!oe.lastEventTime||!Le.sessionStart||!e)return;const t=Math.round((oe.lastEventTime-Le.sessionStart)/1e3);if(t<1||t>dn)return;const n=Ce(t);$t(N,{action:f.measurement,componentType:m.page,session_duration:t,session_end:oe.lastEventTime,session_start:Le.sessionStart,session_rank:n})}function mn(){return mn=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},mn.apply(this,arguments)}const fn=[],vn=[],gn=()=>{const e=fn.shift();e&&e()},bn=()=>{const e=vn.shift();e&&e()};let hn={};function wn(e){const t=function(e){return{test_name:e.testName,group_name:e.group,subject_id:e.subjectId,exposed_at:Ae(),subject_type:e.subjectType,platform:A.platform}}(e);hn[e.testName]=hn[e.testName]||0,hn[e.testName]+k>Ae()?lt({metricName:\`Event: exposeExperiment \${e.testName} not sent\`,data:t}):(hn[e.testName]=Ae(),ot(E,hn),lt({metricName:\`Event: exposeExperiment \${e.testName} sent\`,data:t}),_t({url:A.exposureEndpoint,data:[t],onError:(t,n)=>{hn[e.testName]=0,ot(E,hn),A.onError(t,n)},isJSON:!0,importance:l.high}))}const yn=e=>{var t,r,i;U(e),z()&&(H.languageCode=(null==(t=navigator)?void 0:t.languages[0])||(null==(r=navigator)?void 0:r.language)||""),te(),(()=>{var e;if(z()&&null!=(e=window)&&e.indexedDB){const e=function(e,t,{blocked:n,upgrade:r,blocking:i,terminated:a}={}){const o=indexedDB.open(e,t),s=Je(o);return r&&o.addEventListener("upgradeneeded",(e=>{r(Je(o.result),e.oldVersion,e.newVersion,Je(o.transaction),e)})),n&&o.addEventListener("blocked",(e=>n(e.oldVersion,e.newVersion,e))),s.then((e=>{a&&e.addEventListener("close",(()=>a())),i&&e.addEventListener("versionchange",(e=>i(e.oldVersion,e.newVersion,e)))})).catch((()=>{})),s}("keyval-store",1,{upgrade(e){e.createObjectStore("keyval")}});rt({idbKeyval:{get:async t=>(await e).get("keyval",t),set:async(t,n)=>(await e).put("keyval",n,t),delete:async t=>(await e).delete("keyval",t),keys:async()=>(await e).getAllKeys("keyval")}})}else rt({idbKeyval:{get:async e=>new Promise((t=>{t(it[e])})),set:async(e,t)=>new Promise((n=>{it[e]=t,n(e)})),delete:async e=>new Promise((()=>{delete it[e]})),keys:async()=>new Promise((e=>{e(Object.keys(it))}))}})})(),lt({metricName:"Initialized Analytics:",data:{deviceId:H.deviceId}}),fn.push((()=>{Pt()})),(async()=>{const e=await at(S);rt({isReady:!0}),gn(),e&&(bn(),se({eventId:e.eventId||oe.eventId,sequenceNumber:e.sequenceNumber||oe.sequenceNumber,sessionId:e.sessionId||oe.sessionId,lastEventTime:e.lastEventTime||oe.lastEventTime,sessionUUID:e.sessionUUID||oe.sessionUUID}),function(e){se(mn({},function(e){const t={};return O.forEach((n=>{e[n]&&(t[n]=e[n])})),t}(e),de()))}(e),Ue({sessionStart:e.sessionStart||oe.sessionStart}),De({ac:e.ac||Ie.ac,af:e.af||Ie.af,ah:e.ah||Ie.ah,al:e.al||Ie.al,am:e.am||Ie.am,ar:e.ar||Ie.ar,as:e.as||Ie.as,pv:e.pv||Ie.pv}),A.trackUserId&&Y({userId:e.userId||H.userId}),pn(),lt({metricName:"Initialized Analytics IndexedDB:",data:e}))})(),async function(){at(E).then((e=>{hn=null!=e?e:{}})).catch((e=>{e instanceof Error&&A.onError(e)}))}(),Z(),z()&&(ln((()=>{se({lastEventTime:Ae()}),st(),Bt()}),"hidden"),ln((()=>{pn()}),"visible")),z()&&(i=()=>{var e,t,n,r;te(),ee({width:null!=(e=null==(t=window)?void 0:t.innerWidth)?e:null,height:null!=(n=null==(r=window)?void 0:r.innerHeight)?n:null})},addEventListener("resize",(()=>{requestAnimationFrame((()=>{i()}))}))),(()=>{if(z())try{const e=n(2);en.markStep=e.markStep,en.markStepOnce=e.markStepOnce,en.incrementUjNavigation=e.incrementUjNavigation,Yt=new e.Perfume({analyticsTracker:e=>{const{data:t,attribution:n,metricName:r,navigatorInformation:i,rating:a}=e,o=I[r],s=(null==n?void 0:n.category)||null;if(!o&&!s)return;const c=(null==i?void 0:i.deviceMemory)||0,u=(null==i?void 0:i.hardwareConcurrency)||0,l=(null==i?void 0:i.isLowEndDevice)||!1,p=(null==i?void 0:i.isLowEndExperience)||!1,v=(null==i?void 0:i.serviceWorkerStatus)||"unsupported",g=Vt({deviceMemory:c,hardwareConcurrency:u,isLowEndDevice:l,isLowEndExperience:p,serviceWorkerStatus:v},Gt),b={is_low_end_device:l,is_low_end_experience:p,page_key:re.pageKey||"",save_data:t.saveData||!1,service_worker:v,is_perf_metric:!0};if("navigationTiming"===r)t&&"number"==typeof t.redirectTime&&Ht({metricName:I.redirectTime.eventName,metricType:d.histogram,tags:b,value:t.redirectTime||0});else if("TTFB"===r)$t(o.eventName,Vt({action:f.measurement,componentType:m.page,duration:t||null,vitalsScore:a||null},g)),Ht({metricName:I.TTFB.eventName,metricType:d.histogram,tags:Vt({},b),value:t}),a&&Ht({metricName:\`perf_web_vitals_ttfb_\${a}\`,metricType:d.count,tags:b,value:1});else if("networkInformation"===r)null!=t&&t.effectiveType&&(Gt=t,$t(o.eventName,{action:f.measurement,componentType:m.page,networkInformationDownlink:t.downlink,networkInformationEffectiveType:t.effectiveType,networkInformationRtt:t.rtt,networkInformationSaveData:t.saveData,navigatorDeviceMemory:c,navigatorHardwareConcurrency:u}));else if("storageEstimate"===r)$t(o.eventName,Vt({action:f.measurement,componentType:m.page},t,g)),Ht({metricName:"perf_storage_estimate_caches",metricType:d.histogram,tags:b,value:t.caches}),Ht({metricName:"perf_storage_estimate_indexed_db",metricType:d.histogram,tags:b,value:t.indexedDB});else if("CLS"===r)$t(o.eventName,Vt({action:f.measurement,componentType:m.page,score:100*t||null,vitalsScore:a||null},g)),a&&Ht({metricName:\`perf_web_vitals_cls_\${a}\`,metricType:d.count,tags:b,value:1});else if("FID"===r){const e=(null==n?void 0:n.performanceEntry)||null,r=parseInt((null==e?void 0:e.processingStart)||"");$t(o.eventName,Vt({action:f.measurement,componentType:m.page,duration:t||null,processingStart:null!=e&&e.processingStart?r:null,startTime:null!=e&&e.startTime?parseInt(e.startTime):null,vitalsScore:a||null},g)),a&&Ht({metricName:\`perf_web_vitals_fidVitals_\${a}\`,metricType:d.count,tags:b,value:1})}else"userJourneyStep"===r?($t("perf_user_journey_step",Vt({action:f.measurement,componentType:m.page,duration:t||null,rating:null!=a?a:null,step_name:(null==n?void 0:n.stepName)||""},g)),Ht({metricName:\`user_journey_step.\${A.projectName}.\${A.platform}.\${(null==n?void 0:n.stepName)||""}_vitals_\${a}\`,metricType:d.count,tags:b,value:1}),Ht({metricName:\`user_journey_step.\${A.projectName}.\${A.platform}.\${(null==n?void 0:n.stepName)||""}\`,metricType:d.distribution,tags:b,value:t||null})):I[r]&&t&&($t(o.eventName,Vt({action:f.measurement,componentType:m.page,duration:t||null,vitalsScore:a||null},g)),a&&(Ht({metricName:\`perf_web_vitals_\${Xt(r)}_\${a}\`,metricType:d.count,tags:b,value:1}),"LCP"===r&&Ht({metricName:\`perf_web_vitals_\${Xt(r)}\`,metricType:d.distribution,tags:b,value:t})))},maxMeasureTime:3e4,steps:A.steps,onMarkStep:Zt})}catch(e){e instanceof Error&&A.onError(e)}})()},Tn=e=>{Y(e),e.userAgent&&Z(),lt({metricName:"Identify:",data:{countryCode:H.countryCode,deviceId:H.deviceId,userId:H.userId}})},kn=({blacklistRegex:e,pageKeyRegex:t,browserHistory:n})=>{Kt({blacklistRegex:e||[],isEnabled:!0}),ae({pageKeyRegex:t}),on({callMarkNTBT:!1}),n.listen((()=>{on()}))},_n=({blacklistRegex:e,pageKeyRegex:t,nextJsRouter:n})=>{Kt({blacklistRegex:e||[],isEnabled:!0}),ae({pageKeyRegex:t}),on({callMarkNTBT:!1}),n.events.on("routeChangeComplete",(()=>{on()}))},Sn=()=>{Y({isOptOut:!0}),ot(S,{})},En=()=>{Y({isOptOut:!1})},xn={Button:{label:"cb_button",uuid:"e921a074-40e6-4371-8700-134d5cd633e6",componentType:m.button}};function On(e,t,n){return{componentName:e,actions:t,data:n}}function jn(){return jn=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},jn.apply(this,arguments)}function Nn(e,t,n){const{componentName:r,data:i}=n;$t(e.label,jn({componentType:e.componentType,action:t,loggingId:e.uuid,component_name:r},i))}const In={actionMapping:{onPress:f.click,onHover:f.hover},handlers:{Button:{[f.click]:e=>Nn(xn.Button,f.click,e),[f.hover]:e=>Nn(xn.Button,f.hover,e)}}};function Pn(e,t=!1){t?_t({url:A.tracesEndpoint,data:{traces:e},isJSON:!0,onError:A.onError}):yt((()=>{_t({url:A.tracesEndpoint,data:{traces:e},isJSON:!0,onError:A.onError})})),ut({metricName:"Batch Traces",data:e})}function Mn(){return Mn=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},Mn.apply(this,arguments)}const Bn=1e6;function Cn(e){return e*Bn}function Dn(e=function(){var e;return null==(e=window)?void 0:e.crypto}()){const t=new Uint32Array(2);return null==e||e.getRandomValues(t),((BigInt(t[0])<<BigInt(32))+BigInt(t[1])).toString()}function An(e,t){return{"x-datadog-origin":"rum","x-datadog-parent-id":t,"x-datadog-sampling-priority":"1","x-datadog-trace-id":e}}function Ln(e){var t;const{name:n,traceId:r,spanId:i,start:a,duration:o,resource:s,meta:c}=e;return{duration:o?Cn(o):0,name:n,resource:s,service:A.projectName,span_id:null!=i?i:Dn(),start:a?Cn(a):0,trace_id:null!=r?r:Dn(),parent_id:P,type:M,meta:Mn({platform:A.platform},re.pageKey?{page_key:re.pageKey}:{},null!=(t=Se.ujs)&&t.length?{last_ujs:Se.ujs[Se.ujs.length-1]}:{},null!=c?c:{})}}function Un(e){return[Ln(e)]}function Rn(e,t){Oe()&&function(e){return e.length>0}(e)&&(t&&function(e,t){e.forEach((e=>function(e,t){const n=Mn({},e.meta,t.meta),r={start:t.start?Cn(t.start):e.start,duration:t.duration?Cn(t.duration):e.duration};Object.assign(e,t,Mn({meta:n},r))}(e,t)))}(e,t),je.tracesQueue.push(e),wt(Pn)&&(Pn(je.tracesQueue),je.tracesQueue=[]))}function qn(e){var t=function(e,t){if("object"!=typeof e||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var r=n.call(e,"string");if("object"!=typeof r)return r;throw new TypeError("@@toPrimitive must return a primitive value.")}return String(e)}(e);return"symbol"==typeof t?t:String(t)}function Fn(){return Fn=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},Fn.apply(this,arguments)}function zn(){return void 0!==typeof window&&"performance"in window&&"mark"in performance&&"getEntriesByName"in performance}function Kn(e,t){return\`perf_\${e}\${null!=t&&t.label?\`_\${t.label}\`:""}\`}function $n(e,t,n){return\`\${Kn(e,n)}__\${t}\`}let Qn={};function Wn(e,t,n){if(!zn())return;const r=$n(e,t,n);if(performance.mark(r),"end"===t){const t=Kn(e,n);!function(e,t,n){try{performance.measure(e,t,n)}catch(e){A.onError(e)}}(t,$n(e,"start",n),r);const i=performance.getEntriesByName(t).pop();i&&Ht(Fn({metricName:e,metricType:d.distribution,value:i.duration},null!=n&&n.tags?{tags:n.tags}:{}))}}function Hn(e,t){if(!zn())return;const n=$n(e,"start",t);Qn[n]||(Wn(e,"start",t),Qn[n]=!0)}function Vn(e,t){const n=$n(e,"start",t),r=function(e,t){if(null==e)return{};var n,r,i={},a=Object.keys(e);for(r=0;r<a.length;r++)n=a[r],t.indexOf(n)>=0||(i[n]=e[n]);return i}(Qn,[n].map(qn));Qn=r}function Jn(e,t){if(!zn())return;const n=$n(e,"start",t);Qn[n]&&(Wn(e,"end",t),Vn(e,t))}function Xn(){zn()&&(performance.clearMarks(),Qn={})}var Gn=n(784);function Zn(){return Zn=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},Zn.apply(this,arguments)}function Yn(e,t,n=l.low){const r=(0,Gn.useRef)(t);return(0,Gn.useEffect)((()=>{r.current=t}),[t]),(0,Gn.useCallback)((t=>{$t(e,Zn({},r.current,t),n)}),[e,n])}function er(){return er=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},er.apply(this,arguments)}function tr(e,t,n=l.low){(0,Gn.useEffect)((()=>{const r=er({},t,{action:f.render});$t(e,r,n)}),[])}function nr(){return nr=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},nr.apply(this,arguments)}const rr=function(e,t){return{markStartPerf:(0,Gn.useCallback)((()=>Hn(e,t)),[e,t]),markEndPerf:(0,Gn.useCallback)((n=>Jn(e,nr({},t,n))),[e,t])}};function ir(){return ir=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n=arguments[t];for(var r in n)Object.prototype.hasOwnProperty.call(n,r)&&(e[r]=n[r])}return e},ir.apply(this,arguments)}function ar(){return Object.entries(ir({},Se,zt(),{sessionUUID:oe.sessionUUID,userId:oe.userId})).reduce(((e,t)=>{return null!=(n=t[1])&&""!==n?ir({},e,{[t[0]]:t[1]}):e;var n}),{})}async function or(){return new Promise((e=>{Mt(vt(je.eventsQueue)),Qt(bt(je.metricsQueue),!0),Pn(je.tracesQueue,!0),Ne({eventsQueue:[],metricsQueue:[],tracesQueue:[]}),e()}))}function sr(){return{"X-CB-Device-ID":H.deviceId||"unknown","X-CB-Is-Logged-In":H.userId?"true":"false","X-CB-Pagekey":re.pageKey||"unknown","X-CB-UJS":(e=Se.ujs,void 0===e||0===e.length?"":e.join(",")),"X-CB-Platform":A.platform||"unknown","X-CB-Project-Name":A.projectName||"unknown","X-CB-Session-UUID":oe.sessionUUID||"unknown","X-CB-Version-Name":A.version?String(A.version):"unknown"};var e}})(),r})()}));`;
const loadTelemetryScript = () => {
  return new Promise((resolve, reject) => {
    if (window.ClientAnalytics) {
      return resolve();
    }
    try {
      const script = document.createElement("script");
      script.textContent = TELEMETRY_SCRIPT_CONTENT;
      script.type = "text/javascript";
      document.head.appendChild(script);
      initCCA();
      document.head.removeChild(script);
      resolve();
    } catch (_a) {
      console.error("Failed to execute inlined telemetry script");
      reject();
    }
  });
};
const initCCA = () => {
  var _a, _b, _c;
  if (typeof window !== "undefined") {
    const deviceId = (_c = (_a = store.config.get().deviceId) !== null && _a !== void 0 ? _a : (_b = window.crypto) === null || _b === void 0 ? void 0 : _b.randomUUID()) !== null && _c !== void 0 ? _c : "";
    if (window.ClientAnalytics) {
      const { init, identify, PlatformName } = window.ClientAnalytics;
      init({
        isProd: true,
        amplitudeApiKey: "c66737ad47ec354ced777935b0af822e",
        platform: PlatformName.web,
        projectName: "base_account_sdk",
        showDebugLogging: false,
        version: "1.0.0",
        apiEndpoint: "https://cca-lite.coinbase.com"
      });
      identify({ deviceId });
      store.config.set({ deviceId });
    }
  }
};
const factoryAddress = "0xba5ed110efdba3d005bfc882d75358acbbb85842";
const spendPermissionManagerAddress = "0xf85210B21cC50302F477BA56686d2019dC9b67Ad";
const abi = [
  { inputs: [], stateMutability: "nonpayable", type: "constructor" },
  {
    inputs: [{ name: "owner", type: "bytes" }],
    name: "AlreadyOwner",
    type: "error"
  },
  { inputs: [], name: "Initialized", type: "error" },
  {
    inputs: [{ name: "owner", type: "bytes" }],
    name: "InvalidEthereumAddressOwner",
    type: "error"
  },
  {
    inputs: [{ name: "key", type: "uint256" }],
    name: "InvalidNonceKey",
    type: "error"
  },
  {
    inputs: [{ name: "owner", type: "bytes" }],
    name: "InvalidOwnerBytesLength",
    type: "error"
  },
  { inputs: [], name: "LastOwner", type: "error" },
  {
    inputs: [{ name: "index", type: "uint256" }],
    name: "NoOwnerAtIndex",
    type: "error"
  },
  {
    inputs: [{ name: "ownersRemaining", type: "uint256" }],
    name: "NotLastOwner",
    type: "error"
  },
  {
    inputs: [{ name: "selector", type: "bytes4" }],
    name: "SelectorNotAllowed",
    type: "error"
  },
  { inputs: [], name: "Unauthorized", type: "error" },
  { inputs: [], name: "UnauthorizedCallContext", type: "error" },
  { inputs: [], name: "UpgradeFailed", type: "error" },
  {
    inputs: [
      { name: "index", type: "uint256" },
      { name: "expectedOwner", type: "bytes" },
      { name: "actualOwner", type: "bytes" }
    ],
    name: "WrongOwnerAtIndex",
    type: "error"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "index",
        type: "uint256"
      },
      { indexed: false, name: "owner", type: "bytes" }
    ],
    name: "AddOwner",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "index",
        type: "uint256"
      },
      { indexed: false, name: "owner", type: "bytes" }
    ],
    name: "RemoveOwner",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "implementation",
        type: "address"
      }
    ],
    name: "Upgraded",
    type: "event"
  },
  { stateMutability: "payable", type: "fallback" },
  {
    inputs: [],
    name: "REPLAYABLE_NONCE_KEY",
    outputs: [{ name: "", type: "uint256" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "owner", type: "address" }],
    name: "addOwnerAddress",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      { name: "x", type: "bytes32" },
      { name: "y", type: "bytes32" }
    ],
    name: "addOwnerPublicKey",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [{ name: "functionSelector", type: "bytes4" }],
    name: "canSkipChainIdValidation",
    outputs: [{ name: "", type: "bool" }],
    stateMutability: "pure",
    type: "function"
  },
  {
    inputs: [],
    name: "domainSeparator",
    outputs: [{ name: "", type: "bytes32" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [],
    name: "eip712Domain",
    outputs: [
      { name: "fields", type: "bytes1" },
      { name: "name", type: "string" },
      { name: "version", type: "string" },
      { name: "chainId", type: "uint256" },
      { name: "verifyingContract", type: "address" },
      { name: "salt", type: "bytes32" },
      { name: "extensions", type: "uint256[]" }
    ],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [],
    name: "entryPoint",
    outputs: [{ name: "", type: "address" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      { name: "target", type: "address" },
      { name: "value", type: "uint256" },
      { name: "data", type: "bytes" }
    ],
    name: "execute",
    outputs: [],
    stateMutability: "payable",
    type: "function"
  },
  {
    inputs: [
      {
        components: [
          { name: "target", type: "address" },
          { name: "value", type: "uint256" },
          { name: "data", type: "bytes" }
        ],
        name: "calls",
        type: "tuple[]"
      }
    ],
    name: "executeBatch",
    outputs: [],
    stateMutability: "payable",
    type: "function"
  },
  {
    inputs: [{ name: "calls", type: "bytes[]" }],
    name: "executeWithoutChainIdValidation",
    outputs: [],
    stateMutability: "payable",
    type: "function"
  },
  {
    inputs: [
      {
        components: [
          { name: "sender", type: "address" },
          { name: "nonce", type: "uint256" },
          { name: "initCode", type: "bytes" },
          { name: "callData", type: "bytes" },
          { name: "callGasLimit", type: "uint256" },
          {
            name: "verificationGasLimit",
            type: "uint256"
          },
          {
            name: "preVerificationGas",
            type: "uint256"
          },
          { name: "maxFeePerGas", type: "uint256" },
          {
            name: "maxPriorityFeePerGas",
            type: "uint256"
          },
          { name: "paymasterAndData", type: "bytes" },
          { name: "signature", type: "bytes" }
        ],
        name: "userOp",
        type: "tuple"
      }
    ],
    name: "getUserOpHashWithoutChainId",
    outputs: [{ name: "", type: "bytes32" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [],
    name: "implementation",
    outputs: [{ name: "$", type: "address" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "owners", type: "bytes[]" }],
    name: "initialize",
    outputs: [],
    stateMutability: "payable",
    type: "function"
  },
  {
    inputs: [{ name: "account", type: "address" }],
    name: "isOwnerAddress",
    outputs: [{ name: "", type: "bool" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "account", type: "bytes" }],
    name: "isOwnerBytes",
    outputs: [{ name: "", type: "bool" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      { name: "x", type: "bytes32" },
      { name: "y", type: "bytes32" }
    ],
    name: "isOwnerPublicKey",
    outputs: [{ name: "", type: "bool" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      { name: "hash", type: "bytes32" },
      { name: "signature", type: "bytes" }
    ],
    name: "isValidSignature",
    outputs: [{ name: "result", type: "bytes4" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [],
    name: "nextOwnerIndex",
    outputs: [{ name: "", type: "uint256" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "index", type: "uint256" }],
    name: "ownerAtIndex",
    outputs: [{ name: "", type: "bytes" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [],
    name: "ownerCount",
    outputs: [{ name: "", type: "uint256" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [],
    name: "proxiableUUID",
    outputs: [{ name: "", type: "bytes32" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      { name: "index", type: "uint256" },
      { name: "owner", type: "bytes" }
    ],
    name: "removeLastOwner",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      { name: "index", type: "uint256" },
      { name: "owner", type: "bytes" }
    ],
    name: "removeOwnerAtIndex",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [],
    name: "removedOwnersCount",
    outputs: [{ name: "", type: "uint256" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "hash", type: "bytes32" }],
    name: "replaySafeHash",
    outputs: [{ name: "", type: "bytes32" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      { name: "newImplementation", type: "address" },
      { name: "data", type: "bytes" }
    ],
    name: "upgradeToAndCall",
    outputs: [],
    stateMutability: "payable",
    type: "function"
  },
  {
    inputs: [
      {
        components: [
          { name: "sender", type: "address" },
          { name: "nonce", type: "uint256" },
          { name: "initCode", type: "bytes" },
          { name: "callData", type: "bytes" },
          { name: "callGasLimit", type: "uint256" },
          {
            name: "verificationGasLimit",
            type: "uint256"
          },
          {
            name: "preVerificationGas",
            type: "uint256"
          },
          { name: "maxFeePerGas", type: "uint256" },
          {
            name: "maxPriorityFeePerGas",
            type: "uint256"
          },
          { name: "paymasterAndData", type: "bytes" },
          { name: "signature", type: "bytes" }
        ],
        name: "userOp",
        type: "tuple"
      },
      { name: "userOpHash", type: "bytes32" },
      { name: "missingAccountFunds", type: "uint256" }
    ],
    name: "validateUserOp",
    outputs: [{ name: "validationData", type: "uint256" }],
    stateMutability: "nonpayable",
    type: "function"
  },
  { stateMutability: "payable", type: "receive" }
];
const factoryAbi = [
  {
    inputs: [{ name: "implementation_", type: "address" }],
    stateMutability: "payable",
    type: "constructor"
  },
  { inputs: [], name: "OwnerRequired", type: "error" },
  {
    inputs: [
      { name: "owners", type: "bytes[]" },
      { name: "nonce", type: "uint256" }
    ],
    name: "createAccount",
    outputs: [
      {
        name: "account",
        type: "address"
      }
    ],
    stateMutability: "payable",
    type: "function"
  },
  {
    inputs: [
      { name: "owners", type: "bytes[]" },
      { name: "nonce", type: "uint256" }
    ],
    name: "getAddress",
    outputs: [{ name: "", type: "address" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [],
    name: "implementation",
    outputs: [{ name: "", type: "address" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [],
    name: "initCodeHash",
    outputs: [{ name: "", type: "bytes32" }],
    stateMutability: "view",
    type: "function"
  }
];
const standardErrorCodes = {
  rpc: {
    invalidInput: -32e3,
    resourceNotFound: -32001,
    resourceUnavailable: -32002,
    transactionRejected: -32003,
    methodNotSupported: -32004,
    limitExceeded: -32005,
    parse: -32700,
    invalidRequest: -32600,
    methodNotFound: -32601,
    invalidParams: -32602,
    internal: -32603
  },
  provider: {
    userRejectedRequest: 4001,
    unauthorized: 4100,
    unsupportedMethod: 4200,
    disconnected: 4900,
    chainDisconnected: 4901,
    unsupportedChain: 4902
  }
};
const errorValues = {
  "-32700": {
    standard: "JSON RPC 2.0",
    message: "Invalid JSON was received by the server. An error occurred on the server while parsing the JSON text."
  },
  "-32600": {
    standard: "JSON RPC 2.0",
    message: "The JSON sent is not a valid Request object."
  },
  "-32601": {
    standard: "JSON RPC 2.0",
    message: "The method does not exist / is not available."
  },
  "-32602": {
    standard: "JSON RPC 2.0",
    message: "Invalid method parameter(s)."
  },
  "-32603": {
    standard: "JSON RPC 2.0",
    message: "Internal JSON-RPC error."
  },
  "-32000": {
    standard: "EIP-1474",
    message: "Invalid input."
  },
  "-32001": {
    standard: "EIP-1474",
    message: "Resource not found."
  },
  "-32002": {
    standard: "EIP-1474",
    message: "Resource unavailable."
  },
  "-32003": {
    standard: "EIP-1474",
    message: "Transaction rejected."
  },
  "-32004": {
    standard: "EIP-1474",
    message: "Method not supported."
  },
  "-32005": {
    standard: "EIP-1474",
    message: "Request limit exceeded."
  },
  "4001": {
    standard: "EIP-1193",
    message: "User rejected the request."
  },
  "4100": {
    standard: "EIP-1193",
    message: "The requested account and/or method has not been authorized by the user."
  },
  "4200": {
    standard: "EIP-1193",
    message: "The requested method is not supported by this Ethereum provider."
  },
  "4900": {
    standard: "EIP-1193",
    message: "The provider is disconnected from all chains."
  },
  "4901": {
    standard: "EIP-1193",
    message: "The provider is disconnected from the specified chain."
  },
  "4902": {
    standard: "EIP-3085",
    message: "Unrecognized chain ID."
  }
};
const FALLBACK_MESSAGE = "Unspecified error message.";
const JSON_RPC_SERVER_ERROR_MESSAGE = "Unspecified server error.";
function getMessageFromCode(code, fallbackMessage = FALLBACK_MESSAGE) {
  if (code && Number.isInteger(code)) {
    const codeString = code.toString();
    if (hasKey(errorValues, codeString)) {
      return errorValues[codeString].message;
    }
    if (isJsonRpcServerError(code)) {
      return JSON_RPC_SERVER_ERROR_MESSAGE;
    }
  }
  return fallbackMessage;
}
function isValidCode(code) {
  if (!Number.isInteger(code)) {
    return false;
  }
  const codeString = code.toString();
  if (errorValues[codeString]) {
    return true;
  }
  if (isJsonRpcServerError(code)) {
    return true;
  }
  return false;
}
function serialize(error, { shouldIncludeStack = false } = {}) {
  const serialized = {};
  if (error && typeof error === "object" && !Array.isArray(error) && hasKey(error, "code") && isValidCode(error.code)) {
    const _error = error;
    serialized.code = _error.code;
    if (_error.message && typeof _error.message === "string") {
      serialized.message = _error.message;
      if (hasKey(_error, "data")) {
        serialized.data = _error.data;
      }
    } else {
      serialized.message = getMessageFromCode(serialized.code);
      serialized.data = { originalError: assignOriginalError(error) };
    }
  } else {
    serialized.code = standardErrorCodes.rpc.internal;
    serialized.message = hasStringProperty(error, "message") ? error.message : FALLBACK_MESSAGE;
    serialized.data = { originalError: assignOriginalError(error) };
  }
  if (shouldIncludeStack) {
    serialized.stack = hasStringProperty(error, "stack") ? error.stack : void 0;
  }
  return serialized;
}
function isJsonRpcServerError(code) {
  return code >= -32099 && code <= -32e3;
}
function assignOriginalError(error) {
  if (error && typeof error === "object" && !Array.isArray(error)) {
    return Object.assign({}, error);
  }
  return error;
}
function hasKey(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
}
function hasStringProperty(obj, prop) {
  return typeof obj === "object" && obj !== null && prop in obj && typeof obj[prop] === "string";
}
const standardErrors = {
  rpc: {
    parse: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.parse, arg),
    invalidRequest: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.invalidRequest, arg),
    invalidParams: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.invalidParams, arg),
    methodNotFound: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.methodNotFound, arg),
    internal: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.internal, arg),
    server: (opts) => {
      if (!opts || typeof opts !== "object" || Array.isArray(opts)) {
        throw new Error("Ethereum RPC Server errors must provide single object argument.");
      }
      const { code } = opts;
      if (!Number.isInteger(code) || code > -32005 || code < -32099) {
        throw new Error('"code" must be an integer such that: -32099 <= code <= -32005');
      }
      return getEthJsonRpcError(code, opts);
    },
    invalidInput: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.invalidInput, arg),
    resourceNotFound: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.resourceNotFound, arg),
    resourceUnavailable: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.resourceUnavailable, arg),
    transactionRejected: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.transactionRejected, arg),
    methodNotSupported: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.methodNotSupported, arg),
    limitExceeded: (arg) => getEthJsonRpcError(standardErrorCodes.rpc.limitExceeded, arg)
  },
  provider: {
    userRejectedRequest: (arg) => {
      return getEthProviderError(standardErrorCodes.provider.userRejectedRequest, arg);
    },
    unauthorized: (arg) => {
      return getEthProviderError(standardErrorCodes.provider.unauthorized, arg);
    },
    unsupportedMethod: (arg) => {
      return getEthProviderError(standardErrorCodes.provider.unsupportedMethod, arg);
    },
    disconnected: (arg) => {
      return getEthProviderError(standardErrorCodes.provider.disconnected, arg);
    },
    chainDisconnected: (arg) => {
      return getEthProviderError(standardErrorCodes.provider.chainDisconnected, arg);
    },
    unsupportedChain: (arg) => {
      return getEthProviderError(standardErrorCodes.provider.unsupportedChain, arg);
    },
    custom: (opts) => {
      if (!opts || typeof opts !== "object" || Array.isArray(opts)) {
        throw new Error("Ethereum Provider custom errors must provide single object argument.");
      }
      const { code, message, data } = opts;
      if (!message || typeof message !== "string") {
        throw new Error('"message" must be a nonempty string');
      }
      return new EthereumProviderError(code, message, data);
    }
  }
};
function getEthJsonRpcError(code, arg) {
  const [message, data] = parseOpts(arg);
  return new EthereumRpcError(code, message || getMessageFromCode(code), data);
}
function getEthProviderError(code, arg) {
  const [message, data] = parseOpts(arg);
  return new EthereumProviderError(code, message || getMessageFromCode(code), data);
}
function parseOpts(arg) {
  if (arg) {
    if (typeof arg === "string") {
      return [arg];
    }
    if (typeof arg === "object" && !Array.isArray(arg)) {
      const { message, data } = arg;
      if (message && typeof message !== "string") {
        throw new Error("Must specify string message.");
      }
      return [message || void 0, data];
    }
  }
  return [];
}
class EthereumRpcError extends Error {
  constructor(code, message, data) {
    if (!Number.isInteger(code)) {
      throw new Error('"code" must be an integer.');
    }
    if (!message || typeof message !== "string") {
      throw new Error('"message" must be a nonempty string.');
    }
    super(message);
    this.code = code;
    if (data !== void 0) {
      this.data = data;
    }
  }
}
class EthereumProviderError extends EthereumRpcError {
  /**
   * Create an Ethereum Provider JSON-RPC error.
   * `code` must be an integer in the 1000 <= 4999 range.
   */
  constructor(code, message, data) {
    if (!isValidEthProviderCode(code)) {
      throw new Error('"code" must be an integer such that: 1000 <= code <= 4999');
    }
    super(code, message, data);
  }
}
function isValidEthProviderCode(code) {
  return Number.isInteger(code) && code >= 1e3 && code <= 4999;
}
function isActionableHttpRequestError(errorObject) {
  return typeof errorObject === "object" && errorObject !== null && "code" in errorObject && "data" in errorObject && errorObject.code === -32090 && typeof errorObject.data === "object" && errorObject.data !== null && "type" in errorObject.data && errorObject.data.type === "INSUFFICIENT_FUNDS";
}
function isViemError(error) {
  return typeof error === "object" && error !== null && "details" in error;
}
function viemHttpErrorToProviderError(error) {
  try {
    const details = JSON.parse(error.details);
    return new EthereumRpcError(details.code, details.message, details.data);
  } catch (_2) {
    return null;
  }
}
function assertPresence(value, error, message) {
  if (value === null || value === void 0) {
    throw error !== null && error !== void 0 ? error : standardErrors.rpc.invalidParams({
      message: "value must be present",
      data: value
    });
  }
}
function assertArrayPresence(value, message) {
  if (!Array.isArray(value)) {
    throw standardErrors.rpc.invalidParams({
      message: message !== null && message !== void 0 ? message : "value must be an array",
      data: value
    });
  }
}
const COOP_ERROR_MESSAGE = `Base Account SDK requires the Cross-Origin-Opener-Policy header to not be set to 'same-origin'. This is to ensure that the SDK can communicate with the Base Account app.

Please see https://docs.base.org/smart-wallet/quickstart#cross-origin-opener-policy for more information.`;
const createCoopChecker = () => {
  let crossOriginOpenerPolicy;
  return {
    getCrossOriginOpenerPolicy: () => {
      if (crossOriginOpenerPolicy === void 0) {
        return "undefined";
      }
      return crossOriginOpenerPolicy;
    },
    checkCrossOriginOpenerPolicy: async () => {
      if (typeof window === "undefined") {
        crossOriginOpenerPolicy = "non-browser-env";
        return;
      }
      try {
        const url = `${window.location.origin}${window.location.pathname}`;
        const response = await fetch(url, {
          method: "HEAD"
        });
        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }
        const result = response.headers.get("Cross-Origin-Opener-Policy");
        crossOriginOpenerPolicy = result !== null && result !== void 0 ? result : "null";
        if (crossOriginOpenerPolicy === "same-origin") {
          console.error(COOP_ERROR_MESSAGE);
        }
      } catch (error) {
        console.error("Error checking Cross-Origin-Opener-Policy:", error.message);
        crossOriginOpenerPolicy = "error";
      }
    }
  };
};
const { checkCrossOriginOpenerPolicy, getCrossOriginOpenerPolicy } = createCoopChecker();
function validatePreferences(preference) {
  if (!preference) {
    return;
  }
  if (preference.attribution) {
    if (preference.attribution.auto !== void 0 && preference.attribution.dataSuffix !== void 0) {
      throw new Error(`Attribution cannot contain both auto and dataSuffix properties`);
    }
  }
  if (preference.telemetry) {
    if (typeof preference.telemetry !== "boolean") {
      throw new Error(`Telemetry must be a boolean`);
    }
  }
}
function validateSubAccount(toAccount) {
  if (typeof toAccount !== "function") {
    throw new Error(`toAccount is not a function`);
  }
}
var ComponentType;
(function(ComponentType2) {
  ComponentType2["unknown"] = "unknown";
  ComponentType2["banner"] = "banner";
  ComponentType2["button"] = "button";
  ComponentType2["card"] = "card";
  ComponentType2["chart"] = "chart";
  ComponentType2["content_script"] = "content_script";
  ComponentType2["dropdown"] = "dropdown";
  ComponentType2["link"] = "link";
  ComponentType2["page"] = "page";
  ComponentType2["modal"] = "modal";
  ComponentType2["table"] = "table";
  ComponentType2["search_bar"] = "search_bar";
  ComponentType2["service_worker"] = "service_worker";
  ComponentType2["text"] = "text";
  ComponentType2["text_input"] = "text_input";
  ComponentType2["tray"] = "tray";
  ComponentType2["checkbox"] = "checkbox";
  ComponentType2["icon"] = "icon";
})(ComponentType || (ComponentType = {}));
var ActionType;
(function(ActionType2) {
  ActionType2["unknown"] = "unknown";
  ActionType2["blur"] = "blur";
  ActionType2["click"] = "click";
  ActionType2["change"] = "change";
  ActionType2["dismiss"] = "dismiss";
  ActionType2["focus"] = "focus";
  ActionType2["hover"] = "hover";
  ActionType2["select"] = "select";
  ActionType2["measurement"] = "measurement";
  ActionType2["move"] = "move";
  ActionType2["process"] = "process";
  ActionType2["render"] = "render";
  ActionType2["scroll"] = "scroll";
  ActionType2["view"] = "view";
  ActionType2["search"] = "search";
  ActionType2["keyPress"] = "keyPress";
  ActionType2["error"] = "error";
})(ActionType || (ActionType = {}));
var AnalyticsEventImportance;
(function(AnalyticsEventImportance2) {
  AnalyticsEventImportance2["low"] = "low";
  AnalyticsEventImportance2["high"] = "high";
})(AnalyticsEventImportance || (AnalyticsEventImportance = {}));
function logEvent(name2, event, importance) {
  var _a, _b, _c;
  if (window.ClientAnalytics) {
    (_a = window.ClientAnalytics) === null || _a === void 0 ? void 0 : _a.logEvent(name2, Object.assign(Object.assign({}, event), { sdkVersion: PACKAGE_VERSION, sdkName: PACKAGE_NAME, appName: (_c = (_b = store.config.get().metadata) === null || _b === void 0 ? void 0 : _b.appName) !== null && _c !== void 0 ? _c : "", appOrigin: window.location.origin }), importance);
  }
}
const logPopupSetupStarted = () => {
  logEvent("communicator.popup_setup.started", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown
  }, AnalyticsEventImportance.high);
};
const logPopupSetupCompleted = () => {
  logEvent("communicator.popup_setup.completed", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown
  }, AnalyticsEventImportance.high);
};
const logPopupUnloadReceived = () => {
  logEvent("communicator.popup_unload.received", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown
  }, AnalyticsEventImportance.high);
};
const logDialogShown = ({ dialogContext }) => {
  logEvent(`dialog.${dialogContext}.shown`, {
    action: ActionType.render,
    componentType: ComponentType.modal,
    dialogContext
  }, AnalyticsEventImportance.high);
};
const logDialogDismissed = ({ dialogContext }) => {
  logEvent(`dialog.${dialogContext}.dismissed`, {
    action: ActionType.dismiss,
    componentType: ComponentType.modal,
    dialogContext
  }, AnalyticsEventImportance.high);
};
const logDialogActionClicked = ({ dialogContext, dialogAction }) => {
  logEvent(`dialog.${dialogContext}.action_clicked`, {
    action: ActionType.click,
    componentType: ComponentType.button,
    dialogContext,
    dialogAction
  }, AnalyticsEventImportance.high);
};
const FONT_FACE_CSS = `
@font-face {
  font-family: "BaseSans-Regular";
  src: url("data:font/woff2;charset=utf-8;base64,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")
    format("woff2");
  font-weight: normal;
  font-style: normal;
  font-display: swap;
}
`;
const FONT_NAME = "BaseSans-Regular";
function injectFontStyle() {
  const existing = document.head.querySelector(`style[base-sdk-font="${FONT_NAME}"]`);
  if (existing)
    return;
  const style = document.createElement("style");
  style.setAttribute("base-sdk-font", FONT_NAME);
  style.textContent = FONT_FACE_CSS;
  document.head.appendChild(style);
}
var n, l$1, u$2, i$1, o$1, r$1, f$2, e$1, c$1, s$1, h$1 = {}, v$1 = [], p$1 = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i, y$1 = Array.isArray;
function d$1(n2, l2) {
  for (var u2 in l2) n2[u2] = l2[u2];
  return n2;
}
function w$1(n2) {
  n2 && n2.parentNode && n2.parentNode.removeChild(n2);
}
function _(l2, u2, t2) {
  var i2, o2, r2, f2 = {};
  for (r2 in u2) "key" == r2 ? i2 = u2[r2] : "ref" == r2 ? o2 = u2[r2] : f2[r2] = u2[r2];
  if (arguments.length > 2 && (f2.children = arguments.length > 3 ? n.call(arguments, 2) : t2), "function" == typeof l2 && null != l2.defaultProps) for (r2 in l2.defaultProps) void 0 === f2[r2] && (f2[r2] = l2.defaultProps[r2]);
  return g(l2, f2, i2, o2, null);
}
function g(n2, t2, i2, o2, r2) {
  var f2 = { type: n2, props: t2, key: i2, ref: o2, __k: null, __: null, __b: 0, __e: null, __d: void 0, __c: null, constructor: void 0, __v: null == r2 ? ++u$2 : r2, __i: -1, __u: 0 };
  return null == r2 && null != l$1.vnode && l$1.vnode(f2), f2;
}
function b(n2) {
  return n2.children;
}
function k$1(n2, l2) {
  this.props = n2, this.context = l2;
}
function x(n2, l2) {
  if (null == l2) return n2.__ ? x(n2.__, n2.__i + 1) : null;
  for (var u2; l2 < n2.__k.length; l2++) if (null != (u2 = n2.__k[l2]) && null != u2.__e) return u2.__e;
  return "function" == typeof n2.type ? x(n2) : null;
}
function C$1(n2) {
  var l2, u2;
  if (null != (n2 = n2.__) && null != n2.__c) {
    for (n2.__e = n2.__c.base = null, l2 = 0; l2 < n2.__k.length; l2++) if (null != (u2 = n2.__k[l2]) && null != u2.__e) {
      n2.__e = n2.__c.base = u2.__e;
      break;
    }
    return C$1(n2);
  }
}
function M(n2) {
  (!n2.__d && (n2.__d = true) && i$1.push(n2) && !P.__r++ || o$1 !== l$1.debounceRendering) && ((o$1 = l$1.debounceRendering) || r$1)(P);
}
function P() {
  var n2, u2, t2, o2, r2, e2, c2, s2;
  for (i$1.sort(f$2); n2 = i$1.shift(); ) n2.__d && (u2 = i$1.length, o2 = void 0, e2 = (r2 = (t2 = n2).__v).__e, c2 = [], s2 = [], t2.__P && ((o2 = d$1({}, r2)).__v = r2.__v + 1, l$1.vnode && l$1.vnode(o2), O(t2.__P, o2, r2, t2.__n, t2.__P.namespaceURI, 32 & r2.__u ? [e2] : null, c2, null == e2 ? x(r2) : e2, !!(32 & r2.__u), s2), o2.__v = r2.__v, o2.__.__k[o2.__i] = o2, j$1(c2, o2, s2), o2.__e != e2 && C$1(o2)), i$1.length > u2 && i$1.sort(f$2));
  P.__r = 0;
}
function S(n2, l2, u2, t2, i2, o2, r2, f2, e2, c2, s2) {
  var a2, p2, y2, d2, w2, _2 = t2 && t2.__k || v$1, g2 = l2.length;
  for (u2.__d = e2, $(u2, l2, _2), e2 = u2.__d, a2 = 0; a2 < g2; a2++) null != (y2 = u2.__k[a2]) && (p2 = -1 === y2.__i ? h$1 : _2[y2.__i] || h$1, y2.__i = a2, O(n2, y2, p2, i2, o2, r2, f2, e2, c2, s2), d2 = y2.__e, y2.ref && p2.ref != y2.ref && (p2.ref && N(p2.ref, null, y2), s2.push(y2.ref, y2.__c || d2, y2)), null == w2 && null != d2 && (w2 = d2), 65536 & y2.__u || p2.__k === y2.__k ? e2 = I(y2, e2, n2) : "function" == typeof y2.type && void 0 !== y2.__d ? e2 = y2.__d : d2 && (e2 = d2.nextSibling), y2.__d = void 0, y2.__u &= -196609);
  u2.__d = e2, u2.__e = w2;
}
function $(n2, l2, u2) {
  var t2, i2, o2, r2, f2, e2 = l2.length, c2 = u2.length, s2 = c2, a2 = 0;
  for (n2.__k = [], t2 = 0; t2 < e2; t2++) null != (i2 = l2[t2]) && "boolean" != typeof i2 && "function" != typeof i2 ? (r2 = t2 + a2, (i2 = n2.__k[t2] = "string" == typeof i2 || "number" == typeof i2 || "bigint" == typeof i2 || i2.constructor == String ? g(null, i2, null, null, null) : y$1(i2) ? g(b, { children: i2 }, null, null, null) : void 0 === i2.constructor && i2.__b > 0 ? g(i2.type, i2.props, i2.key, i2.ref ? i2.ref : null, i2.__v) : i2).__ = n2, i2.__b = n2.__b + 1, o2 = null, -1 !== (f2 = i2.__i = L(i2, u2, r2, s2)) && (s2--, (o2 = u2[f2]) && (o2.__u |= 131072)), null == o2 || null === o2.__v ? (-1 == f2 && a2--, "function" != typeof i2.type && (i2.__u |= 65536)) : f2 !== r2 && (f2 == r2 - 1 ? a2-- : f2 == r2 + 1 ? a2++ : (f2 > r2 ? a2-- : a2++, i2.__u |= 65536))) : i2 = n2.__k[t2] = null;
  if (s2) for (t2 = 0; t2 < c2; t2++) null != (o2 = u2[t2]) && 0 == (131072 & o2.__u) && (o2.__e == n2.__d && (n2.__d = x(o2)), V(o2, o2));
}
function I(n2, l2, u2) {
  var t2, i2;
  if ("function" == typeof n2.type) {
    for (t2 = n2.__k, i2 = 0; t2 && i2 < t2.length; i2++) t2[i2] && (t2[i2].__ = n2, l2 = I(t2[i2], l2, u2));
    return l2;
  }
  n2.__e != l2 && (l2 && n2.type && !u2.contains(l2) && (l2 = x(n2)), u2.insertBefore(n2.__e, l2 || null), l2 = n2.__e);
  do {
    l2 = l2 && l2.nextSibling;
  } while (null != l2 && 8 === l2.nodeType);
  return l2;
}
function L(n2, l2, u2, t2) {
  var i2 = n2.key, o2 = n2.type, r2 = u2 - 1, f2 = u2 + 1, e2 = l2[u2];
  if (null === e2 || e2 && i2 == e2.key && o2 === e2.type && 0 == (131072 & e2.__u)) return u2;
  if (t2 > (null != e2 && 0 == (131072 & e2.__u) ? 1 : 0)) for (; r2 >= 0 || f2 < l2.length; ) {
    if (r2 >= 0) {
      if ((e2 = l2[r2]) && 0 == (131072 & e2.__u) && i2 == e2.key && o2 === e2.type) return r2;
      r2--;
    }
    if (f2 < l2.length) {
      if ((e2 = l2[f2]) && 0 == (131072 & e2.__u) && i2 == e2.key && o2 === e2.type) return f2;
      f2++;
    }
  }
  return -1;
}
function T$1(n2, l2, u2) {
  "-" === l2[0] ? n2.setProperty(l2, null == u2 ? "" : u2) : n2[l2] = null == u2 ? "" : "number" != typeof u2 || p$1.test(l2) ? u2 : u2 + "px";
}
function A(n2, l2, u2, t2, i2) {
  var o2;
  n: if ("style" === l2) if ("string" == typeof u2) n2.style.cssText = u2;
  else {
    if ("string" == typeof t2 && (n2.style.cssText = t2 = ""), t2) for (l2 in t2) u2 && l2 in u2 || T$1(n2.style, l2, "");
    if (u2) for (l2 in u2) t2 && u2[l2] === t2[l2] || T$1(n2.style, l2, u2[l2]);
  }
  else if ("o" === l2[0] && "n" === l2[1]) o2 = l2 !== (l2 = l2.replace(/(PointerCapture)$|Capture$/i, "$1")), l2 = l2.toLowerCase() in n2 || "onFocusOut" === l2 || "onFocusIn" === l2 ? l2.toLowerCase().slice(2) : l2.slice(2), n2.l || (n2.l = {}), n2.l[l2 + o2] = u2, u2 ? t2 ? u2.u = t2.u : (u2.u = e$1, n2.addEventListener(l2, o2 ? s$1 : c$1, o2)) : n2.removeEventListener(l2, o2 ? s$1 : c$1, o2);
  else {
    if ("http://www.w3.org/2000/svg" == i2) l2 = l2.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
    else if ("width" != l2 && "height" != l2 && "href" != l2 && "list" != l2 && "form" != l2 && "tabIndex" != l2 && "download" != l2 && "rowSpan" != l2 && "colSpan" != l2 && "role" != l2 && "popover" != l2 && l2 in n2) try {
      n2[l2] = null == u2 ? "" : u2;
      break n;
    } catch (n3) {
    }
    "function" == typeof u2 || (null == u2 || false === u2 && "-" !== l2[4] ? n2.removeAttribute(l2) : n2.setAttribute(l2, "popover" == l2 && 1 == u2 ? "" : u2));
  }
}
function F(n2) {
  return function(u2) {
    if (this.l) {
      var t2 = this.l[u2.type + n2];
      if (null == u2.t) u2.t = e$1++;
      else if (u2.t < t2.u) return;
      return t2(l$1.event ? l$1.event(u2) : u2);
    }
  };
}
function O(n2, u2, t2, i2, o2, r2, f2, e2, c2, s2) {
  var a2, h2, v2, p2, w2, _2, g2, m2, x2, C2, M2, P2, $2, I2, H, L2, T2 = u2.type;
  if (void 0 !== u2.constructor) return null;
  128 & t2.__u && (c2 = !!(32 & t2.__u), r2 = [e2 = u2.__e = t2.__e]), (a2 = l$1.__b) && a2(u2);
  n: if ("function" == typeof T2) try {
    if (m2 = u2.props, x2 = "prototype" in T2 && T2.prototype.render, C2 = (a2 = T2.contextType) && i2[a2.__c], M2 = a2 ? C2 ? C2.props.value : a2.__ : i2, t2.__c ? g2 = (h2 = u2.__c = t2.__c).__ = h2.__E : (x2 ? u2.__c = h2 = new T2(m2, M2) : (u2.__c = h2 = new k$1(m2, M2), h2.constructor = T2, h2.render = q), C2 && C2.sub(h2), h2.props = m2, h2.state || (h2.state = {}), h2.context = M2, h2.__n = i2, v2 = h2.__d = true, h2.__h = [], h2._sb = []), x2 && null == h2.__s && (h2.__s = h2.state), x2 && null != T2.getDerivedStateFromProps && (h2.__s == h2.state && (h2.__s = d$1({}, h2.__s)), d$1(h2.__s, T2.getDerivedStateFromProps(m2, h2.__s))), p2 = h2.props, w2 = h2.state, h2.__v = u2, v2) x2 && null == T2.getDerivedStateFromProps && null != h2.componentWillMount && h2.componentWillMount(), x2 && null != h2.componentDidMount && h2.__h.push(h2.componentDidMount);
    else {
      if (x2 && null == T2.getDerivedStateFromProps && m2 !== p2 && null != h2.componentWillReceiveProps && h2.componentWillReceiveProps(m2, M2), !h2.__e && (null != h2.shouldComponentUpdate && false === h2.shouldComponentUpdate(m2, h2.__s, M2) || u2.__v === t2.__v)) {
        for (u2.__v !== t2.__v && (h2.props = m2, h2.state = h2.__s, h2.__d = false), u2.__e = t2.__e, u2.__k = t2.__k, u2.__k.some(function(n3) {
          n3 && (n3.__ = u2);
        }), P2 = 0; P2 < h2._sb.length; P2++) h2.__h.push(h2._sb[P2]);
        h2._sb = [], h2.__h.length && f2.push(h2);
        break n;
      }
      null != h2.componentWillUpdate && h2.componentWillUpdate(m2, h2.__s, M2), x2 && null != h2.componentDidUpdate && h2.__h.push(function() {
        h2.componentDidUpdate(p2, w2, _2);
      });
    }
    if (h2.context = M2, h2.props = m2, h2.__P = n2, h2.__e = false, $2 = l$1.__r, I2 = 0, x2) {
      for (h2.state = h2.__s, h2.__d = false, $2 && $2(u2), a2 = h2.render(h2.props, h2.state, h2.context), H = 0; H < h2._sb.length; H++) h2.__h.push(h2._sb[H]);
      h2._sb = [];
    } else do {
      h2.__d = false, $2 && $2(u2), a2 = h2.render(h2.props, h2.state, h2.context), h2.state = h2.__s;
    } while (h2.__d && ++I2 < 25);
    h2.state = h2.__s, null != h2.getChildContext && (i2 = d$1(d$1({}, i2), h2.getChildContext())), x2 && !v2 && null != h2.getSnapshotBeforeUpdate && (_2 = h2.getSnapshotBeforeUpdate(p2, w2)), S(n2, y$1(L2 = null != a2 && a2.type === b && null == a2.key ? a2.props.children : a2) ? L2 : [L2], u2, t2, i2, o2, r2, f2, e2, c2, s2), h2.base = u2.__e, u2.__u &= -161, h2.__h.length && f2.push(h2), g2 && (h2.__E = h2.__ = null);
  } catch (n3) {
    if (u2.__v = null, c2 || null != r2) {
      for (u2.__u |= c2 ? 160 : 32; e2 && 8 === e2.nodeType && e2.nextSibling; ) e2 = e2.nextSibling;
      r2[r2.indexOf(e2)] = null, u2.__e = e2;
    } else u2.__e = t2.__e, u2.__k = t2.__k;
    l$1.__e(n3, u2, t2);
  }
  else null == r2 && u2.__v === t2.__v ? (u2.__k = t2.__k, u2.__e = t2.__e) : u2.__e = z$1(t2.__e, u2, t2, i2, o2, r2, f2, c2, s2);
  (a2 = l$1.diffed) && a2(u2);
}
function j$1(n2, u2, t2) {
  u2.__d = void 0;
  for (var i2 = 0; i2 < t2.length; i2++) N(t2[i2], t2[++i2], t2[++i2]);
  l$1.__c && l$1.__c(u2, n2), n2.some(function(u3) {
    try {
      n2 = u3.__h, u3.__h = [], n2.some(function(n3) {
        n3.call(u3);
      });
    } catch (n3) {
      l$1.__e(n3, u3.__v);
    }
  });
}
function z$1(u2, t2, i2, o2, r2, f2, e2, c2, s2) {
  var a2, v2, p2, d2, _2, g2, m2, b2 = i2.props, k2 = t2.props, C2 = t2.type;
  if ("svg" === C2 ? r2 = "http://www.w3.org/2000/svg" : "math" === C2 ? r2 = "http://www.w3.org/1998/Math/MathML" : r2 || (r2 = "http://www.w3.org/1999/xhtml"), null != f2) {
    for (a2 = 0; a2 < f2.length; a2++) if ((_2 = f2[a2]) && "setAttribute" in _2 == !!C2 && (C2 ? _2.localName === C2 : 3 === _2.nodeType)) {
      u2 = _2, f2[a2] = null;
      break;
    }
  }
  if (null == u2) {
    if (null === C2) return document.createTextNode(k2);
    u2 = document.createElementNS(r2, C2, k2.is && k2), c2 && (l$1.__m && l$1.__m(t2, f2), c2 = false), f2 = null;
  }
  if (null === C2) b2 === k2 || c2 && u2.data === k2 || (u2.data = k2);
  else {
    if (f2 = f2 && n.call(u2.childNodes), b2 = i2.props || h$1, !c2 && null != f2) for (b2 = {}, a2 = 0; a2 < u2.attributes.length; a2++) b2[(_2 = u2.attributes[a2]).name] = _2.value;
    for (a2 in b2) if (_2 = b2[a2], "children" == a2) ;
    else if ("dangerouslySetInnerHTML" == a2) p2 = _2;
    else if (!(a2 in k2)) {
      if ("value" == a2 && "defaultValue" in k2 || "checked" == a2 && "defaultChecked" in k2) continue;
      A(u2, a2, null, _2, r2);
    }
    for (a2 in k2) _2 = k2[a2], "children" == a2 ? d2 = _2 : "dangerouslySetInnerHTML" == a2 ? v2 = _2 : "value" == a2 ? g2 = _2 : "checked" == a2 ? m2 = _2 : c2 && "function" != typeof _2 || b2[a2] === _2 || A(u2, a2, _2, b2[a2], r2);
    if (v2) c2 || p2 && (v2.__html === p2.__html || v2.__html === u2.innerHTML) || (u2.innerHTML = v2.__html), t2.__k = [];
    else if (p2 && (u2.innerHTML = ""), S(u2, y$1(d2) ? d2 : [d2], t2, i2, o2, "foreignObject" === C2 ? "http://www.w3.org/1999/xhtml" : r2, f2, e2, f2 ? f2[0] : i2.__k && x(i2, 0), c2, s2), null != f2) for (a2 = f2.length; a2--; ) w$1(f2[a2]);
    c2 || (a2 = "value", "progress" === C2 && null == g2 ? u2.removeAttribute("value") : void 0 !== g2 && (g2 !== u2[a2] || "progress" === C2 && !g2 || "option" === C2 && g2 !== b2[a2]) && A(u2, a2, g2, b2[a2], r2), a2 = "checked", void 0 !== m2 && m2 !== u2[a2] && A(u2, a2, m2, b2[a2], r2));
  }
  return u2;
}
function N(n2, u2, t2) {
  try {
    if ("function" == typeof n2) {
      var i2 = "function" == typeof n2.__u;
      i2 && n2.__u(), i2 && null == u2 || (n2.__u = n2(u2));
    } else n2.current = u2;
  } catch (n3) {
    l$1.__e(n3, t2);
  }
}
function V(n2, u2, t2) {
  var i2, o2;
  if (l$1.unmount && l$1.unmount(n2), (i2 = n2.ref) && (i2.current && i2.current !== n2.__e || N(i2, null, u2)), null != (i2 = n2.__c)) {
    if (i2.componentWillUnmount) try {
      i2.componentWillUnmount();
    } catch (n3) {
      l$1.__e(n3, u2);
    }
    i2.base = i2.__P = null;
  }
  if (i2 = n2.__k) for (o2 = 0; o2 < i2.length; o2++) i2[o2] && V(i2[o2], u2, t2 || "function" != typeof n2.type);
  t2 || w$1(n2.__e), n2.__c = n2.__ = n2.__e = n2.__d = void 0;
}
function q(n2, l2, u2) {
  return this.constructor(n2, u2);
}
function B$1(u2, t2, i2) {
  var o2, r2, f2, e2;
  l$1.__ && l$1.__(u2, t2), r2 = (o2 = false) ? null : t2.__k, f2 = [], e2 = [], O(t2, u2 = t2.__k = _(b, null, [u2]), r2 || h$1, h$1, t2.namespaceURI, r2 ? null : t2.firstChild ? n.call(t2.childNodes) : null, f2, r2 ? r2.__e : t2.firstChild, o2, e2), j$1(f2, u2, e2);
}
n = v$1.slice, l$1 = { __e: function(n2, l2, u2, t2) {
  for (var i2, o2, r2; l2 = l2.__; ) if ((i2 = l2.__c) && !i2.__) try {
    if ((o2 = i2.constructor) && null != o2.getDerivedStateFromError && (i2.setState(o2.getDerivedStateFromError(n2)), r2 = i2.__d), null != i2.componentDidCatch && (i2.componentDidCatch(n2, t2 || {}), r2 = i2.__d), r2) return i2.__E = i2;
  } catch (l3) {
    n2 = l3;
  }
  throw n2;
} }, u$2 = 0, k$1.prototype.setState = function(n2, l2) {
  var u2;
  u2 = null != this.__s && this.__s !== this.state ? this.__s : this.__s = d$1({}, this.state), "function" == typeof n2 && (n2 = n2(d$1({}, u2), this.props)), n2 && d$1(u2, n2), null != n2 && this.__v && (l2 && this._sb.push(l2), M(this));
}, k$1.prototype.forceUpdate = function(n2) {
  this.__v && (this.__e = true, n2 && this.__h.push(n2), M(this));
}, k$1.prototype.render = b, i$1 = [], r$1 = "function" == typeof Promise ? Promise.prototype.then.bind(Promise.resolve()) : setTimeout, f$2 = function(n2, l2) {
  return n2.__v.__b - l2.__v.__b;
}, P.__r = 0, e$1 = 0, c$1 = F(false), s$1 = F(true);
var f$1 = 0;
function u$1(e2, t2, n2, o2, i2, u2) {
  t2 || (t2 = {});
  var a2, c2, l2 = t2;
  "ref" in t2 && (a2 = t2.ref, delete t2.ref);
  var p2 = { type: e2, props: l2, key: n2, ref: a2, __k: null, __: null, __b: 0, __e: null, __d: void 0, __c: null, constructor: void 0, __v: --f$1, __i: -1, __u: 0, __source: i2, __self: u2 };
  if ("function" == typeof e2 && (a2 = e2.defaultProps)) for (c2 in a2) void 0 === l2[c2] && (l2[c2] = a2[c2]);
  return l$1.vnode && l$1.vnode(p2), p2;
}
async function getDisplayableUsername(address) {
  return truncateAddress(address);
}
function truncateAddress(address, length = 4) {
  return `${address.slice(0, 2 + length)}...${address.slice(-length)}`;
}
const WHITE = "#FFF";
const BRAND_BLUE = "#0000FF";
const BaseLogo = ({ fill }) => {
  const fillColor = fill === "blue" ? BRAND_BLUE : WHITE;
  return u$1("svg", { width: "16", height: "16", viewBox: "0 0 16 16", fill: "none", xmlns: "http://www.w3.org/2000/svg", children: u$1("path", { d: "M0 2.014C0 1.58105 0 1.36457 0.0815779 1.19805C0.159686 1.03861 0.288611 0.909686 0.448049 0.831578C0.61457 0.75 0.831047 0.75 1.264 0.75H14.736C15.169 0.75 15.3854 0.75 15.552 0.831578C15.7114 0.909686 15.8403 1.03861 15.9184 1.19805C16 1.36457 16 1.58105 16 2.014V15.486C16 15.919 16 16.1354 15.9184 16.302C15.8403 16.4614 15.7114 16.5903 15.552 16.6684C15.3854 16.75 15.169 16.75 14.736 16.75H1.264C0.831047 16.75 0.61457 16.75 0.448049 16.6684C0.288611 16.5903 0.159686 16.4614 0.0815779 16.302C0 16.1354 0 15.919 0 15.486V2.014Z", fill: fillColor }) });
};
var t, r, u, i, o = 0, f = [], c = l$1, e = c.__b, a = c.__r, v = c.diffed, l = c.__c, m = c.unmount, s = c.__;
function d(n2, t2) {
  c.__h && c.__h(r, n2, o || t2), o = 0;
  var u2 = r.__H || (r.__H = { __: [], __h: [] });
  return n2 >= u2.__.length && u2.__.push({}), u2.__[n2];
}
function h(n2) {
  return o = 1, p(D, n2);
}
function p(n2, u2, i2) {
  var o2 = d(t++, 2);
  if (o2.t = n2, !o2.__c && (o2.__ = [D(void 0, u2), function(n3) {
    var t2 = o2.__N ? o2.__N[0] : o2.__[0], r2 = o2.t(t2, n3);
    t2 !== r2 && (o2.__N = [r2, o2.__[1]], o2.__c.setState({}));
  }], o2.__c = r, !r.u)) {
    var f2 = function(n3, t2, r2) {
      if (!o2.__c.__H) return true;
      var u3 = o2.__c.__H.__.filter(function(n4) {
        return !!n4.__c;
      });
      if (u3.every(function(n4) {
        return !n4.__N;
      })) return !c2 || c2.call(this, n3, t2, r2);
      var i3 = false;
      return u3.forEach(function(n4) {
        if (n4.__N) {
          var t3 = n4.__[0];
          n4.__ = n4.__N, n4.__N = void 0, t3 !== n4.__[0] && (i3 = true);
        }
      }), !(!i3 && o2.__c.props === n3) && (!c2 || c2.call(this, n3, t2, r2));
    };
    r.u = true;
    var c2 = r.shouldComponentUpdate, e2 = r.componentWillUpdate;
    r.componentWillUpdate = function(n3, t2, r2) {
      if (this.__e) {
        var u3 = c2;
        c2 = void 0, f2(n3, t2, r2), c2 = u3;
      }
      e2 && e2.call(this, n3, t2, r2);
    }, r.shouldComponentUpdate = f2;
  }
  return o2.__N || o2.__;
}
function y(n2, u2) {
  var i2 = d(t++, 3);
  !c.__s && C(i2.__H, u2) && (i2.__ = n2, i2.i = u2, r.__H.__h.push(i2));
}
function T(n2, r2) {
  var u2 = d(t++, 7);
  return C(u2.__H, r2) && (u2.__ = n2(), u2.__H = r2, u2.__h = n2), u2.__;
}
function j() {
  for (var n2; n2 = f.shift(); ) if (n2.__P && n2.__H) try {
    n2.__H.__h.forEach(z), n2.__H.__h.forEach(B), n2.__H.__h = [];
  } catch (t2) {
    n2.__H.__h = [], c.__e(t2, n2.__v);
  }
}
c.__b = function(n2) {
  r = null, e && e(n2);
}, c.__ = function(n2, t2) {
  n2 && t2.__k && t2.__k.__m && (n2.__m = t2.__k.__m), s && s(n2, t2);
}, c.__r = function(n2) {
  a && a(n2), t = 0;
  var i2 = (r = n2.__c).__H;
  i2 && (u === r ? (i2.__h = [], r.__h = [], i2.__.forEach(function(n3) {
    n3.__N && (n3.__ = n3.__N), n3.i = n3.__N = void 0;
  })) : (i2.__h.forEach(z), i2.__h.forEach(B), i2.__h = [], t = 0)), u = r;
}, c.diffed = function(n2) {
  v && v(n2);
  var t2 = n2.__c;
  t2 && t2.__H && (t2.__H.__h.length && (1 !== f.push(t2) && i === c.requestAnimationFrame || ((i = c.requestAnimationFrame) || w)(j)), t2.__H.__.forEach(function(n3) {
    n3.i && (n3.__H = n3.i), n3.i = void 0;
  })), u = r = null;
}, c.__c = function(n2, t2) {
  t2.some(function(n3) {
    try {
      n3.__h.forEach(z), n3.__h = n3.__h.filter(function(n4) {
        return !n4.__ || B(n4);
      });
    } catch (r2) {
      t2.some(function(n4) {
        n4.__h && (n4.__h = []);
      }), t2 = [], c.__e(r2, n3.__v);
    }
  }), l && l(n2, t2);
}, c.unmount = function(n2) {
  m && m(n2);
  var t2, r2 = n2.__c;
  r2 && r2.__H && (r2.__H.__.forEach(function(n3) {
    try {
      z(n3);
    } catch (n4) {
      t2 = n4;
    }
  }), r2.__H = void 0, t2 && c.__e(t2, r2.__v));
};
var k = "function" == typeof requestAnimationFrame;
function w(n2) {
  var t2, r2 = function() {
    clearTimeout(u2), k && cancelAnimationFrame(t2), setTimeout(n2);
  }, u2 = setTimeout(r2, 100);
  k && (t2 = requestAnimationFrame(r2));
}
function z(n2) {
  var t2 = r, u2 = n2.__c;
  "function" == typeof u2 && (n2.__c = void 0, u2()), r = t2;
}
function B(n2) {
  var t2 = r;
  n2.__c = n2.__(), r = t2;
}
function C(n2, t2) {
  return !n2 || n2.length !== t2.length || t2.some(function(t3, r2) {
    return t3 !== n2[r2];
  });
}
function D(n2, t2) {
  return "function" == typeof t2 ? t2(n2) : t2;
}
const css = /* @__PURE__ */ (() => `.-base-acc-sdk-css-reset{-webkit-font-smoothing:antialiased;pointer-events:auto !important}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-container{position:fixed;top:0;left:0;width:100%;height:100%;z-index:2147483647}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-container *{user-select:none;box-sizing:border-box}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-backdrop{position:fixed;top:0;left:0;width:100%;height:100%;background-color:rgba(0,0,0,.5);display:flex;align-items:center;justify-content:center;padding:20px}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-backdrop{align-items:flex-end;justify-content:stretch;padding:0}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog{position:relative;z-index:2147483648}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog{width:100%}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance{background:#fff;border-radius:12px;box-shadow:0 20px 25px -5px rgba(0,0,0,.1),0 10px 10px -5px rgba(0,0,0,.04);width:380px;max-height:90vh;overflow:hidden;transform:scale(0.95);opacity:0;transition:all .2s ease-in-out}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance{touch-action:pan-y;user-select:none}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-hidden{transform:scale(0.9);opacity:0}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-hidden{transform:translateY(100%)}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance:not(.-base-acc-sdk-dialog-instance-hidden){transform:scale(1);opacity:1}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance:not(.-base-acc-sdk-dialog-instance-hidden){transform:translateY(0)}}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance{width:100%;max-width:100%;border-radius:20px 20px 0 0;box-shadow:0 -10px 25px rgba(0,0,0,.15);max-height:80vh;transform:translateY(0)}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-hidden{transform:translateY(100%);opacity:1}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance:not(.-base-acc-sdk-dialog-instance-hidden){transform:translateY(0);opacity:1}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header{display:flex;align-items:center;justify-content:space-between;padding:16px 20px 0 20px}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header{padding:16px 20px 12px 20px}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header-icon-and-title{display:flex;align-items:center;gap:8px}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header-icon-and-title-title{font-family:"BaseSans-Regular",sans-serif;font-size:14px;font-weight:400;color:#5b616e}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header-cblogo{width:32px;height:32px}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header-close{display:flex;align-items:center;justify-content:center;width:32px;height:32px;cursor:pointer;border-radius:6px;transition:background-color .2s}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header-close:hover{background-color:#f5f7f8}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header-close-icon{width:14px;height:14px}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-header-close-icon{display:none}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-content{padding:20px 20px 16px 20px;font-family:"BaseSans-Regular",sans-serif}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-content{padding:8px 20px 12px 20px}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-content-title{font-size:20px;font-weight:600;line-height:28px;color:#0a0b0d;margin-bottom:10px}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-content-message{font-size:16px;font-weight:400;line-height:24px;color:#5b616e;margin-bottom:0}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-actions{display:flex;padding:16px 20px 20px 20px;flex-direction:column}@media(max-width: 600px)and (orientation: portrait){.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-actions{padding:16px 20px calc(20px + env(safe-area-inset-bottom)) 20px;gap:6px}}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-button{font-family:"BaseSans-Regular",sans-serif;font-size:16px;font-weight:500;line-height:24px;border:none;border-radius:12px;padding:16px 24px;cursor:pointer;transition:all .2s ease-in-out;width:100%;margin:4px 0}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-button:disabled{opacity:.5;cursor:not-allowed}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-button-primary{background-color:#0a0b0d;color:#fff}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-button-primary:hover:not(:disabled){background-color:#1c1e20}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-button-primary:active:not(:disabled){background-color:#2a2d31}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-button-secondary{background-color:#eef0f3;color:#0a0b0d}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-button-secondary:hover:not(:disabled){background-color:#e1e4e8}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-instance-button-secondary:active:not(:disabled){background-color:#d4d8dd}.-base-acc-sdk-css-reset .-base-acc-sdk-dialog-handle-bar{position:absolute;top:-16px;left:50%;transform:translateX(-50%);width:64px;height:4px;background-color:#d1d5db;border-radius:2px;opacity:0;animation:handleBarFadeIn .2s ease-in-out .2s forwards}@keyframes handleBarFadeIn{from{opacity:0}to{opacity:1}}`)();
const closeIcon = `data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTQiIGhlaWdodD0iMTQiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTEzIDFMMSAxM20wLTEyTDEzIDEzIiBzdHJva2U9IiM5Q0EzQUYiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+PC9zdmc+`;
function isPhonePortrait() {
  return window.innerWidth <= 600 && window.innerHeight > window.innerWidth;
}
const DialogHandleBar = () => {
  const [showHandleBar, setShowHandleBar] = h(false);
  y(() => {
    const checkOrientation = () => {
      setShowHandleBar(isPhonePortrait());
    };
    checkOrientation();
    window.addEventListener("resize", checkOrientation);
    window.addEventListener("orientationchange", checkOrientation);
    return () => {
      window.removeEventListener("resize", checkOrientation);
      window.removeEventListener("orientationchange", checkOrientation);
    };
  }, []);
  if (!showHandleBar) {
    return null;
  }
  return u$1("div", { class: "-base-acc-sdk-dialog-handle-bar" });
};
class Dialog {
  constructor() {
    this.items = /* @__PURE__ */ new Map();
    this.nextItemKey = 0;
    this.root = null;
  }
  attach(el) {
    this.root = document.createElement("div");
    this.root.className = "-base-acc-sdk-dialog-root";
    el.appendChild(this.root);
    this.render();
  }
  presentItem(itemProps) {
    const key = this.nextItemKey++;
    this.items.set(key, itemProps);
    this.render();
  }
  clear() {
    this.items.clear();
    if (this.root) {
      B$1(null, this.root);
    }
  }
  render() {
    if (this.root) {
      B$1(u$1("div", { children: u$1(DialogContainer, { children: Array.from(this.items.entries()).map(([key, itemProps]) => _(DialogInstance, Object.assign({}, itemProps, { key, handleClose: () => {
        var _a;
        this.clear();
        (_a = itemProps.onClose) === null || _a === void 0 ? void 0 : _a.call(itemProps);
      } }))) }) }), this.root);
    }
  }
}
const DialogContainer = (props) => {
  const [dragY, setDragY] = h(0);
  const [isDragging, setIsDragging] = h(false);
  const [startY, setStartY] = h(0);
  const handleTouchStart = (e2) => {
    if (!isPhonePortrait())
      return;
    const touch = e2.touches[0];
    setStartY(touch.clientY);
    setIsDragging(true);
  };
  const handleTouchMove = (e2) => {
    if (!isDragging)
      return;
    const touch = e2.touches[0];
    const deltaY = touch.clientY - startY;
    if (deltaY > 0) {
      setDragY(deltaY);
      e2.preventDefault();
    }
  };
  const handleTouchEnd = () => {
    if (!isDragging)
      return;
    setIsDragging(false);
    if (dragY > 100) {
      const closeButton = document.querySelector(".-base-acc-sdk-dialog-instance-header-close");
      if (closeButton) {
        closeButton.click();
      }
    } else {
      setDragY(0);
    }
  };
  return u$1("div", { class: clsx("-base-acc-sdk-dialog-container"), children: [u$1("style", { children: css }), u$1("div", { class: "-base-acc-sdk-dialog-backdrop", onTouchStart: handleTouchStart, onTouchMove: handleTouchMove, onTouchEnd: handleTouchEnd, children: u$1("div", { class: "-base-acc-sdk-dialog", style: {
    transform: `translateY(${dragY}px)`,
    transition: isDragging ? "none" : "transform 0.2s ease-out"
  }, children: [u$1(DialogHandleBar, {}), props.children] }) })] });
};
const DialogInstance = ({ title, message, actionItems, handleClose }) => {
  const [hidden, setHidden] = h(true);
  const [isLoadingUsername, setIsLoadingUsername] = h(true);
  const [username, setUsername] = h(null);
  y(() => {
    const timer = window.setTimeout(() => {
      setHidden(false);
    }, 1);
    return () => {
      window.clearTimeout(timer);
    };
  }, []);
  y(() => {
    const fetchEnsName = async () => {
      var _a;
      const address = (_a = store.account.get().accounts) === null || _a === void 0 ? void 0 : _a[0];
      if (address) {
        const username2 = await getDisplayableUsername(address);
        setUsername(username2);
      }
      setIsLoadingUsername(false);
    };
    fetchEnsName();
  }, []);
  const headerTitle = T(() => {
    return username ? `Signed in as ${username}` : "Base Account";
  }, [username]);
  const shouldShowHeaderTitle = !isLoadingUsername;
  return u$1("div", { class: clsx("-base-acc-sdk-dialog-instance", hidden && "-base-acc-sdk-dialog-instance-hidden"), children: [u$1("div", { class: "-base-acc-sdk-dialog-instance-header", children: [u$1("div", { class: "-base-acc-sdk-dialog-instance-header-icon-and-title", children: [u$1(BaseLogo, { fill: "blue" }), shouldShowHeaderTitle && u$1("div", { class: "-base-acc-sdk-dialog-instance-header-icon-and-title-title", children: headerTitle })] }), u$1("div", { class: "-base-acc-sdk-dialog-instance-header-close", onClick: handleClose, children: u$1("img", { src: closeIcon, class: "-base-acc-sdk-dialog-instance-header-close-icon" }) })] }), u$1("div", { class: "-base-acc-sdk-dialog-instance-content", children: [u$1("div", { class: "-base-acc-sdk-dialog-instance-content-title", children: title }), u$1("div", { class: "-base-acc-sdk-dialog-instance-content-message", children: message })] }), actionItems && actionItems.length > 0 && u$1("div", { class: "-base-acc-sdk-dialog-instance-actions", children: actionItems.map((action, i2) => u$1("button", { class: clsx("-base-acc-sdk-dialog-instance-button", action.variant === "primary" && "-base-acc-sdk-dialog-instance-button-primary", action.variant === "secondary" && "-base-acc-sdk-dialog-instance-button-secondary"), onClick: action.onClick, children: action.text }, i2)) })] });
};
let dialog = null;
function initDialog() {
  if (!dialog) {
    const root = document.createElement("div");
    root.className = "-base-acc-sdk-css-reset";
    document.body.appendChild(root);
    dialog = new Dialog();
    dialog.attach(root);
  }
  injectFontStyle();
  return dialog;
}
const POPUP_WIDTH = 420;
const POPUP_HEIGHT = 700;
const POPUP_BLOCKED_TITLE = "{app} wants to continue in Base Account";
const POPUP_BLOCKED_MESSAGE = "This action requires your permission to open a new window.";
function openPopup(url) {
  const left = (window.innerWidth - POPUP_WIDTH) / 2 + window.screenX;
  const top = (window.innerHeight - POPUP_HEIGHT) / 2 + window.screenY;
  appendAppInfoQueryParams(url);
  function tryOpenPopup() {
    const popupId = `wallet_${crypto.randomUUID()}`;
    const popup2 = window.open(url, popupId, `width=${POPUP_WIDTH}, height=${POPUP_HEIGHT}, left=${left}, top=${top}`);
    popup2 === null || popup2 === void 0 ? void 0 : popup2.focus();
    if (!popup2) {
      return null;
    }
    return popup2;
  }
  const popup = tryOpenPopup();
  if (!popup) {
    return openPopupWithDialog(tryOpenPopup);
  }
  return Promise.resolve(popup);
}
function closePopup(popup) {
  if (popup && !popup.closed) {
    popup.close();
  }
}
function appendAppInfoQueryParams(url) {
  const params = {
    sdkName: PACKAGE_NAME,
    sdkVersion: PACKAGE_VERSION,
    origin: window.location.origin,
    coop: getCrossOriginOpenerPolicy()
  };
  for (const [key, value] of Object.entries(params)) {
    if (!url.searchParams.has(key)) {
      url.searchParams.append(key, value.toString());
    }
  }
}
function openPopupWithDialog(tryOpenPopup) {
  var _a, _b;
  const dappName = (_b = (_a = store.config.get().metadata) === null || _a === void 0 ? void 0 : _a.appName) !== null && _b !== void 0 ? _b : "App";
  const dialog2 = initDialog();
  return new Promise((resolve, reject) => {
    logDialogShown({ dialogContext: "popup_blocked" });
    dialog2.presentItem({
      title: POPUP_BLOCKED_TITLE.replace("{app}", dappName),
      message: POPUP_BLOCKED_MESSAGE,
      onClose: () => {
        logDialogActionClicked({
          dialogContext: "popup_blocked",
          dialogAction: "cancel"
        });
        reject(standardErrors.rpc.internal("Popup window was blocked"));
      },
      actionItems: [
        {
          text: "Try again",
          variant: "primary",
          onClick: () => {
            logDialogActionClicked({
              dialogContext: "popup_blocked",
              dialogAction: "confirm"
            });
            const popup = tryOpenPopup();
            if (popup) {
              resolve(popup);
            } else {
              reject(standardErrors.rpc.internal("Popup window was blocked"));
            }
            dialog2.clear();
          }
        },
        {
          text: "Cancel",
          variant: "secondary",
          onClick: () => {
            logDialogActionClicked({
              dialogContext: "popup_blocked",
              dialogAction: "cancel"
            });
            reject(standardErrors.rpc.internal("Popup window was blocked"));
            dialog2.clear();
          }
        }
      ]
    });
  });
}
class Communicator {
  constructor({ url = CB_KEYS_URL, metadata, preference }) {
    this.popup = null;
    this.listeners = /* @__PURE__ */ new Map();
    this.postMessage = async (message) => {
      const popup = await this.waitForPopupLoaded();
      popup.postMessage(message, this.url.origin);
    };
    this.postRequestAndWaitForResponse = async (request) => {
      const responsePromise = this.onMessage(({ requestId }) => requestId === request.id);
      this.postMessage(request);
      return await responsePromise;
    };
    this.onMessage = async (predicate) => {
      return new Promise((resolve, reject) => {
        const listener = (event) => {
          if (event.origin !== this.url.origin)
            return;
          const message = event.data;
          if (predicate(message)) {
            resolve(message);
            window.removeEventListener("message", listener);
            this.listeners.delete(listener);
          }
        };
        window.addEventListener("message", listener);
        this.listeners.set(listener, { reject });
      });
    };
    this.disconnect = () => {
      closePopup(this.popup);
      this.popup = null;
      this.listeners.forEach(({ reject }, listener) => {
        reject(standardErrors.provider.userRejectedRequest("Request rejected"));
        window.removeEventListener("message", listener);
      });
      this.listeners.clear();
    };
    this.waitForPopupLoaded = async () => {
      if (this.popup && !this.popup.closed) {
        this.popup.focus();
        return this.popup;
      }
      logPopupSetupStarted();
      this.popup = await openPopup(this.url);
      this.onMessage(({ event }) => event === "PopupUnload").then(() => {
        this.disconnect();
        logPopupUnloadReceived();
      }).catch(() => {
      });
      return this.onMessage(({ event }) => event === "PopupLoaded").then((message) => {
        this.postMessage({
          requestId: message.id,
          data: {
            version: PACKAGE_VERSION,
            sdkName: PACKAGE_NAME,
            metadata: this.metadata,
            preference: this.preference,
            location: window.location.toString()
          }
        });
      }).then(() => {
        if (!this.popup)
          throw standardErrors.rpc.internal();
        logPopupSetupCompleted();
        return this.popup;
      });
    };
    this.url = new URL(url);
    this.metadata = metadata;
    this.preference = preference;
  }
}
function serializeError(error) {
  const serialized = serialize(getErrorObject(error), {
    shouldIncludeStack: true
  });
  const docUrl = new URL("https://docs.cloud.coinbase.com/wallet-sdk/docs/errors");
  docUrl.searchParams.set("version", PACKAGE_VERSION);
  docUrl.searchParams.set("code", serialized.code.toString());
  docUrl.searchParams.set("message", serialized.message);
  return Object.assign(Object.assign({}, serialized), { docUrl: docUrl.href });
}
function isErrorResponse(response) {
  return response.errorMessage !== void 0;
}
function getErrorObject(error) {
  var _a;
  if (typeof error === "string") {
    return {
      message: error,
      code: standardErrorCodes.rpc.internal
    };
  }
  if (isErrorResponse(error)) {
    const message = error.errorMessage;
    const code = (_a = error.errorCode) !== null && _a !== void 0 ? _a : message.match(/(denied|rejected)/i) ? standardErrorCodes.provider.userRejectedRequest : void 0;
    return Object.assign(Object.assign({}, error), {
      message,
      code,
      data: { method: error.method }
    });
  }
  return error;
}
class ProviderEventEmitter extends EventEmitter {
}
const logRequestStarted$1 = ({ method, correlationId }) => {
  logEvent("provider.request.started", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    signerType: "base-account",
    correlationId
  }, AnalyticsEventImportance.high);
};
const logRequestError$1 = ({ method, correlationId, errorMessage }) => {
  logEvent("provider.request.error", {
    action: ActionType.error,
    componentType: ComponentType.unknown,
    method,
    signerType: "base-account",
    correlationId,
    errorMessage
  }, AnalyticsEventImportance.high);
};
const logRequestResponded = ({ method, correlationId }) => {
  logEvent("provider.request.responded", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    signerType: "base-account",
    correlationId
  }, AnalyticsEventImportance.high);
};
function OpaqueType() {
  return (value) => value;
}
const HexString = OpaqueType();
function IntNumber(num) {
  return Math.floor(num);
}
const INT_STRING_REGEX = /^[0-9]*$/;
const HEXADECIMAL_STRING_REGEX = /^[a-f0-9]*$/;
function uint8ArrayToHex(value) {
  return [...value].map((b2) => b2.toString(16).padStart(2, "0")).join("");
}
function hexStringToUint8Array(hexString) {
  return new Uint8Array(hexString.match(/.{1,2}/g).map((byte) => Number.parseInt(byte, 16)));
}
function hexStringFromNumber(num) {
  return HexString(`0x${BigInt(num).toString(16)}`);
}
function has0xPrefix(str) {
  return str.startsWith("0x") || str.startsWith("0X");
}
function strip0x(hex) {
  if (has0xPrefix(hex)) {
    return hex.slice(2);
  }
  return hex;
}
function isHexString(hex) {
  if (typeof hex !== "string") {
    return false;
  }
  const s2 = strip0x(hex).toLowerCase();
  return HEXADECIMAL_STRING_REGEX.test(s2);
}
function ensureHexString(hex, includePrefix = false) {
  if (typeof hex === "string") {
    const s2 = strip0x(hex).toLowerCase();
    if (HEXADECIMAL_STRING_REGEX.test(s2)) {
      return HexString(includePrefix ? `0x${s2}` : s2);
    }
  }
  throw standardErrors.rpc.invalidParams(`"${String(hex)}" is not a hexadecimal string`);
}
function ensureEvenLengthHexString(hex, includePrefix = false) {
  let h2 = ensureHexString(hex, false);
  if (h2.length % 2 === 1) {
    h2 = HexString(`0${h2}`);
  }
  return includePrefix ? HexString(`0x${h2}`) : h2;
}
function ensureIntNumber(num) {
  if (typeof num === "number" && Number.isInteger(num)) {
    return IntNumber(num);
  }
  if (typeof num === "string") {
    if (INT_STRING_REGEX.test(num)) {
      return IntNumber(Number(num));
    }
    if (isHexString(num)) {
      return IntNumber(Number(BigInt(ensureEvenLengthHexString(num, true))));
    }
  }
  throw standardErrors.rpc.invalidParams(`Not an integer: ${String(num)}`);
}
const logHandshakeStarted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_signer.handshake.started", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logHandshakeError = ({ method, correlationId, errorMessage }) => {
  var _a;
  logEvent("scw_signer.handshake.error", {
    action: ActionType.error,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    errorMessage,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logHandshakeCompleted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_signer.handshake.completed", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logRequestStarted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_signer.request.started", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logRequestError = ({ method, correlationId, errorMessage }) => {
  var _a;
  logEvent("scw_signer.request.error", {
    action: ActionType.error,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    errorMessage,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logRequestCompleted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_signer.request.completed", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logSubAccountRequestStarted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_sub_account.request.started", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logSubAccountRequestCompleted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_sub_account.request.completed", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logSubAccountRequestError = ({ method, correlationId, errorMessage }) => {
  var _a;
  logEvent("scw_sub_account.request.error", {
    action: ActionType.error,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    errorMessage,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logAddOwnerStarted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_sub_account.add_owner.started", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logAddOwnerCompleted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_sub_account.add_owner.completed", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logAddOwnerError = ({ method, correlationId, errorMessage }) => {
  var _a;
  logEvent("scw_sub_account.add_owner.error", {
    action: ActionType.error,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    errorMessage,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logInsufficientBalanceErrorHandlingStarted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_sub_account.insufficient_balance.error_handling.started", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logInsufficientBalanceErrorHandlingCompleted = ({ method, correlationId }) => {
  var _a;
  logEvent("scw_sub_account.insufficient_balance.error_handling.completed", {
    action: ActionType.unknown,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const logInsufficientBalanceErrorHandlingError = ({ method, correlationId, errorMessage }) => {
  var _a;
  logEvent("scw_sub_account.insufficient_balance.error_handling.error", {
    action: ActionType.error,
    componentType: ComponentType.unknown,
    method,
    correlationId,
    errorMessage,
    enableAutoSubAccounts: (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.enableAutoSubAccounts
  }, AnalyticsEventImportance.high);
};
const parseErrorMessageFromAny = (errorOrAny) => {
  return "message" in errorOrAny && typeof errorOrAny.message === "string" ? errorOrAny.message : "";
};
const entryPoint06Abi = [
  {
    inputs: [
      { name: "preOpGas", type: "uint256" },
      { name: "paid", type: "uint256" },
      { name: "validAfter", type: "uint48" },
      { name: "validUntil", type: "uint48" },
      { name: "targetSuccess", type: "bool" },
      { name: "targetResult", type: "bytes" }
    ],
    name: "ExecutionResult",
    type: "error"
  },
  {
    inputs: [
      { name: "opIndex", type: "uint256" },
      { name: "reason", type: "string" }
    ],
    name: "FailedOp",
    type: "error"
  },
  {
    inputs: [{ name: "sender", type: "address" }],
    name: "SenderAddressResult",
    type: "error"
  },
  {
    inputs: [{ name: "aggregator", type: "address" }],
    name: "SignatureValidationFailed",
    type: "error"
  },
  {
    inputs: [
      {
        components: [
          { name: "preOpGas", type: "uint256" },
          { name: "prefund", type: "uint256" },
          { name: "sigFailed", type: "bool" },
          { name: "validAfter", type: "uint48" },
          { name: "validUntil", type: "uint48" },
          { name: "paymasterContext", type: "bytes" }
        ],
        name: "returnInfo",
        type: "tuple"
      },
      {
        components: [
          { name: "stake", type: "uint256" },
          { name: "unstakeDelaySec", type: "uint256" }
        ],
        name: "senderInfo",
        type: "tuple"
      },
      {
        components: [
          { name: "stake", type: "uint256" },
          { name: "unstakeDelaySec", type: "uint256" }
        ],
        name: "factoryInfo",
        type: "tuple"
      },
      {
        components: [
          { name: "stake", type: "uint256" },
          { name: "unstakeDelaySec", type: "uint256" }
        ],
        name: "paymasterInfo",
        type: "tuple"
      }
    ],
    name: "ValidationResult",
    type: "error"
  },
  {
    inputs: [
      {
        components: [
          { name: "preOpGas", type: "uint256" },
          { name: "prefund", type: "uint256" },
          { name: "sigFailed", type: "bool" },
          { name: "validAfter", type: "uint48" },
          { name: "validUntil", type: "uint48" },
          { name: "paymasterContext", type: "bytes" }
        ],
        name: "returnInfo",
        type: "tuple"
      },
      {
        components: [
          { name: "stake", type: "uint256" },
          { name: "unstakeDelaySec", type: "uint256" }
        ],
        name: "senderInfo",
        type: "tuple"
      },
      {
        components: [
          { name: "stake", type: "uint256" },
          { name: "unstakeDelaySec", type: "uint256" }
        ],
        name: "factoryInfo",
        type: "tuple"
      },
      {
        components: [
          { name: "stake", type: "uint256" },
          { name: "unstakeDelaySec", type: "uint256" }
        ],
        name: "paymasterInfo",
        type: "tuple"
      },
      {
        components: [
          { name: "aggregator", type: "address" },
          {
            components: [
              { name: "stake", type: "uint256" },
              {
                name: "unstakeDelaySec",
                type: "uint256"
              }
            ],
            name: "stakeInfo",
            type: "tuple"
          }
        ],
        name: "aggregatorInfo",
        type: "tuple"
      }
    ],
    name: "ValidationResultWithAggregation",
    type: "error"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "userOpHash",
        type: "bytes32"
      },
      {
        indexed: true,
        name: "sender",
        type: "address"
      },
      {
        indexed: false,
        name: "factory",
        type: "address"
      },
      {
        indexed: false,
        name: "paymaster",
        type: "address"
      }
    ],
    name: "AccountDeployed",
    type: "event"
  },
  { anonymous: false, inputs: [], name: "BeforeExecution", type: "event" },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "account",
        type: "address"
      },
      {
        indexed: false,
        name: "totalDeposit",
        type: "uint256"
      }
    ],
    name: "Deposited",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "aggregator",
        type: "address"
      }
    ],
    name: "SignatureAggregatorChanged",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "account",
        type: "address"
      },
      {
        indexed: false,
        name: "totalStaked",
        type: "uint256"
      },
      {
        indexed: false,
        name: "unstakeDelaySec",
        type: "uint256"
      }
    ],
    name: "StakeLocked",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "account",
        type: "address"
      },
      {
        indexed: false,
        name: "withdrawTime",
        type: "uint256"
      }
    ],
    name: "StakeUnlocked",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "account",
        type: "address"
      },
      {
        indexed: false,
        name: "withdrawAddress",
        type: "address"
      },
      {
        indexed: false,
        name: "amount",
        type: "uint256"
      }
    ],
    name: "StakeWithdrawn",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "userOpHash",
        type: "bytes32"
      },
      {
        indexed: true,
        name: "sender",
        type: "address"
      },
      {
        indexed: true,
        name: "paymaster",
        type: "address"
      },
      {
        indexed: false,
        name: "nonce",
        type: "uint256"
      },
      { indexed: false, name: "success", type: "bool" },
      {
        indexed: false,
        name: "actualGasCost",
        type: "uint256"
      },
      {
        indexed: false,
        name: "actualGasUsed",
        type: "uint256"
      }
    ],
    name: "UserOperationEvent",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "userOpHash",
        type: "bytes32"
      },
      {
        indexed: true,
        name: "sender",
        type: "address"
      },
      {
        indexed: false,
        name: "nonce",
        type: "uint256"
      },
      {
        indexed: false,
        name: "revertReason",
        type: "bytes"
      }
    ],
    name: "UserOperationRevertReason",
    type: "event"
  },
  {
    anonymous: false,
    inputs: [
      {
        indexed: true,
        name: "account",
        type: "address"
      },
      {
        indexed: false,
        name: "withdrawAddress",
        type: "address"
      },
      {
        indexed: false,
        name: "amount",
        type: "uint256"
      }
    ],
    name: "Withdrawn",
    type: "event"
  },
  {
    inputs: [],
    name: "SIG_VALIDATION_FAILED",
    outputs: [{ name: "", type: "uint256" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      { name: "initCode", type: "bytes" },
      { name: "sender", type: "address" },
      { name: "paymasterAndData", type: "bytes" }
    ],
    name: "_validateSenderAndPaymaster",
    outputs: [],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "unstakeDelaySec", type: "uint32" }],
    name: "addStake",
    outputs: [],
    stateMutability: "payable",
    type: "function"
  },
  {
    inputs: [{ name: "account", type: "address" }],
    name: "balanceOf",
    outputs: [{ name: "", type: "uint256" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "account", type: "address" }],
    name: "depositTo",
    outputs: [],
    stateMutability: "payable",
    type: "function"
  },
  {
    inputs: [{ name: "", type: "address" }],
    name: "deposits",
    outputs: [
      { name: "deposit", type: "uint112" },
      { name: "staked", type: "bool" },
      { name: "stake", type: "uint112" },
      { name: "unstakeDelaySec", type: "uint32" },
      { name: "withdrawTime", type: "uint48" }
    ],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "account", type: "address" }],
    name: "getDepositInfo",
    outputs: [
      {
        components: [
          { name: "deposit", type: "uint112" },
          { name: "staked", type: "bool" },
          { name: "stake", type: "uint112" },
          { name: "unstakeDelaySec", type: "uint32" },
          { name: "withdrawTime", type: "uint48" }
        ],
        name: "info",
        type: "tuple"
      }
    ],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      { name: "sender", type: "address" },
      { name: "key", type: "uint192" }
    ],
    name: "getNonce",
    outputs: [{ name: "nonce", type: "uint256" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [{ name: "initCode", type: "bytes" }],
    name: "getSenderAddress",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      {
        components: [
          { name: "sender", type: "address" },
          { name: "nonce", type: "uint256" },
          { name: "initCode", type: "bytes" },
          { name: "callData", type: "bytes" },
          { name: "callGasLimit", type: "uint256" },
          {
            name: "verificationGasLimit",
            type: "uint256"
          },
          {
            name: "preVerificationGas",
            type: "uint256"
          },
          { name: "maxFeePerGas", type: "uint256" },
          {
            name: "maxPriorityFeePerGas",
            type: "uint256"
          },
          { name: "paymasterAndData", type: "bytes" },
          { name: "signature", type: "bytes" }
        ],
        name: "userOp",
        type: "tuple"
      }
    ],
    name: "getUserOpHash",
    outputs: [{ name: "", type: "bytes32" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      {
        components: [
          {
            components: [
              { name: "sender", type: "address" },
              { name: "nonce", type: "uint256" },
              { name: "initCode", type: "bytes" },
              { name: "callData", type: "bytes" },
              {
                name: "callGasLimit",
                type: "uint256"
              },
              {
                name: "verificationGasLimit",
                type: "uint256"
              },
              {
                name: "preVerificationGas",
                type: "uint256"
              },
              {
                name: "maxFeePerGas",
                type: "uint256"
              },
              {
                name: "maxPriorityFeePerGas",
                type: "uint256"
              },
              {
                name: "paymasterAndData",
                type: "bytes"
              },
              { name: "signature", type: "bytes" }
            ],
            name: "userOps",
            type: "tuple[]"
          },
          {
            name: "aggregator",
            type: "address"
          },
          { name: "signature", type: "bytes" }
        ],
        name: "opsPerAggregator",
        type: "tuple[]"
      },
      { name: "beneficiary", type: "address" }
    ],
    name: "handleAggregatedOps",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      {
        components: [
          { name: "sender", type: "address" },
          { name: "nonce", type: "uint256" },
          { name: "initCode", type: "bytes" },
          { name: "callData", type: "bytes" },
          { name: "callGasLimit", type: "uint256" },
          {
            name: "verificationGasLimit",
            type: "uint256"
          },
          {
            name: "preVerificationGas",
            type: "uint256"
          },
          { name: "maxFeePerGas", type: "uint256" },
          {
            name: "maxPriorityFeePerGas",
            type: "uint256"
          },
          { name: "paymasterAndData", type: "bytes" },
          { name: "signature", type: "bytes" }
        ],
        name: "ops",
        type: "tuple[]"
      },
      { name: "beneficiary", type: "address" }
    ],
    name: "handleOps",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [{ name: "key", type: "uint192" }],
    name: "incrementNonce",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      { name: "callData", type: "bytes" },
      {
        components: [
          {
            components: [
              { name: "sender", type: "address" },
              { name: "nonce", type: "uint256" },
              {
                name: "callGasLimit",
                type: "uint256"
              },
              {
                name: "verificationGasLimit",
                type: "uint256"
              },
              {
                name: "preVerificationGas",
                type: "uint256"
              },
              { name: "paymaster", type: "address" },
              {
                name: "maxFeePerGas",
                type: "uint256"
              },
              {
                name: "maxPriorityFeePerGas",
                type: "uint256"
              }
            ],
            name: "mUserOp",
            type: "tuple"
          },
          { name: "userOpHash", type: "bytes32" },
          { name: "prefund", type: "uint256" },
          { name: "contextOffset", type: "uint256" },
          { name: "preOpGas", type: "uint256" }
        ],
        name: "opInfo",
        type: "tuple"
      },
      { name: "context", type: "bytes" }
    ],
    name: "innerHandleOp",
    outputs: [{ name: "actualGasCost", type: "uint256" }],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      { name: "", type: "address" },
      { name: "", type: "uint192" }
    ],
    name: "nonceSequenceNumber",
    outputs: [{ name: "", type: "uint256" }],
    stateMutability: "view",
    type: "function"
  },
  {
    inputs: [
      {
        components: [
          { name: "sender", type: "address" },
          { name: "nonce", type: "uint256" },
          { name: "initCode", type: "bytes" },
          { name: "callData", type: "bytes" },
          { name: "callGasLimit", type: "uint256" },
          {
            name: "verificationGasLimit",
            type: "uint256"
          },
          {
            name: "preVerificationGas",
            type: "uint256"
          },
          { name: "maxFeePerGas", type: "uint256" },
          {
            name: "maxPriorityFeePerGas",
            type: "uint256"
          },
          { name: "paymasterAndData", type: "bytes" },
          { name: "signature", type: "bytes" }
        ],
        name: "op",
        type: "tuple"
      },
      { name: "target", type: "address" },
      { name: "targetCallData", type: "bytes" }
    ],
    name: "simulateHandleOp",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      {
        components: [
          { name: "sender", type: "address" },
          { name: "nonce", type: "uint256" },
          { name: "initCode", type: "bytes" },
          { name: "callData", type: "bytes" },
          { name: "callGasLimit", type: "uint256" },
          {
            name: "verificationGasLimit",
            type: "uint256"
          },
          {
            name: "preVerificationGas",
            type: "uint256"
          },
          { name: "maxFeePerGas", type: "uint256" },
          {
            name: "maxPriorityFeePerGas",
            type: "uint256"
          },
          { name: "paymasterAndData", type: "bytes" },
          { name: "signature", type: "bytes" }
        ],
        name: "userOp",
        type: "tuple"
      }
    ],
    name: "simulateValidation",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [],
    name: "unlockStake",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      {
        name: "withdrawAddress",
        type: "address"
      }
    ],
    name: "withdrawStake",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  {
    inputs: [
      {
        name: "withdrawAddress",
        type: "address"
      },
      { name: "withdrawAmount", type: "uint256" }
    ],
    name: "withdrawTo",
    outputs: [],
    stateMutability: "nonpayable",
    type: "function"
  },
  { stateMutability: "payable", type: "receive" }
];
const entryPoint06Address = "0x5FF137D4b0FDCD49DcA30c7CF57E578a026d2789";
function getInitCode(userOperation, options = {}) {
  const { forHash } = options;
  const { authorization, factory, factoryData } = userOperation;
  if (forHash && (factory === "0x7702" || factory === "0x7702000000000000000000000000000000000000")) {
    if (!authorization)
      return "0x7702000000000000000000000000000000000000";
    return concat$1([authorization.address, factoryData ?? "0x"]);
  }
  if (!factory)
    return "0x";
  return concat$1([factory, factoryData ?? "0x"]);
}
const paymasterSignatureMagic = "0x22e325a297439656";
function toPackedUserOperation(userOperation, options = {}) {
  const { callGasLimit, callData, maxPriorityFeePerGas, maxFeePerGas, paymaster, paymasterData, paymasterPostOpGasLimit, paymasterSignature, paymasterVerificationGasLimit, sender, signature = "0x", verificationGasLimit } = userOperation;
  const accountGasLimits = concat$1([
    pad$1(numberToHex(verificationGasLimit || 0n), { size: 16 }),
    pad$1(numberToHex(callGasLimit || 0n), { size: 16 })
  ]);
  const initCode = getInitCode(userOperation, options);
  const gasFees = concat$1([
    pad$1(numberToHex(maxPriorityFeePerGas || 0n), { size: 16 }),
    pad$1(numberToHex(maxFeePerGas || 0n), { size: 16 })
  ]);
  const nonce = userOperation.nonce ?? 0n;
  const paymasterAndData = paymaster ? concat$1([
    paymaster,
    pad$1(numberToHex(paymasterVerificationGasLimit || 0n), {
      size: 16
    }),
    pad$1(numberToHex(paymasterPostOpGasLimit || 0n), {
      size: 16
    }),
    paymasterData || "0x",
    ...paymasterSignature ? options.forHash ? [paymasterSignatureMagic] : [
      paymasterSignature,
      pad$1(numberToHex(size$2(paymasterSignature)), { size: 2 }),
      paymasterSignatureMagic
    ] : []
  ]) : "0x";
  const preVerificationGas = userOperation.preVerificationGas ?? 0n;
  return {
    accountGasLimits,
    callData,
    initCode,
    gasFees,
    nonce,
    paymasterAndData,
    preVerificationGas,
    sender,
    signature
  };
}
const types = {
  PackedUserOperation: [
    { type: "address", name: "sender" },
    { type: "uint256", name: "nonce" },
    { type: "bytes", name: "initCode" },
    { type: "bytes", name: "callData" },
    { type: "bytes32", name: "accountGasLimits" },
    { type: "uint256", name: "preVerificationGas" },
    { type: "bytes32", name: "gasFees" },
    { type: "bytes", name: "paymasterAndData" }
  ]
};
function getUserOperationTypedData(parameters) {
  const { chainId, entryPointAddress, userOperation } = parameters;
  const packedUserOp = toPackedUserOperation(userOperation, { forHash: true });
  return {
    types,
    primaryType: "PackedUserOperation",
    domain: {
      name: "ERC4337",
      version: "1",
      chainId,
      verifyingContract: entryPointAddress
    },
    message: packedUserOp
  };
}
function getUserOperationHash(parameters) {
  const { chainId, entryPointAddress, entryPointVersion } = parameters;
  const userOperation = parameters.userOperation;
  const { authorization, callData = "0x", callGasLimit, maxFeePerGas, maxPriorityFeePerGas, nonce, paymasterAndData = "0x", preVerificationGas, sender, verificationGasLimit } = userOperation;
  if (entryPointVersion === "0.8" || entryPointVersion === "0.9")
    return hashTypedData(getUserOperationTypedData({
      chainId,
      entryPointAddress,
      userOperation
    }));
  const packedUserOp = (() => {
    var _a, _b;
    if (entryPointVersion === "0.6") {
      const factory = (_a = userOperation.initCode) == null ? void 0 : _a.slice(0, 42);
      const factoryData = (_b = userOperation.initCode) == null ? void 0 : _b.slice(42);
      const initCode = getInitCode({
        authorization,
        factory,
        factoryData
      }, { forHash: true });
      return encodeAbiParameters([
        { type: "address" },
        { type: "uint256" },
        { type: "bytes32" },
        { type: "bytes32" },
        { type: "uint256" },
        { type: "uint256" },
        { type: "uint256" },
        { type: "uint256" },
        { type: "uint256" },
        { type: "bytes32" }
      ], [
        sender,
        nonce,
        keccak256(initCode),
        keccak256(callData),
        callGasLimit,
        verificationGasLimit,
        preVerificationGas,
        maxFeePerGas,
        maxPriorityFeePerGas,
        keccak256(paymasterAndData)
      ]);
    }
    if (entryPointVersion === "0.7") {
      const packedUserOp2 = toPackedUserOperation(userOperation, {
        forHash: true
      });
      return encodeAbiParameters([
        { type: "address" },
        { type: "uint256" },
        { type: "bytes32" },
        { type: "bytes32" },
        { type: "bytes32" },
        { type: "uint256" },
        { type: "bytes32" },
        { type: "bytes32" }
      ], [
        packedUserOp2.sender,
        packedUserOp2.nonce,
        keccak256(packedUserOp2.initCode),
        keccak256(packedUserOp2.callData),
        packedUserOp2.accountGasLimits,
        packedUserOp2.preVerificationGas,
        packedUserOp2.gasFees,
        keccak256(packedUserOp2.paymasterAndData)
      ]);
    }
    throw new Error(`entryPointVersion "${entryPointVersion}" not supported.`);
  })();
  return keccak256(encodeAbiParameters([{ type: "bytes32" }, { type: "address" }, { type: "uint256" }], [keccak256(packedUserOp), entryPointAddress, BigInt(chainId)]));
}
async function toSmartAccount(implementation) {
  const { extend, nonceKeyManager = createNonceManager({
    source: {
      get() {
        return Date.now();
      },
      set() {
      }
    }
  }), ...rest } = implementation;
  let deployed = false;
  const address = await implementation.getAddress();
  return {
    ...extend,
    ...rest,
    address,
    async getFactoryArgs() {
      if ("isDeployed" in this && await this.isDeployed())
        return { factory: void 0, factoryData: void 0 };
      return implementation.getFactoryArgs();
    },
    async getNonce(parameters) {
      const key = (parameters == null ? void 0 : parameters.key) ?? BigInt(await nonceKeyManager.consume({
        address,
        chainId: implementation.client.chain.id,
        client: implementation.client
      }));
      if (implementation.getNonce)
        return await implementation.getNonce({ ...parameters, key });
      const nonce = await readContract(implementation.client, {
        abi: parseAbi([
          "function getNonce(address, uint192) pure returns (uint256)"
        ]),
        address: implementation.entryPoint.address,
        functionName: "getNonce",
        args: [address, key]
      });
      return nonce;
    },
    async isDeployed() {
      if (deployed)
        return true;
      const code = await getAction(implementation.client, getCode, "getCode")({
        address
      });
      deployed = Boolean(code);
      return deployed;
    },
    ...implementation.sign ? {
      async sign(parameters) {
        const [{ factory, factoryData }, signature] = await Promise.all([
          this.getFactoryArgs(),
          implementation.sign(parameters)
        ]);
        if (factory && factoryData)
          return serializeErc6492Signature({
            address: factory,
            data: factoryData,
            signature
          });
        return signature;
      }
    } : {},
    async signMessage(parameters) {
      const [{ factory, factoryData }, signature] = await Promise.all([
        this.getFactoryArgs(),
        implementation.signMessage(parameters)
      ]);
      if (factory && factoryData && factory !== "0x7702")
        return serializeErc6492Signature({
          address: factory,
          data: factoryData,
          signature
        });
      return signature;
    },
    async signTypedData(parameters) {
      const [{ factory, factoryData }, signature] = await Promise.all([
        this.getFactoryArgs(),
        implementation.signTypedData(parameters)
      ]);
      if (factory && factoryData && factory !== "0x7702")
        return serializeErc6492Signature({
          address: factory,
          data: factoryData,
          signature
        });
      return signature;
    },
    type: "smart"
  };
}
class AccountNotDeployedError extends BaseError$1 {
  constructor({ cause }) {
    super("Smart Account is not deployed.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- No `factory`/`factoryData` or `initCode` properties are provided for Smart Account deployment.",
        "- An incorrect `sender` address is provided."
      ],
      name: "AccountNotDeployedError"
    });
  }
}
Object.defineProperty(AccountNotDeployedError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa20/
});
class ExecutionRevertedError extends BaseError$1 {
  constructor({ cause, data, message } = {}) {
    var _a;
    const reason = (_a = message == null ? void 0 : message.replace("execution reverted: ", "")) == null ? void 0 : _a.replace("execution reverted", "");
    super(`Execution reverted ${reason ? `with reason: ${reason}` : "for an unknown reason"}.`, {
      cause,
      name: "ExecutionRevertedError"
    });
    Object.defineProperty(this, "data", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    this.data = data;
  }
}
Object.defineProperty(ExecutionRevertedError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32521
});
Object.defineProperty(ExecutionRevertedError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /execution reverted/
});
class FailedToSendToBeneficiaryError extends BaseError$1 {
  constructor({ cause }) {
    super("Failed to send funds to beneficiary.", {
      cause,
      name: "FailedToSendToBeneficiaryError"
    });
  }
}
Object.defineProperty(FailedToSendToBeneficiaryError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa91/
});
class GasValuesOverflowError extends BaseError$1 {
  constructor({ cause }) {
    super("Gas value overflowed.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- one of the gas values exceeded 2**120 (uint120)"
      ].filter(Boolean),
      name: "GasValuesOverflowError"
    });
  }
}
Object.defineProperty(GasValuesOverflowError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa94/
});
class HandleOpsOutOfGasError extends BaseError$1 {
  constructor({ cause }) {
    super("The `handleOps` function was called by the Bundler with a gas limit too low.", {
      cause,
      name: "HandleOpsOutOfGasError"
    });
  }
}
Object.defineProperty(HandleOpsOutOfGasError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa95/
});
class InitCodeFailedError extends BaseError$1 {
  constructor({ cause, factory, factoryData, initCode }) {
    super("Failed to simulate deployment for Smart Account.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- Invalid `factory`/`factoryData` or `initCode` properties are present",
        "- Smart Account deployment execution ran out of gas (low `verificationGasLimit` value)",
        "- Smart Account deployment execution reverted with an error\n",
        factory && `factory: ${factory}`,
        factoryData && `factoryData: ${factoryData}`,
        initCode && `initCode: ${initCode}`
      ].filter(Boolean),
      name: "InitCodeFailedError"
    });
  }
}
Object.defineProperty(InitCodeFailedError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa13/
});
class InitCodeMustCreateSenderError extends BaseError$1 {
  constructor({ cause, factory, factoryData, initCode }) {
    super("Smart Account initialization implementation did not create an account.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- `factory`/`factoryData` or `initCode` properties are invalid",
        "- Smart Account initialization implementation is incorrect\n",
        factory && `factory: ${factory}`,
        factoryData && `factoryData: ${factoryData}`,
        initCode && `initCode: ${initCode}`
      ].filter(Boolean),
      name: "InitCodeMustCreateSenderError"
    });
  }
}
Object.defineProperty(InitCodeMustCreateSenderError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa15/
});
class InitCodeMustReturnSenderError extends BaseError$1 {
  constructor({ cause, factory, factoryData, initCode, sender }) {
    super("Smart Account initialization implementation does not return the expected sender.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "Smart Account initialization implementation does not return a sender address\n",
        factory && `factory: ${factory}`,
        factoryData && `factoryData: ${factoryData}`,
        initCode && `initCode: ${initCode}`,
        sender && `sender: ${sender}`
      ].filter(Boolean),
      name: "InitCodeMustReturnSenderError"
    });
  }
}
Object.defineProperty(InitCodeMustReturnSenderError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa14/
});
class InsufficientPrefundError extends BaseError$1 {
  constructor({ cause }) {
    super("Smart Account does not have sufficient funds to execute the User Operation.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the Smart Account does not have sufficient funds to cover the required prefund, or",
        "- a Paymaster was not provided"
      ].filter(Boolean),
      name: "InsufficientPrefundError"
    });
  }
}
Object.defineProperty(InsufficientPrefundError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa21/
});
class InternalCallOnlyError extends BaseError$1 {
  constructor({ cause }) {
    super("Bundler attempted to call an invalid function on the EntryPoint.", {
      cause,
      name: "InternalCallOnlyError"
    });
  }
}
Object.defineProperty(InternalCallOnlyError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa92/
});
class InvalidAggregatorError extends BaseError$1 {
  constructor({ cause }) {
    super("Bundler used an invalid aggregator for handling aggregated User Operations.", {
      cause,
      name: "InvalidAggregatorError"
    });
  }
}
Object.defineProperty(InvalidAggregatorError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa96/
});
class InvalidAccountNonceError extends BaseError$1 {
  constructor({ cause, nonce }) {
    super("Invalid Smart Account nonce used for User Operation.", {
      cause,
      metaMessages: [nonce && `nonce: ${nonce}`].filter(Boolean),
      name: "InvalidAccountNonceError"
    });
  }
}
Object.defineProperty(InvalidAccountNonceError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa25/
});
class InvalidBeneficiaryError extends BaseError$1 {
  constructor({ cause }) {
    super("Bundler has not set a beneficiary address.", {
      cause,
      name: "InvalidBeneficiaryError"
    });
  }
}
Object.defineProperty(InvalidBeneficiaryError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa90/
});
class InvalidFieldsError extends BaseError$1 {
  constructor({ cause }) {
    super("Invalid fields set on User Operation.", {
      cause,
      name: "InvalidFieldsError"
    });
  }
}
Object.defineProperty(InvalidFieldsError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32602
});
class InvalidPaymasterAndDataError extends BaseError$1 {
  constructor({ cause, paymasterAndData }) {
    super("Paymaster properties provided are invalid.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the `paymasterAndData` property is of an incorrect length\n",
        paymasterAndData && `paymasterAndData: ${paymasterAndData}`
      ].filter(Boolean),
      name: "InvalidPaymasterAndDataError"
    });
  }
}
Object.defineProperty(InvalidPaymasterAndDataError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa93/
});
class PaymasterDepositTooLowError extends BaseError$1 {
  constructor({ cause }) {
    super("Paymaster deposit for the User Operation is too low.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the Paymaster has deposited less than the expected amount via the `deposit` function"
      ].filter(Boolean),
      name: "PaymasterDepositTooLowError"
    });
  }
}
Object.defineProperty(PaymasterDepositTooLowError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32508
});
Object.defineProperty(PaymasterDepositTooLowError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa31/
});
class PaymasterFunctionRevertedError extends BaseError$1 {
  constructor({ cause }) {
    super("The `validatePaymasterUserOp` function on the Paymaster reverted.", {
      cause,
      name: "PaymasterFunctionRevertedError"
    });
  }
}
Object.defineProperty(PaymasterFunctionRevertedError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa33/
});
class PaymasterNotDeployedError extends BaseError$1 {
  constructor({ cause }) {
    super("The Paymaster contract has not been deployed.", {
      cause,
      name: "PaymasterNotDeployedError"
    });
  }
}
Object.defineProperty(PaymasterNotDeployedError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa30/
});
class PaymasterRateLimitError extends BaseError$1 {
  constructor({ cause }) {
    super("UserOperation rejected because paymaster (or signature aggregator) is throttled/banned.", {
      cause,
      name: "PaymasterRateLimitError"
    });
  }
}
Object.defineProperty(PaymasterRateLimitError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32504
});
class PaymasterStakeTooLowError extends BaseError$1 {
  constructor({ cause }) {
    super("UserOperation rejected because paymaster (or signature aggregator) is throttled/banned.", {
      cause,
      name: "PaymasterStakeTooLowError"
    });
  }
}
Object.defineProperty(PaymasterStakeTooLowError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32505
});
class PaymasterPostOpFunctionRevertedError extends BaseError$1 {
  constructor({ cause }) {
    super("Paymaster `postOp` function reverted.", {
      cause,
      name: "PaymasterPostOpFunctionRevertedError"
    });
  }
}
Object.defineProperty(PaymasterPostOpFunctionRevertedError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa50/
});
class SenderAlreadyConstructedError extends BaseError$1 {
  constructor({ cause, factory, factoryData, initCode }) {
    super("Smart Account has already been deployed.", {
      cause,
      metaMessages: [
        "Remove the following properties and try again:",
        factory && "`factory`",
        factoryData && "`factoryData`",
        initCode && "`initCode`"
      ].filter(Boolean),
      name: "SenderAlreadyConstructedError"
    });
  }
}
Object.defineProperty(SenderAlreadyConstructedError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa10/
});
class SignatureCheckFailedError extends BaseError$1 {
  constructor({ cause }) {
    super("UserOperation rejected because account signature check failed (or paymaster signature, if the paymaster uses its data as signature).", {
      cause,
      name: "SignatureCheckFailedError"
    });
  }
}
Object.defineProperty(SignatureCheckFailedError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32507
});
class SmartAccountFunctionRevertedError extends BaseError$1 {
  constructor({ cause }) {
    super("The `validateUserOp` function on the Smart Account reverted.", {
      cause,
      name: "SmartAccountFunctionRevertedError"
    });
  }
}
Object.defineProperty(SmartAccountFunctionRevertedError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa23/
});
class UnsupportedSignatureAggregatorError extends BaseError$1 {
  constructor({ cause }) {
    super("UserOperation rejected because account specified unsupported signature aggregator.", {
      cause,
      name: "UnsupportedSignatureAggregatorError"
    });
  }
}
Object.defineProperty(UnsupportedSignatureAggregatorError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32506
});
class UserOperationExpiredError extends BaseError$1 {
  constructor({ cause }) {
    super("User Operation expired.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the `validAfter` or `validUntil` values returned from `validateUserOp` on the Smart Account are not satisfied"
      ].filter(Boolean),
      name: "UserOperationExpiredError"
    });
  }
}
Object.defineProperty(UserOperationExpiredError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa22/
});
class UserOperationPaymasterExpiredError extends BaseError$1 {
  constructor({ cause }) {
    super("Paymaster for User Operation expired.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the `validAfter` or `validUntil` values returned from `validatePaymasterUserOp` on the Paymaster are not satisfied"
      ].filter(Boolean),
      name: "UserOperationPaymasterExpiredError"
    });
  }
}
Object.defineProperty(UserOperationPaymasterExpiredError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa32/
});
class UserOperationSignatureError extends BaseError$1 {
  constructor({ cause }) {
    super("Signature provided for the User Operation is invalid.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the `signature` for the User Operation is incorrectly computed, and unable to be verified by the Smart Account"
      ].filter(Boolean),
      name: "UserOperationSignatureError"
    });
  }
}
Object.defineProperty(UserOperationSignatureError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa24/
});
class UserOperationPaymasterSignatureError extends BaseError$1 {
  constructor({ cause }) {
    super("Signature provided for the User Operation is invalid.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the `signature` for the User Operation is incorrectly computed, and unable to be verified by the Paymaster"
      ].filter(Boolean),
      name: "UserOperationPaymasterSignatureError"
    });
  }
}
Object.defineProperty(UserOperationPaymasterSignatureError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa34/
});
class UserOperationRejectedByEntryPointError extends BaseError$1 {
  constructor({ cause }) {
    super("User Operation rejected by EntryPoint's `simulateValidation` during account creation or validation.", {
      cause,
      name: "UserOperationRejectedByEntryPointError"
    });
  }
}
Object.defineProperty(UserOperationRejectedByEntryPointError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32500
});
class UserOperationRejectedByPaymasterError extends BaseError$1 {
  constructor({ cause }) {
    super("User Operation rejected by Paymaster's `validatePaymasterUserOp`.", {
      cause,
      name: "UserOperationRejectedByPaymasterError"
    });
  }
}
Object.defineProperty(UserOperationRejectedByPaymasterError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32501
});
class UserOperationRejectedByOpCodeError extends BaseError$1 {
  constructor({ cause }) {
    super("User Operation rejected with op code validation error.", {
      cause,
      name: "UserOperationRejectedByOpCodeError"
    });
  }
}
Object.defineProperty(UserOperationRejectedByOpCodeError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32502
});
class UserOperationOutOfTimeRangeError extends BaseError$1 {
  constructor({ cause }) {
    super("UserOperation out of time-range: either wallet or paymaster returned a time-range, and it is already expired (or will expire soon).", {
      cause,
      name: "UserOperationOutOfTimeRangeError"
    });
  }
}
Object.defineProperty(UserOperationOutOfTimeRangeError, "code", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: -32503
});
class UnknownBundlerError extends BaseError$1 {
  constructor({ cause }) {
    super(`An error occurred while executing user operation: ${cause == null ? void 0 : cause.shortMessage}`, {
      cause,
      name: "UnknownBundlerError"
    });
  }
}
class VerificationGasLimitExceededError extends BaseError$1 {
  constructor({ cause }) {
    super("User Operation verification gas limit exceeded.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the gas used for verification exceeded the `verificationGasLimit`"
      ].filter(Boolean),
      name: "VerificationGasLimitExceededError"
    });
  }
}
Object.defineProperty(VerificationGasLimitExceededError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa40/
});
class VerificationGasLimitTooLowError extends BaseError$1 {
  constructor({ cause }) {
    super("User Operation verification gas limit is too low.", {
      cause,
      metaMessages: [
        "This could arise when:",
        "- the `verificationGasLimit` is too low to verify the User Operation"
      ].filter(Boolean),
      name: "VerificationGasLimitTooLowError"
    });
  }
}
Object.defineProperty(VerificationGasLimitTooLowError, "message", {
  enumerable: true,
  configurable: true,
  writable: true,
  value: /aa41/
});
class UserOperationExecutionError extends BaseError$1 {
  constructor(cause, { callData, callGasLimit, docsPath, factory, factoryData, initCode, maxFeePerGas, maxPriorityFeePerGas, nonce, paymaster, paymasterAndData, paymasterData, paymasterPostOpGasLimit, paymasterVerificationGasLimit, preVerificationGas, sender, signature, verificationGasLimit }) {
    const prettyArgs = prettyPrint({
      callData,
      callGasLimit,
      factory,
      factoryData,
      initCode,
      maxFeePerGas: typeof maxFeePerGas !== "undefined" && `${formatGwei(maxFeePerGas)} gwei`,
      maxPriorityFeePerGas: typeof maxPriorityFeePerGas !== "undefined" && `${formatGwei(maxPriorityFeePerGas)} gwei`,
      nonce,
      paymaster,
      paymasterAndData,
      paymasterData,
      paymasterPostOpGasLimit,
      paymasterVerificationGasLimit,
      preVerificationGas,
      sender,
      signature,
      verificationGasLimit
    });
    super(cause.shortMessage, {
      cause,
      docsPath,
      metaMessages: [
        ...cause.metaMessages ? [...cause.metaMessages, " "] : [],
        "Request Arguments:",
        prettyArgs
      ].filter(Boolean),
      name: "UserOperationExecutionError"
    });
    Object.defineProperty(this, "cause", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    this.cause = cause;
  }
}
class UserOperationReceiptNotFoundError extends BaseError$1 {
  constructor({ hash }) {
    super(`User Operation receipt with hash "${hash}" could not be found. The User Operation may not have been processed yet.`, { name: "UserOperationReceiptNotFoundError" });
  }
}
class UserOperationNotFoundError extends BaseError$1 {
  constructor({ hash }) {
    super(`User Operation with hash "${hash}" could not be found.`, {
      name: "UserOperationNotFoundError"
    });
  }
}
class WaitForUserOperationReceiptTimeoutError extends BaseError$1 {
  constructor({ hash }) {
    super(`Timed out while waiting for User Operation with hash "${hash}" to be confirmed.`, { name: "WaitForUserOperationReceiptTimeoutError" });
  }
}
const bundlerErrors = [
  ExecutionRevertedError,
  InvalidFieldsError,
  PaymasterDepositTooLowError,
  PaymasterRateLimitError,
  PaymasterStakeTooLowError,
  SignatureCheckFailedError,
  UnsupportedSignatureAggregatorError,
  UserOperationOutOfTimeRangeError,
  UserOperationRejectedByEntryPointError,
  UserOperationRejectedByPaymasterError,
  UserOperationRejectedByOpCodeError
];
function getBundlerError(err, args) {
  const message = (err.details || "").toLowerCase();
  if (AccountNotDeployedError.message.test(message))
    return new AccountNotDeployedError({
      cause: err
    });
  if (FailedToSendToBeneficiaryError.message.test(message))
    return new FailedToSendToBeneficiaryError({
      cause: err
    });
  if (GasValuesOverflowError.message.test(message))
    return new GasValuesOverflowError({
      cause: err
    });
  if (HandleOpsOutOfGasError.message.test(message))
    return new HandleOpsOutOfGasError({
      cause: err
    });
  if (InitCodeFailedError.message.test(message))
    return new InitCodeFailedError({
      cause: err,
      factory: args.factory,
      factoryData: args.factoryData,
      initCode: args.initCode
    });
  if (InitCodeMustCreateSenderError.message.test(message))
    return new InitCodeMustCreateSenderError({
      cause: err,
      factory: args.factory,
      factoryData: args.factoryData,
      initCode: args.initCode
    });
  if (InitCodeMustReturnSenderError.message.test(message))
    return new InitCodeMustReturnSenderError({
      cause: err,
      factory: args.factory,
      factoryData: args.factoryData,
      initCode: args.initCode,
      sender: args.sender
    });
  if (InsufficientPrefundError.message.test(message))
    return new InsufficientPrefundError({
      cause: err
    });
  if (InternalCallOnlyError.message.test(message))
    return new InternalCallOnlyError({
      cause: err
    });
  if (InvalidAccountNonceError.message.test(message))
    return new InvalidAccountNonceError({
      cause: err,
      nonce: args.nonce
    });
  if (InvalidAggregatorError.message.test(message))
    return new InvalidAggregatorError({
      cause: err
    });
  if (InvalidBeneficiaryError.message.test(message))
    return new InvalidBeneficiaryError({
      cause: err
    });
  if (InvalidPaymasterAndDataError.message.test(message))
    return new InvalidPaymasterAndDataError({
      cause: err
    });
  if (PaymasterDepositTooLowError.message.test(message))
    return new PaymasterDepositTooLowError({
      cause: err
    });
  if (PaymasterFunctionRevertedError.message.test(message))
    return new PaymasterFunctionRevertedError({
      cause: err
    });
  if (PaymasterNotDeployedError.message.test(message))
    return new PaymasterNotDeployedError({
      cause: err
    });
  if (PaymasterPostOpFunctionRevertedError.message.test(message))
    return new PaymasterPostOpFunctionRevertedError({
      cause: err
    });
  if (SmartAccountFunctionRevertedError.message.test(message))
    return new SmartAccountFunctionRevertedError({
      cause: err
    });
  if (SenderAlreadyConstructedError.message.test(message))
    return new SenderAlreadyConstructedError({
      cause: err,
      factory: args.factory,
      factoryData: args.factoryData,
      initCode: args.initCode
    });
  if (UserOperationExpiredError.message.test(message))
    return new UserOperationExpiredError({
      cause: err
    });
  if (UserOperationPaymasterExpiredError.message.test(message))
    return new UserOperationPaymasterExpiredError({
      cause: err
    });
  if (UserOperationPaymasterSignatureError.message.test(message))
    return new UserOperationPaymasterSignatureError({
      cause: err
    });
  if (UserOperationSignatureError.message.test(message))
    return new UserOperationSignatureError({
      cause: err
    });
  if (VerificationGasLimitExceededError.message.test(message))
    return new VerificationGasLimitExceededError({
      cause: err
    });
  if (VerificationGasLimitTooLowError.message.test(message))
    return new VerificationGasLimitTooLowError({
      cause: err
    });
  const error = err.walk((e2) => bundlerErrors.some((error2) => error2.code === e2.code));
  if (error) {
    if (error.code === ExecutionRevertedError.code)
      return new ExecutionRevertedError({
        cause: err,
        data: error.data,
        message: error.details
      });
    if (error.code === InvalidFieldsError.code)
      return new InvalidFieldsError({
        cause: err
      });
    if (error.code === PaymasterDepositTooLowError.code)
      return new PaymasterDepositTooLowError({
        cause: err
      });
    if (error.code === PaymasterRateLimitError.code)
      return new PaymasterRateLimitError({
        cause: err
      });
    if (error.code === PaymasterStakeTooLowError.code)
      return new PaymasterStakeTooLowError({
        cause: err
      });
    if (error.code === SignatureCheckFailedError.code)
      return new SignatureCheckFailedError({
        cause: err
      });
    if (error.code === UnsupportedSignatureAggregatorError.code)
      return new UnsupportedSignatureAggregatorError({
        cause: err
      });
    if (error.code === UserOperationOutOfTimeRangeError.code)
      return new UserOperationOutOfTimeRangeError({
        cause: err
      });
    if (error.code === UserOperationRejectedByEntryPointError.code)
      return new UserOperationRejectedByEntryPointError({
        cause: err
      });
    if (error.code === UserOperationRejectedByPaymasterError.code)
      return new UserOperationRejectedByPaymasterError({
        cause: err
      });
    if (error.code === UserOperationRejectedByOpCodeError.code)
      return new UserOperationRejectedByOpCodeError({
        cause: err
      });
  }
  return new UnknownBundlerError({
    cause: err
  });
}
function getUserOperationError(err, { calls, docsPath, ...args }) {
  const cause = (() => {
    const cause2 = getBundlerError(err, args);
    if (calls && cause2 instanceof ExecutionRevertedError) {
      const revertData = getRevertData(cause2);
      const contractCalls = calls == null ? void 0 : calls.filter((call) => call.abi);
      if (revertData && contractCalls.length > 0)
        return getContractError({ calls: contractCalls, revertData });
    }
    return cause2;
  })();
  return new UserOperationExecutionError(cause, {
    docsPath,
    ...args
  });
}
function getRevertData(error) {
  let revertData;
  error.walk((e2) => {
    var _a, _b, _c, _d;
    const error2 = e2;
    if (typeof error2.data === "string" || typeof ((_a = error2.data) == null ? void 0 : _a.revertData) === "string" || !(error2 instanceof BaseError$1) && typeof error2.message === "string") {
      const match = (_d = (_c = ((_b = error2.data) == null ? void 0 : _b.revertData) || error2.data || error2.message).match) == null ? void 0 : _d.call(_c, /(0x[A-Za-z0-9]*)/);
      if (match) {
        revertData = match[1];
        return true;
      }
    }
    return false;
  });
  return revertData;
}
function getContractError(parameters) {
  const { calls, revertData } = parameters;
  const { abi: abi2, functionName, args, to } = (() => {
    const contractCalls = calls == null ? void 0 : calls.filter((call) => Boolean(call.abi));
    if (contractCalls.length === 1)
      return contractCalls[0];
    const compatContractCalls = contractCalls.filter((call) => {
      try {
        return Boolean(decodeErrorResult({
          abi: call.abi,
          data: revertData
        }));
      } catch {
        return false;
      }
    });
    if (compatContractCalls.length === 1)
      return compatContractCalls[0];
    return {
      abi: [],
      functionName: contractCalls.reduce((acc, call) => `${acc ? `${acc} | ` : ""}${call.functionName}`, ""),
      args: void 0,
      to: void 0
    };
  })();
  const cause = (() => {
    if (revertData === "0x")
      return new ContractFunctionZeroDataError({ functionName });
    return new ContractFunctionRevertedError({
      abi: abi2,
      data: revertData,
      functionName
    });
  })();
  return new ContractFunctionExecutionError(cause, {
    abi: abi2,
    args,
    contractAddress: to,
    functionName
  });
}
function formatUserOperationGas(parameters) {
  const gas = {};
  if (parameters.callGasLimit)
    gas.callGasLimit = BigInt(parameters.callGasLimit);
  if (parameters.preVerificationGas)
    gas.preVerificationGas = BigInt(parameters.preVerificationGas);
  if (parameters.verificationGasLimit)
    gas.verificationGasLimit = BigInt(parameters.verificationGasLimit);
  if (parameters.paymasterPostOpGasLimit)
    gas.paymasterPostOpGasLimit = BigInt(parameters.paymasterPostOpGasLimit);
  if (parameters.paymasterVerificationGasLimit)
    gas.paymasterVerificationGasLimit = BigInt(parameters.paymasterVerificationGasLimit);
  return gas;
}
function formatUserOperationRequest(request) {
  const rpcRequest = {};
  if (typeof request.callData !== "undefined")
    rpcRequest.callData = request.callData;
  if (typeof request.callGasLimit !== "undefined")
    rpcRequest.callGasLimit = numberToHex(request.callGasLimit);
  if (typeof request.factory !== "undefined")
    rpcRequest.factory = request.factory;
  if (typeof request.factoryData !== "undefined")
    rpcRequest.factoryData = request.factoryData;
  if (typeof request.initCode !== "undefined")
    rpcRequest.initCode = request.initCode;
  if (typeof request.maxFeePerGas !== "undefined")
    rpcRequest.maxFeePerGas = numberToHex(request.maxFeePerGas);
  if (typeof request.maxPriorityFeePerGas !== "undefined")
    rpcRequest.maxPriorityFeePerGas = numberToHex(request.maxPriorityFeePerGas);
  if (typeof request.nonce !== "undefined")
    rpcRequest.nonce = numberToHex(request.nonce);
  if (typeof request.paymaster !== "undefined")
    rpcRequest.paymaster = request.paymaster;
  if (typeof request.paymasterAndData !== "undefined")
    rpcRequest.paymasterAndData = request.paymasterAndData || "0x";
  if (typeof request.paymasterData !== "undefined")
    rpcRequest.paymasterData = request.paymasterData;
  if (typeof request.paymasterPostOpGasLimit !== "undefined")
    rpcRequest.paymasterPostOpGasLimit = numberToHex(request.paymasterPostOpGasLimit);
  if (typeof request.paymasterSignature !== "undefined")
    rpcRequest.paymasterSignature = request.paymasterSignature;
  if (typeof request.paymasterVerificationGasLimit !== "undefined")
    rpcRequest.paymasterVerificationGasLimit = numberToHex(request.paymasterVerificationGasLimit);
  if (typeof request.preVerificationGas !== "undefined")
    rpcRequest.preVerificationGas = numberToHex(request.preVerificationGas);
  if (typeof request.sender !== "undefined")
    rpcRequest.sender = request.sender;
  if (typeof request.signature !== "undefined")
    rpcRequest.signature = request.signature;
  if (typeof request.verificationGasLimit !== "undefined")
    rpcRequest.verificationGasLimit = numberToHex(request.verificationGasLimit);
  if (typeof request.authorization !== "undefined")
    rpcRequest.eip7702Auth = formatAuthorization(request.authorization);
  return rpcRequest;
}
function formatAuthorization(authorization) {
  return {
    address: authorization.address,
    chainId: numberToHex(authorization.chainId),
    nonce: numberToHex(authorization.nonce),
    r: authorization.r ? numberToHex(BigInt(authorization.r), { size: 32 }) : pad$1("0x", { size: 32 }),
    s: authorization.s ? numberToHex(BigInt(authorization.s), { size: 32 }) : pad$1("0x", { size: 32 }),
    yParity: authorization.yParity ? numberToHex(authorization.yParity, { size: 1 }) : pad$1("0x", { size: 32 })
  };
}
async function getPaymasterData(client, parameters) {
  const { chainId, entryPointAddress, context, ...userOperation } = parameters;
  const request = formatUserOperationRequest(userOperation);
  const { paymasterPostOpGasLimit, paymasterVerificationGasLimit, ...rest } = await client.request({
    method: "pm_getPaymasterData",
    params: [
      {
        ...request,
        callGasLimit: request.callGasLimit ?? "0x0",
        verificationGasLimit: request.verificationGasLimit ?? "0x0",
        preVerificationGas: request.preVerificationGas ?? "0x0"
      },
      entryPointAddress,
      numberToHex(chainId),
      context
    ]
  });
  return {
    ...rest,
    ...paymasterPostOpGasLimit && {
      paymasterPostOpGasLimit: hexToBigInt(paymasterPostOpGasLimit)
    },
    ...paymasterVerificationGasLimit && {
      paymasterVerificationGasLimit: hexToBigInt(paymasterVerificationGasLimit)
    }
  };
}
async function getPaymasterStubData(client, parameters) {
  const { chainId, entryPointAddress, context, ...userOperation } = parameters;
  const request = formatUserOperationRequest(userOperation);
  const { paymasterPostOpGasLimit, paymasterVerificationGasLimit, ...rest } = await client.request({
    method: "pm_getPaymasterStubData",
    params: [
      {
        ...request,
        callGasLimit: request.callGasLimit ?? "0x0",
        verificationGasLimit: request.verificationGasLimit ?? "0x0",
        preVerificationGas: request.preVerificationGas ?? "0x0"
      },
      entryPointAddress,
      numberToHex(chainId),
      context
    ]
  });
  return {
    ...rest,
    ...paymasterPostOpGasLimit && {
      paymasterPostOpGasLimit: hexToBigInt(paymasterPostOpGasLimit)
    },
    ...paymasterVerificationGasLimit && {
      paymasterVerificationGasLimit: hexToBigInt(paymasterVerificationGasLimit)
    }
  };
}
const defaultParameters = [
  "factory",
  "fees",
  "gas",
  "paymaster",
  "nonce",
  "signature",
  "authorization"
];
async function prepareUserOperation(client, parameters_) {
  var _a, _b;
  const parameters = parameters_;
  const { account: account_ = client.account, dataSuffix = typeof client.dataSuffix === "string" ? client.dataSuffix : (_a = client.dataSuffix) == null ? void 0 : _a.value, parameters: properties = defaultParameters, stateOverride } = parameters;
  if (!account_)
    throw new AccountNotFoundError();
  const account2 = parseAccount(account_);
  const bundlerClient = client;
  const paymaster = parameters.paymaster ?? (bundlerClient == null ? void 0 : bundlerClient.paymaster);
  const paymasterAddress = typeof paymaster === "string" ? paymaster : void 0;
  const { getPaymasterStubData: getPaymasterStubData$1, getPaymasterData: getPaymasterData$1 } = (() => {
    if (paymaster === true)
      return {
        getPaymasterStubData: (parameters2) => getAction(bundlerClient, getPaymasterStubData, "getPaymasterStubData")(parameters2),
        getPaymasterData: (parameters2) => getAction(bundlerClient, getPaymasterData, "getPaymasterData")(parameters2)
      };
    if (typeof paymaster === "object") {
      const { getPaymasterStubData: getPaymasterStubData2, getPaymasterData: getPaymasterData2 } = paymaster;
      return {
        getPaymasterStubData: getPaymasterData2 && getPaymasterStubData2 ? getPaymasterStubData2 : getPaymasterData2,
        getPaymasterData: getPaymasterData2 && getPaymasterStubData2 ? getPaymasterData2 : void 0
      };
    }
    return {
      getPaymasterStubData: void 0,
      getPaymasterData: void 0
    };
  })();
  const paymasterContext = parameters.paymasterContext ? parameters.paymasterContext : bundlerClient == null ? void 0 : bundlerClient.paymasterContext;
  let request = {
    ...parameters,
    paymaster: paymasterAddress,
    sender: account2.address
  };
  const [callData, factory, fees, nonce, authorization] = await Promise.all([
    (async () => {
      if (parameters.calls)
        return account2.encodeCalls(parameters.calls.map((call_) => {
          const call = call_;
          if (call.abi)
            return {
              data: encodeFunctionData(call),
              to: call.to,
              value: call.value
            };
          return call;
        }));
      return parameters.callData;
    })(),
    (async () => {
      if (!properties.includes("factory"))
        return void 0;
      if (parameters.initCode)
        return { initCode: parameters.initCode };
      if (parameters.factory && parameters.factoryData) {
        return {
          factory: parameters.factory,
          factoryData: parameters.factoryData
        };
      }
      const { factory: factory2, factoryData } = await account2.getFactoryArgs();
      if (account2.entryPoint.version === "0.6")
        return {
          initCode: factory2 && factoryData ? concat$1([factory2, factoryData]) : void 0
        };
      return {
        factory: factory2,
        factoryData
      };
    })(),
    (async () => {
      var _a2;
      if (!properties.includes("fees"))
        return void 0;
      if (typeof parameters.maxFeePerGas === "bigint" && typeof parameters.maxPriorityFeePerGas === "bigint")
        return request;
      if ((_a2 = bundlerClient == null ? void 0 : bundlerClient.userOperation) == null ? void 0 : _a2.estimateFeesPerGas) {
        const fees2 = await bundlerClient.userOperation.estimateFeesPerGas({
          account: account2,
          bundlerClient,
          userOperation: request
        });
        return {
          ...request,
          ...fees2
        };
      }
      try {
        const client_ = bundlerClient.client ?? client;
        const fees2 = await getAction(client_, estimateFeesPerGas, "estimateFeesPerGas")({
          chain: client_.chain,
          type: "eip1559"
        });
        return {
          maxFeePerGas: typeof parameters.maxFeePerGas === "bigint" ? parameters.maxFeePerGas : BigInt(
            // Bundlers unfortunately have strict rules on fee prechecks – we will need to set a generous buffer.
            2n * fees2.maxFeePerGas
          ),
          maxPriorityFeePerGas: typeof parameters.maxPriorityFeePerGas === "bigint" ? parameters.maxPriorityFeePerGas : BigInt(
            // Bundlers unfortunately have strict rules on fee prechecks – we will need to set a generous buffer.
            2n * fees2.maxPriorityFeePerGas
          )
        };
      } catch {
        return void 0;
      }
    })(),
    (async () => {
      if (!properties.includes("nonce"))
        return void 0;
      if (typeof parameters.nonce === "bigint")
        return parameters.nonce;
      return account2.getNonce();
    })(),
    (async () => {
      if (!properties.includes("authorization"))
        return void 0;
      if (typeof parameters.authorization === "object")
        return parameters.authorization;
      if (account2.authorization && !await account2.isDeployed()) {
        const authorization2 = await prepareAuthorization(account2.client, account2.authorization);
        return {
          ...authorization2,
          r: "0xfffffffffffffffffffffffffffffff000000000000000000000000000000000",
          s: "0x7aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
          yParity: 1
        };
      }
      return void 0;
    })()
  ]);
  if (typeof callData !== "undefined")
    request.callData = dataSuffix ? concat$1([callData, dataSuffix]) : callData;
  if (typeof factory !== "undefined")
    request = { ...request, ...factory };
  if (typeof fees !== "undefined")
    request = { ...request, ...fees };
  if (typeof nonce !== "undefined")
    request.nonce = nonce;
  if (typeof authorization !== "undefined")
    request.authorization = authorization;
  if (properties.includes("signature")) {
    if (typeof parameters.signature !== "undefined")
      request.signature = parameters.signature;
    else
      request.signature = await account2.getStubSignature(request);
  }
  if (account2.entryPoint.version === "0.6" && !request.initCode)
    request.initCode = "0x";
  let chainId;
  async function getChainId$1() {
    if (chainId)
      return chainId;
    if (client.chain)
      return client.chain.id;
    const chainId_ = await getAction(client, getChainId, "getChainId")({});
    chainId = chainId_;
    return chainId;
  }
  let isPaymasterPopulated = false;
  if (properties.includes("paymaster") && getPaymasterStubData$1 && !paymasterAddress && !parameters.paymasterAndData) {
    const { isFinal = false, sponsor: _2, ...paymasterArgs } = await getPaymasterStubData$1({
      chainId: await getChainId$1(),
      entryPointAddress: account2.entryPoint.address,
      context: paymasterContext,
      ...request
    });
    isPaymasterPopulated = isFinal;
    request = {
      ...request,
      ...paymasterArgs
    };
  }
  if (account2.entryPoint.version === "0.6" && !request.paymasterAndData)
    request.paymasterAndData = "0x";
  if (properties.includes("gas")) {
    if ((_b = account2.userOperation) == null ? void 0 : _b.estimateGas) {
      const gas = await account2.userOperation.estimateGas(request);
      request = {
        ...request,
        ...gas
      };
    }
    if (typeof request.callGasLimit === "undefined" || typeof request.preVerificationGas === "undefined" || typeof request.verificationGasLimit === "undefined" || request.paymaster && typeof request.paymasterPostOpGasLimit === "undefined" || request.paymaster && typeof request.paymasterVerificationGasLimit === "undefined") {
      const gas = await getAction(bundlerClient, estimateUserOperationGas, "estimateUserOperationGas")({
        account: account2,
        // Some Bundlers fail if nullish gas values are provided for gas estimation :') –
        // so we will need to set a default zeroish value.
        callGasLimit: 0n,
        preVerificationGas: 0n,
        verificationGasLimit: 0n,
        stateOverride,
        ...request.paymaster ? {
          paymasterPostOpGasLimit: 0n,
          paymasterVerificationGasLimit: 0n
        } : {},
        ...request
      });
      request = {
        ...request,
        callGasLimit: request.callGasLimit ?? gas.callGasLimit,
        preVerificationGas: request.preVerificationGas ?? gas.preVerificationGas,
        verificationGasLimit: request.verificationGasLimit ?? gas.verificationGasLimit,
        paymasterPostOpGasLimit: request.paymasterPostOpGasLimit ?? gas.paymasterPostOpGasLimit,
        paymasterVerificationGasLimit: request.paymasterVerificationGasLimit ?? gas.paymasterVerificationGasLimit
      };
    }
  }
  if (properties.includes("paymaster") && getPaymasterData$1 && !paymasterAddress && !parameters.paymasterAndData && !isPaymasterPopulated) {
    const paymaster2 = await getPaymasterData$1({
      chainId: await getChainId$1(),
      entryPointAddress: account2.entryPoint.address,
      context: paymasterContext,
      ...request
    });
    request = {
      ...request,
      ...paymaster2
    };
  }
  delete request.calls;
  delete request.parameters;
  delete request.paymasterContext;
  if (typeof request.paymaster !== "string")
    delete request.paymaster;
  return request;
}
async function estimateUserOperationGas(client, parameters) {
  var _a;
  const { account: account_ = client.account, entryPointAddress, stateOverride } = parameters;
  if (!account_ && !parameters.sender)
    throw new AccountNotFoundError();
  const account2 = account_ ? parseAccount(account_) : void 0;
  const rpcStateOverride = serializeStateOverride(stateOverride);
  const request = account2 ? await getAction(client, prepareUserOperation, "prepareUserOperation")({
    ...parameters,
    parameters: [
      "authorization",
      "factory",
      "nonce",
      "paymaster",
      "signature"
    ]
  }) : parameters;
  try {
    const params = [
      formatUserOperationRequest(request),
      entryPointAddress ?? ((_a = account2 == null ? void 0 : account2.entryPoint) == null ? void 0 : _a.address)
    ];
    const result = await client.request({
      method: "eth_estimateUserOperationGas",
      params: rpcStateOverride ? [...params, rpcStateOverride] : [...params]
    });
    return formatUserOperationGas(result);
  } catch (error) {
    const calls = parameters.calls;
    throw getUserOperationError(error, {
      ...request,
      ...calls ? { calls } : {}
    });
  }
}
function getSupportedEntryPoints(client) {
  return client.request({ method: "eth_supportedEntryPoints" });
}
function formatUserOperation(parameters) {
  const userOperation = { ...parameters };
  if (parameters.callGasLimit)
    userOperation.callGasLimit = BigInt(parameters.callGasLimit);
  if (parameters.maxFeePerGas)
    userOperation.maxFeePerGas = BigInt(parameters.maxFeePerGas);
  if (parameters.maxPriorityFeePerGas)
    userOperation.maxPriorityFeePerGas = BigInt(parameters.maxPriorityFeePerGas);
  if (parameters.nonce)
    userOperation.nonce = BigInt(parameters.nonce);
  if (parameters.paymasterPostOpGasLimit)
    userOperation.paymasterPostOpGasLimit = BigInt(parameters.paymasterPostOpGasLimit);
  if (parameters.paymasterVerificationGasLimit)
    userOperation.paymasterVerificationGasLimit = BigInt(parameters.paymasterVerificationGasLimit);
  if (parameters.preVerificationGas)
    userOperation.preVerificationGas = BigInt(parameters.preVerificationGas);
  if (parameters.verificationGasLimit)
    userOperation.verificationGasLimit = BigInt(parameters.verificationGasLimit);
  return userOperation;
}
async function getUserOperation(client, { hash }) {
  const result = await client.request({
    method: "eth_getUserOperationByHash",
    params: [hash]
  }, { dedupe: true });
  if (!result)
    throw new UserOperationNotFoundError({ hash });
  const { blockHash, blockNumber, entryPoint, transactionHash, userOperation } = result;
  return {
    blockHash,
    blockNumber: BigInt(blockNumber),
    entryPoint,
    transactionHash,
    userOperation: formatUserOperation(userOperation)
  };
}
function formatUserOperationReceipt(parameters) {
  const receipt = { ...parameters };
  if (parameters.actualGasCost)
    receipt.actualGasCost = BigInt(parameters.actualGasCost);
  if (parameters.actualGasUsed)
    receipt.actualGasUsed = BigInt(parameters.actualGasUsed);
  if (parameters.logs)
    receipt.logs = parameters.logs.map((log) => formatLog(log));
  if (parameters.receipt)
    receipt.receipt = formatTransactionReceipt(receipt.receipt);
  return receipt;
}
async function getUserOperationReceipt(client, { hash }) {
  const receipt = await client.request({
    method: "eth_getUserOperationReceipt",
    params: [hash]
  }, { dedupe: true });
  if (!receipt)
    throw new UserOperationReceiptNotFoundError({ hash });
  return formatUserOperationReceipt(receipt);
}
async function sendUserOperation(client, parameters) {
  var _a, _b;
  const { account: account_ = client.account, entryPointAddress } = parameters;
  if (!account_ && !parameters.sender)
    throw new AccountNotFoundError();
  const account2 = account_ ? parseAccount(account_) : void 0;
  const request = account2 ? await getAction(client, prepareUserOperation, "prepareUserOperation")(parameters) : parameters;
  const signature = parameters.signature || await ((_a = account2 == null ? void 0 : account2.signUserOperation) == null ? void 0 : _a.call(account2, request));
  const rpcParameters = formatUserOperationRequest({
    ...request,
    signature
  });
  try {
    return await client.request({
      method: "eth_sendUserOperation",
      params: [
        rpcParameters,
        entryPointAddress ?? ((_b = account2 == null ? void 0 : account2.entryPoint) == null ? void 0 : _b.address)
      ]
    }, { retryCount: 0 });
  } catch (error) {
    const calls = parameters.calls;
    throw getUserOperationError(error, {
      ...request,
      ...calls ? { calls } : {},
      signature
    });
  }
}
function waitForUserOperationReceipt(client, parameters) {
  const { hash, pollingInterval = client.pollingInterval, retryCount, timeout = 12e4 } = parameters;
  let count = 0;
  const observerId = stringify$1([
    "waitForUserOperationReceipt",
    client.uid,
    hash
  ]);
  return new Promise((resolve, reject) => {
    const unobserve = observe(observerId, { resolve, reject }, (emit) => {
      const done = (fn) => {
        unpoll();
        fn();
        unobserve();
      };
      const timeoutId = timeout ? setTimeout(() => done(() => emit.reject(new WaitForUserOperationReceiptTimeoutError({ hash }))), timeout) : void 0;
      const unpoll = poll(async () => {
        if (retryCount && count >= retryCount) {
          clearTimeout(timeoutId);
          done(() => emit.reject(new WaitForUserOperationReceiptTimeoutError({ hash })));
        }
        try {
          const receipt = await getAction(client, getUserOperationReceipt, "getUserOperationReceipt")({ hash });
          clearTimeout(timeoutId);
          done(() => emit.resolve(receipt));
        } catch (err) {
          const error = err;
          if (error.name !== "UserOperationReceiptNotFoundError") {
            clearTimeout(timeoutId);
            done(() => emit.reject(error));
          }
        }
        count++;
      }, {
        emitOnBegin: true,
        interval: pollingInterval
      });
      return unpoll;
    });
  });
}
function bundlerActions(client) {
  return {
    estimateUserOperationGas: (parameters) => estimateUserOperationGas(client, parameters),
    getChainId: () => getChainId(client),
    getSupportedEntryPoints: () => getSupportedEntryPoints(client),
    getUserOperation: (parameters) => getUserOperation(client, parameters),
    getUserOperationReceipt: (parameters) => getUserOperationReceipt(client, parameters),
    prepareUserOperation: (parameters) => prepareUserOperation(client, parameters),
    sendUserOperation: (parameters) => sendUserOperation(client, parameters),
    waitForUserOperationReceipt: (parameters) => waitForUserOperationReceipt(client, parameters)
  };
}
function createBundlerClient(parameters) {
  const { client: client_, dataSuffix, key = "bundler", name: name2 = "Bundler Client", paymaster, paymasterContext, transport, userOperation } = parameters;
  const client = Object.assign(createClient({
    ...parameters,
    chain: parameters.chain ?? (client_ == null ? void 0 : client_.chain),
    key,
    name: name2,
    transport,
    type: "bundlerClient"
  }), {
    client: client_,
    dataSuffix: dataSuffix ?? (client_ == null ? void 0 : client_.dataSuffix),
    paymaster,
    paymasterContext,
    userOperation
  });
  return client.extend(bundlerActions);
}
const ChainClients = createStore$1(() => ({}));
function createClients(chains2) {
  chains2.forEach((c2) => {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    if (!c2.rpcUrl) {
      return;
    }
    const viemchain = defineChain({
      id: c2.id,
      rpcUrls: {
        default: {
          http: [c2.rpcUrl]
        }
      },
      name: (_b = (_a = c2.nativeCurrency) === null || _a === void 0 ? void 0 : _a.name) !== null && _b !== void 0 ? _b : "",
      nativeCurrency: {
        name: (_d = (_c = c2.nativeCurrency) === null || _c === void 0 ? void 0 : _c.name) !== null && _d !== void 0 ? _d : "",
        symbol: (_f = (_e = c2.nativeCurrency) === null || _e === void 0 ? void 0 : _e.symbol) !== null && _f !== void 0 ? _f : "",
        decimals: (_h = (_g = c2.nativeCurrency) === null || _g === void 0 ? void 0 : _g.decimal) !== null && _h !== void 0 ? _h : 18
      }
    });
    const client = createPublicClient({
      chain: viemchain,
      transport: http(c2.rpcUrl)
    });
    const bundlerClient = createBundlerClient({
      client,
      transport: http(c2.rpcUrl)
    });
    ChainClients.setState({
      [c2.id]: {
        client,
        bundlerClient
      }
    });
  });
}
function getClient(chainId) {
  var _a;
  return (_a = ChainClients.getState()[chainId]) === null || _a === void 0 ? void 0 : _a.client;
}
const correlationIdsStore = createStore$1(() => ({
  correlationIds: /* @__PURE__ */ new Map()
}));
const correlationIds = {
  get: (key) => {
    const correlationId = correlationIdsStore.getState().correlationIds.get(key);
    return correlationId;
  },
  set: (key, correlationId) => {
    correlationIdsStore.setState((state) => {
      const newMap = new Map(state.correlationIds);
      newMap.set(key, correlationId);
      return { correlationIds: newMap };
    });
  },
  delete: (key) => {
    correlationIdsStore.setState((state) => {
      const newMap = new Map(state.correlationIds);
      newMap.delete(key);
      return { correlationIds: newMap };
    });
  },
  clear: () => {
    correlationIdsStore.setState({
      correlationIds: /* @__PURE__ */ new Map()
    });
  }
};
function assertSubAccount(info) {
  if (typeof info !== "object" || info === null) {
    throw standardErrors.rpc.internal("sub account info is not an object");
  }
  if (!("address" in info)) {
    throw standardErrors.rpc.internal("sub account is invalid");
  }
  if ("address" in info && typeof info.address === "string" && !isAddress(info.address)) {
    throw standardErrors.rpc.internal("sub account address is invalid");
  }
  if ("factory" in info && typeof info.factory === "string" && !isAddress(info.factory)) {
    throw standardErrors.rpc.internal("sub account factory address is invalid");
  }
  if ("factoryData" in info && typeof info.factoryData === "string" && !isHex(info.factoryData)) {
    throw standardErrors.rpc.internal("sub account factory data is invalid");
  }
}
async function generateKeyPair$1() {
  return crypto.subtle.generateKey({
    name: "ECDH",
    namedCurve: "P-256"
  }, true, ["deriveKey"]);
}
async function deriveSharedSecret(ownPrivateKey, peerPublicKey) {
  return crypto.subtle.deriveKey({
    name: "ECDH",
    public: peerPublicKey
  }, ownPrivateKey, {
    name: "AES-GCM",
    length: 256
  }, false, ["encrypt", "decrypt"]);
}
async function encrypt(sharedSecret, plainText) {
  const iv = crypto.getRandomValues(new Uint8Array(12));
  const cipherText = await crypto.subtle.encrypt({
    name: "AES-GCM",
    iv
  }, sharedSecret, new TextEncoder().encode(plainText));
  return { iv, cipherText };
}
async function decrypt(sharedSecret, { iv, cipherText }) {
  const plainText = await crypto.subtle.decrypt({
    name: "AES-GCM",
    iv
  }, sharedSecret, cipherText);
  return new TextDecoder().decode(plainText);
}
function getFormat(keyType) {
  switch (keyType) {
    case "public":
      return "spki";
    case "private":
      return "pkcs8";
  }
}
async function exportKeyToHexString(type, key) {
  const format = getFormat(type);
  const exported = await crypto.subtle.exportKey(format, key);
  return uint8ArrayToHex(new Uint8Array(exported));
}
async function importKeyFromHexString(type, hexString) {
  const format = getFormat(type);
  const arrayBuffer = hexStringToUint8Array(hexString).buffer;
  return await crypto.subtle.importKey(format, new Uint8Array(arrayBuffer), {
    name: "ECDH",
    namedCurve: "P-256"
  }, true, type === "private" ? ["deriveKey"] : []);
}
async function encryptContent(content, sharedSecret) {
  const serialized = JSON.stringify(content, (_2, value) => {
    if (!(value instanceof Error))
      return value;
    const error = value;
    return Object.assign(Object.assign({}, error.code ? { code: error.code } : {}), { message: error.message });
  });
  return encrypt(sharedSecret, serialized);
}
async function decryptContent(encryptedData, sharedSecret) {
  return JSON.parse(await decrypt(sharedSecret, encryptedData));
}
async function fetchRPCRequest(request, rpcUrl) {
  const requestBody = Object.assign(Object.assign({}, request), { jsonrpc: "2.0", id: crypto.randomUUID() });
  const res = await window.fetch(rpcUrl, {
    method: "POST",
    body: JSON.stringify(requestBody),
    mode: "cors",
    headers: {
      "Content-Type": "application/json",
      "X-Cbw-Sdk-Version": PACKAGE_VERSION,
      "X-Cbw-Sdk-Platform": PACKAGE_NAME
    }
  });
  const { result, error } = await res.json();
  if (error)
    throw error;
  return result;
}
function checkErrorForInvalidRequestArgs(args) {
  if (!args || typeof args !== "object" || Array.isArray(args)) {
    throw standardErrors.rpc.invalidParams({
      message: "Expected a single, non-array, object argument.",
      data: args
    });
  }
  const { method, params } = args;
  if (typeof method !== "string" || method.length === 0) {
    throw standardErrors.rpc.invalidParams({
      message: "'args.method' must be a non-empty string.",
      data: args
    });
  }
  if (params !== void 0 && !Array.isArray(params) && (typeof params !== "object" || params === null)) {
    throw standardErrors.rpc.invalidParams({
      message: "'args.params' must be an object or array if provided.",
      data: args
    });
  }
  switch (method) {
    case "eth_sign":
    case "eth_signTypedData_v2":
    case "eth_subscribe":
    case "eth_unsubscribe":
      throw standardErrors.provider.unsupportedMethod();
  }
}
const version = "0.1.1";
function getVersion() {
  return version;
}
class BaseError extends Error {
  constructor(shortMessage, options = {}) {
    const details = (() => {
      var _a;
      if (options.cause instanceof BaseError) {
        if (options.cause.details)
          return options.cause.details;
        if (options.cause.shortMessage)
          return options.cause.shortMessage;
      }
      if ((_a = options.cause) == null ? void 0 : _a.message)
        return options.cause.message;
      return options.details;
    })();
    const docsPath = (() => {
      if (options.cause instanceof BaseError)
        return options.cause.docsPath || options.docsPath;
      return options.docsPath;
    })();
    const docsBaseUrl = "https://oxlib.sh";
    const docs = `${docsBaseUrl}${docsPath ?? ""}`;
    const message = [
      shortMessage || "An error occurred.",
      ...options.metaMessages ? ["", ...options.metaMessages] : [],
      ...details || docsPath ? [
        "",
        details ? `Details: ${details}` : void 0,
        docsPath ? `See: ${docs}` : void 0
      ] : []
    ].filter((x2) => typeof x2 === "string").join("\n");
    super(message, options.cause ? { cause: options.cause } : void 0);
    Object.defineProperty(this, "details", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    Object.defineProperty(this, "docs", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    Object.defineProperty(this, "docsPath", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    Object.defineProperty(this, "shortMessage", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    Object.defineProperty(this, "cause", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: void 0
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "BaseError"
    });
    Object.defineProperty(this, "version", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: `ox@${getVersion()}`
    });
    this.cause = options.cause;
    this.details = details;
    this.docs = docs;
    this.docsPath = docsPath;
    this.shortMessage = shortMessage;
  }
  walk(fn) {
    return walk(this, fn);
  }
}
function walk(err, fn) {
  if (fn == null ? void 0 : fn(err))
    return err;
  if (err && typeof err === "object" && "cause" in err && err.cause)
    return walk(err.cause, fn);
  return fn ? null : err;
}
const bigIntSuffix = "#__bigint";
function stringify(value, replacer, space) {
  return JSON.stringify(value, (key, value2) => {
    if (typeof value2 === "bigint")
      return value2.toString() + bigIntSuffix;
    return value2;
  }, space);
}
function assertSize$1(bytes, size_) {
  if (size(bytes) > size_)
    throw new SizeOverflowError2({
      givenSize: size(bytes),
      maxSize: size_
    });
}
function assertStartOffset$1(value, start) {
  if (typeof start === "number" && start > 0 && start > size(value) - 1)
    throw new SliceOffsetOutOfBoundsError2({
      offset: start,
      position: "start",
      size: size(value)
    });
}
function assertEndOffset$1(value, start, end) {
  if (typeof start === "number" && typeof end === "number" && size(value) !== end - start) {
    throw new SliceOffsetOutOfBoundsError2({
      offset: end,
      position: "end",
      size: size(value)
    });
  }
}
const charCodeMap = {
  zero: 48,
  nine: 57,
  A: 65,
  F: 70,
  a: 97,
  f: 102
};
function charCodeToBase16(char) {
  if (char >= charCodeMap.zero && char <= charCodeMap.nine)
    return char - charCodeMap.zero;
  if (char >= charCodeMap.A && char <= charCodeMap.F)
    return char - (charCodeMap.A - 10);
  if (char >= charCodeMap.a && char <= charCodeMap.f)
    return char - (charCodeMap.a - 10);
  return void 0;
}
function assertSize(hex, size_) {
  if (size$1(hex) > size_)
    throw new SizeOverflowError$1({
      givenSize: size$1(hex),
      maxSize: size_
    });
}
function assertStartOffset(value, start) {
  if (typeof start === "number" && start > 0 && start > size$1(value) - 1)
    throw new SliceOffsetOutOfBoundsError$1({
      offset: start,
      position: "start",
      size: size$1(value)
    });
}
function assertEndOffset(value, start, end) {
  if (typeof start === "number" && typeof end === "number" && size$1(value) !== end - start) {
    throw new SliceOffsetOutOfBoundsError$1({
      offset: end,
      position: "end",
      size: size$1(value)
    });
  }
}
function pad(hex_, options = {}) {
  const { dir, size: size2 = 32 } = options;
  if (size2 === 0)
    return hex_;
  const hex = hex_.replace("0x", "");
  if (hex.length > size2 * 2)
    throw new SizeExceedsPaddingSizeError({
      size: Math.ceil(hex.length / 2),
      targetSize: size2,
      type: "Hex"
    });
  return `0x${hex[dir === "right" ? "padEnd" : "padStart"](size2 * 2, "0")}`;
}
const encoder = /* @__PURE__ */ new TextEncoder();
const hexes = /* @__PURE__ */ Array.from({ length: 256 }, (_v, i2) => i2.toString(16).padStart(2, "0"));
function assert$3(value, options = {}) {
  const { strict = false } = options;
  if (!value)
    throw new InvalidHexTypeError(value);
  if (typeof value !== "string")
    throw new InvalidHexTypeError(value);
  if (strict) {
    if (!/^0x[0-9a-fA-F]*$/.test(value))
      throw new InvalidHexValueError(value);
  }
  if (!value.startsWith("0x"))
    throw new InvalidHexValueError(value);
}
function concat(...values) {
  return `0x${values.reduce((acc, x2) => acc + x2.replace("0x", ""), "")}`;
}
function from$2(value) {
  if (value instanceof Uint8Array)
    return fromBytes$2(value);
  if (Array.isArray(value))
    return fromBytes$2(new Uint8Array(value));
  return value;
}
function fromBytes$2(value, options = {}) {
  let string = "";
  for (let i2 = 0; i2 < value.length; i2++)
    string += hexes[value[i2]];
  const hex = `0x${string}`;
  if (typeof options.size === "number") {
    assertSize(hex, options.size);
    return padRight(hex, options.size);
  }
  return hex;
}
function fromNumber(value, options = {}) {
  const { signed, size: size2 } = options;
  const value_ = BigInt(value);
  let maxValue;
  if (size2) {
    if (signed)
      maxValue = (1n << BigInt(size2) * 8n - 1n) - 1n;
    else
      maxValue = 2n ** (BigInt(size2) * 8n) - 1n;
  } else if (typeof value === "number") {
    maxValue = BigInt(Number.MAX_SAFE_INTEGER);
  }
  const minValue = typeof maxValue === "bigint" && signed ? -maxValue - 1n : 0;
  if (maxValue && value_ > maxValue || value_ < minValue) {
    const suffix = typeof value === "bigint" ? "n" : "";
    throw new IntegerOutOfRangeError({
      max: maxValue ? `${maxValue}${suffix}` : void 0,
      min: `${minValue}${suffix}`,
      signed,
      size: size2,
      value: `${value}${suffix}`
    });
  }
  const stringValue = (signed && value_ < 0 ? (1n << BigInt(size2 * 8)) + BigInt(value_) : value_).toString(16);
  const hex = `0x${stringValue}`;
  if (size2)
    return padLeft(hex, size2);
  return hex;
}
function fromString(value, options = {}) {
  return fromBytes$2(encoder.encode(value), options);
}
function padLeft(value, size2) {
  return pad(value, { dir: "left", size: size2 });
}
function padRight(value, size2) {
  return pad(value, { dir: "right", size: size2 });
}
function slice$1(value, start, end, options = {}) {
  const { strict } = options;
  assertStartOffset(value, start);
  const value_ = `0x${value.replace("0x", "").slice((start ?? 0) * 2, (end ?? value.length) * 2)}`;
  if (strict)
    assertEndOffset(value_, start, end);
  return value_;
}
function size$1(value) {
  return Math.ceil((value.length - 2) / 2);
}
function toBigInt$1(hex, options = {}) {
  const { signed } = options;
  if (options.size)
    assertSize(hex, options.size);
  const value = BigInt(hex);
  if (!signed)
    return value;
  const size2 = (hex.length - 2) / 2;
  const max_unsigned = (1n << BigInt(size2) * 8n) - 1n;
  const max_signed = max_unsigned >> 1n;
  if (value <= max_signed)
    return value;
  return value - max_unsigned - 1n;
}
function validate$1(value, options = {}) {
  const { strict = false } = options;
  try {
    assert$3(value, { strict });
    return true;
  } catch {
    return false;
  }
}
class IntegerOutOfRangeError extends BaseError {
  constructor({ max, min, signed, size: size2, value }) {
    super(`Number \`${value}\` is not in safe${size2 ? ` ${size2 * 8}-bit` : ""}${signed ? " signed" : " unsigned"} integer range ${max ? `(\`${min}\` to \`${max}\`)` : `(above \`${min}\`)`}`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Hex.IntegerOutOfRangeError"
    });
  }
}
class InvalidHexTypeError extends BaseError {
  constructor(value) {
    super(`Value \`${typeof value === "object" ? stringify(value) : value}\` of type \`${typeof value}\` is an invalid hex type.`, {
      metaMessages: ['Hex types must be represented as `"0x${string}"`.']
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Hex.InvalidHexTypeError"
    });
  }
}
class InvalidHexValueError extends BaseError {
  constructor(value) {
    super(`Value \`${value}\` is an invalid hex value.`, {
      metaMessages: [
        'Hex values must start with `"0x"` and contain only hexadecimal characters (0-9, a-f, A-F).'
      ]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Hex.InvalidHexValueError"
    });
  }
}
let SizeOverflowError$1 = class SizeOverflowError extends BaseError {
  constructor({ givenSize, maxSize }) {
    super(`Size cannot exceed \`${maxSize}\` bytes. Given size: \`${givenSize}\` bytes.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Hex.SizeOverflowError"
    });
  }
};
let SliceOffsetOutOfBoundsError$1 = class SliceOffsetOutOfBoundsError extends BaseError {
  constructor({ offset, position, size: size2 }) {
    super(`Slice ${position === "start" ? "starting" : "ending"} at offset \`${offset}\` is out-of-bounds (size: \`${size2}\`).`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Hex.SliceOffsetOutOfBoundsError"
    });
  }
};
class SizeExceedsPaddingSizeError extends BaseError {
  constructor({ size: size2, targetSize, type }) {
    super(`${type.charAt(0).toUpperCase()}${type.slice(1).toLowerCase()} size (\`${size2}\`) exceeds padding size (\`${targetSize}\`).`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Hex.SizeExceedsPaddingSizeError"
    });
  }
}
function assert$2(value) {
  if (value instanceof Uint8Array)
    return;
  if (!value)
    throw new InvalidBytesTypeError(value);
  if (typeof value !== "object")
    throw new InvalidBytesTypeError(value);
  if (!("BYTES_PER_ELEMENT" in value))
    throw new InvalidBytesTypeError(value);
  if (value.BYTES_PER_ELEMENT !== 1 || value.constructor.name !== "Uint8Array")
    throw new InvalidBytesTypeError(value);
}
function from$1(value) {
  if (value instanceof Uint8Array)
    return value;
  if (typeof value === "string")
    return fromHex$3(value);
  return fromArray(value);
}
function fromArray(value) {
  return value instanceof Uint8Array ? value : new Uint8Array(value);
}
function fromHex$3(value, options = {}) {
  const { size: size2 } = options;
  let hex = value;
  if (size2) {
    assertSize(value, size2);
    hex = padRight(value, size2);
  }
  let hexString = hex.slice(2);
  if (hexString.length % 2)
    hexString = `0${hexString}`;
  const length = hexString.length / 2;
  const bytes = new Uint8Array(length);
  for (let index = 0, j2 = 0; index < length; index++) {
    const nibbleLeft = charCodeToBase16(hexString.charCodeAt(j2++));
    const nibbleRight = charCodeToBase16(hexString.charCodeAt(j2++));
    if (nibbleLeft === void 0 || nibbleRight === void 0) {
      throw new BaseError(`Invalid byte sequence ("${hexString[j2 - 2]}${hexString[j2 - 1]}" in "${hexString}").`);
    }
    bytes[index] = nibbleLeft * 16 + nibbleRight;
  }
  return bytes;
}
function size(value) {
  return value.length;
}
function slice(value, start, end, options = {}) {
  const { strict } = options;
  assertStartOffset$1(value, start);
  const value_ = value.slice(start, end);
  if (strict)
    assertEndOffset$1(value_, start, end);
  return value_;
}
function toBigInt(bytes, options = {}) {
  const { size: size2 } = options;
  if (typeof size2 !== "undefined")
    assertSize$1(bytes, size2);
  const hex = fromBytes$2(bytes, options);
  return toBigInt$1(hex, options);
}
function validate(value) {
  try {
    assert$2(value);
    return true;
  } catch {
    return false;
  }
}
class InvalidBytesTypeError extends BaseError {
  constructor(value) {
    super(`Value \`${typeof value === "object" ? stringify(value) : value}\` of type \`${typeof value}\` is an invalid Bytes value.`, {
      metaMessages: ["Bytes values must be of type `Bytes`."]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Bytes.InvalidBytesTypeError"
    });
  }
}
class SizeOverflowError2 extends BaseError {
  constructor({ givenSize, maxSize }) {
    super(`Size cannot exceed \`${maxSize}\` bytes. Given size: \`${givenSize}\` bytes.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Bytes.SizeOverflowError"
    });
  }
}
class SliceOffsetOutOfBoundsError2 extends BaseError {
  constructor({ offset, position, size: size2 }) {
    super(`Slice ${position === "start" ? "starting" : "ending"} at offset \`${offset}\` is out-of-bounds (size: \`${size2}\`).`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Bytes.SliceOffsetOutOfBoundsError"
    });
  }
}
function sha256(value, options = {}) {
  const { as = typeof value === "string" ? "Hex" : "Bytes" } = options;
  const bytes = sha256$1(from$1(value));
  if (as === "Bytes")
    return bytes;
  return fromBytes$2(bytes);
}
function assert$1(publicKey, options = {}) {
  const { compressed } = options;
  const { prefix, x: x2, y: y2 } = publicKey;
  if (compressed === false || typeof x2 === "bigint" && typeof y2 === "bigint") {
    if (prefix !== 4)
      throw new InvalidPrefixError({
        prefix,
        cause: new InvalidUncompressedPrefixError()
      });
    return;
  }
  if (compressed === true || typeof x2 === "bigint" && typeof y2 === "undefined") {
    if (prefix !== 3 && prefix !== 2)
      throw new InvalidPrefixError({
        prefix,
        cause: new InvalidCompressedPrefixError()
      });
    return;
  }
  throw new InvalidError({ publicKey });
}
function from(value) {
  const publicKey = (() => {
    if (validate$1(value))
      return fromHex$2(value);
    if (validate(value))
      return fromBytes$1(value);
    const { prefix, x: x2, y: y2 } = value;
    if (typeof x2 === "bigint" && typeof y2 === "bigint")
      return { prefix: prefix ?? 4, x: x2, y: y2 };
    return { prefix, x: x2 };
  })();
  assert$1(publicKey);
  return publicKey;
}
function fromBytes$1(publicKey) {
  return fromHex$2(fromBytes$2(publicKey));
}
function fromHex$2(publicKey) {
  if (publicKey.length !== 132 && publicKey.length !== 130 && publicKey.length !== 68)
    throw new InvalidSerializedSizeError$1({ publicKey });
  if (publicKey.length === 130) {
    const x3 = BigInt(slice$1(publicKey, 0, 32));
    const y2 = BigInt(slice$1(publicKey, 32, 64));
    return {
      prefix: 4,
      x: x3,
      y: y2
    };
  }
  if (publicKey.length === 132) {
    const prefix2 = Number(slice$1(publicKey, 0, 1));
    const x3 = BigInt(slice$1(publicKey, 1, 33));
    const y2 = BigInt(slice$1(publicKey, 33, 65));
    return {
      prefix: prefix2,
      x: x3,
      y: y2
    };
  }
  const prefix = Number(slice$1(publicKey, 0, 1));
  const x2 = BigInt(slice$1(publicKey, 1, 33));
  return {
    prefix,
    x: x2
  };
}
function toHex$1(publicKey, options = {}) {
  assert$1(publicKey);
  const { prefix, x: x2, y: y2 } = publicKey;
  const { includePrefix = true } = options;
  const publicKey_ = concat(
    includePrefix ? fromNumber(prefix, { size: 1 }) : "0x",
    fromNumber(x2, { size: 32 }),
    // If the public key is not compressed, add the y coordinate.
    typeof y2 === "bigint" ? fromNumber(y2, { size: 32 }) : "0x"
  );
  return publicKey_;
}
class InvalidError extends BaseError {
  constructor({ publicKey }) {
    super(`Value \`${stringify(publicKey)}\` is not a valid public key.`, {
      metaMessages: [
        "Public key must contain:",
        "- an `x` and `prefix` value (compressed)",
        "- an `x`, `y`, and `prefix` value (uncompressed)"
      ]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidError"
    });
  }
}
class InvalidPrefixError extends BaseError {
  constructor({ prefix, cause }) {
    super(`Prefix "${prefix}" is invalid.`, {
      cause
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidPrefixError"
    });
  }
}
class InvalidCompressedPrefixError extends BaseError {
  constructor() {
    super("Prefix must be 2 or 3 for compressed public keys.");
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidCompressedPrefixError"
    });
  }
}
class InvalidUncompressedPrefixError extends BaseError {
  constructor() {
    super("Prefix must be 4 for uncompressed public keys.");
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidUncompressedPrefixError"
    });
  }
}
let InvalidSerializedSizeError$1 = class InvalidSerializedSizeError extends BaseError {
  constructor({ publicKey }) {
    super(`Value \`${publicKey}\` is an invalid public key size.`, {
      metaMessages: [
        "Expected: 33 bytes (compressed + prefix), 64 bytes (uncompressed) or 65 bytes (uncompressed + prefix).",
        `Received ${size$1(from$2(publicKey))} bytes.`
      ]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "PublicKey.InvalidSerializedSizeError"
    });
  }
};
const maxUint256 = 2n ** 256n - 1n;
function assert(signature, options = {}) {
  const { recovered } = options;
  if (typeof signature.r === "undefined")
    throw new MissingPropertiesError({ signature });
  if (typeof signature.s === "undefined")
    throw new MissingPropertiesError({ signature });
  if (recovered && typeof signature.yParity === "undefined")
    throw new MissingPropertiesError({ signature });
  if (signature.r < 0n || signature.r > maxUint256)
    throw new InvalidRError({ value: signature.r });
  if (signature.s < 0n || signature.s > maxUint256)
    throw new InvalidSError({ value: signature.s });
  if (typeof signature.yParity === "number" && signature.yParity !== 0 && signature.yParity !== 1)
    throw new InvalidYParityError({ value: signature.yParity });
}
function fromHex$1(signature) {
  if (signature.length !== 130 && signature.length !== 132)
    throw new InvalidSerializedSizeError2({ signature });
  const r2 = BigInt(slice$1(signature, 0, 32));
  const s2 = BigInt(slice$1(signature, 32, 64));
  const yParity = (() => {
    const yParity2 = Number(`0x${signature.slice(130)}`);
    if (Number.isNaN(yParity2))
      return void 0;
    try {
      return vToYParity(yParity2);
    } catch {
      throw new InvalidYParityError({ value: yParity2 });
    }
  })();
  if (typeof yParity === "undefined")
    return {
      r: r2,
      s: s2
    };
  return {
    r: r2,
    s: s2,
    yParity
  };
}
function toHex(signature) {
  assert(signature);
  const r2 = signature.r;
  const s2 = signature.s;
  const signature_ = concat(
    fromNumber(r2, { size: 32 }),
    fromNumber(s2, { size: 32 }),
    // If the signature is recovered, add the recovery byte to the signature.
    typeof signature.yParity === "number" ? fromNumber(yParityToV(signature.yParity), { size: 1 }) : "0x"
  );
  return signature_;
}
function vToYParity(v2) {
  if (v2 === 0 || v2 === 27)
    return 0;
  if (v2 === 1 || v2 === 28)
    return 1;
  if (v2 >= 35)
    return v2 % 2 === 0 ? 1 : 0;
  throw new InvalidVError({ value: v2 });
}
function yParityToV(yParity) {
  if (yParity === 0)
    return 27;
  if (yParity === 1)
    return 28;
  throw new InvalidYParityError({ value: yParity });
}
class InvalidSerializedSizeError2 extends BaseError {
  constructor({ signature }) {
    super(`Value \`${signature}\` is an invalid signature size.`, {
      metaMessages: [
        "Expected: 64 bytes or 65 bytes.",
        `Received ${size$1(from$2(signature))} bytes.`
      ]
    });
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidSerializedSizeError"
    });
  }
}
class MissingPropertiesError extends BaseError {
  constructor({ signature }) {
    super(`Signature \`${stringify(signature)}\` is missing either an \`r\`, \`s\`, or \`yParity\` property.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.MissingPropertiesError"
    });
  }
}
class InvalidRError extends BaseError {
  constructor({ value }) {
    super(`Value \`${value}\` is an invalid r value. r must be a positive integer less than 2^256.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidRError"
    });
  }
}
class InvalidSError extends BaseError {
  constructor({ value }) {
    super(`Value \`${value}\` is an invalid s value. s must be a positive integer less than 2^256.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidSError"
    });
  }
}
class InvalidYParityError extends BaseError {
  constructor({ value }) {
    super(`Value \`${value}\` is an invalid y-parity value. Y-parity must be 0 or 1.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidYParityError"
    });
  }
}
class InvalidVError extends BaseError {
  constructor({ value }) {
    super(`Value \`${value}\` is an invalid v value. v must be 27, 28 or >=35.`);
    Object.defineProperty(this, "name", {
      enumerable: true,
      configurable: true,
      writable: true,
      value: "Signature.InvalidVError"
    });
  }
}
const decoder = /* @__PURE__ */ new TextDecoder();
const integerToCharacter = /* @__PURE__ */ Object.fromEntries(Array.from("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/").map((a2, i2) => [i2, a2.charCodeAt(0)]));
({
  ...Object.fromEntries(Array.from("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/").map((a2, i2) => [a2.charCodeAt(0), i2]))
});
function fromBytes(value, options = {}) {
  const { pad: pad2 = true, url = false } = options;
  const encoded = new Uint8Array(Math.ceil(value.length / 3) * 4);
  for (let i2 = 0, j2 = 0; j2 < value.length; i2 += 4, j2 += 3) {
    const y2 = (value[j2] << 16) + (value[j2 + 1] << 8) + (value[j2 + 2] | 0);
    encoded[i2] = integerToCharacter[y2 >> 18];
    encoded[i2 + 1] = integerToCharacter[y2 >> 12 & 63];
    encoded[i2 + 2] = integerToCharacter[y2 >> 6 & 63];
    encoded[i2 + 3] = integerToCharacter[y2 & 63];
  }
  const k2 = value.length % 3;
  const end = Math.floor(value.length / 3) * 4 + (k2 && k2 + 1);
  let base64 = decoder.decode(new Uint8Array(encoded.buffer, 0, end));
  if (pad2 && k2 === 1)
    base64 += "==";
  if (pad2 && k2 === 2)
    base64 += "=";
  if (url)
    base64 = base64.replaceAll("+", "-").replaceAll("/", "_");
  return base64;
}
function fromHex(value, options = {}) {
  return fromBytes(fromHex$3(value), options);
}
/*! noble-curves - MIT License (c) 2022 Paul Miller (paulmillr.com) */
const p256_CURVE = {
  p: BigInt("0xffffffff00000001000000000000000000000000ffffffffffffffffffffffff"),
  n: BigInt("0xffffffff00000000ffffffffffffffffbce6faada7179e84f3b9cac2fc632551"),
  h: BigInt(1),
  a: BigInt("0xffffffff00000001000000000000000000000000fffffffffffffffffffffffc"),
  b: BigInt("0x5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b"),
  Gx: BigInt("0x6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296"),
  Gy: BigInt("0x4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5")
};
const p384_CURVE = {
  p: BigInt("0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff"),
  n: BigInt("0xffffffffffffffffffffffffffffffffffffffffffffffffc7634d81f4372ddf581a0db248b0a77aecec196accc52973"),
  h: BigInt(1),
  a: BigInt("0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000fffffffc"),
  b: BigInt("0xb3312fa7e23ee7e4988e056be3f82d19181d9c6efe8141120314088f5013875ac656398d8a2ed19d2a85c8edd3ec2aef"),
  Gx: BigInt("0xaa87ca22be8b05378eb1c71ef320ad746e1d3b628ba79b9859f741e082542a385502f25dbf55296c3a545e3872760ab7"),
  Gy: BigInt("0x3617de4a96262c6f5d9e98bf9292dc29f8f41dbd289a147ce9da3113b5f0b8c00a60b1ce1d7e819d7a431d7c90ea0e5f")
};
const p521_CURVE = {
  p: BigInt("0x1ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff"),
  n: BigInt("0x01fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffa51868783bf2f966b7fcc0148f709a5d03bb5c9b8899c47aebb6fb71e91386409"),
  h: BigInt(1),
  a: BigInt("0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffc"),
  b: BigInt("0x0051953eb9618e1c9a1f929a21a0b68540eea2da725b99b315f3b8b489918ef109e156193951ec7e937b1652c0bd3bb1bf073573df883d2c34f1ef451fd46b503f00"),
  Gx: BigInt("0x00c6858e06b70404e9cd9e3ecb662395b4429c648139053fb521f828af606b4d3dbaa14b5e77efe75928fe1dc127a2ffa8de3348b3c1856a429bf97e7e31c2e5bd66"),
  Gy: BigInt("0x011839296a789a3bc0045c8a5fb42c7d1bd998f54449579b446817afbd17273e662c97ee72995ef42640c550b9013fad0761353c7086a272c24088be94769fd16650")
};
const Fp256 = Field(p256_CURVE.p);
const Fp384 = Field(p384_CURVE.p);
const Fp521 = Field(p521_CURVE.p);
const p256$1 = createCurve({ ...p256_CURVE, Fp: Fp256, lowS: false }, sha256$2);
createCurve({ ...p384_CURVE, Fp: Fp384, lowS: false }, sha384);
createCurve({ ...p521_CURVE, Fp: Fp521, lowS: false, allowedPrivateKeyLengths: [130, 131, 132] }, sha512);
/*! noble-curves - MIT License (c) 2022 Paul Miller (paulmillr.com) */
const p256 = p256$1;
Uint8Array.from([
  105,
  171,
  180,
  181,
  160,
  222,
  75,
  198,
  42,
  42,
  32,
  31,
  141,
  37,
  186,
  233
]);
function getAuthenticatorData(options = {}) {
  const { flag = 5, rpId = window.location.hostname, signCount = 0 } = options;
  const rpIdHash = sha256(fromString(rpId));
  const flag_bytes = fromNumber(flag, { size: 1 });
  const signCount_bytes = fromNumber(signCount, { size: 4 });
  return concat(rpIdHash, flag_bytes, signCount_bytes);
}
function getClientDataJSON(options) {
  const { challenge, crossOrigin = false, extraClientData, origin = window.location.origin } = options;
  return JSON.stringify({
    type: "webauthn.get",
    challenge: fromHex(challenge, { url: true, pad: false }),
    origin,
    crossOrigin,
    ...extraClientData
  });
}
function getSignPayload(options) {
  const { challenge, crossOrigin, extraClientData, flag, origin, rpId, signCount, userVerification = "required" } = options;
  const authenticatorData = getAuthenticatorData({
    flag,
    rpId,
    signCount
  });
  const clientDataJSON = getClientDataJSON({
    challenge,
    crossOrigin,
    extraClientData,
    origin
  });
  const clientDataJSONHash = sha256(fromString(clientDataJSON));
  const challengeIndex = clientDataJSON.indexOf('"challenge"');
  const typeIndex = clientDataJSON.indexOf('"type"');
  const metadata = {
    authenticatorData,
    clientDataJSON,
    challengeIndex,
    typeIndex,
    userVerificationRequired: userVerification === "required"
  };
  const payload = concat(authenticatorData, clientDataJSONHash);
  return { metadata, payload };
}
async function createKeyPair(options = {}) {
  const { extractable = false } = options;
  const keypair = await globalThis.crypto.subtle.generateKey({
    name: "ECDSA",
    namedCurve: "P-256"
  }, extractable, ["sign", "verify"]);
  const publicKey_raw = await globalThis.crypto.subtle.exportKey("raw", keypair.publicKey);
  const publicKey = from(new Uint8Array(publicKey_raw));
  return {
    privateKey: keypair.privateKey,
    publicKey
  };
}
async function sign$1(options) {
  const { payload, privateKey } = options;
  const signature = await globalThis.crypto.subtle.sign({
    name: "ECDSA",
    hash: "SHA-256"
  }, privateKey, from$1(payload));
  const signature_bytes = fromArray(new Uint8Array(signature));
  const r2 = toBigInt(slice(signature_bytes, 0, 32));
  let s2 = toBigInt(slice(signature_bytes, 32, 64));
  if (s2 > p256.CURVE.n / 2n)
    s2 = p256.CURVE.n - s2;
  return { r: r2, s: s2 };
}
function promisifyRequest(request) {
  return new Promise((resolve, reject) => {
    request.oncomplete = request.onsuccess = () => resolve(request.result);
    request.onabort = request.onerror = () => reject(request.error);
  });
}
function createStore(dbName, storeName) {
  const request = indexedDB.open(dbName);
  request.onupgradeneeded = () => request.result.createObjectStore(storeName);
  const dbp = promisifyRequest(request);
  return (txMode, callback) => dbp.then((db) => callback(db.transaction(storeName, txMode).objectStore(storeName)));
}
let defaultGetStoreFunc;
function defaultGetStore() {
  if (!defaultGetStoreFunc) {
    defaultGetStoreFunc = createStore("keyval-store", "keyval");
  }
  return defaultGetStoreFunc;
}
function get$1(key, customStore = defaultGetStore()) {
  return customStore("readonly", (store2) => promisifyRequest(store2.get(key)));
}
function set(key, value, customStore = defaultGetStore()) {
  return customStore("readwrite", (store2) => {
    store2.put(value, key);
    return promisifyRequest(store2.transaction);
  });
}
function del(key, customStore = defaultGetStore()) {
  return customStore("readwrite", (store2) => {
    store2.delete(key);
    return promisifyRequest(store2.transaction);
  });
}
function createStorage(scope, name2) {
  const store2 = typeof indexedDB !== "undefined" ? createStore(scope, name2) : void 0;
  return {
    getItem: async (key) => {
      const value = await get$1(key, store2);
      if (!value) {
        return null;
      }
      return value;
    },
    removeItem: async (key) => {
      return del(key, store2);
    },
    setItem: async (key, value) => {
      return set(key, value, store2);
    }
  };
}
const STORAGE_SCOPE = "base-acc-sdk";
const STORAGE_NAME = "keys";
const ACTIVE_ID_KEY = "activeId";
const storage = createStorage(STORAGE_SCOPE, STORAGE_NAME);
async function generateKeyPair() {
  const keypair = await createKeyPair({ extractable: false });
  const publicKey = slice$1(toHex$1(keypair.publicKey), 1);
  await storage.setItem(publicKey, keypair);
  await storage.setItem(ACTIVE_ID_KEY, publicKey);
  return keypair;
}
async function getKeypair() {
  const id = await storage.getItem(ACTIVE_ID_KEY);
  if (!id) {
    return null;
  }
  const keypair = await storage.getItem(id);
  if (!keypair) {
    return null;
  }
  return keypair;
}
async function getOrCreateKeypair() {
  const keypair = await getKeypair();
  if (!keypair) {
    const kp = await generateKeyPair();
    const pubKey = slice$1(toHex$1(kp.publicKey), 1);
    await storage.setItem(pubKey, kp);
    await storage.setItem(ACTIVE_ID_KEY, pubKey);
    return kp;
  }
  return keypair;
}
async function getAccount() {
  const keypair = await getOrCreateKeypair();
  const publicKey = slice$1(toHex$1(keypair.publicKey), 1);
  const sign2 = async (payload) => {
    const { payload: message, metadata } = getSignPayload({
      challenge: payload,
      origin: "https://keys.coinbase.com",
      userVerification: "preferred"
    });
    const signature = await sign$1({
      payload: message,
      privateKey: keypair.privateKey
    });
    return {
      signature: toHex(signature),
      raw: {},
      // type changed in viem
      webauthn: metadata
    };
  };
  return {
    id: publicKey,
    publicKey,
    async sign({ hash }) {
      return sign2(hash);
    },
    async signMessage({ message }) {
      return sign2(hashMessage(message));
    },
    async signTypedData(parameters) {
      return sign2(hashTypedData(parameters));
    },
    type: "webAuthn"
  };
}
async function getCryptoKeyAccount() {
  const account2 = await getAccount();
  return {
    account: account2
  };
}
async function removeCryptoKey() {
  const keypair = await getKeypair();
  if (!keypair) {
    return;
  }
  await storage.removeItem(slice$1(toHex$1(keypair.publicKey), 1));
  await storage.removeItem(ACTIVE_ID_KEY);
}
const OWN_PRIVATE_KEY = {
  storageKey: "ownPrivateKey",
  keyType: "private"
};
const OWN_PUBLIC_KEY = {
  storageKey: "ownPublicKey",
  keyType: "public"
};
const PEER_PUBLIC_KEY = {
  storageKey: "peerPublicKey",
  keyType: "public"
};
class SCWKeyManager {
  constructor() {
    this.ownPrivateKey = null;
    this.ownPublicKey = null;
    this.peerPublicKey = null;
    this.sharedSecret = null;
  }
  async getOwnPublicKey() {
    await this.loadKeysIfNeeded();
    return this.ownPublicKey;
  }
  // returns null if the shared secret is not yet derived
  async getSharedSecret() {
    await this.loadKeysIfNeeded();
    return this.sharedSecret;
  }
  async setPeerPublicKey(key) {
    this.sharedSecret = null;
    this.peerPublicKey = key;
    await this.storeKey(PEER_PUBLIC_KEY, key);
    await this.loadKeysIfNeeded();
  }
  async clear() {
    this.ownPrivateKey = null;
    this.ownPublicKey = null;
    this.peerPublicKey = null;
    this.sharedSecret = null;
    store.keys.clear();
  }
  async generateKeyPair() {
    const newKeyPair = await generateKeyPair$1();
    this.ownPrivateKey = newKeyPair.privateKey;
    this.ownPublicKey = newKeyPair.publicKey;
    await this.storeKey(OWN_PRIVATE_KEY, newKeyPair.privateKey);
    await this.storeKey(OWN_PUBLIC_KEY, newKeyPair.publicKey);
  }
  async loadKeysIfNeeded() {
    if (this.ownPrivateKey === null) {
      this.ownPrivateKey = await this.loadKey(OWN_PRIVATE_KEY);
    }
    if (this.ownPublicKey === null) {
      this.ownPublicKey = await this.loadKey(OWN_PUBLIC_KEY);
    }
    if (this.ownPrivateKey === null || this.ownPublicKey === null) {
      await this.generateKeyPair();
    }
    if (this.peerPublicKey === null) {
      this.peerPublicKey = await this.loadKey(PEER_PUBLIC_KEY);
    }
    if (this.sharedSecret === null) {
      if (this.ownPrivateKey === null || this.peerPublicKey === null)
        return;
      this.sharedSecret = await deriveSharedSecret(this.ownPrivateKey, this.peerPublicKey);
    }
  }
  // storage methods
  async loadKey(item) {
    const key = store.keys.get(item.storageKey);
    if (!key)
      return null;
    return importKeyFromHexString(item.keyType, key);
  }
  async storeKey(item, key) {
    const hexString = await exportKeyToHexString(item.keyType, key);
    store.keys.set(item.storageKey, hexString);
  }
}
function get(obj, path) {
  if (typeof obj !== "object" || obj === null)
    return void 0;
  return path.split(/[.[\]]+/).filter(Boolean).reduce((value, key) => {
    if (typeof value === "object" && value !== null) {
      return value[key];
    }
    return void 0;
  }, obj);
}
function getSenderFromRequest(request) {
  var _a;
  if (!Array.isArray(request.params)) {
    return null;
  }
  switch (request.method) {
    case "personal_sign":
      return request.params[1];
    case "eth_signTypedData_v4":
      return request.params[0];
    case "eth_signTransaction":
    case "eth_sendTransaction":
    case "wallet_sendCalls":
      return (_a = request.params[0]) === null || _a === void 0 ? void 0 : _a.from;
    default:
      return null;
  }
}
function addSenderToRequest(request, sender) {
  if (!Array.isArray(request.params)) {
    throw standardErrors.rpc.invalidParams();
  }
  const params = [...request.params];
  switch (request.method) {
    case "eth_signTransaction":
    case "eth_sendTransaction":
    case "wallet_sendCalls":
      params[0].from = sender;
      break;
    case "eth_signTypedData_v4":
      params[0] = sender;
      break;
    case "personal_sign":
      params[1] = sender;
      break;
  }
  return Object.assign(Object.assign({}, request), { params });
}
function assertParamsChainId(params) {
  var _a;
  if (!params || !Array.isArray(params) || !((_a = params[0]) === null || _a === void 0 ? void 0 : _a.chainId)) {
    throw standardErrors.rpc.invalidParams();
  }
  if (typeof params[0].chainId !== "string" && typeof params[0].chainId !== "number") {
    throw standardErrors.rpc.invalidParams();
  }
}
function assertGetCapabilitiesParams(params) {
  if (!params || !Array.isArray(params) || params.length !== 1 && params.length !== 2) {
    throw standardErrors.rpc.invalidParams();
  }
  if (typeof params[0] !== "string" || !isAddress(params[0])) {
    throw standardErrors.rpc.invalidParams();
  }
  if (params.length === 2) {
    if (!Array.isArray(params[1])) {
      throw standardErrors.rpc.invalidParams();
    }
    for (const param of params[1]) {
      if (typeof param !== "string" || !param.startsWith("0x")) {
        throw standardErrors.rpc.invalidParams();
      }
    }
  }
}
function injectRequestCapabilities(request, capabilities) {
  const modifiedRequest = Object.assign({}, request);
  if (capabilities && request.method.startsWith("wallet_")) {
    let requestCapabilities = get(modifiedRequest, "params.0.capabilities");
    if (typeof requestCapabilities === "undefined") {
      requestCapabilities = {};
    }
    if (typeof requestCapabilities !== "object") {
      throw standardErrors.rpc.invalidParams();
    }
    requestCapabilities = Object.assign(Object.assign({}, capabilities), requestCapabilities);
    if (modifiedRequest.params && Array.isArray(modifiedRequest.params)) {
      modifiedRequest.params[0] = Object.assign(Object.assign({}, modifiedRequest.params[0]), { capabilities: requestCapabilities });
    }
  }
  return modifiedRequest;
}
async function initSubAccountConfig() {
  var _a;
  const config2 = (_a = store.subAccountsConfig.get()) !== null && _a !== void 0 ? _a : {};
  const capabilities = {};
  if (config2.enableAutoSubAccounts) {
    const { account: owner } = config2.toOwnerAccount ? await config2.toOwnerAccount() : await getCryptoKeyAccount();
    if (!owner) {
      throw standardErrors.provider.unauthorized("No owner account found");
    }
    capabilities.addSubAccount = {
      account: {
        type: "create",
        keys: [
          {
            type: owner.address ? "address" : "webauthn-p256",
            publicKey: owner.address || owner.publicKey
          }
        ]
      }
    };
  }
  store.subAccountsConfig.set({
    capabilities
  });
}
function assertFetchPermissionsRequest(request) {
  if (request.method === "coinbase_fetchPermissions" && request.params === void 0) {
    return;
  }
  if (request.method === "coinbase_fetchPermissions" && Array.isArray(request.params) && request.params.length === 1 && typeof request.params[0] === "object") {
    if (typeof request.params[0].account !== "string" || !request.params[0].chainId.startsWith("0x")) {
      throw standardErrors.rpc.invalidParams("FetchPermissions - Invalid params: params[0].account must be a hex string");
    }
    if (typeof request.params[0].chainId !== "string" || !request.params[0].chainId.startsWith("0x")) {
      throw standardErrors.rpc.invalidParams("FetchPermissions - Invalid params: params[0].chainId must be a hex string");
    }
    if (typeof request.params[0].spender !== "string" || !request.params[0].spender.startsWith("0x")) {
      throw standardErrors.rpc.invalidParams("FetchPermissions - Invalid params: params[0].spender must be a hex string");
    }
    return;
  }
  throw standardErrors.rpc.invalidParams();
}
function fillMissingParamsForFetchPermissions(request) {
  var _a, _b, _c;
  if (request.params !== void 0) {
    return request;
  }
  const accountFromStore = (_a = store.getState().account.accounts) === null || _a === void 0 ? void 0 : _a[0];
  const chainId = (_b = store.getState().account.chain) === null || _b === void 0 ? void 0 : _b.id;
  const subAccountFromStore = (_c = store.getState().subAccount) === null || _c === void 0 ? void 0 : _c.address;
  if (!accountFromStore || !subAccountFromStore || !chainId) {
    throw standardErrors.rpc.invalidParams("FetchPermissions - one or more of account, sub account, or chain id is missing, connect to sub account via wallet_connect first");
  }
  return {
    method: "coinbase_fetchPermissions",
    params: [
      {
        account: accountFromStore,
        chainId: numberToHex(chainId),
        spender: subAccountFromStore
      }
    ]
  };
}
function createSpendPermissionMessage({ spendPermission, chainId }) {
  return {
    domain: {
      name: "Spend Permission Manager",
      version: "1",
      chainId,
      verifyingContract: spendPermissionManagerAddress
    },
    types: {
      SpendPermission: [
        { name: "account", type: "address" },
        { name: "spender", type: "address" },
        { name: "token", type: "address" },
        { name: "allowance", type: "uint160" },
        { name: "period", type: "uint48" },
        { name: "start", type: "uint48" },
        { name: "end", type: "uint48" },
        { name: "salt", type: "uint256" },
        { name: "extraData", type: "bytes" }
      ]
    },
    primaryType: "SpendPermission",
    message: {
      account: spendPermission.account,
      spender: spendPermission.spender,
      token: spendPermission.token,
      allowance: spendPermission.allowance,
      period: spendPermission.period,
      start: spendPermission.start,
      end: spendPermission.end,
      salt: spendPermission.salt,
      extraData: spendPermission.extraData
    }
  };
}
function createSpendPermissionBatchMessage({ spendPermissionBatch, chainId }) {
  return {
    domain: {
      name: "Spend Permission Manager",
      version: "1",
      chainId,
      verifyingContract: spendPermissionManagerAddress
    },
    types: {
      SpendPermissionBatch: [
        { name: "account", type: "address" },
        { name: "period", type: "uint48" },
        { name: "start", type: "uint48" },
        { name: "end", type: "uint48" },
        { name: "permissions", type: "PermissionDetails[]" }
      ],
      PermissionDetails: [
        { name: "spender", type: "address" },
        { name: "token", type: "address" },
        { name: "allowance", type: "uint160" },
        { name: "salt", type: "uint256" },
        { name: "extraData", type: "bytes" }
      ]
    },
    primaryType: "SpendPermissionBatch",
    message: {
      account: spendPermissionBatch.account,
      period: spendPermissionBatch.period,
      start: spendPermissionBatch.start,
      end: spendPermissionBatch.end,
      permissions: spendPermissionBatch.permissions.map((p2) => ({
        spender: p2.spender,
        token: p2.token,
        allowance: p2.allowance,
        salt: p2.salt,
        extraData: p2.extraData
      }))
    }
  };
}
async function waitForCallsTransactionHash({ client, id }) {
  var _a;
  const result = await waitForCallsStatus(client, {
    id
  });
  if (result.status === "success") {
    return (_a = result.receipts) === null || _a === void 0 ? void 0 : _a[0].transactionHash;
  }
  throw standardErrors.rpc.internal("failed to send transaction");
}
function createWalletSendCallsRequest({ calls, from: from2, chainId, capabilities }) {
  const paymasterUrls = config.get().paymasterUrls;
  let request = {
    method: "wallet_sendCalls",
    params: [
      {
        version: "1.0",
        calls,
        chainId: numberToHex(chainId),
        from: from2,
        atomicRequired: true,
        capabilities
      }
    ]
  };
  if (paymasterUrls === null || paymasterUrls === void 0 ? void 0 : paymasterUrls[chainId]) {
    request = injectRequestCapabilities(request, {
      paymasterService: { url: paymasterUrls === null || paymasterUrls === void 0 ? void 0 : paymasterUrls[chainId] }
    });
  }
  return request;
}
async function presentSubAccountFundingDialog() {
  const dialog2 = initDialog();
  const userChoice = await new Promise((resolve) => {
    logDialogShown({ dialogContext: "sub_account_insufficient_balance" });
    dialog2.presentItem({
      title: "Insufficient spend permission",
      message: "Your spend permission's remaining balance cannot cover this transaction. Please choose how to proceed:",
      onClose: () => {
        logDialogDismissed({ dialogContext: "sub_account_insufficient_balance" });
        dialog2.clear();
      },
      actionItems: [
        {
          text: "Edit spend permission",
          variant: "primary",
          onClick: () => {
            logDialogActionClicked({
              dialogContext: "sub_account_insufficient_balance",
              dialogAction: "create_permission"
            });
            dialog2.clear();
            resolve("update_permission");
          }
        },
        {
          text: "Use primary account",
          variant: "secondary",
          onClick: () => {
            logDialogActionClicked({
              dialogContext: "sub_account_insufficient_balance",
              dialogAction: "continue_in_popup"
            });
            dialog2.clear();
            resolve("continue_popup");
          }
        }
      ]
    });
  });
  return userChoice;
}
function parseFundingOptions({ errorData, sourceAddress }) {
  var _a;
  const spendPermissionRequests = [];
  for (const [token, { amount, sources }] of Object.entries((_a = errorData === null || errorData === void 0 ? void 0 : errorData.required) !== null && _a !== void 0 ? _a : {})) {
    const sourcesWithSufficientBalance = sources.filter((source) => {
      return hexToBigInt(source.balance) >= hexToBigInt(amount) && source.address.toLowerCase() === (sourceAddress === null || sourceAddress === void 0 ? void 0 : sourceAddress.toLowerCase());
    });
    if (sourcesWithSufficientBalance.length === 0) {
      throw new Error("Source address has insufficient balance for a token");
    }
    spendPermissionRequests.push({
      token,
      requiredAmount: hexToBigInt(amount)
    });
  }
  return spendPermissionRequests;
}
function isSendCallsParams(params) {
  return typeof params === "object" && params !== null && "calls" in params;
}
function isEthSendTransactionParams(params) {
  return Array.isArray(params) && params.length === 1 && typeof params[0] === "object" && params[0] !== null && "to" in params[0];
}
function compute16ByteHash(input) {
  return slice$2(keccak256(toHex$2(input)), 0, 16);
}
function makeDataSuffix({ attribution, dappOrigin }) {
  if (!attribution) {
    return;
  }
  if ("auto" in attribution && attribution.auto && dappOrigin) {
    return compute16ByteHash(dappOrigin);
  }
  if ("dataSuffix" in attribution) {
    return attribution.dataSuffix;
  }
  return;
}
function requestHasCapability(request, capabilityName) {
  var _a;
  if (!Array.isArray(request === null || request === void 0 ? void 0 : request.params))
    return false;
  const capabilities = (_a = request.params[0]) === null || _a === void 0 ? void 0 : _a.capabilities;
  if (!capabilities || typeof capabilities !== "object")
    return false;
  return capabilityName in capabilities;
}
function prependWithoutDuplicates(array, item) {
  const filtered = array.filter((i2) => i2 !== item);
  return [item, ...filtered];
}
function appendWithoutDuplicates(array, item) {
  const filtered = array.filter((i2) => i2 !== item);
  return [...filtered, item];
}
async function getCachedWalletConnectResponse() {
  const spendPermissions2 = store.spendPermissions.get();
  const subAccount = store.subAccounts.get();
  const accounts = store.account.get().accounts;
  if (!accounts) {
    return null;
  }
  const walletConnectAccounts = accounts === null || accounts === void 0 ? void 0 : accounts.map((account2) => ({
    address: account2,
    capabilities: {
      subAccounts: subAccount ? [subAccount] : void 0,
      spendPermissions: spendPermissions2.length > 0 ? { permissions: spendPermissions2 } : void 0
    }
  }));
  return {
    accounts: walletConnectAccounts
  };
}
function base64ToBase64Url(base64) {
  return base64.replaceAll("+", "-").replaceAll("/", "_").replace(/=+$/, "");
}
function arrayBufferToBase64Url(buffer) {
  const base64String = btoa(String.fromCharCode(...new Uint8Array(buffer)));
  return base64ToBase64Url(base64String);
}
function convertCredentialToJSON({ webauthn, signature, id }) {
  const signatureRaw = fromHex$1(signature);
  return {
    id,
    rawId: arrayBufferToBase64Url(stringToBytes(id)),
    response: {
      authenticatorData: arrayBufferToBase64Url(hexToBytes(webauthn.authenticatorData)),
      clientDataJSON: arrayBufferToBase64Url(stringToBytes(webauthn.clientDataJSON)),
      signature: arrayBufferToBase64Url(asn1EncodeSignature(signatureRaw.r, signatureRaw.s))
    },
    type: JSON.parse(webauthn.clientDataJSON).type
  };
}
function asn1EncodeSignature(r2, s2) {
  const rBytes = hexToBytes(trim(numberToHex(r2)));
  const sBytes = hexToBytes(trim(numberToHex(s2)));
  const rLength = rBytes.length;
  const sLength = sBytes.length;
  const totalLength = rLength + sLength + 4;
  const signature = new Uint8Array(totalLength + 2);
  signature[0] = 48;
  signature[1] = totalLength;
  signature[2] = 2;
  signature[3] = rLength;
  signature.set(rBytes, 4);
  signature[rLength + 4] = 2;
  signature[rLength + 5] = sLength;
  signature.set(sBytes, rLength + 6);
  return signature;
}
var __rest$1 = function(s2, e2) {
  var t2 = {};
  for (var p2 in s2) if (Object.prototype.hasOwnProperty.call(s2, p2) && e2.indexOf(p2) < 0)
    t2[p2] = s2[p2];
  if (s2 != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i2 = 0, p2 = Object.getOwnPropertySymbols(s2); i2 < p2.length; i2++) {
      if (e2.indexOf(p2[i2]) < 0 && Object.prototype.propertyIsEnumerable.call(s2, p2[i2]))
        t2[p2[i2]] = s2[p2[i2]];
    }
  return t2;
};
async function createSmartAccount(parameters) {
  const { owner, ownerIndex, address, client, factoryData } = parameters;
  const entryPoint = {
    abi: entryPoint06Abi,
    address: entryPoint06Address,
    version: "0.6"
  };
  const factory = {
    abi: factoryAbi,
    address: factoryAddress
  };
  return toSmartAccount({
    client,
    entryPoint,
    extend: { abi, factory },
    async decodeCalls(data) {
      const result = decodeFunctionData({
        abi,
        data
      });
      if (result.functionName === "execute")
        return [{ to: result.args[0], value: result.args[1], data: result.args[2] }];
      if (result.functionName === "executeBatch")
        return result.args[0].map((arg) => ({
          to: arg.target,
          value: arg.value,
          data: arg.data
        }));
      throw new BaseError$1(`unable to decode calls for "${result.functionName}"`);
    },
    async encodeCalls(calls) {
      var _a, _b;
      if (calls.length === 1) {
        return encodeFunctionData({
          abi,
          functionName: "execute",
          args: [calls[0].to, (_a = calls[0].value) !== null && _a !== void 0 ? _a : BigInt(0), (_b = calls[0].data) !== null && _b !== void 0 ? _b : "0x"]
        });
      }
      return encodeFunctionData({
        abi,
        functionName: "executeBatch",
        args: [
          calls.map((call) => {
            var _a2, _b2;
            return {
              data: (_a2 = call.data) !== null && _a2 !== void 0 ? _a2 : "0x",
              target: call.to,
              value: (_b2 = call.value) !== null && _b2 !== void 0 ? _b2 : BigInt(0)
            };
          })
        ]
      });
    },
    async getAddress() {
      return address;
    },
    async getFactoryArgs() {
      if (factoryData)
        return { factory: factory.address, factoryData };
      return { factory: factory.address, factoryData };
    },
    async getStubSignature() {
      if (owner.type === "webAuthn")
        return "0x0000000000000000000000000000000000000000000000000000000000000020000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400000000000000000000000000000000000000000000000000000000000000200000000000000000000000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000c0000000000000000000000000000000000000000000000000000000000000012000000000000000000000000000000000000000000000000000000000000000170000000000000000000000000000000000000000000000000000000000000001949fc7c88032b9fcb5f6efc7a7b8c63668eae9871b765e23123bb473ff57aa831a7c0d9276168ebcc29f2875a0239cffdf2a9cd1c2007c5c77c071db9264df1d000000000000000000000000000000000000000000000000000000000000002549960de5880e8c687434170f6476605b8fe4aeb9a28632c7995cf3ba831d97630500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008a7b2274797065223a22776562617574686e2e676574222c226368616c6c656e6765223a2273496a396e6164474850596759334b7156384f7a4a666c726275504b474f716d59576f4d57516869467773222c226f726967696e223a2268747470733a2f2f7369676e2e636f696e626173652e636f6d222c2263726f73734f726967696e223a66616c73657d00000000000000000000000000000000000000000000";
      return wrapSignature({
        ownerIndex,
        signature: "0xfffffffffffffffffffffffffffffff0000000000000000000000000000000007aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa1c"
      });
    },
    async sign(parameters2) {
      const address2 = await this.getAddress();
      const hash = toReplaySafeHash({
        address: address2,
        chainId: client.chain.id,
        hash: parameters2.hash
      });
      const signature = await sign({ hash, owner });
      return wrapSignature({
        ownerIndex,
        signature
      });
    },
    async signMessage(parameters2) {
      const { message } = parameters2;
      const address2 = await this.getAddress();
      const hash = toReplaySafeHash({
        address: address2,
        chainId: client.chain.id,
        hash: hashMessage(message)
      });
      const signature = await sign({ hash, owner });
      return wrapSignature({
        ownerIndex,
        signature
      });
    },
    async signTypedData(parameters2) {
      const { domain, types: types2, primaryType, message } = parameters2;
      const address2 = await this.getAddress();
      const hash = toReplaySafeHash({
        address: address2,
        chainId: client.chain.id,
        hash: hashTypedData({
          domain,
          message,
          primaryType,
          types: types2
        })
      });
      const signature = await sign({ hash, owner });
      return wrapSignature({
        ownerIndex,
        signature
      });
    },
    async signUserOperation(parameters2) {
      const { chainId = client.chain.id } = parameters2, userOperation = __rest$1(parameters2, ["chainId"]);
      const address2 = await this.getAddress();
      const hash = getUserOperationHash({
        chainId,
        entryPointAddress: entryPoint.address,
        entryPointVersion: entryPoint.version,
        userOperation: Object.assign(Object.assign({}, userOperation), { sender: address2 })
      });
      const signature = await sign({ hash, owner });
      return wrapSignature({
        ownerIndex,
        signature
      });
    },
    userOperation: {
      async estimateGas(userOperation) {
        var _a;
        if (owner.type !== "webAuthn")
          return;
        return {
          verificationGasLimit: BigInt(Math.max(Number((_a = userOperation.verificationGasLimit) !== null && _a !== void 0 ? _a : BigInt(0)), 8e5))
        };
      }
    }
  });
}
async function sign({ hash, owner }) {
  if (owner.type === "webAuthn") {
    const { signature, webauthn } = await owner.sign({
      hash
    });
    return toWebAuthnSignature({ signature, webauthn });
  }
  if (owner.sign)
    return owner.sign({ hash });
  throw new BaseError$1("`owner` does not support raw sign.");
}
function toReplaySafeHash({ address, chainId, hash }) {
  return hashTypedData({
    domain: {
      chainId,
      name: "Coinbase Smart Wallet",
      verifyingContract: address,
      version: "1"
    },
    types: {
      CoinbaseSmartWalletMessage: [
        {
          name: "hash",
          type: "bytes32"
        }
      ]
    },
    primaryType: "CoinbaseSmartWalletMessage",
    message: {
      hash
    }
  });
}
function toWebAuthnSignature({ webauthn, signature }) {
  const { r: r2, s: s2 } = fromHex$1(signature);
  return encodeAbiParameters([
    {
      components: [
        {
          name: "authenticatorData",
          type: "bytes"
        },
        { name: "clientDataJSON", type: "bytes" },
        { name: "challengeIndex", type: "uint256" },
        { name: "typeIndex", type: "uint256" },
        {
          name: "r",
          type: "uint256"
        },
        {
          name: "s",
          type: "uint256"
        }
      ],
      type: "tuple"
    }
  ], [
    {
      authenticatorData: webauthn.authenticatorData,
      clientDataJSON: stringToHex(webauthn.clientDataJSON),
      challengeIndex: BigInt(webauthn.challengeIndex),
      typeIndex: BigInt(webauthn.typeIndex),
      r: r2,
      s: s2
    }
  ]);
}
function wrapSignature(parameters) {
  const { ownerIndex = 0 } = parameters;
  const signatureData = (() => {
    if (size$2(parameters.signature) !== 65)
      return parameters.signature;
    const signature = parseSignature(parameters.signature);
    return encodePacked(["bytes32", "bytes32", "uint8"], [signature.r, signature.s, signature.yParity === 0 ? 27 : 28]);
  })();
  return encodeAbiParameters([
    {
      components: [
        {
          name: "ownerIndex",
          type: "uint8"
        },
        {
          name: "signatureData",
          type: "bytes"
        }
      ],
      type: "tuple"
    }
  ], [
    {
      ownerIndex,
      signatureData
    }
  ]);
}
async function createSubAccountSigner({ address, client, factory, factoryData, owner, ownerIndex, parentAddress, attribution }) {
  var _a;
  const subAccount = {
    address,
    factory,
    factoryData
  };
  const chainId = (_a = client.chain) === null || _a === void 0 ? void 0 : _a.id;
  if (!chainId) {
    throw standardErrors.rpc.internal("chainId not found");
  }
  const account2 = await createSmartAccount({
    owner,
    ownerIndex: ownerIndex !== null && ownerIndex !== void 0 ? ownerIndex : 1,
    address,
    client,
    factoryData
  });
  const request = async (args) => {
    var _a2, _b, _c, _d, _e, _f;
    try {
      switch (args.method) {
        case "wallet_addSubAccount":
          return subAccount;
        case "eth_accounts":
          return [subAccount.address];
        case "eth_coinbase":
          return subAccount.address;
        case "net_version":
          return chainId.toString();
        case "eth_chainId":
          return numberToHex(chainId);
        case "eth_sendTransaction": {
          assertArrayPresence(args.params);
          const rawParams = args.params[0];
          assertPresence(rawParams.to, standardErrors.rpc.invalidParams("to is required"));
          const params = {
            to: rawParams.to,
            data: ensureHexString((_a2 = rawParams.data) !== null && _a2 !== void 0 ? _a2 : "0x", true),
            value: ensureHexString((_b = rawParams.value) !== null && _b !== void 0 ? _b : "0x", true),
            from: (_c = rawParams.from) !== null && _c !== void 0 ? _c : subAccount.address
          };
          const sendCallsRequest = createWalletSendCallsRequest({
            calls: [params],
            chainId,
            from: params.from
          });
          const response = await request(sendCallsRequest);
          return waitForCallsTransactionHash({
            client,
            id: response
          });
        }
        case "wallet_sendCalls": {
          assertArrayPresence(args.params);
          const chainId2 = get(args.params[0], "chainId");
          if (!chainId2) {
            throw standardErrors.rpc.invalidParams("chainId is required");
          }
          if (!isHex(chainId2)) {
            throw standardErrors.rpc.invalidParams("chainId must be a hex encoded integer");
          }
          if (!args.params[0]) {
            throw standardErrors.rpc.invalidParams("params are required");
          }
          if (!("calls" in args.params[0])) {
            throw standardErrors.rpc.invalidParams("calls are required");
          }
          let prepareCallsRequest = {
            method: "wallet_prepareCalls",
            params: [
              {
                version: "1.0",
                calls: args.params[0].calls,
                chainId: chainId2,
                from: subAccount.address,
                capabilities: "capabilities" in args.params[0] ? args.params[0].capabilities : {}
              }
            ]
          };
          if (parentAddress) {
            prepareCallsRequest = injectRequestCapabilities(prepareCallsRequest, {
              funding: [
                {
                  type: "spendPermission",
                  data: {
                    autoApply: true,
                    sources: [parentAddress],
                    preference: "PREFER_DIRECT_BALANCE"
                  }
                }
              ]
            });
          }
          let prepareCallsResponse = await request(prepareCallsRequest);
          const signResponse = await ((_e = (_d = owner).sign) === null || _e === void 0 ? void 0 : _e.call(_d, {
            // Hash returned from wallet_prepareCalls is double hex encoded
            hash: hexToString(prepareCallsResponse.signatureRequest.hash)
          }));
          let signatureData;
          if (!signResponse) {
            throw standardErrors.rpc.internal("signature not found");
          }
          if (isHex(signResponse)) {
            signatureData = {
              type: "secp256k1",
              data: {
                address: owner.address,
                signature: signResponse
              }
            };
          } else {
            signatureData = {
              type: "webauthn",
              data: {
                signature: JSON.stringify(convertCredentialToJSON(Object.assign({ id: (_f = owner.id) !== null && _f !== void 0 ? _f : "1" }, signResponse))),
                publicKey: owner.publicKey
              }
            };
          }
          const sendPreparedCallsResponse = await request({
            method: "wallet_sendPreparedCalls",
            params: [
              {
                version: "1.0",
                type: prepareCallsResponse.type,
                data: prepareCallsResponse.userOp,
                chainId: prepareCallsResponse.chainId,
                signature: signatureData
              }
            ]
          });
          return sendPreparedCallsResponse[0];
        }
        case "wallet_sendPreparedCalls": {
          assertArrayPresence(args.params);
          const chainId2 = get(args.params[0], "chainId");
          if (!chainId2) {
            throw standardErrors.rpc.invalidParams("chainId is required");
          }
          if (!isHex(chainId2)) {
            throw standardErrors.rpc.invalidParams("chainId must be a hex encoded integer");
          }
          const sendPreparedCallsResponse = await client.request({
            method: "wallet_sendPreparedCalls",
            params: args.params
          });
          return sendPreparedCallsResponse;
        }
        case "wallet_prepareCalls": {
          assertArrayPresence(args.params);
          const chainId2 = get(args.params[0], "chainId");
          if (!chainId2) {
            throw standardErrors.rpc.invalidParams("chainId is required");
          }
          if (!isHex(chainId2)) {
            throw standardErrors.rpc.invalidParams("chainId must be a hex encoded integer");
          }
          if (!args.params[0]) {
            throw standardErrors.rpc.invalidParams("params are required");
          }
          if (!get(args.params[0], "calls")) {
            throw standardErrors.rpc.invalidParams("calls are required");
          }
          const prepareCallsParams = args.params[0];
          if (attribution && prepareCallsParams.capabilities && !("attribution" in prepareCallsParams.capabilities)) {
            prepareCallsParams.capabilities.attribution = attribution;
          }
          const prepareCallsResponse = await client.request({
            method: "wallet_prepareCalls",
            params: [Object.assign(Object.assign({}, args.params[0]), { chainId: chainId2 })]
          });
          return prepareCallsResponse;
        }
        case "personal_sign": {
          assertArrayPresence(args.params);
          if (!isHex(args.params[0])) {
            throw standardErrors.rpc.invalidParams("message must be a hex encoded string");
          }
          const message = hexToString(args.params[0]);
          return account2.signMessage({ message });
        }
        case "eth_signTypedData_v4": {
          assertArrayPresence(args.params);
          const typedData = typeof args.params[1] === "string" ? JSON.parse(args.params[1]) : args.params[1];
          return account2.signTypedData(typedData);
        }
        case "eth_signTypedData_v1":
        case "eth_signTypedData_v3":
        case "wallet_addEthereumChain":
        case "wallet_switchEthereumChain":
        default:
          throw standardErrors.rpc.methodNotSupported();
      }
    } catch (error) {
      if (isViemError(error)) {
        const newError = viemHttpErrorToProviderError(error);
        if (newError) {
          throw newError;
        }
      }
      throw error;
    }
  };
  return { request };
}
async function findOwnerIndex({ address, client, publicKey, factory, factoryData }) {
  const code = await getCode(client, {
    address
  });
  if (!code && factory && factoryData) {
    const initData = decodeFunctionData({
      abi: factoryAbi,
      data: factoryData
    });
    if (initData.functionName !== "createAccount") {
      throw standardErrors.rpc.internal("unknown factory function");
    }
    const [owners] = initData.args;
    return owners.findIndex((owner) => {
      return owner.toLowerCase() === formatPublicKey(publicKey).toLowerCase();
    });
  }
  const ownerCount = await readContract(client, {
    address,
    abi,
    functionName: "ownerCount"
  });
  for (let i2 = Number(ownerCount) - 1; i2 >= 0; i2--) {
    const owner = await readContract(client, {
      address,
      abi,
      functionName: "ownerAtIndex",
      args: [BigInt(i2)]
    });
    const formatted = formatPublicKey(publicKey);
    if (owner.toLowerCase() === formatted.toLowerCase()) {
      return i2;
    }
  }
  return -1;
}
function formatPublicKey(publicKey) {
  if (isAddress(publicKey)) {
    return pad$1(publicKey);
  }
  return publicKey;
}
async function presentAddOwnerDialog() {
  var _a, _b;
  const appName = (_b = (_a = store.config.get().metadata) === null || _a === void 0 ? void 0 : _a.appName) !== null && _b !== void 0 ? _b : "App";
  const dialog2 = initDialog();
  return new Promise((resolve) => {
    logDialogShown({ dialogContext: "sub_account_add_owner" });
    dialog2.presentItem({
      title: `Re-authorize ${appName}`,
      message: `${appName} has lost access to your account. Please sign at the next step to re-authorize ${appName}`,
      onClose: () => {
        logDialogDismissed({ dialogContext: "sub_account_add_owner" });
        resolve("cancel");
      },
      actionItems: [
        {
          text: "Continue",
          variant: "primary",
          onClick: () => {
            logDialogActionClicked({
              dialogContext: "sub_account_add_owner",
              dialogAction: "confirm"
            });
            dialog2.clear();
            resolve("authenticate");
          }
        },
        {
          text: "Not now",
          variant: "secondary",
          onClick: () => {
            logDialogActionClicked({
              dialogContext: "sub_account_add_owner",
              dialogAction: "cancel"
            });
            dialog2.clear();
            resolve("cancel");
          }
        }
      ]
    });
  });
}
async function handleAddSubAccountOwner({ ownerAccount, globalAccountRequest }) {
  var _a, _b;
  const account2 = store.account.get();
  const subAccount = store.subAccounts.get();
  const globalAccount = (_a = account2.accounts) === null || _a === void 0 ? void 0 : _a.find((account22) => account22.toLowerCase() !== (subAccount === null || subAccount === void 0 ? void 0 : subAccount.address.toLowerCase()));
  assertPresence(globalAccount, standardErrors.provider.unauthorized("no global account"));
  assertPresence((_b = account2.chain) === null || _b === void 0 ? void 0 : _b.id, standardErrors.provider.unauthorized("no chain id"));
  assertPresence(subAccount === null || subAccount === void 0 ? void 0 : subAccount.address, standardErrors.provider.unauthorized("no sub account"));
  const calls = [];
  if (ownerAccount.type === "local" && ownerAccount.address) {
    calls.push({
      to: subAccount.address,
      data: encodeFunctionData({
        abi,
        functionName: "addOwnerAddress",
        args: [ownerAccount.address]
      }),
      value: toHex$2(0)
    });
  }
  if (ownerAccount.publicKey) {
    const [x2, y2] = decodeAbiParameters([{ type: "bytes32" }, { type: "bytes32" }], ownerAccount.publicKey);
    calls.push({
      to: subAccount.address,
      data: encodeFunctionData({
        abi,
        functionName: "addOwnerPublicKey",
        args: [x2, y2]
      }),
      value: toHex$2(0)
    });
  }
  const request = {
    method: "wallet_sendCalls",
    params: [
      {
        version: "1",
        calls,
        chainId: numberToHex(84532),
        from: globalAccount
      }
    ]
  };
  const selection = await presentAddOwnerDialog();
  if (selection === "cancel") {
    throw standardErrors.provider.unauthorized("user cancelled");
  }
  const callsId = await globalAccountRequest(request);
  const client = getClient(account2.chain.id);
  assertPresence(client, standardErrors.rpc.internal(`client not found for chainId ${account2.chain.id}`));
  const callsResult = await waitForCallsStatus(client, {
    id: callsId
  });
  if (callsResult.status !== "success") {
    throw standardErrors.rpc.internal("add owner call failed");
  }
  const ownerIndex = await findOwnerIndex({
    address: subAccount.address,
    publicKey: ownerAccount.type === "local" && ownerAccount.address ? ownerAccount.address : ownerAccount.publicKey,
    client
  });
  if (ownerIndex === -1) {
    throw standardErrors.rpc.internal("failed to find owner index");
  }
  return ownerIndex;
}
async function handleInsufficientBalanceError({ errorData, globalAccountAddress, subAccountAddress, client, request, subAccountRequest, globalAccountRequest }) {
  var _a;
  const chainId = (_a = client.chain) === null || _a === void 0 ? void 0 : _a.id;
  assertPresence(chainId, standardErrors.rpc.internal(`invalid chainId`));
  const spendPermissionRequests = parseFundingOptions({
    errorData,
    sourceAddress: globalAccountAddress
  });
  const userChoice = await presentSubAccountFundingDialog();
  if (userChoice === "cancel") {
    throw new Error("User cancelled funding");
  }
  let signatureRequest;
  const defaultPeriod = 60 * 60 * 24;
  const defaultMultiplier = 3;
  if (userChoice === "update_permission") {
    if (spendPermissionRequests.length === 1) {
      const spendPermission = spendPermissionRequests[0];
      const message = createSpendPermissionMessage({
        spendPermission: {
          token: spendPermission.token,
          allowance: numberToHex(spendPermission.requiredAmount * BigInt(defaultMultiplier)),
          period: defaultPeriod,
          account: globalAccountAddress,
          spender: subAccountAddress,
          start: 0,
          end: 281474976710655,
          salt: numberToHex(BigInt(Math.floor(Math.random() * Number.MAX_SAFE_INTEGER))),
          extraData: "0x"
        },
        chainId
      });
      signatureRequest = {
        method: "eth_signTypedData_v4",
        params: [globalAccountAddress, message]
      };
    } else {
      const message = createSpendPermissionBatchMessage({
        spendPermissionBatch: {
          account: globalAccountAddress,
          period: defaultPeriod,
          start: 0,
          end: 281474976710655,
          permissions: spendPermissionRequests.map((spendPermission) => ({
            token: spendPermission.token,
            allowance: numberToHex(spendPermission.requiredAmount * BigInt(defaultMultiplier)),
            period: defaultPeriod,
            account: globalAccountAddress,
            spender: subAccountAddress,
            salt: "0x0",
            extraData: "0x"
          }))
        },
        chainId
      });
      signatureRequest = {
        method: "eth_signTypedData_v4",
        params: [globalAccountAddress, message]
      };
    }
    try {
      await globalAccountRequest(signatureRequest);
    } catch (error) {
      console.error(error);
      throw new Error("User denied spend permission request");
    }
    return subAccountRequest(request);
  }
  const transferCalls = spendPermissionRequests.map((spendPermission) => {
    const isNative = spendPermission.token.toLowerCase() === "0xEeeeeEeeeEeEeeEeEeEeeEEEeeeeEeeeeeeeEEeE".toLowerCase();
    if (isNative) {
      return {
        to: subAccountAddress,
        value: numberToHex(spendPermission.requiredAmount),
        data: "0x"
      };
    }
    return {
      to: spendPermission.token,
      value: "0x0",
      data: encodeFunctionData({
        abi: erc20Abi,
        functionName: "transfer",
        args: [subAccountAddress, spendPermission.requiredAmount]
      })
    };
  });
  let originalSendCallsParams;
  if (request.method === "wallet_sendCalls" && isSendCallsParams(request.params)) {
    originalSendCallsParams = request.params[0];
  } else if (request.method === "eth_sendTransaction" && isEthSendTransactionParams(request.params)) {
    const sendCallsRequest = createWalletSendCallsRequest({
      calls: [request.params[0]],
      chainId,
      from: request.params[0].from
    });
    originalSendCallsParams = sendCallsRequest.params[0];
  } else {
    throw new Error("Could not get original call");
  }
  const subAccountCallData = encodeFunctionData({
    abi,
    functionName: "executeBatch",
    args: [
      originalSendCallsParams.calls.map((call) => {
        var _a2, _b;
        return {
          target: call.to,
          value: hexToBigInt((_a2 = call.value) !== null && _a2 !== void 0 ? _a2 : "0x0"),
          data: (_b = call.data) !== null && _b !== void 0 ? _b : "0x"
        };
      })
    ]
  });
  const calls = [
    ...transferCalls,
    { data: subAccountCallData, to: subAccountAddress, value: "0x0" }
  ];
  const result = await globalAccountRequest({
    method: "wallet_sendCalls",
    params: [Object.assign(Object.assign({}, originalSendCallsParams), { calls, from: globalAccountAddress })]
  });
  if (request.method === "eth_sendTransaction") {
    return waitForCallsTransactionHash({
      client,
      id: result
    });
  }
  return result;
}
class Signer {
  constructor(params) {
    var _a, _b, _c, _d;
    this.communicator = params.communicator;
    this.callback = params.callback;
    this.keyManager = new SCWKeyManager();
    const { account: account2, chains: chains2 } = store.getState();
    this.accounts = (_a = account2.accounts) !== null && _a !== void 0 ? _a : [];
    this.chain = (_b = account2.chain) !== null && _b !== void 0 ? _b : {
      id: (_d = (_c = params.metadata.appChainIds) === null || _c === void 0 ? void 0 : _c[0]) !== null && _d !== void 0 ? _d : 1
    };
    if (chains2) {
      createClients(chains2);
    }
  }
  get isConnected() {
    return this.accounts.length > 0;
  }
  async handshake(args) {
    var _a, _b, _c;
    const correlationId = correlationIds.get(args);
    logHandshakeStarted({ method: args.method, correlationId });
    try {
      await ((_b = (_a = this.communicator).waitForPopupLoaded) === null || _b === void 0 ? void 0 : _b.call(_a));
      const handshakeMessage = await this.createRequestMessage({
        handshake: {
          method: args.method,
          params: (_c = args.params) !== null && _c !== void 0 ? _c : []
        }
      }, correlationId);
      const response = await this.communicator.postRequestAndWaitForResponse(handshakeMessage);
      if ("failure" in response.content) {
        throw response.content.failure;
      }
      const peerPublicKey = await importKeyFromHexString("public", response.sender);
      await this.keyManager.setPeerPublicKey(peerPublicKey);
      const decrypted = await this.decryptResponseMessage(response);
      this.handleResponse(args, decrypted);
      logHandshakeCompleted({ method: args.method, correlationId });
    } catch (error) {
      logHandshakeError({
        method: args.method,
        correlationId,
        errorMessage: parseErrorMessageFromAny(error)
      });
      throw error;
    }
  }
  async request(request) {
    const correlationId = correlationIds.get(request);
    logRequestStarted({ method: request.method, correlationId });
    try {
      const result = await this._request(request);
      logRequestCompleted({ method: request.method, correlationId });
      return result;
    } catch (error) {
      logRequestError({
        method: request.method,
        correlationId,
        errorMessage: parseErrorMessageFromAny(error)
      });
      throw error;
    }
  }
  async _request(request) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    if (this.accounts.length === 0) {
      switch (request.method) {
        case "wallet_switchEthereumChain": {
          assertParamsChainId(request.params);
          this.chain.id = Number(request.params[0].chainId);
          return;
        }
        case "wallet_connect": {
          await ((_b = (_a = this.communicator).waitForPopupLoaded) === null || _b === void 0 ? void 0 : _b.call(_a));
          await initSubAccountConfig();
          let capabilitiesToInject = {};
          if (requestHasCapability(request, "addSubAccount")) {
            capabilitiesToInject = (_d = (_c = store.subAccountsConfig.get()) === null || _c === void 0 ? void 0 : _c.capabilities) !== null && _d !== void 0 ? _d : {};
          }
          const modifiedRequest = injectRequestCapabilities(request, capabilitiesToInject);
          return this.sendRequestToPopup(modifiedRequest);
        }
        case "wallet_sendCalls":
        case "wallet_sign": {
          return this.sendRequestToPopup(request);
        }
        default:
          throw standardErrors.provider.unauthorized();
      }
    }
    if (this.shouldRequestUseSubAccountSigner(request)) {
      const correlationId = correlationIds.get(request);
      logSubAccountRequestStarted({ method: request.method, correlationId });
      try {
        const result = await this.sendRequestToSubAccountSigner(request);
        logSubAccountRequestCompleted({ method: request.method, correlationId });
        return result;
      } catch (error) {
        logSubAccountRequestError({
          method: request.method,
          correlationId,
          errorMessage: parseErrorMessageFromAny(error)
        });
        throw error;
      }
    }
    switch (request.method) {
      case "eth_requestAccounts":
      case "eth_accounts": {
        const subAccount = store.subAccounts.get();
        const subAccountsConfig2 = store.subAccountsConfig.get();
        if (subAccount === null || subAccount === void 0 ? void 0 : subAccount.address) {
          this.accounts = (subAccountsConfig2 === null || subAccountsConfig2 === void 0 ? void 0 : subAccountsConfig2.enableAutoSubAccounts) ? prependWithoutDuplicates(this.accounts, subAccount.address) : appendWithoutDuplicates(this.accounts, subAccount.address);
        }
        (_e = this.callback) === null || _e === void 0 ? void 0 : _e.call(this, "connect", { chainId: numberToHex(this.chain.id) });
        return this.accounts;
      }
      case "eth_coinbase":
        return this.accounts[0];
      case "net_version":
        return this.chain.id;
      case "eth_chainId":
        return numberToHex(this.chain.id);
      case "wallet_getCapabilities":
        return this.handleGetCapabilitiesRequest(request);
      case "wallet_switchEthereumChain":
        return this.handleSwitchChainRequest(request);
      case "eth_ecRecover":
      case "personal_sign":
      case "wallet_sign":
      case "personal_ecRecover":
      case "eth_signTransaction":
      case "eth_sendTransaction":
      case "eth_signTypedData_v1":
      case "eth_signTypedData_v3":
      case "eth_signTypedData_v4":
      case "eth_signTypedData":
      case "wallet_addEthereumChain":
      case "wallet_watchAsset":
      case "wallet_sendCalls":
      case "wallet_showCallsStatus":
      case "wallet_grantPermissions":
        return this.sendRequestToPopup(request);
      case "wallet_connect": {
        const cachedResponse = await getCachedWalletConnectResponse();
        if (cachedResponse) {
          return cachedResponse;
        }
        await ((_g = (_f = this.communicator).waitForPopupLoaded) === null || _g === void 0 ? void 0 : _g.call(_f));
        await initSubAccountConfig();
        const subAccountsConfig2 = store.subAccountsConfig.get();
        const modifiedRequest = injectRequestCapabilities(request, (_h = subAccountsConfig2 === null || subAccountsConfig2 === void 0 ? void 0 : subAccountsConfig2.capabilities) !== null && _h !== void 0 ? _h : {});
        const result = await this.sendRequestToPopup(modifiedRequest);
        (_j = this.callback) === null || _j === void 0 ? void 0 : _j.call(this, "connect", { chainId: numberToHex(this.chain.id) });
        return result;
      }
      case "wallet_getSubAccounts": {
        const subAccount = store.subAccounts.get();
        if (subAccount === null || subAccount === void 0 ? void 0 : subAccount.address) {
          return {
            subAccounts: [subAccount]
          };
        }
        if (!this.chain.rpcUrl) {
          throw standardErrors.rpc.internal("No RPC URL set for chain");
        }
        const response = await fetchRPCRequest(request, this.chain.rpcUrl);
        assertArrayPresence(response.subAccounts, "subAccounts");
        if (response.subAccounts.length > 0) {
          assertSubAccount(response.subAccounts[0]);
          const subAccount2 = response.subAccounts[0];
          store.subAccounts.set({
            address: subAccount2.address,
            factory: subAccount2.factory,
            factoryData: subAccount2.factoryData
          });
        }
        return response;
      }
      case "wallet_addSubAccount":
        return this.addSubAccount(request);
      case "coinbase_fetchPermissions": {
        assertFetchPermissionsRequest(request);
        const completeRequest = fillMissingParamsForFetchPermissions(request);
        const permissions = await fetchRPCRequest(completeRequest, CB_WALLET_RPC_URL);
        const requestedChainId = hexToNumber((_k = completeRequest.params) === null || _k === void 0 ? void 0 : _k[0].chainId);
        store.spendPermissions.set(permissions.permissions.map((permission) => Object.assign(Object.assign({}, permission), { chainId: requestedChainId })));
        return permissions;
      }
      default:
        if (!this.chain.rpcUrl) {
          throw standardErrors.rpc.internal("No RPC URL set for chain");
        }
        return fetchRPCRequest(request, this.chain.rpcUrl);
    }
  }
  async sendRequestToPopup(request) {
    var _a, _b;
    await ((_b = (_a = this.communicator).waitForPopupLoaded) === null || _b === void 0 ? void 0 : _b.call(_a));
    const response = await this.sendEncryptedRequest(request);
    const decrypted = await this.decryptResponseMessage(response);
    return this.handleResponse(request, decrypted);
  }
  async handleResponse(request, decrypted) {
    var _a, _b, _c, _d, _e;
    const result = decrypted.result;
    if ("error" in result)
      throw result.error;
    switch (request.method) {
      case "eth_requestAccounts": {
        const accounts = result.value;
        this.accounts = accounts;
        store.account.set({
          accounts,
          chain: this.chain
        });
        (_a = this.callback) === null || _a === void 0 ? void 0 : _a.call(this, "accountsChanged", accounts);
        break;
      }
      case "wallet_connect": {
        const response = result.value;
        const accounts = response.accounts.map((account22) => account22.address);
        this.accounts = accounts;
        store.account.set({
          accounts
        });
        const account2 = response.accounts.at(0);
        const capabilities = account2 === null || account2 === void 0 ? void 0 : account2.capabilities;
        if (capabilities === null || capabilities === void 0 ? void 0 : capabilities.subAccounts) {
          const capabilityResponse = capabilities === null || capabilities === void 0 ? void 0 : capabilities.subAccounts;
          assertArrayPresence(capabilityResponse, "subAccounts");
          assertSubAccount(capabilityResponse[0]);
          store.subAccounts.set({
            address: capabilityResponse[0].address,
            factory: capabilityResponse[0].factory,
            factoryData: capabilityResponse[0].factoryData
          });
        }
        let accounts_ = [this.accounts[0]];
        const subAccount = store.subAccounts.get();
        const subAccountsConfig2 = store.subAccountsConfig.get();
        if (subAccount === null || subAccount === void 0 ? void 0 : subAccount.address) {
          this.accounts = (subAccountsConfig2 === null || subAccountsConfig2 === void 0 ? void 0 : subAccountsConfig2.enableAutoSubAccounts) ? prependWithoutDuplicates(this.accounts, subAccount.address) : appendWithoutDuplicates(this.accounts, subAccount.address);
        }
        const spendPermissions2 = (_c = (_b = response === null || response === void 0 ? void 0 : response.accounts) === null || _b === void 0 ? void 0 : _b[0].capabilities) === null || _c === void 0 ? void 0 : _c.spendPermissions;
        if (spendPermissions2 && "permissions" in spendPermissions2) {
          store.spendPermissions.set(spendPermissions2 === null || spendPermissions2 === void 0 ? void 0 : spendPermissions2.permissions);
        }
        (_d = this.callback) === null || _d === void 0 ? void 0 : _d.call(this, "accountsChanged", accounts_);
        break;
      }
      case "wallet_addSubAccount": {
        assertSubAccount(result.value);
        const subAccount = result.value;
        store.subAccounts.set(subAccount);
        const subAccountsConfig2 = store.subAccountsConfig.get();
        this.accounts = (subAccountsConfig2 === null || subAccountsConfig2 === void 0 ? void 0 : subAccountsConfig2.enableAutoSubAccounts) ? prependWithoutDuplicates(this.accounts, subAccount.address) : appendWithoutDuplicates(this.accounts, subAccount.address);
        (_e = this.callback) === null || _e === void 0 ? void 0 : _e.call(this, "accountsChanged", this.accounts);
        break;
      }
    }
    return result.value;
  }
  async cleanup() {
    var _a, _b;
    const metadata = store.config.get().metadata;
    await this.keyManager.clear();
    store.account.clear();
    store.subAccounts.clear();
    store.spendPermissions.clear();
    store.chains.clear();
    this.accounts = [];
    this.chain = {
      id: (_b = (_a = metadata === null || metadata === void 0 ? void 0 : metadata.appChainIds) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : 1
    };
  }
  /**
   * @returns `null` if the request was successful.
   * https://eips.ethereum.org/EIPS/eip-3326#wallet_switchethereumchain
   */
  async handleSwitchChainRequest(request) {
    assertParamsChainId(request.params);
    const chainId = ensureIntNumber(request.params[0].chainId);
    const localResult = this.updateChain(chainId);
    if (localResult)
      return null;
    const popupResult = await this.sendRequestToPopup(request);
    if (popupResult === null) {
      this.updateChain(chainId);
    }
    return popupResult;
  }
  async handleGetCapabilitiesRequest(request) {
    assertGetCapabilitiesParams(request.params);
    const requestedAccount = request.params[0];
    const filterChainIds = request.params[1];
    if (!this.accounts.some((account2) => isAddressEqual(account2, requestedAccount))) {
      throw standardErrors.provider.unauthorized("no active account found when getting capabilities");
    }
    const capabilities = store.getState().account.capabilities;
    if (!capabilities) {
      return {};
    }
    if (!filterChainIds || filterChainIds.length === 0) {
      return capabilities;
    }
    const filterChainNumbers = new Set(filterChainIds.map((chainId) => hexToNumber(chainId)));
    const filteredCapabilities = Object.fromEntries(Object.entries(capabilities).filter(([capabilityKey]) => {
      try {
        const capabilityChainNumber = hexToNumber(capabilityKey);
        return filterChainNumbers.has(capabilityChainNumber);
      } catch (_a) {
        return false;
      }
    }));
    return filteredCapabilities;
  }
  async sendEncryptedRequest(request) {
    const sharedSecret = await this.keyManager.getSharedSecret();
    if (!sharedSecret) {
      throw standardErrors.provider.unauthorized("No shared secret found when encrypting request");
    }
    const encrypted = await encryptContent({
      action: request,
      chainId: this.chain.id
    }, sharedSecret);
    const correlationId = correlationIds.get(request);
    const message = await this.createRequestMessage({ encrypted }, correlationId);
    return this.communicator.postRequestAndWaitForResponse(message);
  }
  async createRequestMessage(content, correlationId) {
    const publicKey = await exportKeyToHexString("public", await this.keyManager.getOwnPublicKey());
    return {
      id: crypto.randomUUID(),
      correlationId,
      sender: publicKey,
      content,
      timestamp: /* @__PURE__ */ new Date()
    };
  }
  async decryptResponseMessage(message) {
    var _a, _b, _c;
    const content = message.content;
    if ("failure" in content) {
      throw content.failure;
    }
    const sharedSecret = await this.keyManager.getSharedSecret();
    if (!sharedSecret) {
      throw standardErrors.provider.unauthorized("Invalid session: no shared secret found when decrypting response");
    }
    const response = await decryptContent(content.encrypted, sharedSecret);
    const availableChains = (_a = response.data) === null || _a === void 0 ? void 0 : _a.chains;
    if (availableChains) {
      const nativeCurrencies = (_b = response.data) === null || _b === void 0 ? void 0 : _b.nativeCurrencies;
      const chains2 = Object.entries(availableChains).map(([id, rpcUrl]) => {
        const nativeCurrency = nativeCurrencies === null || nativeCurrencies === void 0 ? void 0 : nativeCurrencies[Number(id)];
        return Object.assign({ id: Number(id), rpcUrl }, nativeCurrency ? { nativeCurrency } : {});
      });
      store.chains.set(chains2);
      this.updateChain(this.chain.id, chains2);
      createClients(chains2);
    }
    const walletCapabilities = (_c = response.data) === null || _c === void 0 ? void 0 : _c.capabilities;
    if (walletCapabilities) {
      store.account.set({
        capabilities: walletCapabilities
      });
    }
    return response;
  }
  updateChain(chainId, newAvailableChains) {
    var _a;
    const state = store.getState();
    const chains2 = newAvailableChains !== null && newAvailableChains !== void 0 ? newAvailableChains : state.chains;
    const chain = chains2 === null || chains2 === void 0 ? void 0 : chains2.find((chain2) => chain2.id === chainId);
    if (!chain)
      return false;
    if (chain !== this.chain) {
      this.chain = chain;
      store.account.set({
        chain
      });
      (_a = this.callback) === null || _a === void 0 ? void 0 : _a.call(this, "chainChanged", hexStringFromNumber(chain.id));
    }
    return true;
  }
  async addSubAccount(request) {
    var _a, _b, _c, _d;
    const state = store.getState();
    const subAccount = state.subAccount;
    const subAccountsConfig2 = store.subAccountsConfig.get();
    if (subAccount === null || subAccount === void 0 ? void 0 : subAccount.address) {
      this.accounts = (subAccountsConfig2 === null || subAccountsConfig2 === void 0 ? void 0 : subAccountsConfig2.enableAutoSubAccounts) ? prependWithoutDuplicates(this.accounts, subAccount.address) : appendWithoutDuplicates(this.accounts, subAccount.address);
      (_a = this.callback) === null || _a === void 0 ? void 0 : _a.call(this, "accountsChanged", this.accounts);
      return subAccount;
    }
    await ((_c = (_b = this.communicator).waitForPopupLoaded) === null || _c === void 0 ? void 0 : _c.call(_b));
    if (Array.isArray(request.params) && request.params.length > 0 && request.params[0].account && request.params[0].account.type === "create") {
      let keys2;
      if (request.params[0].account.keys && request.params[0].account.keys.length > 0) {
        keys2 = request.params[0].account.keys;
      } else {
        const config2 = (_d = store.subAccountsConfig.get()) !== null && _d !== void 0 ? _d : {};
        const { account: ownerAccount } = config2.toOwnerAccount ? await config2.toOwnerAccount() : await getCryptoKeyAccount();
        if (!ownerAccount) {
          throw standardErrors.provider.unauthorized("could not get subaccount owner account when adding sub account");
        }
        keys2 = [
          {
            type: ownerAccount.address ? "address" : "webauthn-p256",
            publicKey: ownerAccount.address || ownerAccount.publicKey
          }
        ];
      }
      request.params[0].account.keys = keys2;
    }
    const response = await this.sendRequestToPopup(request);
    assertSubAccount(response);
    return response;
  }
  shouldRequestUseSubAccountSigner(request) {
    const sender = getSenderFromRequest(request);
    const subAccount = store.subAccounts.get();
    if (sender) {
      return sender.toLowerCase() === (subAccount === null || subAccount === void 0 ? void 0 : subAccount.address.toLowerCase());
    }
    return false;
  }
  async sendRequestToSubAccountSigner(request) {
    var _a;
    const subAccount = store.subAccounts.get();
    const subAccountsConfig2 = store.subAccountsConfig.get();
    const config2 = store.config.get();
    assertPresence(subAccount === null || subAccount === void 0 ? void 0 : subAccount.address, standardErrors.provider.unauthorized("no active sub account when sending request to sub account signer"));
    const ownerAccount = (subAccountsConfig2 === null || subAccountsConfig2 === void 0 ? void 0 : subAccountsConfig2.toOwnerAccount) ? await subAccountsConfig2.toOwnerAccount() : await getCryptoKeyAccount();
    assertPresence(ownerAccount === null || ownerAccount === void 0 ? void 0 : ownerAccount.account, standardErrors.provider.unauthorized("no active sub account owner when sending request to sub account signer"));
    const sender = getSenderFromRequest(request);
    if (sender === void 0) {
      request = addSenderToRequest(request, subAccount.address);
    }
    const client = getClient(this.chain.id);
    assertPresence(client, standardErrors.rpc.internal(`client not found for chainId ${this.chain.id} when sending request to sub account signer`));
    const globalAccountAddress = this.accounts.find((account2) => account2.toLowerCase() !== subAccount.address.toLowerCase());
    assertPresence(globalAccountAddress, standardErrors.provider.unauthorized("no global account found when sending request to sub account signer"));
    const dataSuffix = makeDataSuffix({
      attribution: (_a = config2.preference) === null || _a === void 0 ? void 0 : _a.attribution,
      dappOrigin: window.location.origin
    });
    const publicKey = ownerAccount.account.type === "local" ? ownerAccount.account.address : ownerAccount.account.publicKey;
    let ownerIndex = await findOwnerIndex({
      address: subAccount.address,
      factory: subAccount.factory,
      factoryData: subAccount.factoryData,
      publicKey,
      client
    });
    if (ownerIndex === -1) {
      const correlationId = correlationIds.get(request);
      logAddOwnerStarted({ method: request.method, correlationId });
      try {
        ownerIndex = await handleAddSubAccountOwner({
          ownerAccount: ownerAccount.account,
          globalAccountRequest: this.sendRequestToPopup.bind(this)
        });
        logAddOwnerCompleted({ method: request.method, correlationId });
      } catch (error) {
        logAddOwnerError({
          method: request.method,
          correlationId,
          errorMessage: parseErrorMessageFromAny(error)
        });
        return standardErrors.provider.unauthorized("failed to add sub account owner when sending request to sub account signer");
      }
    }
    const { request: subAccountRequest } = await createSubAccountSigner({
      address: subAccount.address,
      owner: ownerAccount.account,
      client,
      factory: subAccount.factory,
      factoryData: subAccount.factoryData,
      parentAddress: globalAccountAddress,
      attribution: dataSuffix ? { suffix: dataSuffix } : void 0,
      ownerIndex
    });
    try {
      const result = await subAccountRequest(request);
      return result;
    } catch (error) {
      let errorObject;
      if (isViemError(error)) {
        errorObject = JSON.parse(error.details);
      } else if (isActionableHttpRequestError(error)) {
        errorObject = error;
      } else {
        throw error;
      }
      if (!(isActionableHttpRequestError(errorObject) && errorObject.data)) {
        throw error;
      }
      if (!errorObject.data) {
        throw error;
      }
      const correlationId = correlationIds.get(request);
      logInsufficientBalanceErrorHandlingStarted({ method: request.method, correlationId });
      try {
        const result = await handleInsufficientBalanceError({
          errorData: errorObject.data,
          globalAccountAddress,
          subAccountAddress: subAccount.address,
          client,
          request,
          subAccountRequest,
          globalAccountRequest: this.request.bind(this)
        });
        logInsufficientBalanceErrorHandlingCompleted({ method: request.method, correlationId });
        return result;
      } catch (handlingError) {
        console.error(handlingError);
        logInsufficientBalanceErrorHandlingError({
          method: request.method,
          correlationId,
          errorMessage: parseErrorMessageFromAny(handlingError)
        });
        throw error;
      }
    }
  }
}
var __rest = function(s2, e2) {
  var t2 = {};
  for (var p2 in s2) if (Object.prototype.hasOwnProperty.call(s2, p2) && e2.indexOf(p2) < 0)
    t2[p2] = s2[p2];
  if (s2 != null && typeof Object.getOwnPropertySymbols === "function")
    for (var i2 = 0, p2 = Object.getOwnPropertySymbols(s2); i2 < p2.length; i2++) {
      if (e2.indexOf(p2[i2]) < 0 && Object.prototype.propertyIsEnumerable.call(s2, p2[i2]))
        t2[p2[i2]] = s2[p2[i2]];
    }
  return t2;
};
class BaseAccountProvider extends ProviderEventEmitter {
  constructor(_a) {
    var { metadata } = _a, _b = _a.preference, { walletUrl } = _b, preference = __rest(_b, ["walletUrl"]);
    super();
    this.isBaseAccount = true;
    this.communicator = new Communicator({
      url: walletUrl,
      metadata,
      preference
    });
    this.signer = new Signer({
      metadata,
      communicator: this.communicator,
      callback: this.emit.bind(this)
    });
  }
  async request(args) {
    const correlationId = crypto.randomUUID();
    correlationIds.set(args, correlationId);
    logRequestStarted$1({ method: args.method, correlationId });
    try {
      const result = await this._request(args);
      logRequestResponded({
        method: args.method,
        correlationId
      });
      return result;
    } catch (error) {
      logRequestError$1({
        method: args.method,
        correlationId,
        errorMessage: error instanceof Error ? error.message : ""
      });
      throw error;
    } finally {
      correlationIds.delete(args);
    }
  }
  async _request(args) {
    var _a, _b;
    try {
      checkErrorForInvalidRequestArgs(args);
      if (!this.signer.isConnected) {
        switch (args.method) {
          case "eth_requestAccounts": {
            await this.signer.handshake({ method: "handshake" });
            await initSubAccountConfig();
            await this.signer.request({
              method: "wallet_connect",
              params: [
                {
                  version: "1",
                  capabilities: Object.assign({}, (_b = (_a = store.subAccountsConfig.get()) === null || _a === void 0 ? void 0 : _a.capabilities) !== null && _b !== void 0 ? _b : {})
                }
              ]
            });
            break;
          }
          case "wallet_connect": {
            await this.signer.handshake({ method: "handshake" });
            const result2 = await this.signer.request(args);
            return result2;
          }
          case "wallet_sendCalls":
          case "wallet_sign": {
            try {
              await this.signer.handshake({ method: "handshake" });
              const result2 = await this.signer.request(args);
              return result2;
            } finally {
              await this.signer.cleanup();
            }
          }
          case "wallet_getCallsStatus": {
            const result2 = await fetchRPCRequest(args, CB_WALLET_RPC_URL);
            return result2;
          }
          case "eth_accounts": {
            return [];
          }
          case "net_version": {
            const result2 = 1;
            return result2;
          }
          case "eth_chainId": {
            const result2 = hexStringFromNumber(1);
            return result2;
          }
          default: {
            throw standardErrors.provider.unauthorized("Must call 'eth_requestAccounts' before other methods");
          }
        }
      }
      const result = await this.signer.request(args);
      return result;
    } catch (error) {
      const { code } = error;
      if (code === standardErrorCodes.provider.unauthorized) {
        await this.disconnect();
      }
      return Promise.reject(serializeError(error));
    }
  }
  async disconnect() {
    await this.signer.cleanup();
    correlationIds.clear();
    this.emit("disconnect", standardErrors.provider.disconnected("User initiated disconnection"));
  }
}
const TBA_PROVIDER_IDENTIFIER = "isCoinbaseBrowser";
function getInjectedProvider() {
  var _a, _b;
  const injectedProvider = (_a = window.ethereum) !== null && _a !== void 0 ? _a : (_b = window.top) === null || _b === void 0 ? void 0 : _b.ethereum;
  if (injectedProvider === null || injectedProvider === void 0 ? void 0 : injectedProvider[TBA_PROVIDER_IDENTIFIER]) {
    return injectedProvider;
  }
  return null;
}
function createBaseAccountSDK(params) {
  var _a, _b, _c, _d;
  const options = {
    metadata: {
      appName: params.appName || "App",
      appLogoUrl: params.appLogoUrl || "",
      appChainIds: params.appChainIds || []
    },
    preference: (_a = params.preference) !== null && _a !== void 0 ? _a : {},
    paymasterUrls: params.paymasterUrls
  };
  if ((_b = params.subAccounts) === null || _b === void 0 ? void 0 : _b.toOwnerAccount) {
    validateSubAccount(params.subAccounts.toOwnerAccount);
  }
  store.subAccountsConfig.set({
    toOwnerAccount: (_c = params.subAccounts) === null || _c === void 0 ? void 0 : _c.toOwnerAccount,
    // @ts-expect-error - enableSubAccounts is not officially supported yet
    enableAutoSubAccounts: (_d = params.subAccounts) === null || _d === void 0 ? void 0 : _d.enableAutoSubAccounts
  });
  store.config.set(options);
  void store.persist.rehydrate();
  void checkCrossOriginOpenerPolicy();
  validatePreferences(options.preference);
  if (options.preference.telemetry !== false) {
    void loadTelemetryScript();
  }
  let provider = null;
  const sdk = {
    getProvider: () => {
      var _a2;
      if (!provider) {
        provider = (_a2 = getInjectedProvider()) !== null && _a2 !== void 0 ? _a2 : new BaseAccountProvider(options);
      }
      return provider;
    },
    subAccount: {
      async create(accountParam) {
        var _a2;
        return await ((_a2 = sdk.getProvider()) === null || _a2 === void 0 ? void 0 : _a2.request({
          method: "wallet_addSubAccount",
          params: [
            {
              version: "1",
              account: accountParam
            }
          ]
        }));
      },
      async get() {
        var _a2, _b2;
        const subAccount = store.subAccounts.get();
        if (subAccount === null || subAccount === void 0 ? void 0 : subAccount.address) {
          return subAccount;
        }
        const response = await ((_a2 = sdk.getProvider()) === null || _a2 === void 0 ? void 0 : _a2.request({
          method: "wallet_connect",
          params: [
            {
              version: "1",
              capabilities: {}
            }
          ]
        }));
        const subAccounts2 = (_b2 = response.accounts[0].capabilities) === null || _b2 === void 0 ? void 0 : _b2.subAccounts;
        if (!Array.isArray(subAccounts2)) {
          return null;
        }
        return subAccounts2[0];
      },
      addOwner: async ({ address, publicKey, chainId }) => {
        var _a2, _b2;
        const subAccount = store.subAccounts.get();
        const account2 = store.account.get();
        assertPresence(account2, new Error("account does not exist"));
        assertPresence(subAccount === null || subAccount === void 0 ? void 0 : subAccount.address, new Error("subaccount does not exist"));
        const calls = [];
        if (publicKey) {
          const [x2, y2] = decodeAbiParameters([{ type: "bytes32" }, { type: "bytes32" }], publicKey);
          calls.push({
            to: subAccount.address,
            data: encodeFunctionData({
              abi,
              functionName: "addOwnerPublicKey",
              args: [x2, y2]
            }),
            value: toHex$2(0)
          });
        }
        if (address) {
          calls.push({
            to: subAccount.address,
            data: encodeFunctionData({
              abi,
              functionName: "addOwnerAddress",
              args: [address]
            }),
            value: toHex$2(0)
          });
        }
        return await ((_a2 = sdk.getProvider()) === null || _a2 === void 0 ? void 0 : _a2.request({
          method: "wallet_sendCalls",
          params: [
            {
              calls,
              chainId: toHex$2(chainId),
              from: (_b2 = account2.accounts) === null || _b2 === void 0 ? void 0 : _b2[0],
              version: "1"
            }
          ]
        }));
      },
      setToOwnerAccount(toSubAccountOwner) {
        validateSubAccount(toSubAccountOwner);
        store.subAccountsConfig.set({
          toOwnerAccount: toSubAccountOwner
        });
      }
    }
  };
  return sdk;
}
const TOKENS = {
  USDC: {
    decimals: 6,
    addresses: {
      base: "0x833589fCD6eDb6E08f4c7C32D4f71b54bdA02913",
      baseSepolia: "0x036CbD53842c5426634e7929541eC2318f3dCF7e"
    }
  }
};
const CHAIN_IDS = {
  base: 8453,
  baseSepolia: 84532
};
const ERC20_TRANSFER_ABI = [
  {
    name: "transfer",
    type: "function",
    stateMutability: "nonpayable",
    inputs: [
      { name: "to", type: "address" },
      { name: "amount", type: "uint256" }
    ],
    outputs: [{ name: "", type: "bool" }]
  },
  {
    name: "Transfer",
    type: "event",
    anonymous: false,
    inputs: [
      { name: "from", type: "address", indexed: true },
      { name: "to", type: "address", indexed: true },
      { name: "value", type: "uint256", indexed: false }
    ]
  }
];
const logPaymentStarted = ({ amount, testnet, correlationId }) => {
  logEvent("payment.pay.started", {
    action: ActionType.process,
    componentType: ComponentType.unknown,
    method: "pay",
    correlationId,
    signerType: "base-account",
    amount,
    testnet
  }, AnalyticsEventImportance.high);
};
const logPaymentError = ({ amount, testnet, correlationId, errorMessage }) => {
  logEvent("payment.pay.error", {
    action: ActionType.error,
    componentType: ComponentType.unknown,
    method: "pay",
    correlationId,
    signerType: "base-account",
    amount,
    testnet,
    errorMessage
  }, AnalyticsEventImportance.high);
};
const logPaymentCompleted = ({ amount, testnet, correlationId }) => {
  logEvent("payment.pay.completed", {
    action: ActionType.process,
    componentType: ComponentType.unknown,
    method: "pay",
    correlationId,
    signerType: "base-account",
    amount,
    testnet
  }, AnalyticsEventImportance.high);
};
const logPaymentStatusCheckStarted = ({ testnet, correlationId }) => {
  logEvent("payment.status_check.started", {
    action: ActionType.process,
    componentType: ComponentType.unknown,
    method: "getPaymentStatus",
    correlationId,
    signerType: "base-account",
    testnet
  }, AnalyticsEventImportance.low);
};
const logPaymentStatusCheckCompleted = ({ testnet, status, correlationId }) => {
  logEvent("payment.status_check.completed", {
    action: ActionType.process,
    componentType: ComponentType.unknown,
    method: "getPaymentStatus",
    correlationId,
    signerType: "base-account",
    testnet,
    status
  }, AnalyticsEventImportance.low);
};
const logPaymentStatusCheckError = ({ testnet, correlationId, errorMessage }) => {
  logEvent("payment.status_check.error", {
    action: ActionType.error,
    componentType: ComponentType.unknown,
    method: "getPaymentStatus",
    correlationId,
    errorMessage,
    signerType: "base-account",
    testnet
  }, AnalyticsEventImportance.low);
};
async function getPaymentStatus(options) {
  var _a;
  const { id, testnet = false, telemetry = true } = options;
  const correlationId = crypto.randomUUID();
  if (telemetry) {
    logPaymentStatusCheckStarted({ testnet, correlationId });
  }
  try {
    const bundlerUrl = testnet ? "https://api.developer.coinbase.com/rpc/v1/base-sepolia/S-fOd2n2Oi4fl4e1Crm83XeDXZ7tkg8O" : "https://api.developer.coinbase.com/rpc/v1/base/S-fOd2n2Oi4fl4e1Crm83XeDXZ7tkg8O";
    const receipt = await fetch(bundlerUrl, {
      method: "POST",
      headers: {
        "Content-Type": "application/json"
      },
      body: JSON.stringify({
        jsonrpc: "2.0",
        id: 1,
        method: "eth_getUserOperationReceipt",
        params: [id]
      })
    }).then((res) => res.json());
    if (receipt.error) {
      console.error("[getPaymentStatus] RPC error:", receipt.error);
      const errorMessage = receipt.error.message || "Network error";
      if (telemetry) {
        logPaymentStatusCheckError({ testnet, correlationId, errorMessage });
      }
      return {
        status: "failed",
        id,
        message: "Unable to check payment status. Please try again later.",
        error: errorMessage
      };
    }
    if (!receipt.result) {
      const userOpResponse = await fetch(bundlerUrl, {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify({
          jsonrpc: "2.0",
          id: 2,
          method: "eth_getUserOperationByHash",
          params: [id]
        })
      }).then((res) => res.json());
      if (userOpResponse.result) {
        if (telemetry) {
          logPaymentStatusCheckCompleted({ testnet, status: "pending", correlationId });
        }
        const result2 = {
          status: "pending",
          id,
          message: "Your payment is being processed. This usually takes a few seconds.",
          sender: userOpResponse.result.sender
        };
        return result2;
      }
      if (telemetry) {
        logPaymentStatusCheckCompleted({ testnet, status: "not_found", correlationId });
      }
      const result = {
        status: "not_found",
        id,
        message: "Payment not found. Please check your transaction ID."
      };
      return result;
    }
    const { success, receipt: txReceipt, reason } = receipt.result;
    if (success) {
      let amount;
      let recipient;
      if (txReceipt === null || txReceipt === void 0 ? void 0 : txReceipt.logs) {
        const network = testnet ? "baseSepolia" : "base";
        const usdcAddress = TOKENS.USDC.addresses[network].toLowerCase();
        for (const log of txReceipt.logs) {
          if (((_a = log.address) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === usdcAddress) {
            try {
              const decoded = decodeEventLog({
                abi: ERC20_TRANSFER_ABI,
                data: log.data,
                topics: log.topics
              });
              if (decoded.eventName === "Transfer" && decoded.args) {
                const args = decoded.args;
                if (args.value && args.to) {
                  amount = formatUnits(args.value, 6);
                  recipient = args.to;
                  break;
                }
              }
            } catch (e2) {
              console.error("[getPaymentStatus] Error parsing log:", e2);
            }
          }
        }
      }
      if (telemetry) {
        logPaymentStatusCheckCompleted({ testnet, status: "completed", correlationId });
      }
      const result = {
        status: "completed",
        id,
        message: "Payment completed successfully",
        sender: receipt.result.sender,
        amount,
        recipient
      };
      return result;
    } else {
      let userFriendlyError = "Payment could not be completed";
      if (reason) {
        if (reason.toLowerCase().includes("insufficient")) {
          userFriendlyError = "Insufficient USDC balance";
        } else if (reason.toLowerCase().includes("revert")) {
          userFriendlyError = "Payment was rejected";
        } else {
          userFriendlyError = reason;
        }
      }
      if (telemetry) {
        logPaymentStatusCheckCompleted({ testnet, status: "failed", correlationId });
      }
      const result = {
        status: "failed",
        id,
        message: "Payment failed",
        sender: receipt.result.sender,
        error: userFriendlyError
      };
      return result;
    }
  } catch (error) {
    console.error("[getPaymentStatus] Error checking status:", error);
    const errorMessage = error instanceof Error ? error.message : "Connection error";
    if (telemetry) {
      logPaymentStatusCheckError({ testnet, correlationId, errorMessage });
    }
    const result = {
      status: "failed",
      id,
      message: "Unable to check payment status",
      error: errorMessage
    };
    return result;
  }
}
function createEphemeralSDK(chainId, walletUrl, telemetry = true) {
  const appName = typeof window !== "undefined" ? window.location.origin : "Base Pay SDK";
  const sdk = createBaseAccountSDK({
    appName,
    appChainIds: [chainId],
    preference: {
      telemetry,
      walletUrl
    }
  });
  return sdk;
}
async function executePayment(sdk, requestParams) {
  var _a;
  const provider = sdk.getProvider();
  const result = await provider.request({
    method: "wallet_sendCalls",
    params: [requestParams]
  });
  let transactionHash;
  let payerInfoResponses;
  if (typeof result === "string" && result.length >= 66) {
    transactionHash = result.slice(0, 66);
  } else if (typeof result === "object" && result !== null) {
    const resultObj = result;
    if (typeof resultObj.id === "string" && resultObj.id.length >= 66) {
      transactionHash = resultObj.id.slice(0, 66);
      if ((_a = resultObj.capabilities) === null || _a === void 0 ? void 0 : _a.dataCallback) {
        payerInfoResponses = resultObj.capabilities.dataCallback;
      }
    } else {
      throw new Error(`Could not extract transaction hash from object response. Available fields: ${Object.keys(resultObj).join(", ")}`);
    }
  } else {
    throw new Error(`Unexpected response format from wallet_sendCalls: expected string with length > 66 or object with id, got ${typeof result}`);
  }
  return { transactionHash, payerInfoResponses };
}
async function executePaymentWithSDK(requestParams, testnet, walletUrl, telemetry = true) {
  const network = testnet ? "baseSepolia" : "base";
  const chainId = CHAIN_IDS[network];
  const sdk = createEphemeralSDK(chainId, walletUrl, telemetry);
  const provider = sdk.getProvider();
  try {
    const result = await executePayment(sdk, requestParams);
    return result;
  } finally {
    await provider.disconnect();
  }
}
function encodeTransferCall(recipient, amount) {
  const amountInUnits = parseUnits(amount, TOKENS.USDC.decimals);
  return encodeFunctionData({
    abi: ERC20_TRANSFER_ABI,
    functionName: "transfer",
    args: [recipient, amountInUnits]
  });
}
function buildSendCallsRequest(transferData, testnet, payerInfo) {
  const network = testnet ? "baseSepolia" : "base";
  const chainId = CHAIN_IDS[network];
  const usdcAddress = TOKENS.USDC.addresses[network];
  const call = {
    to: usdcAddress,
    data: transferData,
    value: "0x0"
    // No ETH value for ERC20 transfer
  };
  const capabilities = {};
  if (payerInfo && payerInfo.requests.length > 0) {
    capabilities.dataCallback = {
      requests: payerInfo.requests.map((request) => {
        var _a;
        return {
          type: request.type,
          optional: (_a = request.optional) !== null && _a !== void 0 ? _a : false
        };
      }),
      callbackURL: payerInfo.callbackURL
    };
  }
  const requestParams = {
    version: "2.0.0",
    chainId,
    calls: [call],
    capabilities
  };
  return requestParams;
}
function translatePaymentToSendCalls(recipient, amount, testnet, payerInfo) {
  const transferData = encodeTransferCall(recipient, amount);
  return buildSendCallsRequest(transferData, testnet, payerInfo);
}
function validateStringAmount(amount, maxDecimals) {
  if (typeof amount !== "string") {
    throw new Error("Invalid amount: must be a string");
  }
  const numAmount = parseFloat(amount);
  if (isNaN(numAmount)) {
    throw new Error("Invalid amount: must be a valid number");
  }
  if (numAmount <= 0) {
    throw new Error("Invalid amount: must be greater than 0");
  }
  const decimalIndex = amount.indexOf(".");
  if (decimalIndex !== -1) {
    const decimalPlaces = amount.length - decimalIndex - 1;
    if (decimalPlaces > maxDecimals) {
      throw new Error(`Invalid amount: pay only supports up to ${maxDecimals} decimal places`);
    }
  }
}
function validateAddress(address) {
  if (!address) {
    throw new Error("Invalid address: address is required");
  }
  if (!isAddress(address)) {
    throw new Error("Invalid address: must be a valid Ethereum address");
  }
}
async function pay(options) {
  var _a;
  const { amount, to, testnet = false, payerInfo, walletUrl, telemetry = true } = options;
  const correlationId = crypto.randomUUID();
  if (telemetry) {
    logPaymentStarted({ amount, testnet, correlationId });
  }
  try {
    validateStringAmount(amount, 2);
    validateAddress(to);
    const requestParams = translatePaymentToSendCalls(to, amount, testnet, payerInfo);
    const executionResult = await executePaymentWithSDK(requestParams, testnet, walletUrl, telemetry);
    if (telemetry) {
      logPaymentCompleted({ amount, testnet, correlationId });
    }
    return {
      success: true,
      id: executionResult.transactionHash,
      amount,
      to,
      payerInfoResponses: executionResult.payerInfoResponses
    };
  } catch (error) {
    let errorMessage = "Unknown error occurred";
    if (error instanceof Error) {
      errorMessage = error.message;
    } else if (typeof error === "string") {
      errorMessage = error;
    } else if (error && typeof error === "object") {
      const err = error;
      if (typeof (err === null || err === void 0 ? void 0 : err.message) === "string") {
        errorMessage = err.message;
      } else if (typeof ((_a = err === null || err === void 0 ? void 0 : err.error) === null || _a === void 0 ? void 0 : _a.message) === "string") {
        errorMessage = err.error.message;
      } else if (typeof (err === null || err === void 0 ? void 0 : err.reason) === "string") {
        errorMessage = err.reason;
      }
    }
    if (telemetry) {
      logPaymentError({ amount, testnet, correlationId, errorMessage });
    }
    return {
      success: false,
      error: errorMessage,
      amount,
      to
    };
  }
}
const base = {
  pay,
  getPaymentStatus,
  constants: {
    CHAIN_IDS,
    TOKENS
  },
  types: {}
};
export {
  base,
  createBaseAccountSDK,
  getCryptoKeyAccount,
  getPaymentStatus,
  pay,
  removeCryptoKey
};
