export namespace secp256k1 {
    export { create };
    export { CURVE };
    export { getPublicKey };
    export { getSharedSecret };
    export { sign };
    export { verify };
    export { Point as ProjectivePoint };
    export { Signature };
    export { utils };
}
declare function create(hash: any): {
    CURVE: any;
    getPublicKey: (privateKey: any, isCompressed?: boolean) => any;
    getSharedSecret: (privateA: any, publicB: any, isCompressed?: boolean) => any;
    sign: (msgHash: any, privKey: any, opts?: {
        lowS: any;
        prehash: boolean;
    }) => any;
    verify: (signature: any, msgHash: any, publicKey: any, opts?: {
        lowS: any;
        prehash: boolean;
    }) => boolean;
    ProjectivePoint: {
        new (px: any, py: any, pz: any): {
            px: any;
            py: any;
            pz: any;
            get x(): any;
            get y(): any;
            _setWindowSize(windowSize: any): void;
            assertValidity(): void;
            hasEvenY(): boolean;
            /**
             * Compare one point to another.
             */
            equals(other: any): any;
            /**
             * Flips point to one corresponding to (x, -y) in Affine coordinates.
             */
            negate(): /*elided*/ any;
            double(): /*elided*/ any;
            add(other: any): /*elided*/ any;
            subtract(other: any): /*elided*/ any;
            is0(): any;
            wNAF(n: any): {
                p: any;
                f: any;
            };
            /**
             * Non-constant-time multiplication. Uses double-and-add algorithm.
             * It's faster, but should only be used when you don't care about
             * an exposed private key e.g. sig verification, which works over *public* keys.
             */
            multiplyUnsafe(sc: any): any;
            /**
             * Constant time multiplication.
             * Uses wNAF method. Windowed method may be 10% faster,
             * but takes 2x longer to generate and consumes 2x memory.
             * Uses precomputes when available.
             * Uses endomorphism for Koblitz curves.
             * @param scalar by which the point would be multiplied
             * @returns New point
             */
            multiply(scalar: any): any;
            /**
             * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
             * Not using Strauss-Shamir trick: precomputation tables are faster.
             * The trick could be useful if both P and Q are not G (not in our case).
             * @returns non-zero affine point
             */
            multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
            toAffine(iz: any): any;
            isTorsionFree(): any;
            clearCofactor(): any;
            toRawBytes(isCompressed?: boolean): any;
            toHex(isCompressed?: boolean): string;
        };
        fromAffine(p: any): {
            px: any;
            py: any;
            pz: any;
            get x(): any;
            get y(): any;
            _setWindowSize(windowSize: any): void;
            assertValidity(): void;
            hasEvenY(): boolean;
            /**
             * Compare one point to another.
             */
            equals(other: any): any;
            /**
             * Flips point to one corresponding to (x, -y) in Affine coordinates.
             */
            negate(): /*elided*/ any;
            double(): /*elided*/ any;
            add(other: any): /*elided*/ any;
            subtract(other: any): /*elided*/ any;
            is0(): any;
            wNAF(n: any): {
                p: any;
                f: any;
            };
            /**
             * Non-constant-time multiplication. Uses double-and-add algorithm.
             * It's faster, but should only be used when you don't care about
             * an exposed private key e.g. sig verification, which works over *public* keys.
             */
            multiplyUnsafe(sc: any): any;
            /**
             * Constant time multiplication.
             * Uses wNAF method. Windowed method may be 10% faster,
             * but takes 2x longer to generate and consumes 2x memory.
             * Uses precomputes when available.
             * Uses endomorphism for Koblitz curves.
             * @param scalar by which the point would be multiplied
             * @returns New point
             */
            multiply(scalar: any): any;
            /**
             * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
             * Not using Strauss-Shamir trick: precomputation tables are faster.
             * The trick could be useful if both P and Q are not G (not in our case).
             * @returns non-zero affine point
             */
            multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
            toAffine(iz: any): any;
            isTorsionFree(): any;
            clearCofactor(): any;
            toRawBytes(isCompressed?: boolean): any;
            toHex(isCompressed?: boolean): string;
        };
        /**
         * Takes a bunch of Projective Points but executes only one
         * inversion on all of them. Inversion is very slow operation,
         * so this improves performance massively.
         * Optimization: converts a list of projective points to a list of identical points with Z=1.
         */
        normalizeZ(points: any): any;
        /**
         * Converts hash string or Uint8Array to Point.
         * @param hex short/long ECDSA hex
         */
        fromHex(hex: any): {
            px: any;
            py: any;
            pz: any;
            get x(): any;
            get y(): any;
            _setWindowSize(windowSize: any): void;
            assertValidity(): void;
            hasEvenY(): boolean;
            /**
             * Compare one point to another.
             */
            equals(other: any): any;
            /**
             * Flips point to one corresponding to (x, -y) in Affine coordinates.
             */
            negate(): /*elided*/ any;
            double(): /*elided*/ any;
            add(other: any): /*elided*/ any;
            subtract(other: any): /*elided*/ any;
            is0(): any;
            wNAF(n: any): {
                p: any;
                f: any;
            };
            /**
             * Non-constant-time multiplication. Uses double-and-add algorithm.
             * It's faster, but should only be used when you don't care about
             * an exposed private key e.g. sig verification, which works over *public* keys.
             */
            multiplyUnsafe(sc: any): any;
            /**
             * Constant time multiplication.
             * Uses wNAF method. Windowed method may be 10% faster,
             * but takes 2x longer to generate and consumes 2x memory.
             * Uses precomputes when available.
             * Uses endomorphism for Koblitz curves.
             * @param scalar by which the point would be multiplied
             * @returns New point
             */
            multiply(scalar: any): any;
            /**
             * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
             * Not using Strauss-Shamir trick: precomputation tables are faster.
             * The trick could be useful if both P and Q are not G (not in our case).
             * @returns non-zero affine point
             */
            multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
            toAffine(iz: any): any;
            isTorsionFree(): any;
            clearCofactor(): any;
            toRawBytes(isCompressed?: boolean): any;
            toHex(isCompressed?: boolean): string;
        };
        fromPrivateKey(privateKey: any): any;
        msm(points: any, scalars: any): any;
        BASE: {
            px: any;
            py: any;
            pz: any;
            get x(): any;
            get y(): any;
            _setWindowSize(windowSize: any): void;
            assertValidity(): void;
            hasEvenY(): boolean;
            /**
             * Compare one point to another.
             */
            equals(other: any): any;
            /**
             * Flips point to one corresponding to (x, -y) in Affine coordinates.
             */
            negate(): /*elided*/ any;
            double(): /*elided*/ any;
            add(other: any): /*elided*/ any;
            subtract(other: any): /*elided*/ any;
            is0(): any;
            wNAF(n: any): {
                p: any;
                f: any;
            };
            /**
             * Non-constant-time multiplication. Uses double-and-add algorithm.
             * It's faster, but should only be used when you don't care about
             * an exposed private key e.g. sig verification, which works over *public* keys.
             */
            multiplyUnsafe(sc: any): any;
            /**
             * Constant time multiplication.
             * Uses wNAF method. Windowed method may be 10% faster,
             * but takes 2x longer to generate and consumes 2x memory.
             * Uses precomputes when available.
             * Uses endomorphism for Koblitz curves.
             * @param scalar by which the point would be multiplied
             * @returns New point
             */
            multiply(scalar: any): any;
            /**
             * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
             * Not using Strauss-Shamir trick: precomputation tables are faster.
             * The trick could be useful if both P and Q are not G (not in our case).
             * @returns non-zero affine point
             */
            multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
            toAffine(iz: any): any;
            isTorsionFree(): any;
            clearCofactor(): any;
            toRawBytes(isCompressed?: boolean): any;
            toHex(isCompressed?: boolean): string;
        };
        ZERO: {
            px: any;
            py: any;
            pz: any;
            get x(): any;
            get y(): any;
            _setWindowSize(windowSize: any): void;
            assertValidity(): void;
            hasEvenY(): boolean;
            /**
             * Compare one point to another.
             */
            equals(other: any): any;
            /**
             * Flips point to one corresponding to (x, -y) in Affine coordinates.
             */
            negate(): /*elided*/ any;
            double(): /*elided*/ any;
            add(other: any): /*elided*/ any;
            subtract(other: any): /*elided*/ any;
            is0(): any;
            wNAF(n: any): {
                p: any;
                f: any;
            };
            /**
             * Non-constant-time multiplication. Uses double-and-add algorithm.
             * It's faster, but should only be used when you don't care about
             * an exposed private key e.g. sig verification, which works over *public* keys.
             */
            multiplyUnsafe(sc: any): any;
            /**
             * Constant time multiplication.
             * Uses wNAF method. Windowed method may be 10% faster,
             * but takes 2x longer to generate and consumes 2x memory.
             * Uses precomputes when available.
             * Uses endomorphism for Koblitz curves.
             * @param scalar by which the point would be multiplied
             * @returns New point
             */
            multiply(scalar: any): any;
            /**
             * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
             * Not using Strauss-Shamir trick: precomputation tables are faster.
             * The trick could be useful if both P and Q are not G (not in our case).
             * @returns non-zero affine point
             */
            multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
            toAffine(iz: any): any;
            isTorsionFree(): any;
            clearCofactor(): any;
            toRawBytes(isCompressed?: boolean): any;
            toHex(isCompressed?: boolean): string;
        };
    };
    Signature: {
        new (r: any, s: any, recovery: any): {
            r: any;
            s: any;
            recovery: any;
            assertValidity(): void;
            addRecoveryBit(recovery: any): /*elided*/ any;
            recoverPublicKey(msgHash: any): any;
            hasHighS(): boolean;
            normalizeS(): /*elided*/ any;
            toDERRawBytes(): Uint8Array<ArrayBuffer>;
            toDERHex(): any;
            toCompactRawBytes(): Uint8Array<ArrayBuffer>;
            toCompactHex(): string;
        };
        fromCompact(hex: any): {
            r: any;
            s: any;
            recovery: any;
            assertValidity(): void;
            addRecoveryBit(recovery: any): /*elided*/ any;
            recoverPublicKey(msgHash: any): any;
            hasHighS(): boolean;
            normalizeS(): /*elided*/ any;
            toDERRawBytes(): Uint8Array<ArrayBuffer>;
            toDERHex(): any;
            toCompactRawBytes(): Uint8Array<ArrayBuffer>;
            toCompactHex(): string;
        };
        fromDER(hex: any): {
            r: any;
            s: any;
            recovery: any;
            assertValidity(): void;
            addRecoveryBit(recovery: any): /*elided*/ any;
            recoverPublicKey(msgHash: any): any;
            hasHighS(): boolean;
            normalizeS(): /*elided*/ any;
            toDERRawBytes(): Uint8Array<ArrayBuffer>;
            toDERHex(): any;
            toCompactRawBytes(): Uint8Array<ArrayBuffer>;
            toCompactHex(): string;
        };
    };
    utils: {
        isValidPrivateKey(privateKey: any): boolean;
        normPrivateKeyToScalar: (key: any) => any;
        /**
         * Produces cryptographically secure private key from random of size
         * (groupLen + ceil(groupLen / 2)) with modulo bias being negligible.
         */
        randomPrivateKey: () => Uint8Array<ArrayBuffer>;
        /**
         * Creates precompute table for an arbitrary EC point. Makes point "cached".
         * Allows to massively speed-up `point.multiply(scalar)`.
         * @returns cached point
         * @example
         * const fast = utils.precompute(8, ProjectivePoint.fromHex(someonesPubKey));
         * fast.multiply(privKey); // much faster ECDH now
         */
        precompute(windowSize?: number, point?: {
            px: any;
            py: any;
            pz: any;
            get x(): any;
            get y(): any;
            _setWindowSize(windowSize: any): void;
            assertValidity(): void;
            hasEvenY(): boolean;
            /**
             * Compare one point to another.
             */
            equals(other: any): any;
            /**
             * Flips point to one corresponding to (x, -y) in Affine coordinates.
             */
            negate(): /*elided*/ any;
            double(): /*elided*/ any;
            add(other: any): /*elided*/ any;
            subtract(other: any): /*elided*/ any;
            is0(): any;
            wNAF(n: any): {
                p: any;
                f: any;
            };
            /**
             * Non-constant-time multiplication. Uses double-and-add algorithm.
             * It's faster, but should only be used when you don't care about
             * an exposed private key e.g. sig verification, which works over *public* keys.
             */
            multiplyUnsafe(sc: any): any;
            /**
             * Constant time multiplication.
             * Uses wNAF method. Windowed method may be 10% faster,
             * but takes 2x longer to generate and consumes 2x memory.
             * Uses precomputes when available.
             * Uses endomorphism for Koblitz curves.
             * @param scalar by which the point would be multiplied
             * @returns New point
             */
            multiply(scalar: any): any;
            /**
             * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
             * Not using Strauss-Shamir trick: precomputation tables are faster.
             * The trick could be useful if both P and Q are not G (not in our case).
             * @returns non-zero affine point
             */
            multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
            toAffine(iz: any): any;
            isTorsionFree(): any;
            clearCofactor(): any;
            toRawBytes(isCompressed?: boolean): any;
            toHex(isCompressed?: boolean): string;
        }): {
            px: any;
            py: any;
            pz: any;
            get x(): any;
            get y(): any;
            _setWindowSize(windowSize: any): void;
            assertValidity(): void;
            hasEvenY(): boolean;
            /**
             * Compare one point to another.
             */
            equals(other: any): any;
            /**
             * Flips point to one corresponding to (x, -y) in Affine coordinates.
             */
            negate(): /*elided*/ any;
            double(): /*elided*/ any;
            add(other: any): /*elided*/ any;
            subtract(other: any): /*elided*/ any;
            is0(): any;
            wNAF(n: any): {
                p: any;
                f: any;
            };
            /**
             * Non-constant-time multiplication. Uses double-and-add algorithm.
             * It's faster, but should only be used when you don't care about
             * an exposed private key e.g. sig verification, which works over *public* keys.
             */
            multiplyUnsafe(sc: any): any;
            /**
             * Constant time multiplication.
             * Uses wNAF method. Windowed method may be 10% faster,
             * but takes 2x longer to generate and consumes 2x memory.
             * Uses precomputes when available.
             * Uses endomorphism for Koblitz curves.
             * @param scalar by which the point would be multiplied
             * @returns New point
             */
            multiply(scalar: any): any;
            /**
             * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
             * Not using Strauss-Shamir trick: precomputation tables are faster.
             * The trick could be useful if both P and Q are not G (not in our case).
             * @returns non-zero affine point
             */
            multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
            toAffine(iz: any): any;
            isTorsionFree(): any;
            clearCofactor(): any;
            toRawBytes(isCompressed?: boolean): any;
            toHex(isCompressed?: boolean): string;
        };
    };
};
declare const CURVE: any;
declare function getPublicKey(privateKey: any, isCompressed?: boolean): any;
declare function getSharedSecret(privateA: any, publicB: any, isCompressed?: boolean): any;
declare function sign(msgHash: any, privKey: any, opts?: {
    lowS: any;
    prehash: boolean;
}): any;
declare function verify(signature: any, msgHash: any, publicKey: any, opts?: {
    lowS: any;
    prehash: boolean;
}): boolean;
declare const Point: {
    new (px: any, py: any, pz: any): {
        px: any;
        py: any;
        pz: any;
        get x(): any;
        get y(): any;
        _setWindowSize(windowSize: any): void;
        assertValidity(): void;
        hasEvenY(): boolean;
        /**
         * Compare one point to another.
         */
        equals(other: any): any;
        /**
         * Flips point to one corresponding to (x, -y) in Affine coordinates.
         */
        negate(): /*elided*/ any;
        double(): /*elided*/ any;
        add(other: any): /*elided*/ any;
        subtract(other: any): /*elided*/ any;
        is0(): any;
        wNAF(n: any): {
            p: any;
            f: any;
        };
        /**
         * Non-constant-time multiplication. Uses double-and-add algorithm.
         * It's faster, but should only be used when you don't care about
         * an exposed private key e.g. sig verification, which works over *public* keys.
         */
        multiplyUnsafe(sc: any): any;
        /**
         * Constant time multiplication.
         * Uses wNAF method. Windowed method may be 10% faster,
         * but takes 2x longer to generate and consumes 2x memory.
         * Uses precomputes when available.
         * Uses endomorphism for Koblitz curves.
         * @param scalar by which the point would be multiplied
         * @returns New point
         */
        multiply(scalar: any): any;
        /**
         * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
         * Not using Strauss-Shamir trick: precomputation tables are faster.
         * The trick could be useful if both P and Q are not G (not in our case).
         * @returns non-zero affine point
         */
        multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
        toAffine(iz: any): any;
        isTorsionFree(): any;
        clearCofactor(): any;
        toRawBytes(isCompressed?: boolean): any;
        toHex(isCompressed?: boolean): string;
    };
    fromAffine(p: any): {
        px: any;
        py: any;
        pz: any;
        get x(): any;
        get y(): any;
        _setWindowSize(windowSize: any): void;
        assertValidity(): void;
        hasEvenY(): boolean;
        /**
         * Compare one point to another.
         */
        equals(other: any): any;
        /**
         * Flips point to one corresponding to (x, -y) in Affine coordinates.
         */
        negate(): /*elided*/ any;
        double(): /*elided*/ any;
        add(other: any): /*elided*/ any;
        subtract(other: any): /*elided*/ any;
        is0(): any;
        wNAF(n: any): {
            p: any;
            f: any;
        };
        /**
         * Non-constant-time multiplication. Uses double-and-add algorithm.
         * It's faster, but should only be used when you don't care about
         * an exposed private key e.g. sig verification, which works over *public* keys.
         */
        multiplyUnsafe(sc: any): any;
        /**
         * Constant time multiplication.
         * Uses wNAF method. Windowed method may be 10% faster,
         * but takes 2x longer to generate and consumes 2x memory.
         * Uses precomputes when available.
         * Uses endomorphism for Koblitz curves.
         * @param scalar by which the point would be multiplied
         * @returns New point
         */
        multiply(scalar: any): any;
        /**
         * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
         * Not using Strauss-Shamir trick: precomputation tables are faster.
         * The trick could be useful if both P and Q are not G (not in our case).
         * @returns non-zero affine point
         */
        multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
        toAffine(iz: any): any;
        isTorsionFree(): any;
        clearCofactor(): any;
        toRawBytes(isCompressed?: boolean): any;
        toHex(isCompressed?: boolean): string;
    };
    /**
     * Takes a bunch of Projective Points but executes only one
     * inversion on all of them. Inversion is very slow operation,
     * so this improves performance massively.
     * Optimization: converts a list of projective points to a list of identical points with Z=1.
     */
    normalizeZ(points: any): any;
    /**
     * Converts hash string or Uint8Array to Point.
     * @param hex short/long ECDSA hex
     */
    fromHex(hex: any): {
        px: any;
        py: any;
        pz: any;
        get x(): any;
        get y(): any;
        _setWindowSize(windowSize: any): void;
        assertValidity(): void;
        hasEvenY(): boolean;
        /**
         * Compare one point to another.
         */
        equals(other: any): any;
        /**
         * Flips point to one corresponding to (x, -y) in Affine coordinates.
         */
        negate(): /*elided*/ any;
        double(): /*elided*/ any;
        add(other: any): /*elided*/ any;
        subtract(other: any): /*elided*/ any;
        is0(): any;
        wNAF(n: any): {
            p: any;
            f: any;
        };
        /**
         * Non-constant-time multiplication. Uses double-and-add algorithm.
         * It's faster, but should only be used when you don't care about
         * an exposed private key e.g. sig verification, which works over *public* keys.
         */
        multiplyUnsafe(sc: any): any;
        /**
         * Constant time multiplication.
         * Uses wNAF method. Windowed method may be 10% faster,
         * but takes 2x longer to generate and consumes 2x memory.
         * Uses precomputes when available.
         * Uses endomorphism for Koblitz curves.
         * @param scalar by which the point would be multiplied
         * @returns New point
         */
        multiply(scalar: any): any;
        /**
         * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
         * Not using Strauss-Shamir trick: precomputation tables are faster.
         * The trick could be useful if both P and Q are not G (not in our case).
         * @returns non-zero affine point
         */
        multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
        toAffine(iz: any): any;
        isTorsionFree(): any;
        clearCofactor(): any;
        toRawBytes(isCompressed?: boolean): any;
        toHex(isCompressed?: boolean): string;
    };
    fromPrivateKey(privateKey: any): any;
    msm(points: any, scalars: any): any;
    BASE: {
        px: any;
        py: any;
        pz: any;
        get x(): any;
        get y(): any;
        _setWindowSize(windowSize: any): void;
        assertValidity(): void;
        hasEvenY(): boolean;
        /**
         * Compare one point to another.
         */
        equals(other: any): any;
        /**
         * Flips point to one corresponding to (x, -y) in Affine coordinates.
         */
        negate(): /*elided*/ any;
        double(): /*elided*/ any;
        add(other: any): /*elided*/ any;
        subtract(other: any): /*elided*/ any;
        is0(): any;
        wNAF(n: any): {
            p: any;
            f: any;
        };
        /**
         * Non-constant-time multiplication. Uses double-and-add algorithm.
         * It's faster, but should only be used when you don't care about
         * an exposed private key e.g. sig verification, which works over *public* keys.
         */
        multiplyUnsafe(sc: any): any;
        /**
         * Constant time multiplication.
         * Uses wNAF method. Windowed method may be 10% faster,
         * but takes 2x longer to generate and consumes 2x memory.
         * Uses precomputes when available.
         * Uses endomorphism for Koblitz curves.
         * @param scalar by which the point would be multiplied
         * @returns New point
         */
        multiply(scalar: any): any;
        /**
         * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
         * Not using Strauss-Shamir trick: precomputation tables are faster.
         * The trick could be useful if both P and Q are not G (not in our case).
         * @returns non-zero affine point
         */
        multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
        toAffine(iz: any): any;
        isTorsionFree(): any;
        clearCofactor(): any;
        toRawBytes(isCompressed?: boolean): any;
        toHex(isCompressed?: boolean): string;
    };
    ZERO: {
        px: any;
        py: any;
        pz: any;
        get x(): any;
        get y(): any;
        _setWindowSize(windowSize: any): void;
        assertValidity(): void;
        hasEvenY(): boolean;
        /**
         * Compare one point to another.
         */
        equals(other: any): any;
        /**
         * Flips point to one corresponding to (x, -y) in Affine coordinates.
         */
        negate(): /*elided*/ any;
        double(): /*elided*/ any;
        add(other: any): /*elided*/ any;
        subtract(other: any): /*elided*/ any;
        is0(): any;
        wNAF(n: any): {
            p: any;
            f: any;
        };
        /**
         * Non-constant-time multiplication. Uses double-and-add algorithm.
         * It's faster, but should only be used when you don't care about
         * an exposed private key e.g. sig verification, which works over *public* keys.
         */
        multiplyUnsafe(sc: any): any;
        /**
         * Constant time multiplication.
         * Uses wNAF method. Windowed method may be 10% faster,
         * but takes 2x longer to generate and consumes 2x memory.
         * Uses precomputes when available.
         * Uses endomorphism for Koblitz curves.
         * @param scalar by which the point would be multiplied
         * @returns New point
         */
        multiply(scalar: any): any;
        /**
         * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
         * Not using Strauss-Shamir trick: precomputation tables are faster.
         * The trick could be useful if both P and Q are not G (not in our case).
         * @returns non-zero affine point
         */
        multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
        toAffine(iz: any): any;
        isTorsionFree(): any;
        clearCofactor(): any;
        toRawBytes(isCompressed?: boolean): any;
        toHex(isCompressed?: boolean): string;
    };
};
declare class Signature {
    static fromCompact(hex: any): {
        r: any;
        s: any;
        recovery: any;
        assertValidity(): void;
        addRecoveryBit(recovery: any): /*elided*/ any;
        recoverPublicKey(msgHash: any): any;
        hasHighS(): boolean;
        normalizeS(): /*elided*/ any;
        toDERRawBytes(): Uint8Array<ArrayBuffer>;
        toDERHex(): any;
        toCompactRawBytes(): Uint8Array<ArrayBuffer>;
        toCompactHex(): string;
    };
    static fromDER(hex: any): {
        r: any;
        s: any;
        recovery: any;
        assertValidity(): void;
        addRecoveryBit(recovery: any): /*elided*/ any;
        recoverPublicKey(msgHash: any): any;
        hasHighS(): boolean;
        normalizeS(): /*elided*/ any;
        toDERRawBytes(): Uint8Array<ArrayBuffer>;
        toDERHex(): any;
        toCompactRawBytes(): Uint8Array<ArrayBuffer>;
        toCompactHex(): string;
    };
    constructor(r: any, s: any, recovery: any);
    r: any;
    s: any;
    recovery: any;
    assertValidity(): void;
    addRecoveryBit(recovery: any): {
        r: any;
        s: any;
        recovery: any;
        assertValidity(): void;
        addRecoveryBit(recovery: any): /*elided*/ any;
        recoverPublicKey(msgHash: any): any;
        hasHighS(): boolean;
        normalizeS(): /*elided*/ any;
        toDERRawBytes(): Uint8Array<ArrayBuffer>;
        toDERHex(): any;
        toCompactRawBytes(): Uint8Array<ArrayBuffer>;
        toCompactHex(): string;
    };
    recoverPublicKey(msgHash: any): any;
    hasHighS(): boolean;
    normalizeS(): {
        r: any;
        s: any;
        recovery: any;
        assertValidity(): void;
        addRecoveryBit(recovery: any): /*elided*/ any;
        recoverPublicKey(msgHash: any): any;
        hasHighS(): boolean;
        normalizeS(): /*elided*/ any;
        toDERRawBytes(): Uint8Array<ArrayBuffer>;
        toDERHex(): any;
        toCompactRawBytes(): Uint8Array<ArrayBuffer>;
        toCompactHex(): string;
    };
    toDERRawBytes(): Uint8Array<ArrayBuffer>;
    toDERHex(): any;
    toCompactRawBytes(): Uint8Array<ArrayBuffer>;
    toCompactHex(): string;
}
declare namespace utils {
    export function isValidPrivateKey(privateKey: any): boolean;
    export { normPrivateKeyToScalar };
    export function randomPrivateKey(): Uint8Array<ArrayBuffer>;
    /**
     * Creates precompute table for an arbitrary EC point. Makes point "cached".
     * Allows to massively speed-up `point.multiply(scalar)`.
     * @returns cached point
     * @example
     * const fast = utils.precompute(8, ProjectivePoint.fromHex(someonesPubKey));
     * fast.multiply(privKey); // much faster ECDH now
     */
    export function precompute(windowSize?: number, point?: {
        px: any;
        py: any;
        pz: any;
        get x(): any;
        get y(): any;
        _setWindowSize(windowSize: any): void;
        assertValidity(): void;
        hasEvenY(): boolean;
        /**
         * Compare one point to another.
         */
        equals(other: any): any;
        /**
         * Flips point to one corresponding to (x, -y) in Affine coordinates.
         */
        negate(): /*elided*/ any;
        double(): /*elided*/ any;
        add(other: any): /*elided*/ any;
        subtract(other: any): /*elided*/ any;
        is0(): any;
        wNAF(n: any): {
            p: any;
            f: any;
        };
        /**
         * Non-constant-time multiplication. Uses double-and-add algorithm.
         * It's faster, but should only be used when you don't care about
         * an exposed private key e.g. sig verification, which works over *public* keys.
         */
        multiplyUnsafe(sc: any): any;
        /**
         * Constant time multiplication.
         * Uses wNAF method. Windowed method may be 10% faster,
         * but takes 2x longer to generate and consumes 2x memory.
         * Uses precomputes when available.
         * Uses endomorphism for Koblitz curves.
         * @param scalar by which the point would be multiplied
         * @returns New point
         */
        multiply(scalar: any): any;
        /**
         * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
         * Not using Strauss-Shamir trick: precomputation tables are faster.
         * The trick could be useful if both P and Q are not G (not in our case).
         * @returns non-zero affine point
         */
        multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
        toAffine(iz: any): any;
        isTorsionFree(): any;
        clearCofactor(): any;
        toRawBytes(isCompressed?: boolean): any;
        toHex(isCompressed?: boolean): string;
    }): {
        px: any;
        py: any;
        pz: any;
        get x(): any;
        get y(): any;
        _setWindowSize(windowSize: any): void;
        assertValidity(): void;
        hasEvenY(): boolean;
        /**
         * Compare one point to another.
         */
        equals(other: any): any;
        /**
         * Flips point to one corresponding to (x, -y) in Affine coordinates.
         */
        negate(): /*elided*/ any;
        double(): /*elided*/ any;
        add(other: any): /*elided*/ any;
        subtract(other: any): /*elided*/ any;
        is0(): any;
        wNAF(n: any): {
            p: any;
            f: any;
        };
        /**
         * Non-constant-time multiplication. Uses double-and-add algorithm.
         * It's faster, but should only be used when you don't care about
         * an exposed private key e.g. sig verification, which works over *public* keys.
         */
        multiplyUnsafe(sc: any): any;
        /**
         * Constant time multiplication.
         * Uses wNAF method. Windowed method may be 10% faster,
         * but takes 2x longer to generate and consumes 2x memory.
         * Uses precomputes when available.
         * Uses endomorphism for Koblitz curves.
         * @param scalar by which the point would be multiplied
         * @returns New point
         */
        multiply(scalar: any): any;
        /**
         * Efficiently calculate `aP + bQ`. Unsafe, can expose private key, if used incorrectly.
         * Not using Strauss-Shamir trick: precomputation tables are faster.
         * The trick could be useful if both P and Q are not G (not in our case).
         * @returns non-zero affine point
         */
        multiplyAndAddUnsafe(Q: any, a: any, b: any): any;
        toAffine(iz: any): any;
        isTorsionFree(): any;
        clearCofactor(): any;
        toRawBytes(isCompressed?: boolean): any;
        toHex(isCompressed?: boolean): string;
    };
}
declare function normPrivateKeyToScalar(key: any): any;
export {};
